<?php
class CategoryIndexAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'admin';
	}

	public function execute()
	{
		$pid		= $this->context->get('pid');
		if(!is_numeric($pid))
		{
			$pid	= 0;
		}
		$categoryService			= new CategoryService();
		$this->data['data'] 		= $categoryService->getCategoryListByPId($pid);
		
		if($pid>0)
		{
			$this->data['menuCategory']	= $categoryService->getParentList($pid);
		}
		
		$this->data['menu']		= 'category';
		$this->data['submenu']	= 'category_index';
	}
}
