<?php
class HelpSaveEditAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('help','edit');
	}
	
	public function execute()
	{
		$id				= $this->context->post('id');
		$title			= $this->context->post('title');
		$content		= $this->context->post('content');
		$helpService	= new HelpService();
		if(is_numeric($id) && $id)
		{
			$helpService->update($id,array('title'=>$title,'content'=>$content));
			$this->code	= 200;
			$this->data['forward'] = C('LtUrl')->generate('Help', 'Index');
		}
		else
		{
			$id	= $helpService->add(array('title'=>$title,'content'=>$content));
			if($id)
			{
				$this->code	= 200;
				$this->data['forward'] = C('LtUrl')->generate('Help', 'Index');
			}
			else
			{
				$this->code	= 400;
			}
		}
	}
}
