<?php
class IndexSaveEditAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('index','edit');
	}
	
	public function execute()
	{
		$id				= $this->context->post('id');
		$data			= $this->getValidData();
		if(!empty($this->data['error_messages']))
		{
			$this->code	= 407;
		}
		else
		{
			// if($data['info']['con']['guarantee']!='true')
			// {
				// $data['info']['con']['guarantee']	= 'false';
			// }
			
			$data['info']['con']['is_module']		= 1;
			if ($data['info']['con']['classId']>0){
				$data['info']['con']['cid']				= $data['info']['con']['classId'];
				$categoryService		= new CategoryService();
				$tmp	= $categoryService->get($data['info']['con']['classId']);
				$data['info']['con']['classId'] = $tmp['cid'];
			}else{
				$data['info']['con']['cid']				= '';
			}
			
			$productService		= new ProductService();
			$con				= $data['info']['con'];
			$con['pageNum']		= 1;
			if(!array_key_exists('pageSize',$con) || !is_numeric($con['pageSize']) || $con['pageSize']<0 || $con['pageSize']>40)
			{
				$con['pageSize']	= 20;
			}
			//$cols				= array('iid','num_iid','title','nick','pic_url','price','click_url');
			$productService->searchPaikeProducts($con);
			$productList	= $productService->getProductList();
			if($productList)
			{
				foreach($productList as &$plv)
				{
					$plv['title']	= strip_tags($plv['title']);
				}
			}
			$moduleService	= new ModuleService();
			
			if(is_numeric($id) && $id)
			{
				$data['data']	= $productList;
				$moduleService->update($id,$data);
				$this->code	= 200;
				$this->data['forward'] = C('LtUrl')->generate('Index', 'Index',array('position'=>$data['position']));
			}
			else
			{
				$id	= $moduleService->add($data);
				if($id)
				{
					//更新数据
					$moduleService->update($id,array('data'=>$productList));
					
					$this->code	= 200;
					$this->data['forward'] = C('LtUrl')->generate('Index', 'Index',array('position'=>$data['position']));
				}
				else
				{
					$this->code	= 400;
				}
			}
		}
	}
}
