<?php
class IndexUpdateAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	public function execute()
	{
		$id				= $this->context->post('id');
		if(is_numeric($id) && $id)
		{
			$moduleService		= new ModuleService();
			$data				= $moduleService->get($id);
			$productService		= new ProductService();
			$con				= $data['info']['con'];
			$con['pageNum']		= 1;
			if(!array_key_exists('pageSize',$con) || !is_numeric($con['pageSize']) || $con['pageSize']<0 || $con['pageSize']>40)
			{
				$con['pageSize']	= 20;
			}
			$productService->searchPaikeProducts($con);
			$productList		= $productService->getProductList();
			if($productList)
			{
				foreach($productList as &$plv)
				{
					$plv['title']	= strip_tags($plv['title']);
				}
				//更新数据
				$moduleService->update($id,array('data'=>$productList));
				$this->code	= 200;
			}
			else
			{
				$this->code	= 400;
			}
		}
		else
		{
			$this->code	= 400;
		}
	}
}
