<?php
class LinkIndexAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'admin';
	}

	public function execute()
	{
		$page		= $this->getPage();
		$tmp	 	= LtObjectUtil::singleton('LtConfig')->get('pagination.pager');
		$pageSize	= $tmp['per_page'];
		if (empty($pageSize))
		{
			$pageSize 	= 20;
		}
		$num 			= $pageSize;
		$start	 		= ($page-1) * $pageSize;
		
		$linkService		= new LinkService();
		$this->data['data'] = $linkService->getLinkList($start, $num);
		
		$count 		= $this->data['data']['count'];
		$baseUrl 	= C('LtUrl')->generate('Link', 'Index', array('p' => ':page'));
		
		$pagination = new LtPagination;
		$pagination->init();
		$this->data['pages'] = $pagination->pager($page, $count, $baseUrl);
		
		$this->data['menu']		= 'ad';
		$this->data['submenu']	= 'link_index';
	}
}
