<?php
class LinkSaveEditAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('link','edit');
	}
	
	public function execute()
	{
		$id				= $this->context->post('id');
		$siteName		= $this->context->post('siteName');
		$url			= $this->context->post('url');
		$indexShow		= $this->context->post('indexShow');
		if($indexShow!=1)
		{
			$indexShow	= 0;
		}
		$orderby		= $this->context->post('orderby');
		$linkService	= new LinkService();
		if(is_numeric($id) && $id)
		{
			$link	= $linkService->get($id);
			if($link)
			{
				$linkService->update($id,array('site_name'=>$siteName,'url'=>$url,'index_show'=>$indexShow,'orderby'=>$orderby,));
				$this->code	= 200;
				$this->data['forward'] = C('LtUrl')->generate('Link', 'Index');
			}
			else
			{
				$this->code	= 400;
			}
		}
		else
		{
			$id	= $linkService->add(array('site_name'=>$siteName,'url'=>$url,'index_show'=>$indexShow,'orderby'=>$orderby,));
			if($id)
			{
				$this->code	= 200;
				$this->data['forward'] = C('LtUrl')->generate('Link', 'Index');
			}
			else
			{
				$this->code	= 400;
			}
		}
	}
}
