<?php
class MenuAddOtherAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'admin';
	}

	public function execute()
	{
		$menuService	= new MenuService();
		$cid			= $this->context->get('cid');
		$pid			= $this->context->get('pid');
		$data			= array();
		//Ƶ
		if(is_numeric($cid) && $cid)
		{
			$channelService	= new ChannelService();
			$info			= $channelService->get($cid);
			if($info)
			{
				$data['name']		= $info['name'];
				$data['orderby']	= 0;
				$data['link']		= $this->getMenuLink($info['url'],1);
			}
		}
		if(is_numeric($pid) && $pid)
		{
			$pageService	= new PageService();
			$info			= $pageService->get($pid);
			if($info)
			{
				$data['name']		= $info['name'];
				$data['orderby']	= 0;
				$data['link']		= $this->getMenuLink($info['url'],2);
			}
		}
		if(!empty($data))
		{
			$menuService->add($data);
		}
		
		header('Location:'.C('LtUrl')->generate('Menu','Index'));
	}
	
	private function getMenuLink($param,$type)
	{
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "admin")).'frontend/conf/standard/';
		$routerFile		= $confBaseDir.'router.conf.php';
		$content		= file_get_contents($routerFile);
		
		if(preg_match('~\'protocol\'\s+=>\s+\'(.*?)\'~is',$content,$m))
		{
			$protocol	= $m[1];
		}
		
		if($protocol=='standard')
		{
			if($type==1)
			{
				$url	= 'index.php?module=PinDao&action=Index&url='.$param;
			}
			else if($type==2)
			{
				$url	= 'index.php?module=Page&action=Index&url='.$param;
			}
		}
		else
		{
			if(preg_match('~\'postfix\'\s+=>\s+\'(.*?)\'~is',$content,$m))
			{
				$postfix	= $m[1];
			}
			
			if($type==1)
			{
				$url	= 'PinDao-Index-url';
			}
			else if($type==2)
			{
				$url	= 'Page-Index-url';
			}
			
			if(preg_match("~'$url' => '(.*?)'~is",$content,$m))
			{
				$url	= $m[1];
			}
			
			if($protocol=='rewrite')
			{
				$url	.= '-'.$param.$postfix;
			}
			else if($protocol=='path_info')
			{
				$url	= 'index.php/'.$url.'-'.$param.$postfix;
			}
		}
		$url	= $this->data['baseurl'].$url;
		
		return $url;
	}
}
