<?php
class SiteSaveCacheAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('site','cache');
	}
	
	public function execute()
	{
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/standard/';
		$cacheFile		= $confBaseDir.'cache.conf.php';
		
		//cache设置
		$fp 			= fopen($cacheFile, 'r');
		$content 		= fread($fp, filesize($cacheFile));
		fclose($fp);
		
		$lce			= $this->context->post('listcacheenable');
		if(!is_numeric($lce))
		{
			$lce		= 0;
		}
		$dce			= $this->context->post('detailcacheenable');
		if(!is_numeric($dce))
		{
			$dce		= 0;
		}
		$oce			= $this->context->post('othercacheenable');
		if(!is_numeric($oce))
		{
			$oce		= 0;
		}
		
		$content 	= preg_replace('~\$config\["cache.product"\]\["listcacheenable"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["listcacheenable"] = "'.str_replace('"',"'",$lce).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["detailcacheenable"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["detailcacheenable"] = "'.str_replace('"',"'",$dce).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["othercacheenable"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["othercacheenable"] = "'.str_replace('"',"'",$oce).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["listcacheperiod"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["listcacheperiod"] = "'.str_replace('"',"'",$this->context->post('listcacheperiod')).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["detailcacheperiod"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["detailcacheperiod"] = "'.str_replace('"',"'",$this->context->post('detailcacheperiod')).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["othercacheperiod"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["othercacheperiod"] = "'.str_replace('"',"'",$this->context->post('othercacheperiod')).'"', $content);
		
		$fp 		= fopen($cacheFile, 'w');
		fwrite($fp, trim($content));
		fclose($fp);
		
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/';
		
		$configFile 	= $confBaseDir . 'conf_dev.php';
		if(!is_file($configFile))
		{
			$configFile 	= $confBaseDir . 'conf.php';
		}
		C('LtConfig')->loadConfigFile($configFile,true);
		$this->code	= 200;
	}
}
