<?php
class SiteSaveListAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('site','list');
	}
	
	public function execute()
	{
		$data			= $this->getValidData();
		//佣金比率
		if($data['crMin']!='' || $data['crMax']!='')
		{
			if(!($data['crMin']!='' && $data['crMax']!=''))
			{
				$this->data['error_messages']['crMax']	= array('both'=>'两个只能是都填或者都不填');
			}
			else
			{
				if($data['crMin']>=$data['crMax'])
				{
					$this->data['error_messages']['crMax']	= array('lower'=>'起始佣金比率必须小于最高佣金比率');
				}
			}
		}
		if(!empty($this->data['error_messages']))
		{
			$this->code	= 407;
		}
		else
		{
			$settingService	= new SettingService();
			$skey			= 'list_setting';
			$tmp			= $settingService->get($skey);
			if(!$tmp)
			{
				$settingService->add($skey,$data,true);
			}
			else
			{
				$settingService->update($skey,$data,false,true);
			}
			$this->code	= 200;
		}
	}
}
