<?php
class SiteSaveSeoAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('site','seo');
	}
	
	public function execute()
	{
		//URL设置
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "admin")).'frontend/conf/standard/';
		$routerFile		= $confBaseDir.'router.conf.php';
		$content		= file_get_contents($routerFile);
		$mode			= $this->context->post('mode');
		$postfix		= $this->context->post('postfix');
		$listshortcut	= $this->context->post('listshortcut');
		$detailshortcut	= $this->context->post('detailshortcut');
		$content		= preg_replace('~\'postfix\' => \'(.*?)\'~is', '\'postfix\' => \''.$postfix.'\'', $content);
		$content		= preg_replace('~\'protocol\' => \'(.*?)\'~is', '\'protocol\' => \''.$mode.'\'', $content);
		$content		= preg_replace('~\'Default-List\' => \'(.*?)\'~is', '\'Default-List\' => \''.$listshortcut.'\'', $content);
		$content		= preg_replace('~\'Default-View-id\' => \'(.*?)\'~is', '\'Default-View-id\' => \''.$detailshortcut.'\'', $content);
		file_put_contents($routerFile,$content);
		
		//保存seo信息
		$data	= $this->getValidData();
		$settingService	= new SettingService();
		$skey			= 'seo_setting';
		$tmp			= $settingService->get($skey);
		if(!$tmp)
		{
			$settingService->add($skey,$data,true);
		}
		else
		{
			$settingService->update($skey,$data,false,true);
		}
		
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/';
		
		$configFile 	= $confBaseDir . 'conf_dev.php';
		if(!is_file($configFile))
		{
			$configFile 	= $confBaseDir . 'conf.php';
		}
		C('LtConfig')->loadConfigFile($configFile,true);
		
		$this->code	= 200;
	}
}
