<?php
class SiteSaveSystemAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('config','system');
	}
	
	public function execute()
	{
		$data	= $this->getValidData();
		if(!is_numeric($data['detail']['showcontent']))
		{
			$data['detail']['showcontent']	= 0;
		}
		$settingService	= new SettingService();
		$skey			= 'config_setting';
		$tmp			= $settingService->get($skey);
		if(!$tmp)
		{
			$settingService->add($skey,$data,true);
		}
		else
		{
			$settingService->update($skey,$data,false,true);
		}
		$this->code	= 200;
	}
}
