<?php
class SiteSaveUcenterAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'json';
	}
	
	protected function afterConstruct()
	{
		$this->parseDtds('site','ucenter');
	}
	
	public function execute()
	{
		$configFile		= UC_BASE.'config.inc.php';
		
		//cache设置
		$fp 			= fopen($configFile, 'r');
		$content 		= fread($fp, filesize($configFile));
		fclose($fp);
		
		$enable			= $this->context->post('ucenable');
		if(is_numeric($enable) && $enable>0)
		{
			$enable		= 1;
		}
		else
		{
			$enable		= 0;
		}
		
		$data			= $this->getValidData();
		$data['enable']	= $enable;
		
		//替换配置文件
		$content 	= preg_replace("~'UC_KEY', '(.*?)'~is", "'UC_KEY', '".str_replace("'",'""',$data['uckey'])."'", $content);
		$content 	= preg_replace("~'UC_API', '(.*?)'~is", "'UC_API', '".str_replace("'",'""',$data['ucapi'])."'", $content);
		$content 	= preg_replace("~'UC_CHARSET', '(.*?)'~is", "'UC_CHARSET', '".str_replace("'",'""',$data['charset'])."'", $content);
		$content 	= preg_replace("~'UC_IP', '(.*?)'~is", "'UC_IP', '".str_replace("'",'""',$data['ucip'])."'", $content);
		$content 	= preg_replace("~'UC_APPID', '(.*?)'~is", "'UC_APPID', '".str_replace("'",'""',$data['ucappid'])."'", $content);
		
		$fp 		= fopen($configFile, 'w');
		fwrite($fp, trim($content));
		fclose($fp);
		
		//保存到数据库中
		$settingService	= new SettingService();
		$skey			= 'uc_setting';
		$tmp			= $settingService->get($skey);
		if(!$tmp)
		{
			$settingService->add($skey,$data,true);
		}
		else
		{
			$settingService->update($skey,$data,false,true);
		}
		
		$this->code	= 200;
	}
}
