<?php
class DefaultIndexAction extends FrontendAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
		
		$this->data['menu']	= 'default';
		$this->data['layout_class']	= 'yui-t5';
	}

	public function execute()
	{
		$moduleService				= new ModuleService();
		$moduleList					= $moduleService->getListByPosition(0);
		$this->data['moduleList']	= $moduleList;
		
		$seoConfig		= C('SettingService')->get('seo_setting',true);
		$seoTitle		= $this->getSeoStr($seoConfig['indextitle'],array());
		$seoKeyword		= $this->getSeoStr($seoConfig['indexkeyword'],array());
		$seoDescription	= $this->getSeoStr($seoConfig['indexdescription'],array());
		
		$productService	= new ProductService();
		$homekey	= $productService->getpaihots();
		$this->data['paipaitop']	= $homekey['data'];
		
		$this->data['seo']['title']			= $seoTitle;
		$this->data['seo']['keyword']		= $seoKeyword;
		$this->data['seo']['description']	= $seoDescription;
	}
}
