<?php
class DefaultListAction extends FrontendAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
		$this->data['menu']	= 'list';
	}

	public function execute()
	{
		$keyword	= $this->context->get('k');
		if(empty($keyword))
		{
			$keyword	= $this->context->post('k');
		}
		$keyword	= str_replace('/','',$keyword);
		$cat		= $this->context->get('c');
		if(empty($cat))
		{
			$cat	= $this->context->post('c');
		}
		if(!is_numeric($cat))
		{
			$cat = 0;
		}
		// 排序方式:
		// 88 CPS默认排序
		// 89 CPS商品销量排序
		// 4 时间升序
		// 5 时间降序
		// 6 价格升序
		// 7 价格降序
		// 8 信用升序
		// 9 信用降序
		// 10 浏览量升序
		// 11 浏览量降序
		// 12 推荐排序升序
		// 13 综合排序+图片打散
		// 14 综合排序+图片打散
		// 15 综合排序+图片打散
		// 21 按收藏量排序降序
		// 23 按收藏时间排序降序
		// 26 女装排序中的时间轮转
		// 30 按佣金率升序
		// 31 按佣金率降序
		// 32 按佣金升序
		// 33 按佣金降序
		// 80 综合排序+卖家打散
		$orderby	= $this->context->get('o');
		if(!in_array($orderby,array(4,5,6,7,8,9,10,11,12,13,14,15,21,23,26,30,31,32,33,80,88,89)))
		{
			$orderby	= '';
		}
		$price1		= $this->context->post('g1');
		if(empty($price1))
		{
			$price1	= $this->context->get('g1');
		}
		$price2		= $this->context->post('g2');
		if(empty($price2))
		{
			$price2	= $this->context->get('g2');
		}

		$pageSize			= 40;
		$lss				= new SettingService();
		$con				= $lss->get('list_setting',true);
		if(empty($con))
		{
			$con			= array();
		}
		else
		{
			if(array_key_exists('page_size',$con) && is_numeric($con['page_size']) && $con['page_size']>0 && $con['page_size']<=40)
			{
				$pageSize	= $con['page_size'];
			}
			unset($con['page_size']);
		}
		$keyword = trim($keyword);
		if($keyword!='')
		{
			if(function_exists('mb_detect_encoding'))
			{
				$defaultEncode	= $this->data['config']['system']['encode'];
				if(!empty($defaultEncode) && $defaultEncode!='UTF-8')
				{
					$encode 	= mb_detect_encoding($keyword, C('CommonFunction')->getDefaultArray($defaultEncode,array('EUC-CN','ASCII','UTF-8','GB2312','GBK','BIG5')));
					if($encode!='UTF-8')
					{
						$keyword	= iconv($encode,'UTF-8',$keyword);
					}
				}
			}
			$keyword = htmlspecialchars(trim($keyword));
			if(!empty($keyword))
			{
				$con['keyWord']	= $keyword;
				//$this->data['config']['search8']['keyword']	= $keyword;
			}
		}
		
		//检查关键词是否屏蔽
		if(!empty($keyword))
		{
			$settingService = C('SettingService');
			$forbiddenSetting = $settingService->get('forbidden_setting',true);
			if(!empty($forbiddenSetting['keywords']))
			{
				$keywords = explode("\n",str_replace("\r", "", $forbiddenSetting['keywords']));
				if(in_array($keyword,$keywords))
				{
					//屏蔽的商品列表
					$this->layout 	= 'result';
					$this->code		= 403;
					return;
				}
			}
		}

		$categoryName		= '';
		$categoryService	= C('CategoryService');
		if($cat>0)
		{
			$parentCategoryList	= $categoryService->getParentList($cat);
			if($parentCategoryList)
			{
				$this->data['parentCategoryList']	= $parentCategoryList;
				$categoryName						= $parentCategoryList[count($parentCategoryList)-1]['name'];
				if($parentCategoryList[count($parentCategoryList)-1]['is_hide']==1)
				{
					$this->layout 	= 'result';
					$this->code		= 403;
					return;
				}
			}
		}
		
		if($cat>0)
		{
			$cattmp		= $categoryService->get($cat);
			$con['classId']		= $cattmp['cid'];
			$this->data['id']	= $cat;
			$this->data['cid']	= $cattmp['cid'];
		}
		if($price1){
			$con['begPrice']	= $price1;
		}
		if($price2){
			$con['endPrice']	= $price2;
		}
		$this->data['con']				= $con;
 		$this->data['con']['orderby']	= $orderby;
		
		$page			= $this->getPage();
		$ltConfig		= C('LtConfig');
		$pagerConfig	= $ltConfig->get('pagination.pager');
		
		$pagerConfig['per_page']		= $pageSize;
		if($this->data['isRobot'])
		{
			$pagerConfig['num_links_show']	= 100;
		}
		else
		{
			$pagerConfig['num_links_show']	= 15;
		}
		$ltConfig->addConfig(array('pagination.pager'=>$pagerConfig));
		
		$num 			= $pageSize;
		$start	 		= ($page-1) * $pageSize;
		$con['pageIndex']	= $start + 1;
		$con['pageSize']	= $pageSize;
		$con['orderStyle']	= $orderby;


		$productService	= new ProductService();
		$productService->searchPaikeProducts($con);
		$totalNum		= $productService->getTotalProcuct();
		$productList	= $productService->getProductList();
		$this->data['totalNum']		= $totalNum;
		$this->data['productList']	= $productList;
		$this->data['ppcids']	= $productService->get_paipai_ckeys($con['classId']);
		$this->data['xgkeys']	= $productService->get_paipai_kkeys($con['keyWord']);
		
		$baseUrl 	= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'o'=>$orderby,'g1'=>$price1,'g2'=>$price2,'p' => ':page'));
		$baseUrls 	= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'o'=>$orderby,'g1'=>$price1,'g2'=>$price2,'p' => $page));
		$this->data['purl'] = $baseUrls;
		
		$pagination 	= new PiscesPagination;
		$pagination->init();
		//$this->data['pages'] = $pagination->pager($page, $totalNum, $baseUrl, 10);
		$this->data['pages'] = $pagination->pager($page, $totalNum, $baseUrl);

		$orderLink				= array();
		$orderLink['select']	= $orderby;
		$orderLink['']		= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'p' => $page));
		$orderLink['num']		= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'o'=>89,'p' => $page));
		$orderLink['fav']		= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'o'=>21,'p' => $page));
		$orderLink['rate']		= C('LtUrl')->generate('Default', 'List', array('k'=>$keyword,'c'=>$cat,'o'=>8,'p' => $page));

		$this->data['orderby']	= $orderLink;

		$seoConfig		= C('SettingService')->get('seo_setting',true);
		$seoTitle		= $this->getSeoStr($seoConfig['listtitle'],array('keyword'=>$keyword,'catName'=>$categoryName,'page'=>$page));
		$seoKeyword		= $this->getSeoStr($seoConfig['listkeyword'],array('keyword'=>$keyword,'catName'=>$categoryName,'page'=>$page));
		$seoDescription	= $this->getSeoStr($seoConfig['listdescription'],array('keyword'=>$keyword,'catName'=>$categoryName,'page'=>$page));
		
		$this->data['seo']['title']			= $seoTitle;
		$this->data['seo']['keyword']		= $seoKeyword;
		$this->data['seo']['description']	= $seoDescription;
		
		
		if(!$this->data['isRobot'])
		{
			// 跳转到s8
			//$url = C('LtUrl')->generate('Default','Search8',array('q'=>$keyword));
			//$this->redirect($url);
		}
	}
}
