<?php
class DefaultSitemapAction extends FrontendAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
		$this->data['menu']	= 'list';
	}

	public function execute()
	{
		$page			= $this->getPage();

		$ltConfig		= C('LtConfig');
		$pagerConfig	= $ltConfig->get('pagination.pager');
		$pageSize		= 100;
		$pagerConfig['per_page']		= $pageSize;
		if($this->data['isRobot'])
		{
			$pagerConfig['num_links_show']	= 100;
		}
		else
		{
			$pagerConfig['num_links_show']	= 10;
		}
		$ltConfig->addConfig(array('pagination.pager'=>$pagerConfig));
		
		$num 			= $pageSize;
		$start	 		= ($page-1) * $pageSize;
		
		$categoryService			= new CategoryService();
		$categoryList				= $categoryService->getSitemapCategoryList($start,$num);
		$this->data['categoryList']	= $categoryList['rows'];
		$totalNum					= $categoryList['count'];
		
		$productService	= new ProductService();
		$homekey	= $productService->getpaihots();
		$this->data['paipaitop']	= $homekey['data'];
		
		$baseUrl 	= C('LtUrl')->generate('Default', 'Sitemap', array('p' => ':page'));
		
		$pagination 	= new PiscesPagination;
		$pagination->init();
		$this->data['pages'] = $pagination->pager($page, $totalNum, $baseUrl);
		
		//$this->data['seo']['title']	= '网站地图-'.$page;
		$this->data['seo']['title']	= '网站地图 - '.$this->data['site']['site_name'];
	}
}
