<?php
class DefaultInstallAction extends InstallAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
	}

	public function execute()
	{
		$p			= strpos($_SERVER['SCRIPT_NAME'], 'install.php');
		$baseurl	= substr($_SERVER['SCRIPT_NAME'], 0, $p);
		
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/standard/';
		
		$fp 			= fopen($confBaseDir.'host.conf.php', 'r');
		$content 		= fread($fp, filesize($confBaseDir.'host.conf.php'));
		fclose($fp);
		
		$content 	= preg_replace('~\$config\["baseurl"\] = ".*?";~is', '$config["baseurl"] = "'.$baseurl.'";', $content);
		
		$fp 		= fopen($confBaseDir.'host.conf.php', 'w');
		fwrite($fp, trim($content));
		fclose($fp);
		
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/';
		
		$configFile 	= $confBaseDir . 'conf_dev.php';
		if(!is_file($configFile))
		{
			$configFile 	= $confBaseDir . 'conf.php';
		}
		C('LtConfig')->loadConfigFile($configFile,true);
		
		$this->data['baseurl']	= C('LtConfig')->get('baseurl');
	}
}
