<?php
class DefaultInstall2Action extends InstallAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
	}

	public function execute()
	{
		if(!function_exists('mysql_connect'))
		{
			$this->data['mysql_enabled']	= 0;
			$this->data['quit']				= 1;
		}
		else
		{
			$this->data['mysql_enabled']	= 1;
		}
		
		$this->data['disk_space'] 			= intval(diskfreespace('.') / (1024 * 1024)).'M';
		
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/standard/';
		
		$errors	= array();
		if(is_writeable($confBaseDir.'db.conf.php'))
		{
			$this->data['writeable']['db'] 	= 1;
		}
		else
		{
			$this->data['writeable']['db'] 	= 0;
			$this->data['warning']			= 1;
			$errors[]	= '数据库配置文件paipai\code\conf\standard\db.conf.php文件不可写，请手工修改文件中的数据库配置后再继续安装';
		}
		
		$codeBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app"));
		$piscesBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "code"));
		$checkdir 		= array('tmp' => $codeBaseDir.'tmp', 'backup' => $piscesBaseDir.'backup');
		
		foreach($checkdir as $k=>$v)
		{
			if($this->isDirWriteable($v))
			{
				$this->data['writeable'][$k] 	= 1;
			}
			else
			{
				$this->data['writeable'][$k] 	= 0;
				$this->data['quit']				= 1;
			}
		}
		
		$opts = array(
		    'http'=>array(
		    'method'=>"GET",
		    'timeout'=>3,
		  )
		);
		$context = stream_context_create($opts);
	}
	
	private function isDirWriteable($dir)
	{
		if(!is_dir($dir))
		{
			@mkdir($dir, 0777);
		}
		$writeable	=	 false;
		if(is_dir($dir))
		{
			if($fp = @fopen("$dir/write_test.txt", 'w'))
			{
				@fclose($fp);
				@unlink("$dir/write_test.txt");
				$writeable 	= true;
			}
			else
			{
				$writeable 	= false;
			}
		}
		return $writeable;
	}
}
