<?php
class PiscesPagination extends LtPagination
{
	public function __construct()
	{
		parent::__construct();
	}
	
	public function pager($page, $count, $url, $maxPage=100)
	{
		$perPage 	= empty($this->conf['per_page']) ? 25 : $this->conf['per_page'];
		$pagecount 	= ceil($count / $perPage);
		if($maxPage>0 && $pagecount>$maxPage)
		{
			$count	= $perPage*$maxPage;
		}
		return parent::pager($page, $count, $url);
	}
}
