<?php
class BaseDao
{
	protected $db;
	protected $dbh;
	protected $tg;
	
	public function __construct()
	{
		$this->init();
	}
	
	private function init()
	{
		$this->db = LtObjectUtil::singleton('LtDb');
		$this->db->init();
		$this->dbh = $this->db->getDbHandle();
	}
	
	public function getDbh()
	{
		return $this->dbh;
	}
	
	public function get($id)
	{
		return $this->tg->fetch($id);
	}
	
	public function add($data)
	{
		if(!array_key_exists('created', $data))
		{
			$data['created']	= date('Y-m-d H:i:s');
		}
		$result = $this->tg->insert($data);
		return $result;
	}
	
	public function update($id,$data)
	{
		$condition['expression'] 	= "id=:id";
		$condition['value']['id'] 	= $id;
		return $this->tg->updateRows($condition, $data);
	}
	
	public function updateRows($condition, $data)
	{
		return $this->tg->updateRows($condition, $data);
	}
	
	public function del($id)
	{
		return $this->tg->delete($id);
	}
	
	public function count($condition)
	{
		$result = $this->tg->count($condition);
		return $result;
	}
	
	public function fetch($condition)
	{
		$result	= $this->tg->fetchRows(array('where'=>$condition));
		if(!$result)
		{
			return false;
		}
		return $result[0];
	}
	
	public function fetchRows($condition)
	{
		$result = $this->tg->fetchRows($condition);
		return $result;
	}
	
	public function deleteRows($condition)
	{
		$result = $this->tg->deleteRows($condition);
		return $result;
	}
}