<?php
class LinkDao extends BaseDao
{
	private $tgLink;
	
	public function __construct()
	{
		parent::__construct();
		$this->tgLink 	= $this->db->getTDG(C('LtConfig')->get('db.table.prefix')."link");
	}
	
	public function get($id)
	{
		return $this->tgLink->fetch($id);
	}
	
	public function add($data)
	{
		$result = $this->tgLink->insert($data);
		return $result;
	}
	
	public function update($id,$data)
	{
		$condition['expression'] 	= "id=:id";
		$condition['value']['id'] 	= $id;
		return $this->tgLink->updateRows($condition, $data);
	}
	
	public function del($id)
	{
		return $this->tgLink->delete($id);
	}
	
	public function count($condition)
	{
		$result = $this->tgLink->count($condition);
		return $result;
	}
	
	public function fetchRows($condition)
	{
		$result = $this->tgLink->fetchRows($condition);
		return $result;
	}
}