<?php
class MenuDao extends BaseDao
{
	public function __construct()
	{
		parent::__construct();
		$this->tg 	= $this->db->getTDG(C('LtConfig')->get('db.table.prefix')."setting");
	}
	
	public function update($data)
	{
		$condition['where']['expression'] 	= "skey = 'menu_list'";
		$tmp		= $this->tg->fetchRows($condition);
		if(!$tmp)
		{
			$this->tg->insert(array('skey'=>'menu_list','val'=>serialize($data),'created'=>date('Y-m-d H:i:s')));
		}
		else
		{
			$condition['expression'] 	= "skey = 'menu_list'";
			$this->tg->updateRows($condition, array('val'=>serialize($data)));
		}
	}
	
	public function getList()
	{
		$condition['where']['expression'] 	= "skey = 'menu_list'";
		$tmp		= $this->tg->fetchRows($condition);
		if($tmp)
		{
			$tmp	= unserialize($tmp[0]['val']);
			if(!is_array($tmp) || count($tmp)<=0)
			{
				$tmp	= array();
			}
			else
			{
				usort($tmp,array($this,'sortByOrderBy'));
			}
		}
		return $tmp;
	}
	
	private function sortByOrderBy($a, $b)
	{
		if($a['orderby']>=$b['orderby'])
		{
			return -1;
		}
		return 1;
	}
}