<?php
class AdminService
{
	private $adminDao;
	public function __construct()
	{
		$this->adminDao	= new AdminDao();
	}
	
	//idȡû
	public function get($id)
	{
		$info	= $this->adminDao->get($id);
		$cf		= C('CommonFunction');
		if(!empty($info['login_ip']))
		{
			$info['login_ip']	= $cf->number2ip($info['login_ip']);
		}
		if(!empty($info['last_login_ip']))
		{
			$info['last_login_ip']	= $cf->number2ip($info['last_login_ip']);
		}
		return $info;
	}
	
	//ûȡû
	public function getByName($username)
	{
		return $this->adminDao->getByName($username);
	}
	
	//û
	public function add($data)
	{
		if(!array_key_exists('created', $data))
		{
			$data['created']	= date('Y-m-d H:i:s');
		}
		
		$result = $this->adminDao->add($data);
		flush();
		ob_flush();
		flush();
		ob_flush();
		return $result;
	}
	
	public function userNameExists($username)
	{
		return $this->adminDao->exists($username,'username');
	}
	
	public function checkUserLogin($username, $password)
	{
		$user	= $this->getByName($username);
		if(!$user)
		{
			return false;
		}
		if(md5(md5($password).$user['secques'])!=$user['password'])
		{
			return false;
		}
		return $user;
	}
	
	public function updateUserPassword($id,$password,$secques)
	{
		$password	= md5(md5($password).$secques);
		return $this->adminDao->update($id,array('password'=>$password));
	}
	
	public function updateLoginInfo($id,$ip,$loginTime)
	{
		$info	= $this->adminDao->get($id);
		
		if(!$info)
		{
			return false;
		}
		$cf							= C('CommonFunction');
		$data['last_login_ip']		= $info['login_ip'];
		if(!empty($info['login_time']))
		{
			$data['last_login_time']	= $info['login_time'];
		}
		$data['login_times']		= $info['login_times']+1;
		$data['login_time']			= $loginTime;
		$data['login_ip']			= $cf->ip2number($ip);
		
		return $this->adminDao->update($id,$data);
	}
	
	public function createPassword($password,$secques)
	{
		return md5(md5($password).$secques);
	}
}