<?php
class CategoryService extends BaseDbService
{
	public function __construct()
	{
		$this->dao		= new CategoryDao();
	}
	
	public function get($id)
	{
		return $this->dao->get($id);
	}
	
	public function getByIds($ids)
	{
		if(empty($ids))
		{
			return false;
		}
		
		$idSql = $this->getInSql($ids);
		$condition['where']['expression']	= 'id in('.$idSql.')';
		
		return $this->dao->fetchRows($condition);
	}
	
	public function add($data)
	{
		$result	= $this->dao->add($data);
		$this->makeJsCategory();
		return $result;
	}
	
	public function del($id)
	{
		$list		= $this->getCategoryListByPId($id,$sub);
		if($list)
		{
			foreach($list as $lv)
			{
				$this->del($lv['id']);
			}
		}
		$this->dao->del($id);
		$this->makeJsCategory();
	}
	
	public function hideCategory($id,$hide)
	{
		$this->update($id,array('is_hide'=>$hide));
		$subList	= $this->getCategoryListByPId($id);
		if($subList)
		{
			foreach($subList as $sv)
			{
				$this->hideCategory($sv['id'],$hide);
			}
		}
	}
	
	public function menuCategory($id,$menu)
	{
		$this->update($id,array('is_menu'=>$menu));
	}
	
	public function update($id,$data)
	{
		$result	= $this->dao->update($id,$data);
		$this->makeJsCategory();
		return $result;
	}
	
	public function getParentList($id,$self=true)
	{
		$list	= array();
		$info	= $this->dao->get($id);
		if($info)
		{
			if($info['pid']>0)
			{
				$list	= $this->getParentList($info['pid'],true);
			}
			if($self)
			{
				if(!$list)
				{
					$list	= array();
				}
				$list[]	= $info;
			}
		}
		return $list;
	}
	
	public function checkIdAndPid($id,$pid)
	{
		$list	= $this->getParentList($pid);
		if($list)
		{
			foreach($list as $lv)
			{
				if($lv['id']==$id)
				{
					return false;
				}
			}
		}
		return true;
	}
	
	public function getCategoryListByPId($pid, $update=false)
	{
		$condition['where']['expression'] 	= 'pid = '.$pid;
		$condition['orderby'] 				= 'orderby DESC,id ASC';
		return $this->dao->fetchRows($condition);
	}
	
	public function getcid($cid)
	{
		$condition['expression'] 	= 'cid=:cid';
		$condition['value']['cid']	= $cid;
		$result = $this->fetch($condition);
		return $result;
	}
	
	public function getTopShowCategoryList()
	{
		$condition['where']['expression'] 	= 'is_hide=0 and pid = 0';
		$condition['orderby'] 				= 'orderby DESC,id ASC';
		$list		= $this->dao->fetchRows($condition);
		return $list;
	}
	
	public function getMenuCategoryList()
	{
		$condition['where']['expression'] 	= 'is_hide=0 and is_menu=1';
		$condition['orderby'] 				= 'orderby DESC,id ASC';
		$list		= $this->dao->fetchRows($condition);
		return $list;
	}
	
	public function getSitemapCategoryList($start, $num)
	{
		$condition['where']['expression'] 	= 'is_hide=0';
		$condition['orderby'] 				= 'pid ASC, orderby DESC,id ASC';
		$result['count'] 					= $this->dao->count($condition);
		if($result['count']>0)
		{
			$condition['limit'] 			= $num;
			$condition['offset'] 			= $start;
			$result['rows']					= $this->dao->fetchRows($condition);
		}
		return $result;
	}
	
	public function makeJsCategory()
	{
		$jsFile		= APP_WEB_PATH.DIRECTORY_SEPARATOR.'js'.DIRECTORY_SEPARATOR.'category.js';
		$condition['where']['expression'] 	= 'is_hide = 0';
		$condition['orderby'] 				= 'orderby DESC,id ASC';
		$list		= $this->dao->fetchRows($condition);
		$all		= array();
		$multi		= array();
		foreach($list as $cv)
		{
			$tmp							= array('name'=>$cv['name'],'value'=>$cv['id'],'pid'=>$cv['pid']);
			$all[$cv['id']]					= $tmp;
			$multi['multi_'.$cv['pid']][]	= $tmp;
		}
		
		$content	= 'var dataAllCategory='.json_encode($all).';';
		$content	.= 'var dataMultiCategory='.json_encode($multi).';';
		return file_put_contents($jsFile, $content);
	}
}
?>