<?php
class ConfigSettingService extends BaseDbService
{
	public function __construct()
	{
		$this->dao	= new DataDao();
	}
	
	public function get($cache=false)
	{
		if($cache)
		{
			$cache 	= new LtCache();
			$cache->init();
			$ch 	= $cache->getTDG(C('LtConfig')->get('db.table.prefix')."data_config");
			$tmp	= $ch->get('config');
			if(!empty($tmp))
			{
				return $tmp;
			}
		}
		
		$condition['where']['expression'] 	= "name = 'config_setting'";
		$tmp								= $this->dao->fetchRows($condition);
		if(!$tmp)
		{
			return false;
		}
		
		$result	= unserialize($tmp[0]['val']);
		$this->updateCache($result);
		return $result;
	}
	
	public function add($data)
	{
		$result	= $this->dao->add(array('name'=>'config_setting','val'=>serialize($data)));
		$this->updateCache($data);
		return $result;
	}
	
	public function update($data)
	{
		$condition['expression'] 	= "name = 'config_setting'";
		$result	= $this->dao->updateRows($condition, array('val'=>serialize($data)));
		$this->updateCache($data);
		return $result;
	}
	
	private function updateCache($data)
	{
		$cache 	= new LtCache();
		$cache->init();
		$ch 	= $cache->getTDG(C('LtConfig')->get('db.table.prefix')."data_config");
		$tmp	= $ch->get('config');
		if($tmp!==false)
		{
			$ch->update('config',$data);
		}
		else
		{
			$ch->add('config',$data);
		}
	}
}