<?php
class LinkService
{
	private $linkDao;
	public function __construct()
	{
		$this->linkDao	= new LinkDao();
	}
	
	public function get($id)
	{
		return $this->linkDao->get($id);
	}
	
	public function add($data)
	{
		if(!array_key_exists('created', $data))
		{
			$data['created']	= date('Y-m-d H:i:s');
		}
		$result = $this->linkDao->add($data);
		//»
		if($result && $data['index_show']==1)
		{
			$this->getIndexShowList(true);
		}
		return $result;
	}
	
	public function update($id,$data)
	{
		$result	= $this->linkDao->update($id, $data);
		//»
		$this->getIndexShowList(true);
		
		return $result;
	}
	
	public function del($id)
	{
		$tmp	= $this->linkDao->get($id);
		$result	= $this->linkDao->del($id);
		if($tmp && $tmp['index_show']==1)
		{
			$this->getIndexShowList(true);
		}
		return $result;
	}
	
	public function getAll()
	{
		$condition['orderby'] 	= 'orderby DESC';
		return $this->linkDao->fetchRows($condition);
	}
	
	public function getLinkList($start,$num)
	{
		$condition['orderby'] 	= 'updated DESC';
		$result['count'] 		= $this->linkDao->count($condition);
		if($result['count']>0)
		{
			$condition['limit'] 	= $num;
			$condition['offset'] 	= $start;
			$result['rows'] 		= $this->linkDao->fetchRows($condition);
		}
		else
		{
			$result['rows'] 		= false;
		}
		
		return $result;
	}
	
	public function getIndexShowList($updateCache=false)
	{
		$result	= false;
		$cache 	= new LtCache();
		$cache->init();
		$ch 	= $cache->getTDG(C('LtConfig')->get('db.table.prefix')."link");
		
		//cacheлȡ
		if(!$updateCache)
		{
			$result	= $ch->get('index_show_list');
		}
		//ݿвѯ
		if(!$result)
		{
			$condition['where']['expression'] 	= 'index_show = 1';
			$condition['orderby']				= 'orderby DESC';
			$result	= $this->linkDao->fetchRows($condition);
			if($result && $updateCache)
			{
				$tmp	= $ch->get('index_show_list');
				if($tmp!==false)
				{
					$ch->update('index_show_list',$result);
				}
				else
				{
					$ch->add('index_show_list',$result);
				}
			}
		}
		return $result;
	}
}