<?php
class ProductCacheService
{
	public function __construct()
	{
		
	}
	
	public function deleteAll($numPerTime=500)
	{
		$config = C('LtConfig');
		$cacheCfg	= $config->get('cache.product');
		if($cacheCfg['listcacheenable']==1 || $cacheCfg['detailcacheenable']==1)
		{
			//关闭缓存功能
			$this->disableCache();
		}
		
		$listDir	= $cacheCfg['listdir'];
		$detailDir	= $cacheCfg['detaildir'];
		
		//清空列表
		$num = $this->clearCache($listDir,0,$numPerTime);
		if($num<$numPerTime)
		{
			//清空详情
			$num = $this->clearCache($detailDir,$num,$numPerTime);
		}
		
		if($num<$numPerTime)
		{
			$cf = C('CommonFunction');
			$cf->rmdir($listDir);
			$cf->rmdir($detailDir);
		}
		
		return $num;
	}
	
	private function clearCache($dir,$num,$numPerTime)
	{
		if (!file_exists($dir))
		{
			return 0;
		}
		
		$dh  = opendir($dir);
		while (false !== ($filename = readdir($dh))) 
		{
			if($filename=='.' || $filename=='..')
			{
				continue;
			}
			
			$file = $dir.DIRECTORY_SEPARATOR.$filename;
		    if(is_file($file))
		    {
		    	@unlink($file);
		    	$num++;
		    	if($num>=$numPerTime)
		    	{
		    		break;
		    	}
		    }
		    else
		    {
		    	$num = $this->clearCache($file,$num,$numPerTime);
		    	if($num>=$numPerTime)
		    	{
		    		break;
		    	}
		    }
		}
		closedir($dh);
		
		return $num;
	}
	
	private function disableCache()
	{
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "lib")).'conf/standard/';
		$cacheFile		= $confBaseDir.'cache.conf.php';
		
		$content = file_get_contents($cacheFile);
		
		$lce = 0;
		$dce = 0;
		
		$content 	= preg_replace('~\$config\["cache.product"\]\["listcacheenable"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["listcacheenable"] = "'.str_replace('"',"'",$lce).'"', $content);
		$content 	= preg_replace('~\$config\["cache.product"\]\["detailcacheenable"\].*?=.*?"(.*?)"~is', '$config["cache.product"]["detailcacheenable"] = "'.str_replace('"',"'",$dce).'"', $content);
		
		$length = file_put_contents($cacheFile, $content);
		return $length>0;
	}
}
?>