<?php
class ProductService
{
	private $prodcutSearchResult;
	
	private $userId;
	private $useCache;
	
	public function __construct(){
		$this->useCache			= true;
		$this->userId			= 0;
	}
	
	public function getProductById($id)
	{
		$product	= $this->getDataFromCache($id,'detail');
		if(!$product)
		{
			$product = $this->getPaiKeProductByNumId($id);
		}
		return $product;
	}
	
	public function getpaihots(){
		//自动获取首页热门关键词，数据来自于拍拍
		$id = 'home';
		$keywords		= $this->getDataFromCache($id,'other');
		if(!$keywords){
			$url = "http://www.paipai.com/tjw/hotsearch/hotsearch.js?t=";
			$opts = array(
				'http'=>array(
				'method'=>"GET",
				'timeout'=>3,
			  )
			);
			$context 			= stream_context_create($opts);
			$contents			= file_get_contents($url,false,$context);
			if(strlen($contents)>='128'){
				preg_match_all ('/"(.*)"/isU', $contents, $match);
				for ($i=1; $i<101; $i++) {
					$names = str_replace('"','',$match[1][$i]);
					$keywords['data'][$i]['name'] = iconv('GB2312','UTF-8',$names); 
				}
			}
			$this->saveDataToCache($id,'other',$keywords);
		}
		return $keywords;
	}
	
	public function get_paipai_ckeys($cid=0){
	//自动获取栏目页——本类热搜
		$keywords		= $this->getDataFromCache($cid,'other');
		if(!$keywords){
			$url = "http://search.paipai.com/cgi-bin/topKeywordCgi?mode=1002&keywordsNumber=10&classID=$cid&&format=json&charset=utf-8";
			$snoopy = new Snoopy;
			$snoopy->fetch($url);
			$content = $snoopy->results;
			if(strlen($content)>='128'){
				preg_match_all ('/\[\'(.*)\',\'/isU', $content, $match);
				for ($i=1; $i<count($match[1]); $i++) {
					$names = str_replace('"','',$match[1][$i]);
					$keywords['data'][$i]['name'] = iconv('GB2312','UTF-8',$names); 
				}
			}
			$this->saveDataToCache($cid,'other',$keywords);
		}
		return $keywords;
	}
	//获取关键词相关
	public function get_paipai_kkeys($key){
		$cacheId		= md5($key);
		$keywords		= $this->getDataFromCache($cacheId,'other');
		if(!$keywords){
			$key = iconv("UTF-8","GB2312",$key);
			$url = "http://search.paipai.com/cgi-bin/relevant_search?KeyWord=$key";
			$snoopy = new Snoopy;
			$snoopy->fetch($url);
			$content = $snoopy->results;
			if(strlen($content)>='128'){
				preg_match_all ('/\[\'(.*)\',\'/isU', $content, $match);
				for ($i=1; $i<count($match[1]); $i++) {
					$names = str_replace('"','',$match[1][$i]);
					$keywords['data'][$i]['name'] = iconv('GB2312','UTF-8',$names); 
				}
			}
			$this->saveDataToCache($cacheId,'other',$keywords);
		}
		return $keywords;
	}
	private function getPaiKeProductByNumId($id)
	{
		if(empty($id))
		{
			return false;
		}
		$product		= $this->getDataFromCache($id,'detail');
		$config = C('SettingService')->get('config_setting',true);
		if(!$product || ($config['detail']['showcontent'] && count($product['detailInfo'])<1))
		{
			$product = false;
		}

		$paipaiService	= new PaiPaiService("http://api.paipai.com/item/getItem.xhtml");
		$params['itemCode'] = $id;
		if($config['detail']['showcontent'])$params['needDetailInfo'] = 1;
		$params["needParseAttr"] = 1;
		$product = $paipaiService->getResult($params);
		if($product['errorCode']!=0)
		{
			$product = false;
		}
		//
		//保存到cache中
		$this->saveDataToCache($id,'detail',$product);
		return $product;
	}
	
	public function getList($con,$fields=array(),$cache=0,$position='')
	{
		//从缓存中获取
		$cacheId		= md5(serialize($con).serialize($fields).$cache.$position);
		if($cache>0)
		{
			$result	= $this->getListFromCache($cacheId);
			if($result)
			{
				return $result;
			}
		}
		
		$this->searchPaikeProducts($con,$fields,false);
		$result		= $this->getProductList();
		//更新cache
		if($cache>0 && $result)
		{
			$this->saveListToCache($cacheId,$result,$cache);
		}
		return $result;
	}
	
	public function getListFromCacheByCondition($con,$fields=array(),$cache=0,$position='')
	{
		if(empty($cache))
		{
			$cache = 3600;
		}
		return $this->getList($con,$fields,$cache,$position);
	}
	
	public function searchPaikeProducts($con,$cache=true,$spider=false)
	{
		if(!$con['classId'])
		{
			unset($con['classId']);
		}
		
		if(empty($con['classId']) && empty($con['keyWord']))
		{
			$this->prodcutSearchResult	= false;
			return false;
		}

		if(!is_numeric($con['pageSize']))
		{
			$con['pageSize']	= 40;
		}

		if($cache)
		{
			$cacheId		= md5(serialize($con));
			$products		= $this->getDataFromCache($cacheId,'list');
		}
		if(!$products){
			$apiSetting		= C('SettingService')->get('api_setting',true);

			$paipaiService	= new PaiPaiService("http://api.paipai.com/cps/cpsCommSearch.xhtml");
			$params["pageIndex"] = $con['pageIndex'];
			$params["pageSize"] = $con['pageSize'];
			//$params["userId"] = $apiSetting['paipai_pid'];
			if($con['classId']) $params["classId"] = $con['classId'];
			if($con['keyWord']) $params["keyWord"] = $con['keyWord'];
			if($con['orderStyle']) $params["orderStyle"] = $con['orderStyle'];
			if($con['begPrice']) $params["begPrice"] = $con['begPrice']*100;
			if($con['endPrice']) $params["endPrice"] = $con['endPrice']*100;
			if($con['crMin']) $params["crMin"] = $con['crMin']*100;
			if($con['crMax']) $params["crMax"] = $con['crMax']*100;
			$arrRes = $paipaiService->getResult($params);

			if($arrRes['errorCode']!=0)
			{
				$products = false;
			}

			$products	= $arrRes['CpsCommSearchResult'];
			if($cache)
			{
				$this->saveDataToCache($cacheId,'list',$products);
			}
		}
		
		if(count($products['vecComm'])>$con['pageSize'])
		{
			for($i=count($products['vecComm'])-1;$i>=$con['pageSize'];$i--)
			{
				unset($products['vecComm'][$i]);
			}
		}
		if(!$products['vecComm'])
		{
			$products['vecComm'] = array();
		}
		
		$this->prodcutSearchResult	= $products;
		return $products;
	}
	
	
	private function getDataFromCache($id,$type)
	{
		if(!$this->useCache)
		{
			return false;
		}
		$cacheCfg	= C('LtConfig')->get('cache.product');
		if($type=='list')
		{
			$enable		= $cacheCfg['listcacheenable'];
			$period		= $cacheCfg['listcacheperiod'];
			$cacheDir	= $cacheCfg['listdir'];
		}
		else if($type=='detail')
		{
			$enable		= $cacheCfg['detailcacheenable'];
			$period		= $cacheCfg['detailcacheperiod'];
			$cacheDir	= $cacheCfg['detaildir'];
		}else{
			$enable		= $cacheCfg['othercacheenable'];
			$period		= $cacheCfg['othercacheperiod'];
			$cacheDir	= $cacheCfg['otherdir'];
		}
		
		if(!$enable)
		{
			return false;
		}
		
		$ccs		= C('CompressCacheService');
		$d			= $ccs->getCacheDirById($id);
		if($d===false)
		{
			return false;
		}
		$result	= $ccs->getCacheData($cacheDir,$d,$id);
		//检查过期时间
		if($result)
		{
			//没有缓存时间或者缓存时间距离当前时间已经超过设定的cache时间
			$du = C('DateUtil');
			if(!array_key_exists('cache_time',$result) || $du->dateAdd('d',$period,$result['cache_time'])<strtotime(date('Y-m-d')))
			{
				$result	= false;
			}
		}
		
		return $result;
	}
	
	private function saveDataToCache($id,$type,$data)
	{
		if(!$data || !$this->useCache)
		{
			return false;
		}
		
		$cacheCfg	= C('LtConfig')->get('cache.product');
		if($type=='list')
		{
			$enable		= $cacheCfg['listcacheenable'];
			$period		= $cacheCfg['listcacheperiod'];
			$cacheDir	= $cacheCfg['listdir'];
		}
		else if($type=='detail')
		{
			$enable		= $cacheCfg['detailcacheenable'];
			$period		= $cacheCfg['detailcacheperiod'];
			$cacheDir	= $cacheCfg['detaildir'];
		}else{
			$enable		= $cacheCfg['othercacheenable'];
			$period		= $cacheCfg['othercacheperiod'];
			$cacheDir	= $cacheCfg['otherdir'];
		}
		
		if(!$enable)
		{
			return false;
		}
		
		$ccs		= C('CompressCacheService');
		$d			= $ccs->getCacheDirById($id);
		if($d===false)
		{
			return false;
		}
		$data['cache_time']	= date('Y-m-d');
		$ccs->setCacheData($cacheDir,$d,$id,$data);
		
		return true;
	}
	
	public function getTotalProcuct()
	{
		if(is_array($this->prodcutSearchResult) && array_key_exists('hitNum', $this->prodcutSearchResult)){
			return $this->prodcutSearchResult['hitNum'];
		}
		return 0;
	}
	
	public function getProductList()
	{
		if(is_array($this->prodcutSearchResult) && array_key_exists('vecComm', $this->prodcutSearchResult)){
			return $this->prodcutSearchResult['vecComm'];
		}
		return false;
	}
	//paipai click
	public function getClick($con)
	{
		$apiSetting		= C('SettingService')->get('api_setting',true);
		$paipaiService	= new PaiPaiService("http://api.paipai.com/cps/constructCpsUrl.xhtml");
		$params["urlType"] = $con['type'];
		if($con['type']==2) $params["itemCodes"] = $con['id'];
		if($con['type']==3) $params["uinLists"] = $con['id'];
		$arrRes = $paipaiService->getResult($params);
		if(array_key_exists('errorCode', $arrRes) && $arrRes['errorCode']!=0)
		{
			$clickurl = false;
		}
		$clickurl	=	$arrRes['CpsUrlResult'];
		return $clickurl;
	}
	
	private function getProductCommission($id,$fields='')
	{
		//初始化查询的字段
		$cols		= split(',','commission_rate,commission,commission_num,commission_volume');
		$fields		= $this->checkFields($cols,$fields);
		
		$apiSetting		= C('SettingService')->get('api_setting',true);
		//参数
		$params			= array(
			'method' 	=> 'taobao.taobaoke.items.convert',
			'fields' 	=> $fields,
			'nick'		=> $apiSetting['taobao_api_nick'],
			'pid' 		=> C('CommonFunction')->getPid($apiSetting['taobao_api_pid']),
			'num_iids' 	=> $id,
		);
		
		$num			= $apiSetting['taobao_api_num'];
		if($num<=0)
		{
			$num		= 1;
		}
		else if($num>3)
		{
			$num		= 3;
		}
		for($i=0;$i<$num;$i++)
		{
			$tmp 			= $this->searchService->getResult($params);
			if($tmp && !array_key_exists('error_response',$tmp))
			{
				break;
			}
		}
		if(!$tmp || !array_key_exists('taobaoke_items_convert_response', $tmp)){
			return false;
		}
		
		$commission	= array_key_exists('taobaoke_items', $tmp['taobaoke_items_convert_response'])?$tmp['taobaoke_items_convert_response']['taobaoke_items']['taobaoke_item'][0]:false;
		return $commission;
	}
	
	private function getTaobaoItem($id)
	{
		return false;
	}
	
	private function checkFields($allow,$fields)
	{
		if(!empty($fields))
		{
			$tmp	= array();
			foreach($fields as $f)
			{
				if(in_array($f, $allow))
				{
					$tmp[]	= $f;
				}
			}
			$fields	= $tmp;
		}
		if(empty($fields))
		{
			$fields		= $allow;
		}
		$fields			= implode(',', $fields);
		return $fields;
	}
	
	private function getListFromCache($id)
	{
		$cache 	= new LtCache();
		$cache->init();
		$ch 	= $cache->getTDG(C('LtConfig')->get('db.table.prefix')."product".$id);
		
		$result	= $ch->get('list');
		return $result;
	}
	
	private function saveListToCache($id,$data,$ttl)
	{
		$cache 	= new LtCache();
		$cache->init();
		$ch 	= $cache->getTDG(C('LtConfig')->get('db.table.prefix')."product".$id);
		
		$tmp	= $ch->get('list');
		if($tmp!==false)
		{
			$ch->update('list',$data,$ttl);
		}
		else
		{
			$ch->add('list',$data,$ttl);
		}
	}
}
?>