<?php
class CommonFunction
{
    public function ip2number($ip)
    {
		$t	= explode('.',$ip);
		$x	= 0;
		for($i=0;$i<4;$i++)
		{
			$x 	= $x*256+$t[$i];
		}
		return $x;
	}
	
	public function number2ip($num)
	{
		$t	= $num;
		$a	= array();
		for($i = 0;$i < 4;$i++)
		{
			$x				= $t % 256;
			if($x<0)
				$x	+= 256;
			array_unshift($a, $x);
			$t 	= intval($t/256);
		}
		return implode('.',$a);
	}
	
	public function groupData($rows, $groupBy=false, $array=false)
	{
		if(!$groupBy || !$rows)
		{
			return $rows;
		}
		
		$ret	= array();
		foreach($rows as $row)
		{
			$tmp	= &$ret;
			$len	= count($groupBy);
			for($i=0;$i<$len;$i++)
			{
				$gbk	= $groupBy[$i];
				if($i<$len-1)
				{
					${$tmp}[$row[$gbk]]	= array();
					$tmp				= &$tmp[$row[$gbk]];
				}
				else
				{
					if($array)
					{
						if(!array_key_exists($row[$gbk], $tmp))
						{
							$tmp[$row[$gbk]]	= array();
						}
						$tmp[$row[$gbk]][]	= $row;
					}
					else
					{
						$tmp[$row[$gbk]]	= $row;
					}
				}
			}
		}
		
		return $ret;
	}
	
	public function getFileExt($f)
	{
		return trim(substr(strrchr($f, '.'), 1, 10));
	}
	
	public function countDirSize($dir)
	{
		$handle 	= opendir($dir);
		while (false!==($f = readdir($handle)))
		{
			if($f != "." && $f != "..")
			{
				if(is_dir("$dir/$f"))
				{
					$sizeResult += $this->countDirSize("$dir/$f"); 
				}
				else
				{
					$sizeResult += filesize("$dir/$f"); 
				}
			}
		}
		closedir($handle);
		return $sizeResult;
	}
	
	public function saveFile($filePath,$content)
	{
		$d		= dirname($filePath);
		if(!is_dir($d))
		{
			mkdir($d,0777,true);
		}
		
		return file_put_contents($filePath,$content)>0;
	}
	
	public function getUploadImagePath($name)
	{
		$base	= APP_WEB_PATH.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'upload/';
		return 	$base.date('ymd').'/'.$name;
	}
	
	public function getUploadImageUrl($name)
	{
		$base	= rtrim(C('LtConfig')->get('baseurl'),'/');
		$base	= $base.'/images/upload/';
		
		return 	$base.date('ymd').'/'.$name;
	}
	
	public function random($length, $numeric = 0)
	{
		PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
		if($numeric)
		{
			$hash = sprintf('%0'.$length.'d', mt_rand(0, pow(10, $length) - 1));
		}
		else
		{
			$hash 	= '';
			$chars 	= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
			$max 	= strlen($chars) - 1;
			for($i = 0; $i < $length; $i++)
			{
				$hash 	.= $chars[mt_rand(0, $max)];
			}
		}
		return $hash;
	}
	
	public function getKeywordList($str)
	{
		if(empty($str))
		{
			return false;
		}
		$str	= str_replace('，',',',$str);
		$tmp	= explode(',',$str);
		return $tmp;
	}
	
	public function getRandKeyword($str)
	{
		$str	= str_replace('，',',',$str);
		$tmp	= explode(',',$str);
		$len	= count($tmp);
		return $tmp[rand(0,$len-1)];
	}
	
	public function getTbImg($str,$isRobot)
	{
		$str	= str_replace('taobao.net','taobaocdn.com',$str);
		$str	= str_replace('img01.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img02.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img03.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img04.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img05.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img06.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img07.taobaocdn.com','img.taobaocdn.com',$str);
		$str	= str_replace('img08.taobaocdn.com','img.taobaocdn.com',$str);
		
		$str	= str_replace('img.taobaocdn.com/bao/uploaded','www.51zf.cn/u',$str);
		$str	= str_replace('img.taobaocdn.com/imgextra','www.51zf.cn/i',$str);
		
		return $str;
	}
	
	public function getEncodeImg($str)
	{
		//$str = str_replace('0.jpg.2.jpg','0.',$str);
		return base64_encode($str);
	}
	
	public function formatImg160($str)
	{
		$str = str_replace('0.jpg.2.jpg','0.160x160.jpg',$str);
		return base64_encode($str);
	}
	
	public function formatImg80($str)
	{
		$str = str_replace('0.jpg','0.80x80.jpg',$str);
		return base64_encode($str);
	}
	
	public function formatImg1602($str)
	{
		$str = str_replace('0.jpg.2.jpg','0.160x160.jpg',$str);
		return $str;
	}
	
	public function formatImg120($str)
	{
		$str = str_replace('0.jpg.2.jpg','0.120x120.jpg',$str);
		return base64_encode($str);
	}
	
	public function formatImg300($str)
	{
		$str = str_replace('0.jpg','0.300x300.jpg',$str);
		return base64_encode($str);
	}
	
	public function getId($id)
	{
		$siteConf	= C('SettingService')->get('site_setting',true);
		return base64_encode($id.'_'.$siteConf['id_key']);
	}
	
	public function encodeKeyword($keyword)
	{
		return urlencode(base64_encode($keyword));
	}
	
	public function decodeKeyword($keyword)
	{
		return base64_decode(urldecode($keyword));
	}
	
	public function rmdir($dir)
	{
		if (!file_exists($dir))
		{
			return true;
		}
		if ((!is_dir($dir) || is_link($dir)))
		{
			return unlink($dir);
		}
		$dirs = $this->getDirFiles($dir);
		foreach($dirs as $item)
		{
			if ($item == '.' || $item == '..')
			{
				continue;
			}
			if (!$this->rmdir($dir . "/" . $item))
			{
				if (!$this->rmdir($dir . "/" . $item))
				{
					continue;
				}
			};
		}
		
		return rmdir($dir);
	}
	
	public function getLoginUrl()
	{
		return 'http://tool.taozhangmen.net/index.php?module=user&action=login&from=';
	}
	
	public function getReturnRate()
	{
		$returnConfig	= C('SettingService')->get('return_setting',true);
		$returnRate		= array_key_exists('rate',$returnConfig)?$returnConfig['rate']:0;
		return $returnRate;
	}
	
	public function getBeforeTime($time)
	{
		if(!is_numeric($time))
		{
			$time	= strtotime($time);
		}
		$now 	= time();
		$gap 	= $now - $time;
		$desc 	= '';
		$after	= '以前';
		if($gap<0)
		{
			$after	= '以后';
			$gap	= 0-$gap;
		}
		if($gap < 60)
		{
			$desc = "{$gap}秒钟".$after;
		}
		else if($gap < 3600)
		{
			$n = intval($gap / 60);
			$desc = "{$n}分钟".$after;
		}
		else if($gap < 86400)
		{
			$n = intval($gap / 3600);
			$desc = "{$n}小时".$after;
		}
		else 
		{
			$desc = date("n月d日 H:i", $time);
		}
		return $desc;
	}
	
	public function getDefaultArray($element, $arr)
	{
		$num	= count($arr);
		for($i=$num-1;$i>=0;$i--)
		{
			if($arr[$i]==$element)
			{
				unset($arr[$i]);
			}
		}
		array_unshift($arr,$element);
		return $arr;
	}
	
	public function getDirFiles($d)
	{
		if(function_exists('scandir'))
		{
			return scandir($d);
		}
		$dh  = opendir($d);
		while (false !== ($filename = readdir($dh))) 
		{
		    $files[] = $filename;
		}
		closedir($dh);
		
		return $files;
	}
	
	public function getPid($pid)
	{
		if(preg_match('~mm_(\d+)_~',$pid,$m))
		{
			return $m[1];
		}
		return $pid;
	}
	public function get_paipai_cats($cid=0){
		$snoopy 	= new Snoopy;
		$url		= "http://api.paipai.com/attr/getNavigationChildList.xhtml?charset=utf-8&format=json&navigationId=$cid";
		$snoopy->fetch($url);
		$content 	= $snoopy->results;
		$content = str_replace('try { getNavigationChildListSuccess(','',$content);
		$content = str_replace(');}catch(e1){try{getNavigationChildListFail(e1);}catch(e2){}}','',$content);
		$data		= json_decode($content,true);
		return $data['childList'];
	}
	public function getKw($content){
		$base	= rtrim(C('LtConfig')->get('baseurl'),'/');
		$pa = new PhpAnalysis('utf-8', 'utf-8', false);
		$pa->LoadDict();
		$pa->SetSource($content);
		$pa->StartAnalysis( false );
		$tags = $pa->GetFinallyResult();
		return $tags;
	}

}
?>