<?php
class DateUtil
{
    public function dateAdd($interval, $number, $dateStr)
    {
    	if(!is_numeric($dateStr))
    	{
    		$dateStr		= strtotime($dateStr);
    	}
		$dateTime		 	= getdate($dateStr);
		$hours 				= $dateTime["hours"]; 
		$minutes 			= $dateTime["minutes"]; 
		$seconds 			= $dateTime["seconds"]; 
		$month 				= $dateTime["mon"]; 
		$day 				= $dateTime["mday"]; 
		$year 				= $dateTime["year"]; 
		switch ($interval)
		{ 
		    case "y": 
			case "yyyy":	$year +=$number; break; 
			case "q": 		$month +=($number*3); break; 
			case "m": 		$month +=$number; break; 
			case "d": 		$day+=$number; break; 
			case "w":
			case "ww": 		$day+=($number*7); break; 
			case "h": 		$hours+=$number; break; 
			case "n": 		$minutes+=$number; break; 
			case "s": 		$seconds+=$number; break; 
		} 
		$timestamp 			= mktime($hours ,$minutes, $seconds,$month ,$day, $year);
		return $timestamp;
	}
	
	public function isDate($str)
	{
		if(!preg_match('~^\d{4}-\d{1,2}-\d{1,2}$~', $str, $m))
		{
			return false;
		}
		return true;
	}
	
	public function getMonthPeriod($year, $month)
	{
    	$firstDay	= sprintf('%04d-%02d-01',$year,$month);
    	if($month==12){
    		$month	= 1;
    		$year++;
    	}else{
    		$month++;
    	}
    	$lastDay	= $year.'-'.$month.'-01';
    	
    	$lastDay	= $this->dateAdd('d', '-1', $lastDay);
    	$lastDay	= date('Y-m-d', $lastDay);
    	
    	return array($firstDay,$lastDay);
    }
    
    public function getMonthPeriodByDate($dateStr)
	{
    	list($year,$month)	= explode('-',$dateStr);
    	
    	return $this->getMonthPeriod($year,$month);
    }
}
?>