<?php
class LtUrl
{
	public $configHandle;
	public $routingTable;
	public $baseUrl;

	public function __construct()
	{
		if (! $this->configHandle instanceof LtConfig)
		{
			if (class_exists("LtObjectUtil", false))
			{
				$this->configHandle = LtObjectUtil::singleton("LtConfig");
			}
			else
			{
				$this->configHandle = new LtConfig;
			}
		}
	}
	public function init()
	{
		$this->routingTable = $this->configHandle->get("router.routing_table");
		if (empty($this->routingTable))
		{
			$this->routingTable = array('pattern' => ":module/:action/*",
				'default' => array('module' => 'default', 'action' => 'index'),
				'reqs' => array('module' => '[a-zA-Z0-9\.\-_]+',
					'action' => '[a-zA-Z0-9\.\-_]+'
					),
				'varprefix' => ':',
				'delimiter' => '/',
				'postfix' => '',
				'protocol' => 'PATH_INFO', // REWRITE STANDARD
				);
		}
		//url简化
		$this->shortCut 	= $this->configHandle->get("router.short_cut");
		if (empty($this->shortCut))
		{
			$this->shortCut	= array();
		}
		
		$protocol = strtoupper($this->routingTable['protocol']);
		if ('REWRITE' == $protocol)
		{
			$this->baseUrl 	= pathinfo($_SERVER['SCRIPT_NAME'], PATHINFO_DIRNAME);
			$this->baseUrl	= str_replace('\\','/',$this->baseUrl);
			if(strrpos('/',$this->baseUrl)!==0)
			{
				$this->baseUrl	.= '/';
			}
		}
		else if ('STANDARD' == $protocol)
		{
			$this->baseUrl = $_SERVER['PHP_SELF'];
		}
		else
		{
			$this->baseUrl = '';
		}
	}

	public function generate($module, $action, $args = array())
	{
		ksort($args);
		$args = array_merge(array('module' => $module, 'action' => $action), $args);
		$url = $this->baseUrl;
		$url .= $this->reverseMatchingRoutingTable($args);
		return $url;
	}
	
	public function generateOutsiteUrl($baseUrl, $module, $action, $args = array())
	{
		ksort($args);
		$args = array_merge(array('module' => $module, 'action' => $action), $args);
		$url = $baseUrl;
		$url .= $this->reverseMatchingRoutingTable($args);
		return $url;
	}

	/**
	 * 将变量反向匹配路由表, 返回匹配后的url
	 * 
	 * @param array $params 
	 * @return string 
	 */
	public function reverseMatchingRoutingTable($args)
	{
		$ret = $this->routingTable['pattern'];
		$default = $this->routingTable['default'];
		$reqs = $this->routingTable['reqs'];
		$delimiter = $this->routingTable['delimiter'];
		$varprefix = $this->routingTable['varprefix'];
		$postfix = $this->routingTable['postfix'];
		$protocol = strtoupper($this->routingTable['protocol']);
		if ('STANDARD' == $protocol)
		{
			return '?' . http_build_query($args, '', '&');
		}
		$pattern = explode($delimiter, trim($this->routingTable['pattern'], $delimiter));
		
		foreach($pattern as $k => $v)
		{
			if ($v[0] == $varprefix)
			{ 
				// 变量
				$varname = substr($v, 1); 
				// 匹配变量
				if (isset($args[$varname]) && $args[$varname]!='')
				{
					$regex = "/^{$reqs[$varname]}\$/i";
					if (preg_match($regex, $args[$varname]))
					{
						$ret = str_replace($v, $args[$varname], $ret);
						unset($args[$varname]);
					}
				}
				else if (isset($default[$varname]))
				{
					$ret = str_replace($v, $default[$varname], $ret);
				}
			}
			else if ($v[0] == '*')
			{
				// 通配符
				$tmp = '';
				foreach($args as $key => $value)
				{
					if (!isset($default[$key]) && $value!='')
					{
						//$tmp .= $key . $delimiter . rawurlencode(trim($value)) . $delimiter;
						$tmp .= $key . $delimiter . trim($value) . $delimiter;
					}
				}
				$tmp = rtrim($tmp, $delimiter);
				$ret = str_replace($v, $tmp, $ret);
				$ret = rtrim($ret, $delimiter);
			}
			else
			{ 
				// 静态
			}
		}
		
		//简化URL
		if(!empty($this->shortCut))
		{
			foreach($this->shortCut as $shotCutKey=>$shotCutValue)
			{
				if(strpos($ret, $shotCutKey)===0)
				{
					if((substr($ret,strlen($shotCutKey),1)===false || substr($ret,strlen($shotCutKey),1)==$delimiter))
					{
						$ret	= substr($ret,strlen($shotCutKey));
						$ret	= $shotCutValue.$ret;
						break;
					}
				}
			}
		}
		
		if ('REWRITE' == $protocol)
		{
			$ret = $ret . $postfix;
		}
		else if ('PATH_INFO' == $protocol)
		{
			$ret = $_SERVER['SCRIPT_NAME'] . '/' . $ret . $postfix;
		}
		else
		{
			$ret = $ret . $postfix;
		}
		
		return $ret;
	}
}
