<?php
class DefaultViewAction extends FrontendAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'index';
		$this->data['menu']	= 'view';
	}
	
	public function execute()
	{
		$id = $this->context->get('id');
		$id = htmlspecialchars(trim($id));

		//检查是否屏蔽
		$settingService = C('SettingService');
		$forbiddenSetting = $settingService->get('forbidden_setting',true);
		if(!empty($forbiddenSetting['ids']))
		{
			$ids = explode("\n",str_replace("\r", "", $forbiddenSetting['ids']));
			if(in_array($id,$ids))
			{
				//屏蔽的商品
				$this->layout 	= 'result';
				$this->code		= 403;
				return;
			}
		}

		$productService	= C('ProductService');
		$info			= $productService->getProductById($id);
		if($info)
		{
			if(!$this->data['isRobot'] && $searchKey!='')
			{
				if($info['click_url']!='')
				{
				}
			}
			
			if($this->data['config']['detail']['showcontent'])
			{
				$info['detailInfo']	= str_replace('taobao.net','taobaocdn.com',$info['detailInfo']);
				
				if(preg_match_all('~(http://pai\d+\.qpic\.cn[^\'">\s]*)([\'">\s])~is', $info['detailInfo'], $m))
				{
					$num	= count($m[1]);
					for($ii=0;$ii<$num;$ii++)
					{
						$info['detailInfo']	= str_replace($m[1][$ii].$m[2][$ii],$this->data['baseurl'].'images/loading.gif'.$m[2][$ii].' i="'.$this->data['cf']->getEncodeImg($m[1][$ii]).'"',$info['detailInfo']);
					}
				}
				
				$info['detailInfo']	= preg_replace('~<a.*?>~is','<a href="javascript:void(0)" nid="'.$id.'" target="_blank">',$info['detailInfo']);
				$info['detailInfo']	= preg_replace('~<embed .*?>~is','',$info['detailInfo']);
			}
			
			
			$seokey			= $this->data['cf']->getKw($info['itemName']);
			$seoConfig		= C('SettingService')->get('seo_setting',true);
			$seoTitle		= $this->getSeoStr($seoConfig['detailtitle'],array('title'=>$info['itemName'],'price'=>$info['itemPrice']));
			$seoKeyword		= $this->getSeoStr($seoConfig['detailkeyword'],array('title'=>$info['itemName'],'price'=>$info['itemPrice']));
			$seoDescription	= $this->getSeoStr($seoConfig['detaildescription'],array('title'=>$info['itemName'],'price'=>$info['itemPrice']));
			
			$this->data['seo']['title']			= $seoTitle;
			$this->data['seo']['keyword']		= $seokey.','.$info['itemName'];
			$this->data['seo']['description']	= $seoDescription;
			
			$this->data['product']				= $info;
		}
		if($this->data['product']['sellerUin']){
			$opts = array(
				'http'=>array(
				'method'=>"GET",
				'timeout'=>3,
			  )
			);
			$context 			= stream_context_create($opts);
			$news				= file_get_contents('http://api.paipai.com/item/buyerSearchItemList.xhtml?charset=utf-8&format=json&pureData=1&sellerUin='.$this->data['product']['sellerUin'].'&pageIndex=1&pageSize=6&extendInfo=0&itemState=1',false,$context);
			$pros				= json_decode($news,true);
			//print_r($pros);
			$this->data['relatedshop']	= $pros['itemList'];
		}
		
		$this->data['relatedProductUrl'] = C('LtUrl')->generate('Default','RelatedProduct');
		$this->data['searchKey'] = $seokey;
		$this->data['clickUrl']	= C('LtUrl')->generate('Default','Click',array('id'=>$info['itemCode']));
		$this->data['SclickUrl']	= C('LtUrl')->generate('Default','Click',array('id'=>$info['sellerUin']));
	}

}
