﻿<script runat="server" language="VBScript">
' CKFinder
' ========
' http://ckfinder.com
' Copyright (C) 2007-2010, CKSource - Frederico Knabben. All rights reserved.
'
' The software, this file and its contents are subject to the CKFinder
' License. Please read the license.txt file before using, installing, copying,
' modifying or distribute this file or part of its contents. The contents of
' this file is part of the Source Code of CKFinder.

	''
	' @package CKFinder
	' @subpackage Utils
	' @copyright CKSource - Frederico Knabben
	'

	''
	' @package CKFinder
	' @subpackage Utils
	' @copyright CKSource - Frederico Knabben
	'
class CKFinder_Connector_Utils_Image
	' Name of the component that should be used for image manipulation
	Private sComponentName

	Private Sub Class_Initialize()

	End Sub

	Private Sub Class_Terminate()

	End sub

	Private Function throwError( number, text, debugText)
		oCKFinder_Factory.Connector.ErrorHandler.throwError number, text, debugText
	End Function

	''
	' Checks that a file is an image
	' It only checks the extension
	' @return Boolean
	'
	Public Function isImage( filePath )
		Dim extension
		extension = LCase( oCKFinder_Factory.UtilsFileSystem.GetExtension( filePath ) )
		If (extension="jpg" Or extension="jpeg" Or extension="bmp" Or extension="png" Or extension="gif") then
			isImage = True
		Else
			isImage = false
		End if
	End Function

	''
	' Checks that a file is really a valid image
	' @return Boolean
	'
	Public Function isImageValid( filePath )
		isImageValid = False
		If Not(isImage( filePath ) ) Then
			Exit function
		End If

		' It will try to open the file, if it works, we assume that it was a good file.
		Select Case ComponentName
			' If there is no component selected, then everything is valid.
			Case "None"
				isImageValid = True

			Case "Asp.Net"
				isImageValid = validateImage_AspNet(filePath)

			Case "Persits.Jpeg"
				isImageValid = validateImage_Persits_AspJpeg(filePath)

			Case "briz.AspThumb"
				isImageValid = ValidateImage_Briz_AspThumb(filePath)

			Case "AspImage.Image"
				' Doesn't deal properly with gifs and the current demo is expired, so it won't work in normal servers.
				' It also tends to generate crashes very easily.
				isImageValid = validateImage_ServerObjects_ASPImage(filePath)

			Case "shotgraph.image"
				isImageValid = ValidateImage_ShotGraph_Image(filePath)

			Case else
				throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Invalid image manipulation component", ComponentName
		End Select

	End Function

	''
	' Detects which component is available to handle image manipulation
	'
	' @return String
	'
	private Function DetectComponent()
		Dim component, expireDate

		On Error Resume next

		LoadUrl AspNetUrl & "&command=IsEnabled"
		If ( Err.Number=0) Then
			DetectComponent = "Asp.Net"
			Exit function
		End If

		Err.Clear
		Set component = Server.CreateObject("Persits.Jpeg")
		If (Err.number=0) Then
			' Check now that it isn't an expired version
			expireDate = component.expires

			Set component = Nothing
			If (expireDate = #9/9/9999# Or expireDate>Now()) then
				DetectComponent = "Persits.Jpeg"
				Exit Function
			End if
		End If

		Err.Clear
		Set component = Server.CreateObject("briz.AspThumb")
		If (Err.number=0) Then
			Set component = Nothing
			DetectComponent = "briz.AspThumb"
			Exit Function
		End If

		Err.Clear
		Set component = Server.CreateObject("AspImage.Image")
		If (Err.number=0) Then
			' Check now that it isn't an expired version
			expireDate = component.expires
			If (expireDate="N/A") Then expireDate = #01/01/2050#

			Set component = Nothing
			' It's trickier to find out if it can work or not.
			If (IsNull(expireDate) Or DateDiff("d", expireDate, Now())<0 ) then
				DetectComponent = "AspImage.Image"
				Exit function
			End If

		End If

		Err.Clear
		Set component = Server.CreateObject("shotgraph.image")
		If (Err.number=0) Then
			' Validate that it isn't in demo mode.
			component.CreateImage 1, 1, 32
			If (Err.number=0) then
				Set component = Nothing
				DetectComponent = "shotgraph.image"
				Exit Function
			End if
			Set component = Nothing
		End If

		Err.Clear
		throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to find an image manipulation component", ""
	End function

	' Find out which component should be used
	Public Property Get ComponentName()
		If (IsEmpty(sComponentName)) then
			sComponentName = oCKFinder_Factory.Config.getImagesConfig.Component
			If sComponentName = "" Or LCase(sComponentName)="none" Then sComponentName = "None"

			If (sComponentName = "Auto") Then
				sComponentName = DetectComponent()
				oCKFinder_Factory.Config.getImagesConfig.Component = sComponentName
			End If
		End If
		ComponentName = sComponentName
	End Property

	Public function createThumb(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		If Not( isImage( sourceFile ) ) Then Exit Function

		Select Case ComponentName
			Case "Asp.Net"
				createThumb = createThumb_AspNet(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)

			Case "Persits.Jpeg"
				createThumb = createThumb_Persits_AspJpeg(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)

			Case "briz.AspThumb"
				createThumb = createThumb_Briz_AspThumb(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)

			Case "AspImage.Image"
				' Doesn't deal properly with gifs and the current demo is expired, so it won't work in normal servers.
				' It also tends to generate crashes very easily.
				createThumb = createThumb_ServerObjects_ASPImage(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)

			Case "shotgraph.image"
				createThumb = createThumb_ShotGraph_Image(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)

			Case else
				throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Invalid image manipulation component", ComponentName
		End select
	End function


	Private function createThumb_AspNet(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		createThumb_AspNet = CallAspNet( "&command=CreateThumbnail" & _
					"&InputImage=" & server.urlEncode(sourceFile) & _
					"&OutputThumbnail=" & server.urlEncode(targetFile) & _
					"&maxWidth=" & maxWidth & _
					"&maxHeight=" & maxHeight & _
					"&quality=" & quality )
	End function

	Private Function CallAspNet( parameters )
		Dim url
		url = AspNetUrl & parameters

		On Error Resume next
		If not LoadUrl( url ) then
			If Err.number<>0 Then
				If (Err.number = vbObjectError + CKFINDER_CONNECTOR_ERROR_UPLOADED_INVALID) Then
					CallAspNet = False
					Exit function
				End If

				throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Error returned in call to Asp.Net", "Error returned in call to " & url & ". (" & (Err.number - vbObjectError) & ", " & Err.description & ")"
			End If
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Failed to call Asp.Net", "Failed to call url " & url
		End If
		On Error Goto 0

		CallAspNet = true
	End function

	Private function createThumb_Persits_AspJpeg(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		Dim Jpeg
		' Create instance of AspJpeg
		On Error Resume next
		Set Jpeg = Server.CreateObject("Persits.Jpeg")

		If (Err.number<>0) Then
			Set Jpeg = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create Persits.Jpeg component.", Err.description
			Exit function
		End if

		' Open source image
		Jpeg.Open sourceFile

		If (Err.number<>0) Then
			Set Jpeg = nothing
			createThumb_Persits_AspJpeg = false
			Exit function
		End if
		On Error goto 0

		dim iFinalWidth, iFinalHeight
		' If 0 is passed in any of the max sizes it means that that size must be ignored,
		' so the original image size is used.
		iFinalWidth = maxWidth
		If (iFinalWidth = 0) Then iFinalWidth = Jpeg.Width
		iFinalHeight = maxHeight
		If (iFinalHeight = 0) Then iFinalHeight = Jpeg.Height

		if ( Jpeg.Width <= iFinalWidth and Jpeg.Height <= iFinalHeight ) then
			Set Jpeg = Nothing
			createThumb_Persits_AspJpeg = oCKFinder_Factory.UtilsFileSystem.CopyFile( sourceFile, targetFile )
			Exit function
		End If

		dim oSize
		if ( preserveAspectRatio ) then
			' Gets the best size for aspect ratio resampling
			Set oSize = GetAspectRatioSize( iFinalWidth, iFinalHeight, Jpeg.Width, Jpeg.Height )
		else
			Set oSize = new CKFinder_Size
			oSize.Width = iFinalWidth
			oSize.Height = iFinalHeight
		End if

		' Resize
		Jpeg.Width = oSize.Width
		Jpeg.Height = oSize.Height

		Jpeg.Quality = quality

		' create thumbnail and save it to disk
		Jpeg.Save targetFile

		Set Jpeg = Nothing

		createThumb_Persits_AspJpeg = true
	End function

	Private function createThumb_Briz_AspThumb(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		Dim tn
		' Create instance of AspJpeg
		On Error Resume next
		Set tn = Server.CreateObject("briz.AspThumb")

		If (Err.number<>0) Then
			Set tn = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create briz.AspThumb component.", Err.description
			Exit function
		End if

		' Open source image
		tn.Load sourceFile

		If (Err.number<>0) Then
			Set tn = nothing
			createThumb_Briz_AspThumb = false
			Exit function
		End if
		On Error goto 0

		dim iFinalWidth, iFinalHeight
		' If 0 is passed in any of the max sizes it means that that size must be ignored,
		' so the original image size is used.
		iFinalWidth = maxWidth
		If (iFinalWidth = 0) Then iFinalWidth = tn.Width
		iFinalHeight = maxHeight
		If (iFinalHeight = 0) Then iFinalHeight = tn.Height

		if ( tn.Width <= iFinalWidth and tn.Height <= iFinalHeight ) then
			Set tn = Nothing
			createThumb_Briz_AspThumb = oCKFinder_Factory.UtilsFileSystem.CopyFile( sourceFile, targetFile )
			Exit function
		End If

		dim oSize
		if ( preserveAspectRatio ) then
			' Gets the best size for aspect ratio resampling
			Set oSize = GetAspectRatioSize( iFinalWidth, iFinalHeight, tn.Width, tn.Height )
		else
			Set oSize = new CKFinder_Size
			oSize.Width = iFinalWidth
			oSize.Height = iFinalHeight
		End if

		tn.ResizeQuality = quality
		' Resize
		tn.Resize oSize.Width, oSize.Height

		' create thumbnail and save it to disk
		tn.Save targetFile

		Set tn = Nothing

		createThumb_Briz_AspThumb = true
	End function



	' It seems that it can fail to get the dimensions of gif files
	Private function createThumb_ServerObjects_ASPImage(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		Dim Image, expireDate
		' Create instance of AspImage
		On Error Resume next
		Set Image = Server.CreateObject("AspImage.Image")

		If (Err.number<>0) Then
			Set Image = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create AspImage.Image component.", Err.description
			Exit function
		End if
		On Error goto 0

		' Check now that it isn't an expired version
		expireDate = Image.expires
		If (expireDate="N/A") Then expireDate = #01/01/2050#

		' It's trickier to find out if it can work or not.
		If not(IsNull(expireDate) Or DateDiff("d", expireDate, Now())<0 ) then
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "The AspImage.Image component has expired on " & expireDate & ".", ""
			Exit function
		End If

		' Open source image
		If Not(Image.LoadImage(sourceFile)) Then
			Set Image = Nothing
			createThumb_ServerObjects_ASPImage = False
			Exit function
		End If

		' with gifs it returns 0x0
'		Response.Write "Image Height = " & Image.MaxY & " - Image Width = " & Image.MaxX

		dim iFinalWidth, iFinalHeight
		' If 0 is passed in any of the max sizes it means that that size must be ignored,
		' so the original image size is used.
		iFinalWidth = maxWidth
		If (iFinalWidth = 0) Then iFinalWidth = Image.MaxX
		iFinalHeight = maxHeight
		If (iFinalHeight = 0) Then iFinalHeight = Image.MaxY

		if ( Image.MaxX <= iFinalWidth and Image.MaxY <= iFinalHeight ) then
			Set Image = Nothing
			createThumb_ServerObjects_ASPImage = oCKFinder_Factory.UtilsFileSystem.CopyFile( sourceFile, targetFile )
			Exit function
		End If

		dim oSize
		if ( preserveAspectRatio ) then
			' Gets the best size for aspect ratio resampling
			Set oSize = GetAspectRatioSize( iFinalWidth, iFinalHeight, Image.MaxX, Image.MaxY )
		else
			Set oSize = new CKFinder_Size
			oSize.Width = iFinalWidth
			oSize.Height = iFinalHeight
		End if

		' Resize
		Image.ResizeR oSize.Width, oSize.Height

		Dim extension
		extension = LCase(oCKFinder_Factory.UtilsFileSystem.GetExtension( targetFile ) )
		Select Case extension
			Case "jpg", "jpeg"
				Image.ImageFormat = 1
				Image.JPEGQuality = quality
			Case "bmp"
				Image.ImageFormat = 2
			Case "png"
				Image.ImageFormat = 3
			Case "gif"
				Image.ImageFormat = 5
		End select

		' create thumbnail and save it to disk
		Image.FileName = targetFile
		if Image.SaveImage() then
			createThumb_ServerObjects_ASPImage = True
			' It can change automatically the extension to jpg
			If (extension = "jpeg") Then
				Dim savedName
				savedName = Left( targetFile, Len(targetFile)-4) & "jpg"
				createThumb_ServerObjects_ASPImage = oCKFinder_Factory.UtilsFileSystem.RenameFile( savedName, targetFile )
			End if
		else
		' Something happened and we couldn't save the image so just use an HTML header
		' We need to debug the script and find out what went wrong.
			createThumb_ServerObjects_ASPImage = False
			Dim message
			message = Image.Error
			Set Image = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to save thumbnail. ", message
			Exit function
		end if

		Set Image = Nothing
	End function



	Private function createThumb_ShotGraph_Image(sourceFile, targetFile, maxWidth, maxHeight, quality, preserveAspectRatio)
		Dim sg
		' Create instance of ShotGraph
		On Error Resume next
		Set sg = Server.CreateObject("shotgraph.image")

		If (Err.number<>0) Then
			Set sg = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create shotgraph.image component.", Err.description
			Exit function
		End if

		' Validate that it isn't in demo mode.
		sg.CreateImage 1, 1, 32
		If (Err.number<>0) Then
			Set sg = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "The shotgraph.image component has expired.", Err.description
			Exit function
		End if

		Dim palete, imagetype, xsize, ysize
		' Open source image
		imagetype = sg.GetFileDimensions( sourceFile, xsize, ysize)

		If (Err.number<>0) Or imagetype=0 Or imagetype=4 Or imagetype>=6 Then
			Set sg = nothing
			createThumb_ShotGraph_Image = false
			Exit function
		End if
		On Error goto 0

		dim iFinalWidth, iFinalHeight
		' If 0 is passed in any of the max sizes it means that that size must be ignored,
		' so the original image size is used.
		iFinalWidth = maxWidth
		If (iFinalWidth = 0) Then iFinalWidth = xsize
		iFinalHeight = maxHeight
		If (iFinalHeight = 0) Then iFinalHeight = ysize

		if ( xsize <= iFinalWidth and ysize <= iFinalHeight ) then
			Set tn = Nothing
			createThumb_ShotGraph_Image = oCKFinder_Factory.UtilsFileSystem.CopyFile( sourceFile, targetFile )
			Exit function
		End If

		dim oSize
		if ( preserveAspectRatio ) then
			' Gets the best size for aspect ratio resampling
			Set oSize = GetAspectRatioSize( iFinalWidth, iFinalHeight, xsize, ysize )
		else
			Set oSize = new CKFinder_Size
			oSize.Width = iFinalWidth
			oSize.Height = iFinalHeight
		End if

		' Resize
		sg.CreateImage oSize.Width, oSize.Height, 32
		sg.InitClipboard xsize, ysize
		sg.SelectClipboard True
		sg.ReadImage sourceFile, palete, 0, 0
		sg.Stretch 0, 0, oSize.Width, oSize.Height, 0, 0, xsize, ysize, "SRCCOPY", "HALFTONE"
		sg.SelectClipboard False
		sg.Sharpen

		' create thumbnail and save it to disk
		Select Case imagetype
			Case 1
				sg.GifImage -1, 0, targetFile
			Case 2
				sg.JpegImage quality, 0, targetFile
			Case 3
				sg.BmpImage 0, targetFile
			Case 5
				sg.PngImage -1, 1, targetFile
		End select

		Set sg = Nothing

		createThumb_ShotGraph_Image = true
	End function



' Validation

	Private function ValidateImage_AspNet(sourceFile)
		ValidateImage_AspNet = CallAspNet( "&command=ValidateImage" & _
					"&InputImage=" & server.urlEncode(sourceFile) )
	End function

	Private function ValidateImage_Persits_AspJpeg(sourceFile)
		Dim Jpeg
		' Create instance of AspJpeg
		On Error Resume next
		Set Jpeg = Server.CreateObject("Persits.Jpeg")

		If (Err.number<>0) Then
			Set Jpeg = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create Persits.Jpeg component.", Err.description
			Exit function
		End if

		' Open source image
		Jpeg.Open sourceFile

		If (Err.number<>0) Then
			Set Jpeg = nothing
			ValidateImage_Persits_AspJpeg = False
			Exit function
		End if
		On Error goto 0

		ValidateImage_Persits_AspJpeg = true
	End Function


	Private function ValidateImage_Briz_AspThumb(sourceFile)
		Dim tn
		' Create instance of AspThumb
		On Error Resume next
		Set tn = Server.CreateObject("briz.AspThumb")

		If (Err.number<>0) Then
			Set tn = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create briz.AspThumb component.", Err.description
			Exit function
		End if

		' Open source image
		tn.Load sourceFile

		If (Err.number<>0) Then
			Set tn = nothing
			ValidateImage_Briz_AspThumb = False
			Exit function
		End if
		On Error goto 0

		ValidateImage_Briz_AspThumb = true
	End Function


	Private function ValidateImage_ServerObjects_ASPImage(sourceFile)
		Dim Image
		' Create instance of AspImage
		On Error Resume next
		Set Image = Server.CreateObject("AspImage.Image")

		If (Err.number<>0) Then
			Set Image = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create AspImage.Image component.", Err.description
			Exit function
		End if
		On Error goto 0

		' Open source image
		If Not(Image.LoadImage(sourceFile)) Then
			Set Image = Nothing
			ValidateImage_ServerObjects_ASPImage = False
			Exit function
		End If

		Set Image = Nothing
		ValidateImage_ServerObjects_ASPImage = true
	End Function


	Private function ValidateImage_ShotGraph_Image(sourceFile)
		Dim sg
		' Create instance of ShotGraph
		On Error Resume next
		Set sg = Server.CreateObject("shotgraph.image")

		If (Err.number<>0) Then
			Set sg = nothing
			throwError CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to create shotgraph.image component.", Err.description
			Exit function
		End if

		Dim palete, imagetype, xsize, ysize
		' Open source image
		imagetype = sg.GetFileDimensions( sourceFile, xsize, ysize)

		If (Err.number<>0) Or imagetype=0 Or imagetype=4 Or imagetype>=6 Then
			Set sg = nothing
			ValidateImage_ShotGraph_Image = false
			Exit function
		End if
		On Error goto 0

		Set sg = nothing
		ValidateImage_ShotGraph_Image = true
	End function

	''
	' Return aspect ratio size, returns associative array:
	' <pre>
	' Array
	' (
	'	[Width] => 80
	'	[Heigth] => 120
	' )
	' </pre>
	'
	' @param int maxWidth
	' @param int maxHeight
	' @param int actualWidth
	' @param int actualHeight
	' @return array
	'
	private Function GetAspectRatioSize( maxWidth, maxHeight, actualWidth, actualHeight )
		' Creates the Size object to be returned
		dim oSize, iFactorX, iFactorY

		Set oSize = new CKFinder_Size
		oSize.Width = maxWidth
		oSize.Height = maxHeight

		' Calculates the X and Y resize factors
		iFactorX = CSng(maxWidth) / cSng(actualWidth)
		iFactorY = CSng(maxHeight) / CSng(actualHeight)

		' If some dimension have to be scaled
		if ( iFactorX <> 1 or iFactorY <> 1 ) then
			' Uses the lower Factor to scale the oposite size
			if ( iFactorX < iFactorY ) then
				oSize.Height = cInt( CSng(actualHeight) * iFactorX )
			else
				if ( iFactorX > iFactorY ) then oSize.Width = cInt( cSng(actualWidth) * iFactorY )
			End if
		End if

		if ( oSize.Height <= 0 ) Then oSize.Height = 1
		if ( oSize.Width <= 0 ) Then oSize.Width = 1

		' Returns the Size
		Set GetAspectRatioSize = oSize
	End Function


	''
	' Builds the full url to the asp.net loopback page
	' it should be placed in the same folder than the connector.asp
	'
	Private Property Get AspNetUrl()
		Dim url
		url = ""
		If UCase(Request.ServerVariables("HTTPS") = "ON") Then
			url = "https://"
		Else
			url = "http://"
		End if
		url = url & Request.ServerVariables("SERVER_NAME")
		Dim port
		port = request.ServerVariables("SERVER_PORT")
		If (port<>"80") Then url = url & ":" & port
		url = url & oCKFinder_Factory.RegExp.ReplacePattern( "/connector.asp$", Request.ServerVariables("URL"), "/")
		url = url & "loopback.aspx"

		' Generate a temporary file for "authentication".
		url = url & "?tmp=" & oCKFinder_Factory.UtilsFileSystem.createTempFile()

		AspNetUrl = url
	End Property

	''
	' Calls an url
	' The url must return a XML response or an error will be raised.
	' returns true if the call was OK (0 in value of Connector/Error/@number)
	'
	Private Function LoadUrl( sUrlToCall )
		Dim oXmlHttp
		Dim node, value

		Set oXmlHttp = Server.CreateObject("Msxml2.ServerXMLHTTP.3.0")

		oXmlHttp.Open "GET", sUrlToCall, False, Request.ServerVariables("AUTH_USER") & "", Request.ServerVariables("AUTH_PASSWORD") & ""
		oXmlHttp.Send

		if ( (oXmlHttp.status = 200 or oXmlHttp.status = 304) and Not(IsNull(oXmlHttp.responseXML) ) And Not(IsNull( oXmlHttp.responseXML.firstChild)) ) then
		'	this.DOMDocument = oXmlHttp.responseXML ;
		Else
			Err.Raise vbObjectError + CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Unable to LoadUrl (" & sUrlToCall & ")", oXmlHttp.responseText
		End if

		On Error Resume next
		Set node = oXmlHttp.responseXML.SelectSingleNode( "Connector/Error/@number" )
		On Error goto 0
		If (node Is Nothing) Then
			Err.Raise vbObjectError + CKFINDER_CONNECTOR_ERROR_CUSTOM_ERROR, "Invalid XML response", oXmlHttp.responseText
		End if

		value = CInt(node.value)
		If (value<>0) Then
			Err.Raise vbObjectError + value, "Error returned in LoadUrl",  oXmlHttp.responseText
		End if
		Set oXmlHttp = Nothing

		LoadUrl = true
	End Function
End Class

' Auxiliary class
Class CKFinder_Size
	Public Width
	Public Height
End Class

</script>
