/*--------------------------------------
Name: AJAXRequest
Version: 0.8.06
Author: xujiwei
E-mail: vipxjw@163.com
Website: http://www.xujiwei.cn/
License: http://www.gnu.org/licenses/gpl.html GPL
Copyright (c) 2006-2008, xujiwei, All Rights Reserved

AjaxRequest Deveoper Manual:
    http://ajax.xujiwei.cn/
--------------------------------------*/
/**
 * AJAXRequest
 * @author	xujiwei
 * @constructor
 * @class		AJAXRequest
 * @param		{Object}	[initObj]	ʼ
 * @param		{String}	[initObj.url=""]			ҪUrl
 * @param		{String}	[initObj.content=""]		Ҫ͵
 * @param		{String}	[initObj.method="GET"]		󷽷GET  POST
 * @param		{String}	[initObj.charset]			ʱʹõı
 * @param		{Boolean}	[initObj.async=true]		ͣtrue Ϊ첽false Ϊͬ
 * @param		{Number}	[initObj.timeout=3600000]	ʱʱ䣬λΪ
 * @param		{function}	[initObj.ontimeout]			ʱʱĻص
 * @param		{function}	[initObj.onrequeststart]		ʼʱĻص
 * @param		{function}	[initObj.onrequestend]		ʱĻص
 * @param		{function}	[initObj.oncomplete]		ȷʱĻص
 * @param		{function}	[initObj.onexception]		쳣ʱĻص
 * @property	{String}	url			ҪUrl
 * @property	{String}	content		Ҫ͵
 * @property	{String}	method		󷽷GET  POST
 * @property	{String}	charset		ʱʹõı
 * @property	{Boolean}	async		ͣtrue Ϊ첽false Ϊͬ
 * @property	{Number}	timeout		ʱʱ䣬λΪ
 * @property	{function}	ontimeout	ʱʱĻص
 * @property	{function}	onrequeststart	ʼʱĻص
 * @property	{function}	onrequestend	ʱĻص
 * @property	{function}	oncomplete	ȷʱĻص
 * @property	{function}	onexception	쳣ʱĻص
 * @example
 * var ajax1 = new AJAXRequest();
 * var ajax2 = new AJAXRequest({
 * 	url: "getdata.asp",	// getdata.aspȡ
 * 	method: "GET",		// GETʽ
 * 	oncomplete: function(obj) {
 * 		alert(obj.responesText);	// ʾgetdata.asp
 * });
 */
 
 	function $(id){return document.getElementById(id);}
	function $N(d){var n=d*1;return(isNaN(n)?0:n);}
	function $VO(v){return(typeof(v)=="string"?(v=$(v))?v:false:v);}
	function $GID(){return((new Date)*1);}
	function $SOP(id,ct){objPool[id+""]=ct;}
	function $LOP(id){return(objPool[id+""]);}
	function $SRP(f,r,p){return(function(s){s=f(s);for(var i=0;i<r.length;i++) s=s.replace(r[i],p[i]);return(s);});}
	function $GEC(cs){
		if(cs.toUpperCase()=="UTF-8") return(encodeURIComponent);
		else return($SRP(escape,[/\+/g],["%2B"]));
	}
	function $ST(obj,text) {
		var nn=obj.nodeName.toUpperCase();
		if("INPUT|TEXTAREA|OPTION".indexOf(nn)>-1) obj.value=text;
		else try{obj.innerHTML=text;} catch(e){};
	}
	function $CB(cb) {
		if(typeof(cb)=="function") return cb;
		else {
			cb=$VO(cb);
			if(cb) return(function(obj){$ST(cb,obj.responseText);});
			else return this.oncomplete; }
	}
	function $GP(p,v,d,f) {
		var i=0;
		while(i<v.length){p[i]=v[i]?f[i]?f[i](v[i]):v[i]:d[i];i++;}
		while(i<d.length){p[i]=d[i];i++;}
	}
 
function AJAXRequest() {
	var xmlPool=[],objPool=[],AJAX=this,ac=arguments.length,av=arguments;
	var xmlVersion=["MSXML2.XMLHTTP","Microsoft.XMLHTTP"];
	var ec=emptyFun=function(){};
	av=ac>0?typeof(av[0])=="object"?av[0]:{}:{};
	var encode=$GEC(av.charset+"");
	var prop=['url','content','method','async','timeout','ontimeout','onrequeststart','onrequestend','oncomplete','onexception'];
	var defval=['','','GET',true,3600000,ec,ec,ec,ec,ec],l=prop.length;
	while(l--){this[prop[l]]=getp(av[prop[l]],defval[l]);}
	if(!getObj()) return false;
	function getp(p,d) { return p!=undefined?p:d; }
	function getObj() {
		var i,j,tmpObj;
		for(i=0,j=xmlPool.length;i<j;i++) if(xmlPool[i].readyState==0||xmlPool[i].readyState==4) return xmlPool[i];
		try { tmpObj=new XMLHttpRequest; }
		catch(e) {
			for(i=0,j=xmlVersion.length;i<j;i++) {
				try { tmpObj=new ActiveXObject(xmlVersion[i]); } catch(e2) { continue; }
				break;
			}
		}
		if(!tmpObj) return false;
		else { xmlPool[xmlPool.length]=tmpObj; return xmlPool[xmlPool.length-1]; }
	}

	function send(purl,pc,pcbf,pm,pa) {
		var ct,ctf=false,xmlObj=getObj(),ac=arguments.length,av=arguments;
		if(!xmlObj) return false;
		var pmp=pm.toUpperCase()=="POST"?true:false;
		if(!pm||!purl) return false;
		var ev={url:purl, content:pc, method:pm};
		purl+=(purl.indexOf("?")>-1?"&":"?")+"timestamp="+$GID();
		xmlObj.open(pm,purl,pa);
		AJAX.onrequeststart(ev);
		if(pmp) xmlObj.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		ct=setTimeout(function(){ctf=true;xmlObj.abort();},AJAX.timeout);
		var rc=function() {
			if(ctf) { AJAX.ontimeout(ev); AJAX.onrequestend(ev); }
			else if(xmlObj.readyState==4) {
				ev.status=xmlObj.status;
				try{ clearTimeout(ct); } catch(e) {};
				try{ if(xmlObj.status==200) pcbf(xmlObj); else AJAX.onexception(ev); }
				catch(e) { AJAX.onexception(ev); }
				AJAX.onrequestend(ev);
			}
		}
		xmlObj.onreadystatechange=rc;
		if(pmp) xmlObj.send(pc); else xmlObj.send("");
		if(pa==false) rc();
		return true;
	}
	/**
	 * ÷ʱʹõı
	 * @param	{String}	charset	ƣUTF-8  GB2312
	 * @example
	 * var ajax = new AJAXRequest();
	 * ajax.setcharset("GB2312");
	 */
	this.setcharset=function(cs) { encode=$GEC(cs); }
	/**
	 * ʹGETָUrl
	 * @param	{String}	[url]		ҪUrl
	 * @param	{function|Object|String}	[oncomplete]	ȷʱĻصҪµĶ󣬻Ҫ¶ID
	 * @example
	 * var ajax = new AJAXRequest();
	 * ajax.get("getdata.asp", function(obj) {
	 * 	alert(obj.responseText);	// ʾgetdata.aspõ
	 * });
	 * ajax.get("getdata.asp", "txtData");	// getdata.aspõݸµIDΪtxtDataHTMLԪ
	 */
	this.get=function() {
		
		var p=[],av=arguments;
		$GP(p,av,[this.url,this.oncomplete],[null,$CB]);
		if(!p[0]&&!p[1]) return false;
		return(send(p[0],"",p[1],"GET",this.async));
	}
	/**
	 * һʱָUrlָĶ
	 * @param	{function|Object|String}	oncomplete	ȷʱĻصҪµĶ󣬻Ҫ¶ID
	 * @param	{String}	url			Url
	 * @param	{Number}	interval	ʱ
	 * @param	{Number}	times		Ĵ
	 * @return	{String}	update̵ıʶֹͣupdate
	 * @see		AJAXRequest#stopupdate
	 * @example
	 * var ajax = new AJAXRequest();
	 * ajax.update(function(obj) {
	 * 		alert(obj.responseText); 
	 * 	},
	 * 	"getdata.asp",	// getdata.aspȡ
	 * 	1000,	// ÿ1һ
	 * 	3		// 3
	 * );
	 */
	this.update=function() {
		var p=[],purl,puo,pinv,pcnt,av=arguments;
		$GP(p,av,[this.oncomplete,this.url,-1,-1],[$CB,null,$N,$N]);
		if(p[2]==-1) p[3]=1;
		var sf=function(){send(p[1],"",p[0],"GET",AJAX.async);};
		var id=$GID();
		var cf=function(cc) {
			sf(); cc--; if(cc==0) return;
			$SOP(id,setTimeout(function(){cf(cc);},p[2]));
		}
		cf(p[3]);
		return id;
	}
	/**
	 * ֹͣ¶
	 * @param	{String}	update_id	updateصıʶ
	 * @see		AJAXRequest#update
	 * @example
	 * var ajax = new AJAXRequest();
	 * var up = ajax.update("txtData", "getdata.asp");
	 * ajax.stopupdate(up);
	 */
	this.stopupdate=function(id) {
		clearTimeout($LOP(id));
	}
	/**
	 * ݵָUrl
	 * @param	{String}	[url]			Url
	 * @param	{String}	[content]		Ҫ͵
	 * @param	{function|Object|String}	[oncomplete]	ȷʱĻصҪµĶ󣬻Ҫ¶ID
	 * @see		AJAXRequest#postf
	 * @example
	 * var ajax = new AJAXRequest();
	 * ajax.post("postdata.asp", "the data to post", function(){});
	 */
	this.post=function() {
		var p=[],av=arguments;
		$GP(p,av,[this.url,this.content,this.oncomplete],[null,null,$CB]);
		if(!p[0]&&!p[2]) return false;
		return(send(p[0],p[1],p[2],"POST",this.async));
	}
	/**
	 * ָıָUrl
	 * @param	{String|Object}	formObject	ID
	 * @param	{function|Object|String}	[oncomplete]	ȷʱĻصҪµĶ󣬻Ҫ¶ID
	 * @see		AJAXRequest#post
	 * @example
	 * var ajax = new AJAXRequest();
	 * ajax.postf("dataForm", function(obj) {
	 * 	alert(obj.responseText);
	 * });
	 */
	this.postf=function() {
		var p=[],fo,vaf,pcbf,purl,pc,pm,ac=arguments.length,av=arguments;
		fo=ac>0?$VO(av[0]):false;
		if(!fo||(fo&&fo.nodeName!="FORM")) return false;
		vaf=fo.getAttribute("onvalidate");
		vaf=vaf?(typeof(vaf)=="string"?new Function(vaf):vaf):null;
		if(vaf&&!vaf()) return false;
		$GP(p,[av[1],fo.getAttribute("action"),fo.getAttribute("method")],[this.oncomplete,this.url,this.method],[$CB,null,null]);
		pcbf=p[0];purl=p[1];
		if(!pcbf&&!purl) return false;
		pc=this.formToStr(fo); if(!pc) return false;
		if(p[2].toUpperCase()=="POST")
			return(send(purl,pc,pcbf,"POST",true));
		else {
			purl+=(purl.indexOf("?")>-1?"&":"?")+pc;
			return(send(purl,"",pcbf,"GET",true));
		}
	}
	/**
	 * תUrlEncodeַ
	 * @author	SurfChen <surfchen@gmail.com>
	 * @link	http://www.surfchen.org/
	 * @param	{Object} formObject
	 * @returns {String} ַ
	 * @see		AJAXRequest#postf
	 * @ignore
	 */
	this.formToStr=function(fc) {
		var i,qs="",and="",ev="";
		for(i=0;i<fc.length;i++) {
			e=fc[i];
			if (e.name!='') {
				if (e.type=='select-one'&&e.selectedIndex>-1) ev=e.options[e.selectedIndex].value;
				else if (e.type=='checkbox' || e.type=='radio') {
					if (e.checked==false) continue;
					ev=e.value;
				}
				else ev=e.value;
				ev=encode(ev); qs+=and+e.name+'='+ev; and="&";
			}
		}
		return qs;
	}
}