<%
'****************************************************
' MaxCms2.0
' Web: http://www.maxcms.net
' 2005-2009 Dreamwindows Inc. All rights reserved
' author:ElapsedBloom(qiuShi)  2008-11-17
'****************************************************
Option Explicit

dim starttime,endtime
setStartTime

const CONN_OBJ_NAME = "ADODB.CONNECTION"
const RECORDSET_OBJ_NAME = "ADODB.RECORDSET"
	
dim FSO_OBJ_NAME
	FSO_OBJ_NAME = "SCRI"&"PTING.FILES"&"YSTEMOBJECT"

dim STREAM_OBJ_NAME
	STREAM_OBJ_NAME = "ADOD"&"B.ST"&"REAM"

dim DICTIONARY_OBJ_NAME
	DICTIONARY_OBJ_NAME = "SCRIPTING.DICTIONARY"

dim JPEG_OBJ_NAME
	JPEG_OBJ_NAME="Persits.jpeg"

dim TABLE_PRE
	TABLE_PRE = "m_"

Class MainClass
	private className

	Private Sub Class_Initialize
		className=""
	End Sub

	Public Function createObject(byval classStr)
		className=classStr
		classname=replace(classname,".","_")
		Execute("set createObject=new "&classname)
	End Function
	
	Private Sub Class_Terminate()
		
	End Sub
End Class


Class MainClass_DB
	public dbConn,dbRs,isConnect,fetchCount
	private connStr,vqueryCount,vdbType
	private errid,errdes
	
	Private Sub Class_Initialize
		isConnect=false
		vqueryCount=0
		fetchCount=0
	End Sub
	
	Public Property Get queryCount
		queryCount = vqueryCount
	End Property
	
	Public Property Let dbType(byval pType)
		if pType = "sql" then vdbType=pType  else vdbType = "acc"
	End Property
	
	Private Sub getConnStr()
		if vdbType = "sql" then
			connStr = "Provider=Sqloledb;Data Source=" & databaseServer & ";Initial Catalog=" & databaseName & ";User ID=" & databaseUser & ";Password=" & databasePwd & ";"
		elseif vdbType = "acc" then
			connStr = "Provider=Microsoft.Jet.OLEdb.4.0;Data Source=" & server.mappath(accessFilePath)
		end if
	End Sub
	
	Public Sub connect()
		getConnStr
		if isObject(dbConn) = false or isConnect = false then
			On Error Resume Next
			set dbConn=server.CreateObject(CONN_OBJ_NAME)
			dbConn.open connStr
			isConnect = true
			if Err then errid=Err.number:errdes=Err.description:Err.Clear:dbConn.close:set dbConn=nothing:isConnect = false:echoErr err_dbconect,errid,errdes
		end if
	End Sub
	
	Function db(byval sqlStr,byval sqlType)
		if not isConnect = true then connect
		On Error Resume Next
		sqlStr = replace(sqlStr,"{pre}",TABLE_PRE)
		'echo sqlStr&"<br>"
		select case sqlType
			case "execute"
				set db = dbConn.execute(sqlStr)
			case "records1"
				set db=server.CreateObject(RECORDSET_OBJ_NAME)
				db.open sqlStr,dbConn,1,1
			case "records3"
				set db=server.CreateObject(RECORDSET_OBJ_NAME)
				db.open sqlStr,dbConn,3,3
			case "array"
				set dbRs=server.CreateObject(RECORDSET_OBJ_NAME)
				dbRs.open sqlStr,dbConn,1,1
				if not dbRs.eof then
					if fetchCount = 0 then  db = dbRs.getRows() else db = dbRs.getRows(fetchCount)
				end if
				dbRs.close:set dbRs=nothing
		end select
		vqueryCount = vqueryCount+1
		if Err then 
			errid=Err.number:errdes=Err.description:Err.Clear:dbConn.close:set dbConn=nothing:isConnect = false
			echoErr err_rsopen,errid,errdes
		end if
	End Function
	
	Public Sub Class_Terminate()
		if isObject(dbRs) then set dbRs = nothing
		if isConnect then dbConn.close:set dbConn = nothing
	End Sub
End Class


Class MainClass_Cache
	Public continueTime,vcacheFlag 
	Private v_cacheName,cacheData 
	
	Private Sub Class_Initialize() 
		continueTime=clng(cacheTime) 
		vcacheFlag=cacheFlag
	End Sub 
	
	Public Function  setCache(ByVal p_cacheName,ByVal p_cacheValue)
		on error resume next 
		v_cacheName=LCase(p_cacheName) 
		If v_cacheName<>"" Then 
			cacheData=Application(vcacheFlag & v_cacheName) 
			If IsArray(cacheData) Then 
				cacheData(0)=p_cacheValue 
				cacheData(1)=Now()
			Else 
				ReDim cacheData(2) 
				cacheData(0)=p_cacheValue 
				cacheData(1)=Now() 
			End If 
			if err then  
				set cacheData(0)=p_cacheValue : err.clear 
			end if 
			Application.Lock 
			Application(vcacheFlag & v_cacheName) = cacheData 
			Application.unLock 
		Else 
			die err_cachename
		End If 
	End Function 
	
	Public Function  getCache(ByVal p_cacheName)
		on error resume next
		v_cacheName=LCase(p_cacheName) 
		If v_cacheName<>"" Then 
			cacheData=Application(vcacheFlag & v_cacheName) 
			If IsArray(cacheData) Then  
				getCache=cacheData(0)
				if err then  
					set getCache=cacheData(0) : err.clear
				end if
			Else 
				die err_cachevalue 
			End If 
		Else 
			die err_cachename
		End If 
	End Function 
	
	Public Function chkCache(ByVal p_cacheName) 
		v_cacheName=LCase(p_cacheName)
		chkCache=false 
		cacheData=Application(vcacheFlag & v_cacheName) 
		If Not IsArray(cacheData) Then Exit Function 
		If Not IsDate(cacheData(1)) Then Exit Function 
		If DateDiff("s",CDate(cacheData(1)),Now()) < 60*continueTime Then 
			chkCache=true 
		End If 
	End Function 
	
	Public Sub clearCache(ByVal p_cacheName) 
		v_cacheName=LCase(p_cacheName)
		Application.Lock 
		Application(vcacheFlag & v_cacheName) = Empty 
		Application.unLock 
	End Sub 
	
	Public Function havedTime(Byval p_cacheName) 
		v_cacheName=LCase(p_cacheName) 
		If v_cacheName<>"" Then 
			cacheData=Application(vcacheFlag & v_cacheName) 
			If IsArray(cacheData) Then 
				havedTime=cacheData(1) 
			Else 
				die err_cachevalue 
			End If 
		Else
			die err_cachename 
		End If 
	End Function
	
	Public Sub clearAll()
		Application.Lock()
		Application.Contents.RemoveAll()
		Application.UnLock()
	end sub
	
	Public Sub showAllCache()
		dim acon
		echo "б<br>"
		for each acon in Application.Contents
			echo  acon&"<br>"
		next
	End Sub
End Class


Class MainClass_Template
	Public content,allPages,currentPage,currentType
	Private cacheName,labelRule,regExpObj,strDictionary,typeDic
	
	Public Sub Class_Initialize()
		set regExpObj= new RegExp
		regExpObj.ignoreCase = true
		regExpObj.Global = true
		set strDictionary = server.CreateObject(DICTIONARY_OBJ_NAME)
	End Sub
	
	Public Sub Class_Terminate()
		set regExpObj = nothing
		set strDictionary = nothing
	End Sub
	
	Public Function load(Byval filePath)
		cacheName="template_"&filePath
		if(cint(cacheStart) = 1) then
			if (cacheObj.chkCache(cacheName)) then  content = cacheObj.getCache(cacheName) else content = loadFile(filePath):cacheObj.setCache cacheName,content
		else
			content = loadFile(filePath)
		end if
	End Function		
	
	Public Function parseSelf()
		dim matches,match,labelName,selfLabelArray,selfLabelLen,sql,singleAttrKey,singleAttrValue
		sql = "select m_name,m_content from {pre}selflabel"
		labelRule="{self:([\s\S]+?)}"
		if cacheStart = 1  then
			if (not cacheObj.chkCache("selfLabelArray")) then selfLabelArray = conn.db(sql,"array") : cacheObj.setCache "selfLabelArray",selfLabelArray else  selfLabelArray = cacheObj.getCache("selfLabelArray")
		else
			selfLabelArray = conn.db(sql,"array")
		end if
		if isArray(selfLabelArray) then 
			for selfLabelLen = 0 to ubound(selfLabelArray,2)
				singleAttrKey=selfLabelArray(0,selfLabelLen)
				singleAttrValue=decodeHtml(selfLabelArray(1,selfLabelLen))
				if not strDictionary.Exists(singleAttrKey) then strDictionary.add singleAttrKey,singleAttrValue  else  strDictionary(singleAttrKey) = singleAttrValue
			next
		end if
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			labelName = trim(match.SubMatches(0))
			if strDictionary.Exists(labelName) then  content=replace(content,match.value,strDictionary(labelName))
		next
		strDictionary.RemoveAll
		set matches = nothing
	End Function
	
	Public Function parseTopAndFoot() 
		content = replaceStr(content,"{maxcms:top}",loadFileOnCache("template_","/"&sitePath&"template/"&defaultTemplate&"/"&templateFileFolder&"/head.html")) 
		content = replaceStr(content,"{maxcms:foot}",loadFileOnCache("template_","/"&sitePath&"template/"&defaultTemplate&"/"&templateFileFolder&"/foot.html"))
		content = replaceStr(content,"images/","/"&sitePath&"template/"&defaultTemplate&"/images/")
	End Function
	
	Public Function parseGlobal() 
		content = replaceStr(content,"{maxcms:indexlink}",getIndexLink)
		content = replaceStr(content,"{maxcms:topiclink}",getTopicIndexLink)
		content = replaceStr(content,"{maxcms:siteurl}",siteUrl)
		content = replaceStr(content,"{maxcms:sitepath}",sitePath)
		content = replaceStr(content,"{maxcms:sitename}",siteName) 
		content = replaceStr(content,"{maxcms:copyright}",decodeHtml(copyRight))
		content = replaceStr(content,"{maxcms:des}",decodeHtml(siteDes))  
		content = replaceStr(content,"{maxcms:sitevisitjs}",siteVisiteJs)
		content = replaceStr(content,"{maxcms:sitenotice}",decodeHtml(siteNotice))
		content = replaceStr(content,"{maxcms:keywords}",getKeywordsList(siteKeyWords,""))
		content = replaceStr(content,"{maxcms:allcount}",getDataCount("all")) 
		content = replaceStr(content,"{maxcms:daycount}",getDataCount("day"))
		if runMode="static" then  content = replaceStr(content,"{maxcms:runinfo}","") 	 
	End Function
	
	Public Function parseAttr(Byval attr)
		dim attrStr,attrArray,attrDictionary,i,singleAttr,singleAttrKey,singleAttrValue
		attrStr = regExpReplace(attr,"[\s]+",chr(32))
		attrStr = trimOuter(attrStr)
		attrArray = split(attrStr,chr(32))
		for i=0 to ubound(attrArray)
			singleAttr = split(attrArray(i),chr(61))
			singleAttrKey =  singleAttr(0) : singleAttrValue =  singleAttr(1)
			if not strDictionary.Exists(singleAttrKey) then strDictionary.add singleAttrKey,singleAttrValue  else  strDictionary(singleAttrKey) = singleAttrValue
		next
		set parseAttr = strDictionary
	End Function
	
	Public Function regExpReplace(contentstr,patternstr,replacestr)
		regExpObj.Pattern = patternstr
		regExpReplace = regExpObj.replace(contentstr,replacestr)
	End Function
	
	Private Sub initTypeDic
		set typeDic=getTypeNameTemplateArrayOnCache
	End Sub
	
	Public Function parseAreaList()
		dim matches,match,matchesVideolist,matchVideolist,totalStrAreaList,singleStrAreaList
		dim labelAttrArealist,loopStrArealist,currentAreaType,areaType,areaTypeId,currentAreaTypeCut,areaTypeArray
		dim labelAttrVideolist,labelVideolist,labelRuleVideolist,videoListStr
		dim i,j,sql,allTypeCount,typeStr,allTypeArray,m,vCountPerType
		labelRule = "{maxcms:arealist([\s\S]*?)}([\s\S]*?){/maxcms:arealist}"
		labelRuleVideolist = "{maxcms:videolist([\s\S]*?)}([\s\S]*?){/maxcms:videolist}"
		sql = "select m_id,m_name,m_upid from {pre}type order by m_sort asc"
		if cacheStart = 1  then
			if (not cacheObj.chkCache("alltype")) then allTypeArray = conn.DB(sql,"array") : cacheObj.setCache "alltype",allTypeArray else  allTypeArray = cacheObj.getCache("alltype")
		else
			allTypeArray = conn.db(sql,"array")
		end if
		allTypeCount = ubound(allTypeArray,2)
		for  i = 0 to allTypeCount
			if allTypeArray(2,i)=0 then 
				typeStr = typeStr & "," & allTypeArray(0,i)
			end if
		next
		typeStr=trimOuterStr(typeStr,",")
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			labelAttrArealist = match.SubMatches(0)
			loopStrArealist = match.SubMatches(1)
			areaType=parseAttr(labelAttrArealist)("areatype")
			if isNul(areaType)   then  areaType = "all"
			if areaType = "all" then  areaTypeArray = split(typeStr,",") else areaTypeArray = split(areaType,",")
			for j=0  to ubound(areaTypeArray)
				currentAreaType = areaTypeArray(j)
				if not isNum(currentAreaType) then die err_areaList
				m = getArrayElementID(allTypeArray,0,currentAreaType) : if isNul(m) then Exit For
				singleStrAreaList=loopStrArealist
				singleStrAreaList = replaceStr(singleStrAreaList,"[arealist:i]",j+1)
				singleStrAreaList = replaceStr(singleStrAreaList,"[arealist:typename]",allTypeArray(1,m))
				vCountPerType=conn.db("select count(*) from {pre}data where m_type in ("&getTypeIdOnCache(allTypeArray(0,m))&")","array")(0,0)
				singleStrAreaList = replaceStr(singleStrAreaList,"[arealist:count]",vCountPerType)
				singleStrAreaList = replaceStr(singleStrAreaList,"[arealist:link]",getTypeLink(allTypeArray(0,m))) 
				regExpObj.Pattern = labelRuleVideolist
				set matchesVideolist = regExpObj.Execute(singleStrAreaList)
				for each matchVideolist in matchesVideolist
					videoListStr = replaceStr(matchVideolist.value,"areatype",currentAreaType)
					singleStrAreaList = replaceStr(singleStrAreaList,matchVideolist.value,videoListStr)
				next
				set matchesVideolist = nothing
				totalStrAreaList=totalStrAreaList&singleStrAreaList
			next
			content = replaceStr(content,match.value,totalStrAreaList)
			totalStrAreaList = ""
		next
		set matches = nothing
	End Function
	
	Public Function parseVideoList()
		dim match,matches,matchfield,matchesfield
		dim labelAttrVideolist,loopstrVideoList,loopstrVlistNew,loopstrTotal,attrDictionary
		dim vnum,vorder,vtype,vtopic,vtime,vstart,vstate,vcommend
		dim fieldName,fieldAttr,fieldNameAndAttr,fieldAttrLen
		dim i,labelRuleField,n : n=0
		dim namelen,actorlen,deslen,timestyle,videoTime,colornamelen,m_colorname,m_color
		dim m,sql,orderStr,whereType,whereTopic,whereTime,whereStr,videoListArray,whereState,whereCommend,vtypeArray,vtypeI,vtypeStr,vtypeArrayLen
		labelRule = "{maxcms:videolist([\s\S]*?)}([\s\S]*?){/maxcms:videolist}"
		labelRuleField = "\[videolist:([\s\S]+?)\]"
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			labelAttrVideolist = match.SubMatches(0)
			loopstrVideoList = match.SubMatches(1)
			set attrDictionary = parseAttr(labelAttrVideolist)
			vnum = attrDictionary("num") : vorder = attrDictionary("order") : vtype = attrDictionary("type") : vtopic = attrDictionary("topic") : vtime = attrDictionary("time") : vstart = attrDictionary("start") : vstate = attrDictionary("state") : vcommend = attrDictionary("commend")
			if isNul(vnum) then vnum = 10  else vnum = cint(vnum)
		    if isNul(vorder) then vorder = "time"
			select case vorder           
				case "id" : orderStr =" order by m_id desc"
				case "hit" : orderStr =" order by m_hit desc"
				case "time" : orderStr =" order by m_addtime desc"
				case "commend" : orderStr =" order by m_commend desc"
				case "digg" : orderStr =" order by m_digg desc"
				case "hot" : orderStr =" order by m_hit desc" 
			end select
			if isNul(vtype) then vtype="all"
			vtypeStr=""
			if  vtype <> "all" then 
				if vtype="current" then 
					vtypeStr=getTypeIdOnCache(currentTypeId) 
				else 
					if instr(vtype,",")>0 then 
						vtypeArray=split(vtype,","):vtypeArrayLen=ubound(vtypeArray)
						for vtypeI=0 to  vtypeArrayLen
							vtypeStr=vtypeStr&getTypeIdOnCache(vtypeArray(vtypeI))&","
						next
						vtypeStr=trimOuterStr(vtypeStr,",")
					else
						vtypeStr=getTypeIdOnCache(vtype)
					end if
				end if
				whereType=" and m_type in ("&vtypeStr&") "
			else 
				whereType=""
			end if 
			if  vstate="series" then whereState=" and m_state>0" else whereState=""
			if not isNul(vcommend) then   
				select case trim(vcommend)
					case "all" : whereCommend=" and  m_commend>0"
					case else
						if instr(vcommend,",")>0 then whereCommend=" and m_commend in("&vcommend&")" else whereCommend=" and m_commend ="&vcommend
				end select
			else
				whereCommend=""	
			end if
			if not isNul(vtopic) then   
				select case trim(vtopic)
					case "all" : whereTopic=" and m_topic>0"
					case "current" : whereTopic=" and m_topic="&currentTopicId
					case else
						if instr(vtopic,",")>0 then whereTopic=" and m_topic in("&vtopic&")" else whereTopic=" and m_topic ="&vtopic
				end select
			else
				whereTopic=""	
			end if
			select case vtime
				case "day" : whereTime = " and  DateDiff('d',m_addtime,#"&now()&"#)=0"
				case "week" : whereTime = " and  DateDiff('w',m_addtime,#"&now()&"#)=0"
				case "month" : whereTime = " and  DateDiff('m',m_addtime,#"&now()&"#)=0"
				case else : whereTime=""
			end select
			whereStr = " where m_wrong=0 "&whereType&whereTopic&whereTime&whereState&whereCommend
			if not isNul(vstart) then  vstart = cint(vstart) else vstart=1 
			n = vstart-1 : vnum=vnum+vstart-1
			set attrDictionary = nothing			
			sql="select top "&vnum+1&" m_id,m_name,m_type,m_state,m_pic,m_hit,m_actor,m_des,m_topic,m_color,m_addtime,m_publishyear,m_publisharea ,m_commend,m_playdata from {pre}data "&whereStr&orderStr
			conn.fetchCount=vnum
			if cacheStart = 1  then
				if (not cacheObj.chkCache(vnum&whereStr&orderStr)) then videoListArray = conn.DB(sql,"array") : cacheObj.setCache vnum&whereStr&orderStr,videoListArray else  videoListArray = cacheObj.getCache(vnum&whereStr&orderStr)
			else
				videoListArray = conn.db(sql,"array")
			end if
			conn.fetchCount=0
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrVideoList)
			loopstrTotal = ""
			if isArray(videoListArray) then vnum = ubound(videoListArray,2) else vnum=-1
			for i = n to vnum
				loopstrVlistNew = loopstrVideoList
				for each matchfield in matchesfield
					fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
					fieldNameAndAttr = trimOuter(fieldNameAndAttr)
					m = instr(fieldNameAndAttr,chr(32))
					if  m > 0 then 
						fieldName = left(fieldNameAndAttr,m - 1)
						fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
					else
						fieldName = fieldNameAndAttr
						fieldAttr =	""
					end if
					select case fieldName
						case "name"
							namelen = parseAttr(fieldAttr)("len") : if isNul(namelen) then namelen = 8 else namelen=cint(namelen)
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,left(videoListArray(1,i),namelen))
						case "colorname"
							m_color=videoListArray(9,i)
							colornamelen = parseAttr(fieldAttr)("len") : if isNul(colornamelen) then colornamelen = 8 else colornamelen=cint(colornamelen) 
							m_colorname=left(videoListArray(1,i),colornamelen)
							if not isNul(m_color) then 	m_colorname="<font color='"&m_color&"'>"&m_colorname&"</font>"			
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,m_colorname)
						case "actor"
							actorlen = parseAttr(fieldAttr)("len") : if isNul(actorlen) then actorlen = 8 else actorlen=cint(actorlen)
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,left(videoListArray(6,i),actorlen))
						case "des"
							deslen = parseAttr(fieldAttr)("len") : if isNul(deslen) then deslen = 50 else deslen=cint(deslen)
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,left(filterStr(videoListArray(7,i),"html"),deslen))
						case "time"
							timestyle = parseAttr(fieldAttr)("style") : if isNul(timestyle) then timestyle = "m-d"
							videoTime = videoListArray(10,i)
							select case timestyle
								case "yy-m-d"
									loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,year(videoTime)&"-"&month(videoTime)&"-"&day(videoTime))
								case "y-m-d"
									loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,right(year(videoTime),2)&"-"&month(videoTime)&"-"&day(videoTime))
								case "m-d"
									loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,month(videoTime)&"-"&day(videoTime))
							end select
						case "i"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,i+1)
						case "typename"
							initTypeDic
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,split(typeDic(clng(videoListArray(2,i))),",")(0))
						case "typelink"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,getTypeLink(videoListArray(2,i)))
						case "link"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,getContentLink(videoListArray(2,i),videoListArray(0,i)))
						case "pic"
							if not isNul(videoListArray(4,i)) then 
								if instr(videoListArray(4,i),"http://")>0 then 
									loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(4,i))
								else
									loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,"/"&sitePath&videoListArray(4,i))
								end if
							else
								loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,"/"&sitePath&"images/nopic_small.gif")
							end if
						case "hit"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(5,i))
						case "commendpic"
							
						case "currentdaypic"
							if DateDiff("d", Now, videoListArray(10,i))=0 then 
								loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,"<img src='currentdaypic.jpg'></img>")
							else
								loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,"")
							end if
						case "state"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(3,i))
						case "publishtime"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(11,i))
						case "publisharea"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(12,i))
						case "commend"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,videoListArray(13,i))
						case "from"
							loopstrVlistNew = replaceStr(loopstrVlistNew,matchfield.value,getFromStr(videoListArray(14,i)))
					end select
				next
				loopstrTotal = loopstrTotal & loopstrVlistNew
				strDictionary.removeAll
			next
			
			set matchesfield = nothing
			content = replaceStr(content,match.value,loopstrTotal)
			strDictionary.removeAll
		next
		set matches = nothing
	End Function
	
	Public Function parsePageList(typeId,currentPage,totalPages,pageListType)
		dim matchChannel,matchesChannel,loopstrChannel,loopstrTotal,attrChannel,attrDictionary,loopstrChannelNew
		dim labelRuleField
		dim vsize,vorder
		dim i,m,sql,rsObj,orderStr,whereStr
		dim matchfield,matchesfield,fieldNameAndAttr,fieldName,fieldAttr
		dim namelen,actorlen,deslen,timestyle,videoTime,colornamelen,m_colorname,m_color
		dim matchPagelist,matchesPagelist,labelRulePagelist,lenPagelist,strPagelist
		labelRule = "{maxcms:"&pageListType&"list([\s\S]*?)}([\s\S]*?){/maxcms:"&pageListType&"list}"
		labelRuleField = "\["&pageListType&"list:([\s\S]+?)\]"
		labelRulePagelist = "\["&pageListType&"list:pagenumber([\s\S]*?)\]"
		regExpObj.Pattern = labelRule
		set matchesChannel = regExpObj.Execute(content)
		for each matchChannel in matchesChannel
			attrChannel = matchChannel.SubMatches(0)
			loopstrChannel = matchChannel.SubMatches(1)
			set attrDictionary = parseAttr(attrChannel)
			vsize = cint(attrDictionary("size")) : vorder = attrDictionary("order")
			if isNul(vsize) then vsize = 12 
			if isNul(vorder) then vorder = "time"
			select case vorder           
				case "id" : orderStr =" order by m_id desc"
				case "hit" : orderStr =" order by m_hit desc"
				case "time" : orderStr =" order by m_addtime desc"
				case "hot" : orderStr =" order by m_hit desc"
				case "digg" : orderStr =" order by m_digg desc"
			end select
			set attrDictionary = nothing
			select case  pageListType
				case "channel"
					sql="select m_id,m_name,m_type,m_state,m_pic,m_hit,m_actor,m_des,m_topic,m_color,m_addtime,m_publishyear,m_publisharea,m_commend,m_playdata from {pre}data where m_type in ("&typeId&") "&orderStr
				case "search"
					select case clng(searchType)
						case -1 : whereStr=" where m_name like '%"&searchword&"%' or m_actor like '%"&searchword&"%' or m_publisharea like '%"&searchword&"%'  or m_publishyear like '%"&searchword&"%'"
						case 0 : whereStr=" where m_name like '%"&searchword&"%'"
						case 1 : whereStr=" where m_actor like '%"&searchword&"%'"
						case 2 : whereStr=" where m_publisharea like '%"&searchword&"%'"
						case 3 : whereStr=" where m_publishyear like '%"&searchword&"%'"
					end select
					sql="select m_id,m_name,m_type,m_state,m_pic,m_hit,m_actor,m_des,m_topic,m_color,m_addtime,m_publishyear,m_publisharea,m_commend,m_playdata from {pre}data "&whereStr&" "&orderStr
			end select
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrChannel)
			set rsObj=conn.db(sql,"records1")
			if rsObj.eof then 
				if pageListType="channel" then 
					loopstrTotal="Բ𣬸÷޼¼κμ¼"
				elseif  pageListType="search" then
					loopstrTotal="Բûҵκμ¼,<a target='_blank' href='gbook.asp?key="&searchword&"' class='red'><b>ڴ</b></a>ǾΪϲĵӰ"
				end if
			else
				rsObj.pagesize = vsize
				if currentPage>rsObj.pagecount then currentPage=rsObj.pagecount
				rsObj.absolutepage=currentPage
				loopstrTotal = ""			
				for i = 1 to vsize
					loopstrChannelNew = loopstrChannel
					for each matchfield in matchesfield
						fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
						fieldNameAndAttr = trimOuter(fieldNameAndAttr)
						m = instr(fieldNameAndAttr,chr(32))
						if  m > 0 then 
							fieldName = left(fieldNameAndAttr,m - 1)
							fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
						else
							fieldName = fieldNameAndAttr
							fieldAttr =	""
						end if
						select case fieldName
							case "name"
								namelen = parseAttr(fieldAttr)("len") : if isNul(namelen) then namelen = 8 else namelen=cint(namelen)						
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,left(rsObj(1),namelen))
							case "colorname"
								m_color=rsObj(9)
								colornamelen = parseAttr(fieldAttr)("len") : if isNul(colornamelen) then colornamelen = 8 else colornamelen=cint(colornamelen) 
								m_colorname=left(rsObj(1),colornamelen)
								if not isNul(m_color) then 	m_colorname="<font color='"&m_color&"'>"&m_colorname&"</font>"			
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,m_colorname)
							case "actor"
								actorlen = parseAttr(fieldAttr)("len") : if isNul(actorlen) then actorlen = 8 else actorlen=cint(actorlen)
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,left(rsObj(6),actorlen))
							case "des"
								deslen = parseAttr(fieldAttr)("len") : if isNul(deslen) then deslen = 50 else deslen=cint(deslen)
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,left(filterStr(rsObj(7),"html"),deslen))
							case "time"
								timestyle = parseAttr(fieldAttr)("style") : if isNul(timestyle) then timestyle = "m-d"
								videoTime = rsObj(10)
								select case timestyle
									case "yy-m-d"
										loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,year(videoTime)&"-"&month(videoTime)&"-"&day(videoTime))
									case "y-m-d"
										loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,right(year(videoTime),2)&"-"&month(videoTime)&"-"&day(videoTime))
									case "m-d"
										loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,month(videoTime)&"-"&day(videoTime))
								end select
							case "i"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,i+1)
							case "typename"
								initTypeDic
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,split(typeDic(clng(rsObj(2))),",")(0))
							case "typelink"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,getTypeLink(rsObj(2)))
							case "link"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,getContentLink(rsObj(2),rsObj(0)))
							case "pic"
								if not isNul(rsObj(4)) then 
									if instr(rsObj(4),"http://")>0 then 
										loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(4))
									else
										loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,"/"&sitePath&rsObj(4))
									end if
								else
									loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,"/"&sitePath&"images/nopic_small.gif")
								end if
							case "hit"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(5))
							case "commendpic"
								
							case "currentdaypic"
								if DateDiff("d", Now, rsObj(10))=0 then 
									loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,"<img src='currentdaypic.jpg'></img>")
								else
									loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,"")
								end if
							case "state"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(3))
							case "publishtime"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(11))
							case "publisharea"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(12))
							case "commend"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,rsObj(13))
							case "from"
								loopstrChannelNew = replaceStr(loopstrChannelNew,matchfield.value,getFromStr(rsObj(14)))
						end select
						strDictionary.removeAll
					next
					loopstrTotal = loopstrTotal & loopstrChannelNew
					rsObj.movenext
					if rsObj.eof then exit for
				next
			end if
			content = replace(content,matchChannel.value,loopstrTotal)
			regExpObj.Pattern = labelRulePagelist
			set matchesPagelist = regExpObj.Execute(content)
			for each matchPagelist in matchesPagelist
				if rsObj.pagecount=0 then
					content = replace(content,matchPagelist.value,"")
				else
					lenPagelist = parseAttr(matchPagelist.SubMatches(0))("len")
					if isNul(lenPagelist) then lenPagelist = 10 else lenPagelist = cint(lenPagelist)
					strPagelist = pageNumberLinkInfo(currentPage,lenPagelist,rsObj.pagecount,pageListType)
					content = replace(content,matchPagelist.value,strPagelist)
				end if
			next 
			set matchesPagelist = nothing
			set matchesfield = nothing
			strDictionary.removeAll
		next
		set matchesChannel = nothing
		'die ""
	End Function
	
	Public Function parseMenuList()
		dim match,matches,matchfield,matchesfield
		dim labelAttrMenulist,loopstrMenulist,loopstrMlistNew,loopstrTotal
		dim vtype,vnum,vnumSon
		dim fieldName,fieldAttr,fieldNameAndAttr,fieldAttrLen
		dim i,labelRuleField
		dim m,rsArray,rsFlag
		labelRule = "{maxcms:menulist([\s\S]*?)}([\s\S]*?){/maxcms:menulist}"
		labelRuleField = "\[menulist:([\s\S]+?)\]"
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			loopstrTotal = ""
			labelAttrMenulist = match.SubMatches(0)
			loopstrMenulist = match.SubMatches(1)
			vtype = parseAttr(labelAttrMenulist)("type")
			if isNul(vtype) then vtype = "top"
			select case vtype
				case "top"
					rsFlag="top"
					rsArray = conn.db("select m_name,m_id from {pre}type where m_hide=0 and m_upid=0 order by m_sort","array")
					if isArray(rsArray) then vnum = ubound(rsArray,2)  else  vnum=-1
				case "son"
					rsFlag="son"
					rsArray = conn.db("select m_name,m_id from {pre}type where m_hide=0 and m_upid="&currentTypeId&" order by m_sort","array")
					if isArray(rsArray) then vnum = ubound(rsArray,2)  else  vnum=-1
				case "all"
					rsFlag="all" : vnum=-1 : loopstrTotal=getAllMenuListOnCache(0)
				case else
					if not isNum(vtype) then die "ָ"
					'echo vtype&"<br>"
					rsArray = conn.db("select m_name,m_id from {pre}type where m_hide=0 and m_upid="&vtype&" order by m_sort","array")			
					if isArray(rsArray) then vnum = ubound(rsArray,2)  else  vnum=-1
			end select
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrMenulist)
			for i = 0 to vnum
				loopstrMlistNew = loopstrMenulist
				for each matchfield in matchesfield
					fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
					fieldNameAndAttr = trimOuter(fieldNameAndAttr)
					m = instr(fieldNameAndAttr,chr(32))
					if  m > 0 then 
						fieldName = left(fieldNameAndAttr,m - 1)
						fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
					else
						fieldName = fieldNameAndAttr
						fieldAttr =	""
					end if
					select case fieldName
						case "i"
							loopstrMlistNew = replaceStr(loopstrMlistNew,matchfield.value,i+1)
						case "typeid"
							loopstrMlistNew = replaceStr(loopstrMlistNew,matchfield.value,rsArray(1,i))
						case "typename"
							loopstrMlistNew = replaceStr(loopstrMlistNew,matchfield.value,rsArray(0,i))
						case "link"
							loopstrMlistNew = replaceStr(loopstrMlistNew,matchfield.value,getTypeLink(rsArray(1,i)))
					end select
				next
				loopstrTotal = loopstrTotal & loopstrMlistNew
			next
			set matchesfield = nothing
			content = replaceStr(content,match.value,loopstrTotal)
			strDictionary.removeAll
		next
		set matches = nothing
	End Function
	
	Public Function parseTopicList()
		dim match,matches,matchfield,matchesfield
		dim labelAttrTopiclist,loopstrTopiclist,loopstrTopiclistNew,loopstrTotal
		dim vtid,vnum
		dim fieldName,fieldAttr,fieldNameAndAttr,fieldAttrLen
		dim i,labelRuleField
		dim m,rsArray,rsFlag,whereTopic,topicLink
		labelRule = "{maxcms:topiclist([\s\S]*?)}([\s\S]*?){/maxcms:topiclist}"
		labelRuleField = "\[topiclist:([\s\S]+?)\]"
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			loopstrTotal = ""
			labelAttrTopiclist = match.SubMatches(0)
			loopstrTopiclist = match.SubMatches(1)
			vtid = parseAttr(labelAttrTopiclist)("id")
			if isNul(vtid) then vtid = "all"
			select case trim(vtid)
				case "all" : whereTopic=""
				case else
					if instr(vtid,",")>0 then whereTopic=" where m_id in("&vtid&")" else whereTopic=" where m_id ="&vtid
			end select
			rsArray = conn.db("select m_name,m_id,m_pic,m_enname,m_des,(select count(*) from {pre}data where m_topic=t.m_id) as m_count from {pre}topic t "&whereTopic&" order by m_sort asc","array")
			if isArray(rsArray) then vnum = ubound(rsArray,2)  else  vnum=-1
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrTopiclist)
			for i = 0 to vnum
				loopstrTopiclistNew = loopstrTopiclist
				for each matchfield in matchesfield
					fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
					fieldNameAndAttr = trimOuter(fieldNameAndAttr)
					m = instr(fieldNameAndAttr,chr(32))
					if  m > 0 then 
						fieldName = left(fieldNameAndAttr,m - 1)
						fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
					else
						fieldName = fieldNameAndAttr
						fieldAttr =	""
					end if
					select case fieldName
						case "i"
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,i+1)
						case "name"
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,rsArray(0,i))
						case "count"
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,rsArray(5,i))
						case "pic"
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,rsArray(2,i))
						case "link"
							if runMode="dynamic" then topicLink="/"&sitePath&topicDirName&"/?"&rsArray(1,i)&fileSuffix  else topicLink="/"&sitePath&topicDirName&"/"&rsArray(3,i)&fileSuffix
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,topicLink)
						case "des"
							loopstrTopiclistNew = replaceStr(loopstrTopiclistNew,matchfield.value,decodeHtml(rsArray(4,i)))
					end select
				next
				loopstrTotal = loopstrTotal & loopstrTopiclistNew
			next
			set matchesfield = nothing
			content = replaceStr(content,match.value,loopstrTotal)
			strDictionary.removeAll
		next
		set matches = nothing
	End Function
	
	Public Function parseLinkList()
		dim match,matches,matchfield,matchesfield
		dim labelAttrLinklist,loopstrLinklist,loopstrLinklistNew,loopstrTotal
		dim vtype,vnum,whereStr,linkArray
		dim fieldName,fieldAttr,fieldNameAndAttr,fieldAttrLen
		dim i,labelRuleField
		dim m,namelen,deslen
		labelRule = "{maxcms:linklist([\s\S]*?)}([\s\S]*?){/maxcms:linklist}"
		labelRuleField = "\[linklist:([\s\S]+?)\]"
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			labelAttrLinklist = match.SubMatches(0)
			loopstrLinklist = match.SubMatches(1)
			vtype = parseAttr(labelAttrLinklist)("type")
			if isNul(vtype) then vtype = "font"
			select case vtype
				case "font" : whereStr = chr(32) & "m_type='font'" & chr(32)
				case "pic" : whereStr = chr(32) & "m_type='pic'" & chr(32)
				case else : whereStr = chr(32) & "m_type='font'" & chr(32)
			end select
			linkArray = conn.db("select m_name,m_pic,m_url,m_des from {pre}link  where " & whereStr & " order by m_sort asc","array")
			if not isarray(linkArray) then  vnum=-1  else vnum = ubound(linkArray,2)
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrLinklist)
			loopstrTotal = ""
			for i = 0 to vnum
				loopstrLinklistNew = loopstrLinklist
				for each matchfield in matchesfield
					fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
					fieldNameAndAttr = trimOuter(fieldNameAndAttr)
					m = instr(fieldNameAndAttr,chr(32))
					if  m > 0 then 
						fieldName = left(fieldNameAndAttr,m - 1)
						fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
					else
						fieldName = fieldNameAndAttr
						fieldAttr =	""
					end if
					select case fieldName
						case "name"
							namelen = parseAttr(fieldAttr)("len") : if isNul(namelen) then namelen = 8 else namelen=cint(namelen)
							loopstrLinklistNew = replaceStr(loopstrLinklistNew,matchfield.value,left(linkArray(0,i),namelen))
						case "link"
							loopstrLinklistNew = replaceStr(loopstrLinklistNew,matchfield.value,linkArray(2,i))
						case "pic"
							loopstrLinklistNew = replaceStr(loopstrLinklistNew,matchfield.value,linkArray(1,i))
						case "des"
							deslen = cint(parseAttr(fieldAttr)("len")) : if isNul(deslen) then namelen = 20
							loopstrLinklistNew = replaceStr(loopstrLinklistNew,matchfield.value,linkArray(3,i))
						case "i"
							loopstrLinklistNew = replaceStr(loopstrLinklistNew,matchfield.value,i+1)
					end select
				next
				loopstrTotal = loopstrTotal & loopstrLinklistNew
			next
			set matchesfield = nothing
			content = replaceStr(content,match.value,loopstrTotal)
			strDictionary.removeAll
		next
		set matches = nothing
	End Function
	
	Public Function parsePlayList(dataId,str)
		dim match,matches,matchfield,matchesfield
		dim loopstrPlaylist,loopstrPlaylistNew,loopstrTotal
		dim vtype,playRsArray,playDataArray,singlePlayData,vnum,videoFrom,videoUrl
		dim fieldName,fieldAttr,fieldNameAndAttr
		dim i,labelRuleField
		dim m,videoFromStr,videoFromCount,whereStr,n,urlStr
		labelRule = "{playpage:"&str&"list[\s\S]*?}([\s\S]*?){/playpage:"&str&"list}"
		labelRuleField = "\["&str&"list:([\s\S]+?)\]"
		whereStr =chr(32) & "m_id=" & dataId & chr(32)
		regExpObj.Pattern = labelRule
		set matches = regExpObj.Execute(content)
		for each match in matches
			loopstrPlaylist = match.SubMatches(0)
			playRsArray = conn.db("select m_type,m_"&str&"data from {pre}data where " & whereStr,"array")
			playDataArray=getPlayurlArray(playRsArray(1,0))
			vnum = ubound(playDataArray) 
			regExpObj.Pattern = labelRuleField
			set matchesfield = regExpObj.Execute(loopstrPlaylist)
			loopstrTotal = ""
			for i = 0 to vnum
				'die playDataArray(i)
				singlePlayData=split(playDataArray(i),"$$") : videoFrom=i : videoUrl=singlePlayData(1)
				loopstrPlaylistNew = loopstrPlaylist
				for each matchfield in matchesfield
					fieldNameAndAttr = regExpReplace(matchfield.SubMatches(0),"[\s]+",chr(32))
					fieldNameAndAttr = trimOuter(fieldNameAndAttr)
					m = instr(fieldNameAndAttr,chr(32))
					if  m > 0 then 
						fieldName = left(fieldNameAndAttr,m - 1)
						fieldAttr =	right(fieldNameAndAttr,len(fieldNameAndAttr) - m)
					else
						fieldName = fieldNameAndAttr
						fieldAttr =	""
					end if
					select case fieldName
						case "from"
							loopstrPlaylistNew = replace(loopstrPlaylistNew,matchfield.value,singlePlayData(0))
						case "link"
							urlStr = getPlayUrlList(videoFrom,videoUrl,playRsArray(0,0),dataId,str)
							loopstrPlaylistNew = replace(loopstrPlaylistNew,matchfield.value,urlStr)
						case "i"
							loopstrPlaylistNew = replace(loopstrPlaylistNew,matchfield.value,i+1)
					end select
				next
				loopstrTotal = loopstrTotal & loopstrPlaylistNew
			next
			set matchesfield = nothing
			content = replace(content,match.value,loopstrTotal)
			content = replace(content,"{playpage:playlistlen}",vnum+1)
			strDictionary.removeAll
		next
		set matches = nothing
	End Function
	
	Public Function parseIf()
		dim matchIf,matchesIf,strIf,strThen,strThen1,strElse1
		dim ifFlag
		labelRule = "{if:([\s\S]+?)}([\s\S]*?){end if}"
		regExpObj.Pattern = labelRule
		set matchesIf = regExpObj.Execute(content)
		for each matchIf in matchesIf 
			strIf = matchIf.SubMatches(0)
			strThen = matchIf.SubMatches(1)
			if instr(strThen,"{else}")>0 then 
				strThen1=split(strThen,"{else}")(0)
				strElse1=split(strThen,"{else}")(1)
				Execute("if  " & strIf & "then ifFlag = true else ifFlag = false")
				if ifFlag then content = replace(content,matchIf.value,strThen1) else content = replace(content,matchIf.value,strElse1)
			else
				Execute("if  " & strIf & "then ifFlag = true else ifFlag = false")
				if ifFlag then content = replace(content,matchIf.value,strThen) else content = replace(content,matchIf.value,"")
			end if
		next
		set matchesIf = nothing
	End Function
End Class


Class MainClass_DataList
	Public primaryField,tableStr
	Public orderStr,whereStr,dataSortType,fieldsStr,dataPageSize,dataCurrentPage
	Public recordsCount,pagesCount
	private tempTableCount,sqlstr,topCount,whereStr2,whereStr3
	private m,n
	
	Public Sub Class_Initialize
		 dataSortType = "desc"
	End Sub
	
	Public Sub Class_Terminate
		 
	End Sub
	
	Public Function getDataList()
		dim order
		if isNul(dataPageSize) then dataPageSize = 100 else dataPageSize = cint(dataPageSize)
		if not isNul(whereStr) then whereStr= " where "&whereStr else whereStr=""
		if isNul(tableStr) then die err_table
		if isNul(fieldsStr) then fieldsStr = " * "  else  fieldsStr = " " & fieldsStr & " "
		if not isNul(orderStr) then order = " order by " & orderStr & " " & dataSortType  else order=" "
		sqlstr = "select top " & dataPageSize & fieldsStr & " from " & tableStr & " " & whereStr & order
		'die sqlstr
		getDataList = conn.db(sqlstr,"array")
	End Function
	
	Public Function getPageList()
		dim order
		if isNul(dataPageSize) then dataPageSize = 30 else dataPageSize = cint(dataPageSize)
		if not isNul(whereStr) then whereStr2 = " where "&whereStr : whereStr3 = " and "&whereStr else whereStr2="":whereStr3=""
		recordsCount = conn.db("select count(*) from "&tableStr&whereStr2,"array")(0,0)
		m = recordsCount mod dataPageSize
		n = int(recordsCount / dataPageSize)
		if m = 0 then pagesCount = n else pagesCount = n + 1  
		if isNul(primaryField) then die err_primarykey
		if isNul(tableStr) then die err_table
		if isNul(orderStr) then orderStr = primaryField
		if isNul(fieldsStr) then fieldsStr = " * "  else  fieldsStr = " " & fieldsStr & " "
		if dataCurrentPage > pagesCount   then dataCurrentPage = pagesCount
		if isNul(dataCurrentPage)  then 
			dataCurrentPage = 1 
		else 
			if dataCurrentPage <= 0 then dataCurrentPage = 1 else dataCurrentPage = cint(dataCurrentPage)
		end if
		order = " " & orderStr & " " & dataSortType 
		if dataSortType = "desc" then
			if dataCurrentPage = 1 then 
				sqlstr = "select top " & dataPageSize & fieldsStr & " from " & tableStr & " " & whereStr2 & " order by " & order
			else
				sqlstr = "select top " & dataPageSize & fieldsStr & " from " & tableStr & " where " & primaryField & "<(select min(" & primaryField & ") from (select top " & (dataCurrentPage - 1) * dataPageSize & " " & primaryField & " from " & tableStr &" "&whereStr2& " order by  " & order & ") as temptable)  "& whereStr3& " order by " & order
			end if
		else dataSortType = "asc" 
			if dataCurrentPage = 1 then 
				sqlstr = "select top " & dataPageSize & fieldsStr & " from " & tableStr & " " & whereStr2 & " order by " & order
			else
				sqlstr = "select top " & dataPageSize & fieldsStr & " from " & tableStr & " where " & primaryField & ">(select max(" & primaryField & ") from (select top " & (dataCurrentPage - 1) * dataPageSize  & " " & primaryField & " from " & tableStr &" "& whereStr& " order by  " & order & ") as temptable)  "& whereStr3& " order by " & order
			end if
		end if
		getPageList = conn.db(sqlstr,"array")
	End Function
End Class


Class MainClass_Xml
	Public xmlDocument,xmlPath,xmlDomObj,xmlstr
	Private xmlDomVer,xmlFileSavePath
	
	Public Sub Class_Initialize()
		xmlDomVer = getXmlDomVer()
		createXmlDomObj
	End Sub
	
	Public Sub Class_Terminate()
		If IsObject(xmlDomObj) Then Set xmlDomObj = Nothing
	End Sub
	
	Private Function getXmlDomVer()
		dim i,xmldomVersions,xmlDomVersion
		getXmlDomVer = false
		xmldomVersions = Array("Microsoft.2MLDOM","MSXML2.DOMDocument","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.5.0")
		for i = 0 to ubound(xmldomVersions)
			xmlDomVersion = xmldomVersions(i)
			if isInstallObj(xmlDomVersion) then getXmlDomVer = xmlDomVersion : Exit Function
		next
End Function
	
	Private Sub createXmlDomObj
		set xmlDomObj = server.CreateObject(xmlDomVer)
		xmlDomObj.validateonparse = true 
		xmlDomObj.async=false 
	End Sub
	
	Public Function load(Byval xml,Byval xmlType)
		dim xmlUrl,xmlfilePath
		select case xmlType 
			case "xmlfile"
				xmlfilePath=server.mappath(xml)   
		 		xmlDomObj.load(xmlfilePath)   
			case "xmldocument"
				xmlUrl = xml
				xmlstr = getRemoteContent(xmlUrl,"text")
				If left(xmlstr, 5) <> "<?xml" then die err_xml else xmlDomObj.loadXML(xmlstr)
			case "transfer"
				xmlUrl = xml
				xmlstr = bytesToStr(getRemoteContent(xmlUrl,"body"),"gbk")
				If left(xmlstr, 5) <> "<?xml" then die err_xml else xmlDomObj.loadXML(xmlstr)
		end select
	End Function
	
	Public Function isExistNode(nodename)
        dim node
        isExistNode = True
        set node = xmlDomObj.getElementsByTagName(nodename)
        If node.Length = 0 Then isExistNode = False : set node = nothing
    End Function
	
	Public Function getNodeValue(nodename, itemId)
		if isNul(itemId) then  itemId = 0
    	getNodeValue = xmlDomObj.getElementsByTagName(nodename).Item(itemId).Text
    End Function
	
	Public Function getNodeLen(nodename)
        getNodeLen = xmlDomObj.getElementsByTagName(nodename).Length
    End Function
	
	Public Function getNodes(nodename)
        Set getNodes = xmlDomObj.getElementsByTagName(nodename)
    End Function
	
	Public Function getNode(nodename, itemId)
        Set getNode = xmlDomObj.getElementsByTagName(nodename).Item(itemId)
    End Function
	
	Public Function getAttributes(nodeName, attrName, itemId)
        dim xmlAttributes, i
		if isNul(itemId) then  itemId = 0
        Set xmlAttributes = xmlDomObj.getElementsByTagName(nodeName).Item(itemId).Attributes
        For i = 0 To xmlAttributes.Length -1
            If xmlAttributes(i).Name = attrName Then
                getAttributes = XmlAttributes(i).Value
				Set xmlAttributes = nothing
                Exit Function
            End If
        Next
        getAttributes = false
    End Function
	
	Public Function setXmlNodeValue(Byval nodename, Byval itemId, Byval str,Byval savePath)
        dim node
		xmlFileSavePath = savePath
        Set node = xmlDomObj.getElementsByTagName(nodename).Item(itemId)
        node.childNodes(0).text = str
        xmlDomObj.save Server.MapPath(xmlFileSavePath)
		set node = nothing
    End Function

End Class
%>
<!--#include file="config.asp"-->
<!--#include file="CommonFun.asp"-->
<!--#include file="lang.asp"-->

<%
dim mainClassObj
set mainClassObj = New MainClass

dim conn
set conn = mainClassobj.createObject("MainClass.DB") 
if  databaseType  = 0 then  conn.dbType = "acc"

dim objFso,objStream
initializeAllObjects

dim cacheObj
set cacheObj = mainClassObj.createObject("MainClass.Cache")

dim currentTypeId : currentTypeId=-444
dim pageUrlStyle
%>