﻿<%
Private Const MSBITS_TO_A_BYTE = 8
Private Const MSBYTES_TO_A_WORD = 4
Private Const MSBITS_TO_A_WORD = 32

Private MSm_lOnBits(30)
Private MSm_l2Power(30)
 
Private Function MSLShift(lValue, iShiftBits)
    If iShiftBits = 0 Then
        MSLShift = lValue
        Exit Function
    ElseIf iShiftBits = 31 Then
        If lValue And 1 Then
            MSLShift = &H80000000
        Else
            MSLShift = 0
        End If
        Exit Function
    ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
        Err.Raise 6
    End If

    If (lValue And MSm_l2Power(31 - iShiftBits)) Then
        MSLShift = ((lValue And MSm_lOnBits(31 - (iShiftBits + 1))) * MSm_l2Power(iShiftBits)) Or &H80000000
    Else
        MSLShift = ((lValue And MSm_lOnBits(31 - iShiftBits)) * MSm_l2Power(iShiftBits))
    End If
End Function

Private Function MSRShift(lValue, iShiftBits)
    If iShiftBits = 0 Then
        MSRShift = lValue
        Exit Function
    ElseIf iShiftBits = 31 Then
        If lValue And &H80000000 Then
            MSRShift = 1
        Else
            MSRShift = 0
        End If
        Exit Function
    ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
        Err.Raise 6
    End If
    
    MSRShift = (lValue And &H7FFFFFFE) \ MSm_l2Power(iShiftBits)

    If (lValue And &H80000000) Then
        MSRShift = (MSRShift Or (&H40000000 \ MSm_l2Power(iShiftBits - 1)))
    End If
End Function

Private Function MSRotateLeft(lValue, iShiftBits)
    MSRotateLeft = MSLShift(lValue, iShiftBits) Or MSRShift(lValue, (32 - iShiftBits))
End Function

Private Function MSAddUnsigned(lX, lY)
    Dim lX4
    Dim lY4
    Dim lX8
    Dim lY8
    Dim lResult
 
    lX8 = lX And &H80000000
    lY8 = lY And &H80000000
    lX4 = lX And &H40000000
    lY4 = lY And &H40000000
 
    lResult = (lX And &H3FFFFFFF) + (lY And &H3FFFFFFF)
 
    If lX4 And lY4 Then
        lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
    ElseIf lX4 Or lY4 Then
        If lResult And &H40000000 Then
            lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
        Else
            lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
        End If
    Else
        lResult = lResult Xor lX8 Xor lY8
    End If
 
    MSAddUnsigned = lResult
End Function

Private Function MSmd5_F(x, y, z)
    MSmd5_F = (x And y) Or ((Not x) And z)
End Function

Private Function MSmd5_G(x, y, z)
    MSmd5_G = (x And z) Or (y And (Not z))
End Function

Private Function MSmd5_H(x, y, z)
    MSmd5_H = (x Xor y Xor z)
End Function

Private Function MSmd5_I(x, y, z)
    MSmd5_I = (y Xor (x Or (Not z)))
End Function

Private Sub MSmd5_FF(a, b, c, d, x, s, ac)
    a = MSAddUnsigned(a, MSAddUnsigned(MSAddUnsigned(MSmd5_F(b, c, d), x), ac))
    a = MSRotateLeft(a, s)
    a = MSAddUnsigned(a, b)
End Sub

Private Sub MSmd5_GG(a, b, c, d, x, s, ac)
    a = MSAddUnsigned(a, MSAddUnsigned(MSAddUnsigned(MSmd5_G(b, c, d), x), ac))
    a = MSRotateLeft(a, s)
    a = MSAddUnsigned(a, b)
End Sub

Private Sub MSmd5_HH(a, b, c, d, x, s, ac)
    a = MSAddUnsigned(a, MSAddUnsigned(MSAddUnsigned(MSmd5_H(b, c, d), x), ac))
    a = MSRotateLeft(a, s)
    a = MSAddUnsigned(a, b)
End Sub

Private Sub MSmd5_II(a, b, c, d, x, s, ac)
    a = MSAddUnsigned(a, MSAddUnsigned(MSAddUnsigned(MSmd5_I(b, c, d), x), ac))
    a = MSRotateLeft(a, s)
    a = MSAddUnsigned(a, b)
End Sub

Private Function MSConvertToWordArray(sMessage)
    Dim lMessageLength
    Dim lNumberOfWords
    Dim lWordArray()
    Dim lBytePosition
    Dim lByteCount
    Dim lWordCount
    
    Const MODULUS_BITS = 512
    Const CONGRUENT_BITS = 448
    
    lMessageLength = Len(sMessage)
    
    lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ MSBITS_TO_A_BYTE)) \ (MODULUS_BITS \ MSBITS_TO_A_BYTE)) + 1) * (MODULUS_BITS \ MSBITS_TO_A_WORD)
    ReDim lWordArray(lNumberOfWords - 1)
    
    lBytePosition = 0
    lByteCount = 0
    Do Until lByteCount >= lMessageLength
        lWordCount = lByteCount \ MSBYTES_TO_A_WORD
        lBytePosition = (lByteCount Mod MSBYTES_TO_A_WORD) * MSBITS_TO_A_BYTE
        lWordArray(lWordCount) = lWordArray(lWordCount) Or MSLShift(Asc(Mid(sMessage, lByteCount + 1, 1)), lBytePosition)
        lByteCount = lByteCount + 1
    Loop

    lWordCount = lByteCount \ MSBYTES_TO_A_WORD
    lBytePosition = (lByteCount Mod MSBYTES_TO_A_WORD) * MSBITS_TO_A_BYTE

    lWordArray(lWordCount) = lWordArray(lWordCount) Or MSLShift(&H80, lBytePosition)

    lWordArray(lNumberOfWords - 2) = MSLShift(lMessageLength, 3)
    lWordArray(lNumberOfWords - 1) = MSRShift(lMessageLength, 29)
    
    MSConvertToWordArray = lWordArray
End Function

Private Function MSWordToHex(lValue)
    Dim lByte
    Dim lCount
    
    For lCount = 0 To 3
        lByte = MSRShift(lValue, lCount * MSBITS_TO_A_BYTE) And MSm_lOnBits(MSBITS_TO_A_BYTE - 1)
        MSWordToHex = MSWordToHex & Right("0" & Hex(lByte), 2)
    Next
End Function

Public Function MSMD5(sMessage, iLength)
    MSm_lOnBits(0) = CLng(1)
    MSm_lOnBits(1) = CLng(3)
    MSm_lOnBits(2) = CLng(7)
    MSm_lOnBits(3) = CLng(15)
    MSm_lOnBits(4) = CLng(31)
    MSm_lOnBits(5) = CLng(63)
    MSm_lOnBits(6) = CLng(127)
    MSm_lOnBits(7) = CLng(255)
    MSm_lOnBits(8) = CLng(511)
    MSm_lOnBits(9) = CLng(1023)
    MSm_lOnBits(10) = CLng(2047)
    MSm_lOnBits(11) = CLng(4095)
    MSm_lOnBits(12) = CLng(8191)
    MSm_lOnBits(13) = CLng(16383)
    MSm_lOnBits(14) = CLng(32767)
    MSm_lOnBits(15) = CLng(65535)
    MSm_lOnBits(16) = CLng(131071)
    MSm_lOnBits(17) = CLng(262143)
    MSm_lOnBits(18) = CLng(524287)
    MSm_lOnBits(19) = CLng(1048575)
    MSm_lOnBits(20) = CLng(2097151)
    MSm_lOnBits(21) = CLng(4194303)
    MSm_lOnBits(22) = CLng(8388607)
    MSm_lOnBits(23) = CLng(16777215)
    MSm_lOnBits(24) = CLng(33554431)
    MSm_lOnBits(25) = CLng(67108863)
    MSm_lOnBits(26) = CLng(134217727)
    MSm_lOnBits(27) = CLng(268435455)
    MSm_lOnBits(28) = CLng(536870911)
    MSm_lOnBits(29) = CLng(1073741823)
    MSm_lOnBits(30) = CLng(2147483647)
    
    MSm_l2Power(0) = CLng(1)
    MSm_l2Power(1) = CLng(2)
    MSm_l2Power(2) = CLng(4)
    MSm_l2Power(3) = CLng(8)
    MSm_l2Power(4) = CLng(16)
    MSm_l2Power(5) = CLng(32)
    MSm_l2Power(6) = CLng(64)
    MSm_l2Power(7) = CLng(128)
    MSm_l2Power(8) = CLng(256)
    MSm_l2Power(9) = CLng(512)
    MSm_l2Power(10) = CLng(1024)
    MSm_l2Power(11) = CLng(2048)
    MSm_l2Power(12) = CLng(4096)
    MSm_l2Power(13) = CLng(8192)
    MSm_l2Power(14) = CLng(16384)
    MSm_l2Power(15) = CLng(32768)
    MSm_l2Power(16) = CLng(65536)
    MSm_l2Power(17) = CLng(131072)
    MSm_l2Power(18) = CLng(262144)
    MSm_l2Power(19) = CLng(524288)
    MSm_l2Power(20) = CLng(1048576)
    MSm_l2Power(21) = CLng(2097152)
    MSm_l2Power(22) = CLng(4194304)
    MSm_l2Power(23) = CLng(8388608)
    MSm_l2Power(24) = CLng(16777216)
    MSm_l2Power(25) = CLng(33554432)
    MSm_l2Power(26) = CLng(67108864)
    MSm_l2Power(27) = CLng(134217728)
    MSm_l2Power(28) = CLng(268435456)
    MSm_l2Power(29) = CLng(536870912)
    MSm_l2Power(30) = CLng(1073741824)


    Dim x
    Dim k
    Dim AA
    Dim BB
    Dim CC
    Dim DD
    Dim a
    Dim b
    Dim c
    Dim d
    
    Const S11 = 7
    Const S12 = 12
    Const S13 = 17
    Const S14 = 22
    Const S21 = 5
    Const S22 = 9
    Const S23 = 14
    Const S24 = 20
    Const S31 = 4
    Const S32 = 11
    Const S33 = 16
    Const S34 = 23
    Const S41 = 6
    Const S42 = 10
    Const S43 = 15
    Const S44 = 21

    x = MSConvertToWordArray(sMessage)
    
    a = &H67452301
    b = &HEFCDAB89
    c = &H98BADCFE
    d = &H10325476

    For k = 0 To UBound(x) Step 16
        AA = a
        BB = b
        CC = c
        DD = d
    
        MSmd5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
        MSmd5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
        MSmd5_FF c, d, a, b, x(k + 2), S13, &H242070DB
        MSmd5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
        MSmd5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
        MSmd5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
        MSmd5_FF c, d, a, b, x(k + 6), S13, &HA8304613
        MSmd5_FF b, c, d, a, x(k + 7), S14, &HFD469501
        MSmd5_FF a, b, c, d, x(k + 8), S11, &H698098D8
        MSmd5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
        MSmd5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
        MSmd5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
        MSmd5_FF a, b, c, d, x(k + 12), S11, &H6B901122
        MSmd5_FF d, a, b, c, x(k + 13), S12, &HFD987193
        MSmd5_FF c, d, a, b, x(k + 14), S13, &HA679438E
        MSmd5_FF b, c, d, a, x(k + 15), S14, &H49B40821
    
        MSmd5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
        MSmd5_GG d, a, b, c, x(k + 6), S22, &HC040B340
        MSmd5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
        MSmd5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
        MSmd5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
        MSmd5_GG d, a, b, c, x(k + 10), S22, &H2441453
        MSmd5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
        MSmd5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
        MSmd5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
        MSmd5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
        MSmd5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
        MSmd5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
        MSmd5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
        MSmd5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
        MSmd5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
        MSmd5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
            
        MSmd5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
        MSmd5_HH d, a, b, c, x(k + 8), S32, &H8771F681
        MSmd5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
        MSmd5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
        MSmd5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
        MSmd5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
        MSmd5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
        MSmd5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
        MSmd5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
        MSmd5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
        MSmd5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
        MSmd5_HH b, c, d, a, x(k + 6), S34, &H4881D05
        MSmd5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
        MSmd5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
        MSmd5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
        MSmd5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
    
        MSmd5_II a, b, c, d, x(k + 0), S41, &HF4292244
        MSmd5_II d, a, b, c, x(k + 7), S42, &H432AFF97
        MSmd5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
        MSmd5_II b, c, d, a, x(k + 5), S44, &HFC93A039
        MSmd5_II a, b, c, d, x(k + 12), S41, &H655B59C3
        MSmd5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
        MSmd5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
        MSmd5_II b, c, d, a, x(k + 1), S44, &H85845DD1
        MSmd5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
        MSmd5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
        MSmd5_II c, d, a, b, x(k + 6), S43, &HA3014314
        MSmd5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
        MSmd5_II a, b, c, d, x(k + 4), S41, &HF7537E82
        MSmd5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
        MSmd5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
        MSmd5_II b, c, d, a, x(k + 9), S44, &HEB86D391
    
        a = MSAddUnsigned(a, AA)
        b = MSAddUnsigned(b, BB)
        c = MSAddUnsigned(c, CC)
        d = MSAddUnsigned(d, DD)
    Next
    If iLength = 16 Then
        MSMD5 = LCase(MSWordToHex(b) & MSWordToHex(c))  '16Byte
    Else
        MSMD5 = LCase(MSWordToHex(a) & MSWordToHex(b) & MSWordToHex(c) & MSWordToHex(d))  '32Byte
    End If
End Function
%>

