﻿<%
'****************************** 
'函数：ValueToDataDll
'参数：无
'作者：melyy 
'日期：2008/5/16 
'描述：传递值
'web:http://www.melyysoft.com 
'****************************** 
Sub ValueToDataDll(iConnstr)
	vConnstr=iConnstr
End Sub
Class Cls_CmsSystem
	'/////////////////////////公共函数部分////////////////
	Function GetQuery()
		on error resume next
		Dim query, a, x, temp
		If Request.Form="" then
			query = Request.ServerVariables("QUERY_STRING")
		Else
			query = Request.Form
		End If
		query = Split(query, "&")	
		For Each x In query
			a = Split(x, "=")
			If StrComp(a(0), "page", vbTextCompare) <> 0 and StrComp(a(0), "MaxPerPage", vbTextCompare) <> 0 Then
				temp = temp & a(0) & "=" & a(1) & "&"
			End If
		Next
		temp=FC_Replace(temp,"&&","&")
		GetQuery=temp
	End Function
	'**************************************************
	'函数名：GetSubStr
	'作  用：截字符串，汉字一个算两个字符，英文算一个字符
	'参  数：str   ----原字符串
	'        strlen ----截取长度
	'        bShowPoint ---- 是否显示省略号
	'返回值：截取后的字符串
	'**************************************************
	Function GetSubStr(ByVal Str, ByVal strlen, bShowPoint)
		'CheckSNStatus
		If Str = "" Then
			GetSubStr = ""
			Exit Function
		End If
		Dim L, T, c, I, strTemp
		Str = Replace(Replace(Replace(Replace(Str, "&nbsp;", " "), "&quot;", Chr(34)), "&gt;", ">"), "&lt;", "<")
		L = Len(Str)
		T = 0
		strTemp = Str
		strlen = FC_CLng(strlen)
		For I = 1 To L
			c = Abs(Asc(Mid(Str, I, 1)))
			If c > 255 Then
				T = T + 2
			Else
				T = T + 1
			End If
			If T >= strlen Then
				strTemp = Left(Str, I)
				Exit For
			End If
		Next
		strTemp = Replace(Replace(Replace(Replace(strTemp, " ", "&nbsp;"), Chr(34), "&quot;"), ">", "&gt;"), "<", "&lt;")
		If strTemp <> Str And bShowPoint = True Then
			strTemp = strTemp & "…"
		End If
		GetSubStr = strTemp
	End Function
	'**************************************************
	'函数名：GetStrLen
	'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
	'参  数：str  ----要求长度的字符串
	'返回值：字符串长度
	'**************************************************
	Function GetStrLen(Str)
		'CheckSNStatus
		On Error Resume Next
		Dim WINNT_CHINESE
		WINNT_CHINESE = (Len("中国") = 2)
		If WINNT_CHINESE Then
			Dim L, T, c
			Dim I
			L = Len(Str)
			T = L
			For I = 1 To L
				c = Asc(Mid(Str, I, 1))
				If c < 0 Then c = c + 65536
				If c > 255 Then
					T = T + 1
				End If
			Next
			GetStrLen = T
		Else
			GetStrLen = Len(Str)
		End If
		If Err.Number <> 0 Then Err.Clear
	End Function
	
	'**************************************************
	'函数名：Charlong 2008年9月30日加注释
	'作  用：先截取字符串再计算字符串的长度
	'参  数：str----要求长度的字符串
	'返回值：字符串长度
	'**************************************************
	
	Function Charlong(ByVal Str)
		'CheckSNStatus
		If Str = "" Then
			Charlong = 0
			Exit Function
		End If
		Str = Replace(Replace(Replace(Replace(Str, "&nbsp;", " "), "&quot;", Chr(34)), "&gt;", ">"), "&lt;", "<")
		
		Charlong = GetStrLen(Str)
	End Function
	
	'**************************************************
	'函数名：JoinChar
	'作  用：向地址中加入 ? 或 &
	'参  数：strUrl  ----网址
	'返回值：加了 ? 或 & 的网址
	'**************************************************
	Function JoinChar(ByVal strUrl)
		'CheckSNStatus
		If strUrl = "" Then
			JoinChar = ""
			Exit Function
		End If
		If InStr(strUrl, "?") < Len(strUrl) Then
			If InStr(strUrl, "?") > 1 Then
				If InStr(strUrl, "&") < Len(strUrl) Then
					JoinChar = strUrl & "&"
				Else
					JoinChar = strUrl
				End If
			Else
				JoinChar = strUrl & "?"
			End If
		Else
			JoinChar = strUrl
		End If
	End Function
	
	'**************************************************
	'函数名：IsObjInstalled
	'作  用：检查组件是否已经安装
	'参  数：strClassString ----组件名
	'返回值：True  ----已经安装
	'        False ----没有安装
	'**************************************************
	Function IsObjInstalled(strClassString)
		'CheckSNStatus
		On Error Resume Next
		IsObjInstalled = False
		Err = 0
		Dim xTestObj
		Set xTestObj = CreateObject(strClassString)
		If Err.Number = 0 Then IsObjInstalled = True
		Set xTestObj = Nothing
		Err = 0
	End Function
	'**************************************************
	'函数名：TextToTextIn
	'作  用：将调入内容,转换成文本型数据，可供sql查询
	'参  数：strText ----- 调入的数组
	'        strSplit  ----- 分割字符
	'返回值：处理后的数据
	'**************************************************
	Function TextToTextIn(strText,strSplit)
		Dim i
		For i=0 to ubound(split(strText,strSplit))
			If Trim(split(strText,strSplit)(i))<>"" and isnull(Trim(split(strText,strSplit)(i)))=False then
				If i=0 then
					TextToTextIn="'"&Trim(split(strText,strSplit)(i))&"'"
				Else
					TextToTextIn=TextToTextIn &",'"&Trim(split(strText,strSplit)(i))&"'"
				End If
			End If
		Next
	End Function
	'**************************************************
	'函数名：FoundInArr
	'作  用：检测数组中是否有指定的数值
	'参  数：strArr ----- 调入的数组
	'        strItem  ----- 检测的字符
	'        strSplit  ----- 分割字符
	'返回值：True  ----有
	'        False ----没有
	'**************************************************
	Function FoundInArr(strArr, strItem, strSplit)
		'CheckSNStatus
		Dim arrTemp, arrTemp2, I, j
		FoundInArr = False
		If IsNull(strArr) Or IsNull(strItem) Or Trim(strArr) = "" Or Trim(strItem) = "" Then
			Exit Function
		End If
		If IsNull(strSplit) Or strSplit = "" Then
			strSplit = ","
		End If
		If InStr(Trim(strArr), strSplit) > 0 Then
			If InStr(Trim(strItem), strSplit) > 0 Then
				arrTemp = Split(strArr, strSplit)
				arrTemp2 = Split(strItem, strSplit)
				For I = 0 To UBound(arrTemp)
					For j = 0 To UBound(arrTemp2)
						If LCase(Trim(arrTemp2(j))) <> "" And LCase(Trim(arrTemp(I))) <> "" And LCase(Trim(arrTemp2(j))) = LCase(Trim(arrTemp(I))) Then
							FoundInArr = True
							Exit Function
						End If
					Next
				Next
			Else
				arrTemp = Split(strArr, strSplit)
				For I = 0 To UBound(arrTemp)
					If LCase(Trim(arrTemp(I))) = LCase(Trim(strItem)) Then
						FoundInArr = True
						Exit Function
					End If
				Next
			End If
		Else
			If LCase(Trim(strArr)) = LCase(Trim(strItem)) Then
				FoundInArr = True
			End If
		End If
	End Function
	
	
	'**************************************************
	'函数名：GetIDByDefault
	'作  用：获取ID值，如果ID为0，则使用缺省值
	'参  数：ItemID ---- 项目ID值
	'        DefaultID ---- 缺省ID值
	'**************************************************
	Function GetIDByDefault(ItemID, DefaultID)
		'CheckSNStatus
		Dim iItemID
		iItemID = ItemID
		If iItemID = 0 Then iItemID = DefaultID
		If IsNull(iItemID) Then iItemID = 0
		GetIDByDefault = iItemID
	End Function
	
	'**************************************************
	'函数名：FillInArrStr 2008年9月29日
	'作  用：使用一个用逗号分隔的字符串来填充另外一个逗号分隔的字符串，使其达到指定的项目数
	'参  数：strSource ---- 原字符串
	'        strFill ---- 填充字符串
	'        ItemNum ---- 指定填充后的项目数
	'返回值：填充后的字符串
	'**************************************************
	Function FillInArrStr(ByVal strSource, ByVal strFill, ItemNum)
		'CheckSNStatus
		Dim arrSource, arrFill, SourceItemNum, FillItemNum, I
		If IsNull(strSource) Or IsNull(strFill) Then
			FillInArrStr = ""
			Exit Function
		End If
		arrSource = Split(strSource, ",")
		arrFill = Split(strFill, ",")
		SourceItemNum = UBound(arrSource) + 1
		FillItemNum = UBound(arrFill) + 1
		If SourceItemNum < ItemNum And SourceItemNum + FillItemNum >= ItemNum Then
			For I = 0 To ItemNum - SourceItemNum - 1
				strSource = strSource & "," & arrFill(SourceItemNum + FillItemNum - ItemNum + I)
			Next
		End If
		FillInArrStr = strSource
	End Function
	
	
	'**************************************************
	'函数名：GetFirstSeparatorToEnd
	'作  用：截取从第一个分隔符到结尾的字符串
	'参  数：str   ----原字符串
	'        separator ----分隔符
	'返回值：截取后的字符串
	'**************************************************
	Function GetFirstSeparatorToEnd(ByVal Str, separator)
		'CheckSNStatus
		GetFirstSeparatorToEnd = Right(Str, Len(Str) - InStr(Str, separator))
	End Function
	
	'**************************************************
	'函数名：ChkValidDays
	'作  用：有效期的函数
	'参  数：iValidNum ----有效期
	'        iValidUnit ----有效期单位
	'        iBeginTime ---- 开始计算日期
	'返回值：剩余的有效天数
	'**************************************************
	
	Function ChkValidDays(iValidNum, iValidUnit, iBeginTime)
		'CheckSNStatus
		If (iValidNum = "" Or IsNumeric(iValidNum) = False Or iValidUnit = "" Or IsNumeric(iValidUnit) = False Or iBeginTime = "" Or IsDate(iBeginTime) = False) Then
			ChkValidDays = 0
			Exit Function
		End If
		Dim tmpDate, arrInterval
		arrInterval = Array("h", "D", "m", "yyyy")
		If iValidNum = -1 Then
			ChkValidDays = 99999
		Else
			tmpDate = DateAdd(arrInterval(iValidUnit), iValidNum, iBeginTime)
			ChkValidDays = DateDiff("D", Date, tmpDate)
		End If
	End Function
	
	'**************************************************
	'函数名：GetNumString 2008年9月29日
	'作  用：获得项目随即数
	'返回值：随机无重复的数字(用于上传,生成)
	'**************************************************
	Function GetNumString()
		'CheckSNStatus
		Dim v_ymd, v_hms, v_mmm
		v_ymd = Year(Now) & Right("0" & Month(Now), 2) & Right("0" & Day(Now), 2)
		v_hms = Right("0" & Hour(Now), 2) & Right("0" & Minute(Now), 2) & Right("0" & Second(Now), 2)
		Randomize
		v_mmm = Right("0" & CStr(CLng(99 * Rnd) + 1), 2)
		GetNumString = v_ymd & v_hms & v_mmm
	End Function
	'**************************************************
	'函数名：FC_Compare
	'作  用：对比函数
	'**************************************************
	Function FC_Compare(ValueA,ValueB,TrueValue,FalseValue)
		If ValueA=ValueB then
			FC_Compare = TrueValue
		Else
			FC_Compare = FalseValue
		End If
	End Function
	'**************************************************
	'函数名：FC_Replace
	'作  用：容错替换
	'参  数：expression ---- 主数据
	'        find ---- 被替换的字符
	'        replacewith ---- 替换后的字符
	'返回值：容错后的替换字符串,如果 replacewith 空字符,被替换的字符 替换成空
	'**************************************************
	Function FC_Replace(ByVal expression, ByVal find, ByVal replacewith)
		'CheckSNStatus
		If IsNull(expression) Or IsNull(find) Then
			FC_Replace = expression
		ElseIf IsNull(replacewith) Then
			FC_Replace = Replace(expression, find, "")
		Else
			FC_Replace = Replace(expression, find, replacewith)
		End If
	End Function
	'**************************************************
	'函数名：FC_Replace
	'作  用：容错替换
	'参  数：expression ---- 主数据
	'        find ---- 被替换的字符
	'返回值：容错后的替换字符串,如果 replacewith 空字符,被替换的字符 替换成空
	'**************************************************
	Function FC_ReplaceA2b(ByVal expression, ByVal find, ByVal replacewith)
		FC_ReplaceA2b = FC_Replace(expression, find, replacewith)
	End Function
	
	'**************************************************
	'函数名：GetFileExt  2010年9月29日加的注释
	'作  用：获得后缀
	'参  数：FileName ----文件地址
	'**************************************************
	function GetFileExt(fileName)
		dim pos
		pos=instrrev(filename,".")
		if pos>0 then 
			GetFileExt=mid(fileName,pos+1)
		else
			GetFileExt=""
		end if
	end function
	
	'**************************************************
	'函数名：CheckFolderExist  2008年9月29日加的注释
	'作  用：检查文件夹是否存在
	'参  数：FolderName ---- 字符，文件夹的名字
	'返回值：True-----文件夹存在
	'        False----文件夹不存在
	'**************************************************
	Function CheckFolderExist(FolderName)
		'CheckSNStatus
		Dim MsFso
		Set MsFso = Server.CreateObject("Scripting.FileSystemObject")
		If MsFso.FileExists(Server.MapPath(FolderName)) Then
			CheckFolderExist = True
		Else
			CheckFolderExist = False
		End If
		Set MsFso = Nothing
	End Function
	
	
	'**************************************************
	'函数名：FC_CLng
	'作  用：将字符转为整型数值
	'参  数：str1 ---- 字符
	'返回值：如果传入的参数不是数值，返回0，其他情况返回对应的数值
	'**************************************************
	Function FC_CLng(ByVal str1)
		'CheckSNStatus
		If IsNumeric(str1) Then
			FC_CLng = Fix(CDbl(str1))
		Else
			FC_CLng = 0
		End If
	End Function
	
	'**************************************************
	'函数名：FC_CLng1  可以用FC_CLng1代替 2008年9月29日
	'作  用：将字符转为整型数值
	'参  数：str1 ---- 字符
	'返回值：如果传入的参数不是数值，返回1，其他情况返回对应的数值
	'**************************************************
	Function FC_CLng1(ByVal str1)
		'CheckSNStatus
		If IsNumeric(str1) Then
			FC_CLng1 = CLng(str1)
			If FC_CLng1 <= 0 Then FC_CLng1 = 1
		Else
			FC_CLng1 = 1
		End If
	End Function
	'**************************************************
	'函数名：FC_Money
	'作  用：将字符转为Money数值
	'参  数：str1 ---- 字符
	'返回值：如果传入的参数不是数值，返回0，其他情况返回对应的数值
	'**************************************************
	Function FC_Money(ByVal str1)
		'CheckSNStatus
		If IsNumeric(str1) Then
			FC_Money = str1
		Else
			FC_Money = 0
		End If
	End Function
	
	'**************************************************
	'函数名：GetSCRIPTDir  2008年9月29日加的注释
	'作  用：获取脚本的路径
	'参  数：
	'返回值：返回脚本的路径
	'**************************************************
	
	Function GetSCRIPTDir()
		'CheckSNStatus
		GetSCRIPTDir = Split(Trim(Request.ServerVariables("SCRIPT_NAME")), "/")(UBound(Split(Trim(Request.ServerVariables("SCRIPT_NAME")), "/")) - 1)
	End Function
	'**************************************************
	'函数名：GetTrueUrl  2008年9月29日加的注释
	'作  用：获取当前真实的网址
	'参  数：
	'返回值：返回当前真实的网址
	'**************************************************
	Function GetTrueUrl(ShowHttp,ShowPort)
		Dim PortNum
		GetTrueUrl=Request.ServerVariables("SERVER_NAME")
		If Request.ServerVariables("SERVER_PORT")<>80 and ShowPort=True then
			GetTrueUrl = GetTrueUrl &":"&Request.ServerVariables("SERVER_PORT")
		End If
		If ShowHttp then
			GetTrueUrl="http://"&GetTrueUrl
		End If	
	End Function
	'******************************
	'函数：GetGenerator
	'参数：Length,任意长度的数值，随机码位数
	'作者：melyy
	'日期：2008/5/16
	'描述：生成任意英文+数字位数+特殊字符长度的随机码函数
	'author:melyy：增强了此函数的功能，将其定为itype类型2008年9月29日
	'web:http://www.melyysoft.com
	'******************************
	Function GetGenerator(iType, Length)
	 'CheckSNStatus
	 Dim I, tempS
	 If iType = 0 Then
		 tempS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890#@%_$"
	 ElseIf iType = 1 Then
		 tempS = "1234567890"
	 ElseIf iType = 2 Then
		 tempS = "abcdefghijklmnopqrstuvwxyz"
	 ElseIf iType = 3 Then
		 tempS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"
	 ElseIf iType = 4 Then
		 tempS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"
	 Else
		 tempS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890#@%_$"
	 End If
	 GetGenerator = ""
	 If IsNumeric(Length) = False Then
	  Exit Function
	 End If
	 For I = 1 To Length
	  Randomize
	  GetGenerator = GetGenerator & Mid(tempS, Int((Len(tempS) * Rnd) + 1), 1)
	 Next
	End Function
	
	'******************************
	'函数：ReNameFile(FolderPath,OldFile,NewFile)
	'参数：FolderPath-文件夹路径，OldFile-文件名，NewFile-新文件名
	'作者：www.melyysoft.com
	'日期：2008/5/16
	'Author:melyy
	'描述：更改指定文件夹下文件名,当更改数据库名称时，必须先断开数据库连接!
	'******************************
	Function ReNameFile(FolderPath, OldFile, NewFile)
		'CheckSNStatus
		Dim MsFso
		Set MsFso = Server.CreateObject("scripting.filesystemobject")
		If MsFso.FileExists(Server.MapPath(FolderPath) & "\" & OldFile) And MsFso.FileExists(Server.MapPath(FolderPath) & "\" & NewFile) = False Then
			MsFso.GetFile(Server.MapPath(FolderPath) & "\" & OldFile).Name = NewFile
			If err then
				Response.write err.description
				response.end
			end if
			ReNameFile = True
		ElseIf MsFso.FileExists(Server.MapPath(FolderPath) & "\" & NewFile) Then
			ReNameFile = False
			Exit Function
		Else
			ReNameFile = False
			Exit Function
		End If
		Set MsFso = Nothing
	End Function
	'******************************
	'函数：RenameFolder(FolderPath,OldFolder,NewFolder)
	'参数：FolderPath-文件夹路径，OldFolder-文件夹名，NewFolder-新文件夹名
	'作者：www.melyysoft.com
	'日期：2008/5/16
	'描述：更改指定文件夹下文件夹名
	'******************************
	Function RenameFolder(FolderPath, OldFolder, NewFolder)
		'CheckSNStatus
		Dim MsFso
		On Error Resume Next
		Set MsFso = Server.CreateObject("scripting.filesystemobject")
		If MsFso.FolderExists(Server.MapPath(FolderPath) & "\" & OldFolder) And MsFso.FolderExists(Server.MapPath(FolderPath) & "\" & NewFolder) = False Then
			MsFso.GetFolder(Server.MapPath(FolderPath) & "\" & OldFolder).Name = NewFolder
			RenameFolder = True
		ElseIf MsFso.FolderExists(OldFolder) Then
			RenameFolder = False
			Exit Function
		Else
			RenameFolder = False
			Exit Function
		End If
		Set MsFso = Nothing
	End Function
	
	Function CreateDir(strLocalPath)
		'CheckSNStatus
		Dim strPath, objFolder, arrPathList, I, intLevel, tmpPath, tmptpath
		strPath = Replace(strLocalPath, "\", "/")
		Set objFolder = Server.CreateObject("Scripting.FileSystemObject")
		arrPathList = Split(strPath, "/")
		intLevel = UBound(arrPathList) - 1
		For I = 1 To intLevel
		 If I = 1 Then
		  tmptpath = "/" & arrPathList(1) & "/"
		 Else
		  tmptpath = tmptpath & arrPathList(I) & "/"
		 End If
		 tmpPath = Left(tmptpath, Len(tmptpath) - 1)
		 If Not objFolder.FolderExists(Server.MapPath(tmpPath)) Then objFolder.CreateFolder Server.MapPath(tmpPath)
		Next
		Set objFolder = Nothing
	End Function
	
	'/////////////////////管理部分///////////////////////////
	'**************************************************
	'函数名：GetNumber_Option
	'作  用：显示数字下拉菜单
	'参  数：MinNum ---- 初始数
	'        MaxNum ---- 最大数
	'        CurrentNum ----selected 默认数
	'返回值：下拉菜单数据
	'**************************************************
	Public Function GetNumber_Option(MinNum, MaxNum, CurrentNum)
		'CheckSNStatus
		Dim strNumber, I
		For I = MinNum To MaxNum
			If I = CurrentNum Then
				strNumber = strNumber & "<option value='" & I & "' selected>&nbsp;&nbsp;" & I & "&nbsp;&nbsp;</option>"
			Else
				strNumber = strNumber & "<option value='" & I & "'>&nbsp;&nbsp;" & I & "&nbsp;&nbsp;</option>"
			End If
		Next
		GetNumber_Option = strNumber
	End Function
	
	'**************************************************
	'函数名：IsStyleDisplay
	'作  用：是否显示层
	'参  数：Compare1-----比较值1
	'参  数：Compare2-----比较值2
	'返回值：替换后字符串
	'**************************************************
	Public Function IsStyleDisplay(ByVal Compare1, ByVal Compare2)
		'CheckSNStatus
		If Compare1 = Compare2 Then
			IsStyleDisplay = " style='display:'"
		Else
			IsStyleDisplay = " style='display:none'"
		End If
	End Function
	
	'**************************************************
	'函数名：RadioValue
	'作  用：显示单选框或者多选框的值并判断是否选中
	'参  数：compvalue ---- 选项的目前实际值
	'        showvalue ---- 选项的显示值
	'**************************************************
	Public Function RadioValue(compvalue, showvalue)
		'CheckSNStatus
		If compvalue = showvalue Then
			RadioValue = "value='" & showvalue & "' checked"
		Else
			RadioValue = "value='" & showvalue & "'"
		End If
	End Function
	
	'**************************************************
	'函数名：OptionValue
	'作  用：显示下拉列表的值并判断是否选中
	'参  数：compvalue ---- 选项的目前实际值
	'        showvalue ---- 选项的显示值
	'**************************************************
	Public Function OptionValue(compvalue, showvalue)
		'CheckSNStatus
		If compvalue = showvalue Then
			OptionValue = "value='" & showvalue & "' selected"
		Else
			OptionValue = "value='" & showvalue & "'"
		End If
	End Function
	
	'**************************************************
	'函数名：GetArrItem
	'作  用：得到数组中某个元素的值
	'参  数：arrTemp ---- 要取的数组
	'        ItemIndex ---- 第几位数
	'返回值：所属位数的元素
	'**************************************************
	Public Function GetArrItem(ByVal arrTemp, ByVal ItemIndex)
		'CheckSNStatus
		If Not IsArray(arrTemp) Then
			GetArrItem = ""
			Exit Function
		End If
		ItemIndex = FC_CLng(ItemIndex)
		If ItemIndex < 0 Or ItemIndex > UBound(arrTemp) Then
			GetArrItem = ""
			Exit Function
		End If
		Dim strTemp
		strTemp = arrTemp(ItemIndex)
		If InStr(strTemp, "|") > 0 Then
			GetArrItem = Left(strTemp, InStr(strTemp, "|") - 1)
		Else
			GetArrItem = strTemp
		End If
	End Function
	
	'**************************************************
	'函数名：Array2Option
	'作  用：把数组变成下拉列表项目
	'参  数：arrTemp ---- 数组
	'        ItemIndex ---- 数组中默认的数字
	'返回值：下拉菜单
	'**************************************************
	Public Function Array2Option(ByVal arrTemp, ByVal ID)
		'CheckSNStatus
		Dim strOption, I, arrValue
		strOption = "<option value='-1'> </option>"
		ID = FC_CLng(ID)
		For I = 0 To UBound(arrTemp)
			arrValue = Split(arrTemp(I), "|")
			If CLng(arrValue(1)) = 1 Then
				If ID > -1 Then
					If I = ID Then
						strOption = strOption & "<option value='" & I & "' selected>" & arrValue(0) & "</option>"
					Else
						strOption = strOption & "<option value='" & I & "'>" & arrValue(0) & "</option>"
					End If
				Else
					If CLng(arrValue(2)) = 1 Then
						strOption = strOption & "<option value='" & I & "' selected>" & arrValue(0) & "</option>"
					Else
						strOption = strOption & "<option value='" & I & "'>" & arrValue(0) & "</option>"
					End If
				End If
			End If
		Next
		Array2Option = strOption
	End Function
	'**************************************************
	'函数名：CheckPurview_Other
	'作  用：其他权限数组检测
	'参  数：AllPurviews ---- 要比较数组
	'        strPurview ---- 比较字符
	'返回值：True  ---- 存在
	'**************************************************
	Function CheckPurview_Other(AllPurviews, strPurview)
		If IsNull(AllPurviews) Or AllPurviews = "" Or strPurview = "" Then
			CheckPurview_Other = False
			Exit Function
		End If
		CheckPurview_Other = False
		If InStr(AllPurviews, ",") > 0 Then
			Dim arrPurviews, I
			arrPurviews = Split(AllPurviews, ",")
			For I = 0 To UBound(arrPurviews)
				If Trim(arrPurviews(I)) = Trim(strPurview) Then
					CheckPurview_Other = True
					Exit For
				End If
			Next
		Else
			If Trim(AllPurviews) = Trim(strPurview) Then
				CheckPurview_Other = True
			End If
		End If
	End Function
	
	'**************************************************
	'函数名：CheckPurview_Class
	'作  用：栏目权限数组检测
	'参  数：str1 ---- 要比较数组1
	'        str2 ---- 要比较数组2
	'返回值：True  ---- 存在
	'**************************************************
	Function CheckPurview_Class(str1, str2)
		Dim arrTemp, arrTemp2, I, j
		CheckPurview_Class = False
		If IsNull(str1) Or IsNull(str2) Or str1 = "" Or str2 = "" Then
			Exit Function
		End If
		arrTemp = Split(str1 & ",", ",")
		arrTemp2 = Split(str2 & ",", ",")
		For I = 0 To UBound(arrTemp)
			For j = 0 To UBound(arrTemp2)
				If Trim(arrTemp2(j)) <> "" And Trim(arrTemp(I)) <> "" And Trim(arrTemp2(j)) = Trim(arrTemp(I)) Then
					CheckPurview_Class = True
					Exit Function
				End If
			Next
		Next
	End Function
	
	'**************************************************
	'函数名：CheckPurview_Channel
	'作  用：频道允许用户组检测
	'参  数：ChannelPurview ---- 频道的权限　0为开放频道（任何人可以浏览），1为认证频道（游客不能浏览）
	'        ChannelArrGroupID ---- 允许访问的用户组
	'        GroupID ---- 用户所属的用户组
	'返回值：True  ---- 有权限访问
	'**************************************************
	Function CheckPurview_Channel(ChannelPurview, ChannelArrGroupID, UserLogined, GroupID)
		ChannelPurview = FC_CLng(ChannelPurview)
		CheckPurview_Channel = False
		If ChannelPurview = 0 Then
			CheckPurview_Channel = True
		Else
			If UserLogined = True Then
				If FoundInArr(ChannelArrGroupID, GroupID, ",") = True Then
					CheckPurview_Channel = True
				End If
			End If
		End If
	End Function
	
	'**************************************************
	'函数名：ShowPage
	'作  用：显示“上一页 下一页”等信息
	'参  数：sFileName  ----链接地址
	'        TotalNumber ----总数量
	'        MaxPerPage  ----每页数量
	'        CurrentPage ----当前页
	'        ShowTotal   ----是否显示总数量
	'        ShowAllPages ---是否用下拉列表显示所有页面以供跳转。
	'        strUnit     ----计数单位
	'        ShowMaxPerPage  ----是否显示每页信息量选项框
	'返回值：“上一页 下一页”等信息的HTML代码
	'**************************************************
	Function ShowPage(PageLanguageValue, sFileName, totalnumber, MaxPerPage, CurrentPage, ShowTotal, ShowAllPages, strUnit, ShowMaxPerPage)
		Dim TotalPage, strTemp, strUrl, I
		PageLanguageValue = PageLanguageValue & ",,,,,,,"
		If totalnumber = 0 Or MaxPerPage = 0 Or IsNull(MaxPerPage) Then
			ShowPage = ""
			Exit Function
		End If
		If totalnumber Mod MaxPerPage = 0 Then
			TotalPage = totalnumber \ MaxPerPage
		Else
			TotalPage = totalnumber \ MaxPerPage + 1
		End If
		If CurrentPage > TotalPage Then CurrentPage = TotalPage
			
		strTemp = "<div class=""show_page"">"
		If ShowTotal = True Then
			strTemp = strTemp & Split(PageLanguageValue, ",")(0) & " <b>" & totalnumber & "</b> " & strUnit & "&nbsp;&nbsp;"
		End If
		If ShowMaxPerPage = True Then
			strUrl = JoinChar(sFileName) & "MaxPerPage=" & MaxPerPage & "&"
		Else
			strUrl = JoinChar(sFileName)
		End If
		If CurrentPage = 1 Then
			strTemp = strTemp & Split(PageLanguageValue, ",")(1) & " " & Split(PageLanguageValue, ",")(2) & "&nbsp;"
		Else
			strTemp = strTemp & "<a href='" & strUrl & "page=1'> " & Split(PageLanguageValue, ",")(1) & " </a>&nbsp;"
			strTemp = strTemp & "<a href='" & strUrl & "page=" & (CurrentPage - 1) & "'>" & Split(PageLanguageValue, ",")(2) & "</a>&nbsp;"
		End If
		If CurrentPage >= TotalPage Then
			strTemp = strTemp & Split(PageLanguageValue, ",")(3) & "&nbsp;" & Split(PageLanguageValue, ",")(4)
		Else
			strTemp = strTemp & "<a href='" & strUrl & "page=" & (CurrentPage + 1) & "'>" & Split(PageLanguageValue, ",")(3) & "</a>&nbsp;"
			strTemp = strTemp & "<a href='" & strUrl & "page=" & TotalPage & "'>" & Split(PageLanguageValue, ",")(4) & "</a>"
		End If
		strTemp = strTemp & "&nbsp;<strong><font color=red>" & CurrentPage & "</font>/" & TotalPage & "</strong>&nbsp;" & Split(PageLanguageValue, ",")(7)
		If ShowMaxPerPage = True Then
			strTemp = strTemp & "&nbsp;<Input type='text' name='MaxPerPage' size='3' maxlength='4' value='" & MaxPerPage & "' onKeyPress=""if (event.keyCode==13) window.location='" & JoinChar(sFileName) & "page=" & CurrentPage & "&MaxPerPage=" & "'+this.value;"">" & strUnit & "/" & Split(PageLanguageValue, ",")(7)
		Else
			strTemp = strTemp & "&nbsp;<b>" & MaxPerPage & "</b>" & strUnit & "/" & Split(PageLanguageValue, ",")(7)
		End If
		If ShowAllPages = True Then
			If TotalPage > 20 Then
				strTemp = strTemp & "&nbsp;&nbsp;" & Split(PageLanguageValue, ",")(5) & Split(PageLanguageValue, ",")(6) & "<Input type='text' name='page' size='3' maxlength='5' value='" & CurrentPage & "' onKeyPress=""if (event.keyCode==13) window.location='" & strUrl & "page=" & "'+this.value;"">" & Split(PageLanguageValue, ",")(7)
			Else
				strTemp = strTemp & "&nbsp;" & Split(PageLanguageValue, ",")(5) & "：<select name='page' size='1' onchange=""javascript:window.location='" & strUrl & "page=" & "'+this.options[this.selectedIndex].value;"">"
				For I = 1 To TotalPage
				   strTemp = strTemp & "<option value='" & I & "'"
				   If FC_CLng(CurrentPage) = FC_CLng(I) Then strTemp = strTemp & " selected "
				   strTemp = strTemp & ">" & Split(PageLanguageValue, ",")(6) & I & Split(PageLanguageValue, ",")(7) & "</option>"
				Next
				strTemp = strTemp & "</select>"
			End If
		End If
		strTemp = strTemp & "</div>"
		strTemp = FC_Replace(strTemp,"&&","&")
		ShowPage = strTemp
	End Function
	
	'/////////////////////升级部分////////////////////
	
	'**************************************************
	'函数名：FSOSaveFile
	'作  用：保存文件
	'参  数：Content-需填写的内容
	'返回值：无
	'**************************************************
	Function FSOSaveFile(filename, Content)
		  'CheckSNStatus
		  On Error Resume Next
			Dim fso, FileObj
			Set fso = Server.CreateObject("Scripting.FileSystemObject")
			Set FileObj = fso.CreateTextFile(Server.MapPath(filename), True)
			FileObj.Write Content
			FileObj.Close
			Set FileObj = Nothing
			Set fso = Nothing
	End Function
	
	'**************************************************
	'函数名：sBytesToBstr
	'作  用：
	'参  数：
	'返回值：
	'**************************************************
	Function sBytesToBstr(vIn)
		'CheckSNStatus
		Dim Objstream
		Set Objstream = Server.CreateObject("adodb.stream")
		Objstream.Type = 1
		Objstream.Mode = 3
		Objstream.Open
		Objstream.Write vIn
		Objstream.Position = 0
		Objstream.Type = 2
		Objstream.Charset = "UTF-8"
		sBytesToBstr = Objstream.ReadText
		Objstream.Close
		Set Objstream = Nothing
	End Function
	
	'**************************************************
	'函数名：toNum
	'作  用：编码转换 2进制 => 字符串
	'参  数：strFileName ---- 文件名
	'        strContent ---- 内容
	'返回值：需写入的内容(隐藏),True
	'**************************************************
	Function sDoCreateFile(strFileName, ByRef strContent)
		'CheckSNStatus
		sDoCreateFile = False
		Dim strPath
		strPath = Left(strFileName, InStrRev(strFileName, "\", -1, 1))
		Rem ## 检测路径及文件名有效性
		If Not (CreateDir(strPath)) Then Exit Function
		Const ForReading = 1, ForWriting = 2, ForAppending = 8
		Dim fso, f
		Set fso = CreateObject("Scripting.FileSystemObject")
		Set f = fso.OpenTextFile(strFileName, ForWriting, True)
		f.Write strContent
		f.Close
		Set fso = Nothing
		Set f = Nothing
		sDoCreateFile = True
	End Function
	
	'**************************************************
	'函数名：toNum
	'作  用：将带.的字符转换为数值
	'参  数：s ---- 需转换字符串
	'        default ---- 出错时默认值
	'返回值：自定义或者替换后数据
	'**************************************************
	Function toNum(s, default)
		'CheckSNStatus
		s = Replace(s, ".", "")
		If IsNumeric(s) And s <> "" Then
		 toNum = CLng(s)
		Else
		 toNum = default
		End If
	End Function
	
	'其他公共函数部分
	'**************************************************
	'函数名：FC_CBool
	'作  用：将字符转为布尔弄变量
	'参  数：strBool---- 字符
	'返回值：True/False
	'**************************************************
	Function FC_CBool(strBool)
		If strBool = True Or LCase(Trim(strBool)) = "true" Or LCase(Trim(strBool)) = "yes" Or Trim(strBool) = "1" Then
			FC_CBool = True
		Else
			FC_CBool = False
		End If
	End Function
	
	'**************************************************
	'函数名：FC_CDbl
	'作  用：将字符转为双精度数值
	'参  数：str1 ---- 字符
	'返回值：如果传入的参数不是数值，返回0，其他情况返回对应的数值
	'**************************************************
	Function FC_CDbl(ByVal str1)
		If IsNumeric(str1) Then
			FC_CDbl = CDbl(str1)
		Else
			FC_CDbl = 0
		End If
	End Function
	
	'**************************************************
	'函数名：FC_CDate
	'作  用：将字符转为日期
	'参  数：str1 ---- 字符
	'返回值：如果参数不是日期型字符，则返回当前时间，否则返回对应的日期型数据
	'**************************************************
	Function FC_CDate(ByVal str1)
		If IsDate(str1) Then
			FC_CDate = CDate(str1)
		Else
			FC_CDate = Now
		End If
	End Function
	'**************************************************
	'函数名：IsValidUrl
	'作  用：检查网站地址合法性
	'参  数：tmpString ----要检查的tmpString地址
	'返回值：True  ----地址合法
	'        False ----地址不合法
	'**************************************************
	Function IsValidUrl(tmpStr)
		Dim c, I, tmpurl
		IsValidUrl = True
		tmpurl = LCase(Trim(tmpStr))
		If Left(tmpurl, 7) <> "http://" Then tmpurl = "http://" & tmpurl
		For I = 8 To Len(IsValidUrl)
			c = LCase(Mid(tmpurl, I, 1))
			If InStr("abcdefghijklmnopqrstuvwxyz_-./\", c) <= 0 And Not IsNumeric(c) Then
				  IsValidUrl = False
				  Exit Function
			End If
		Next
		If Left(tmpurl, 1) = "." Or Right(tmpurl, 1) = "." Then
			IsValidUrl = False
			Exit Function
		End If
		If InStr(tmpurl, ".") <= 0 Then
			IsValidUrl = False
			Exit Function
		End If
		If InStr(tmpurl, "..") > 0 Then
			IsValidUrl = False
		End If
	End Function
	'**************************************************
	'函数名：IsValidMobile
	'作  用：检查Mobile地址合法性
	'参  数：Mobile ----要检查的Mobile地址
	'返回值：True  ----Mobile地址合法
	'        False ----Mobile地址不合法
	'**************************************************
	Function IsValidMobile(Mobile, MobileStr, MobileLen)
		Dim I, c
		IsValidMobile = True
		If Len(Mobile) = MobileLen Then
			For I = 1 To Len(Mobile)
				c = LCase(Mid(Mobile, I, 1))
				If InStr(MobileStr, c) <= 0 Then
					IsValidMobile = False
					Exit Function
				End If
			Next
		Else
			IsValidMobile = False
		End If
	End Function
	'**************************************************
	'函数名：CheckMobiles
	'作  用：检查手机号码
	'参  数：
	'返回值：True
	'**************************************************
	Function CheckMobiles(Mobiles, MobileStr, MobileLen)
		Dim I
		CheckMobiles = True
		If IsNull(CheckMobiles) Then
			CheckMobiles = False
		Else
			If InStr(Mobiles, ",") <= 0 Then
				CheckMobiles = IsValidMobile(Mobiles, MobileStr, MobileLen)
			Else
				For I = 0 To I = UBound(Split(Mobiles, ","))
					CheckMobiles = IsValidMobile(Split(Mobiles, ",")(I), MobileStr, MobileLen)
					If CheckMobiles = False Then Exit Function
				Next
			End If
		End If
	End Function
	'**************************************************
	'函数名：isChinese
	'作  用：检查传过来的字符串是否是汉字
	'参  数：strInput ---字符串
	'返回值：True  ---- 合法的字符
	'**************************************************
	Public Function isChinese(strInput)
		Dim pGb, qGb
		Set pGb = New RegExp
		pGb.Global = True
		pGb.IgnoreCase = True
		pGb.MultiLine = True
		pGb.Pattern = "[\u4E00-\u9FA5]"
		qGb = pGb.Replace(strInput, "**")
		Set pGb = Nothing
		If Len(qGb) <> Len(strInput) * 2 Then
			isChinese = False
		Else
			isChinese = True
		End If
	End Function
	'**************************************************
	'函数名：isInstrChinese
	'作  用：检查字符是否含有汉字
	'参  数：str ----要检查的字符
	'返回值：True  ----字符合法
	'        False ----字符不合法
	'**************************************************
	Function isInstrChinese(ByVal Str)
		Dim I, c
		isInstrChinese = False
		For I = 1 To Len(Str)
			c = LCase(Mid(Str, I, 1))
			If isChinese(c) = True Then
				isInstrChinese = True
				Exit Function
			End If
		Next
	End Function
	'**************************************************
	'函数名：IsValidStr
	'作  用：检查字符是否在有效范围内
	'参  数：str ----要检查的字符
	'返回值：True  ----字符合法
	'        False ----字符不合法
	'**************************************************
	Function IsValidStr(ByVal Str, ValidStr)
		Dim I, c
		IsValidStr = True
		For I = 1 To Len(Str)
			c = LCase(Mid(Str, I, 1))
			If InStr(ValidStr, c) <= 0 Then
				IsValidStr = False
				Exit Function
			End If
		Next
	End Function
	'**************************************************
	'函数名：isInstrStr
	'作  用：检查字符是否在范围内
	'参  数：str ----要检查的字符
	'返回值：True  ----字符合法
	'        False ----字符不合法
	'**************************************************
	Function isInstrStr(ByVal Str, ValidStr)
		Dim I, c
		isInstrStr = False
		For I = 1 To Len(Str)
			c = LCase(Mid(Str, I, 1))
			If InStr(ValidStr, c) > 0 Then
				isInstrStr = True
				Exit Function
			End If
		Next
	End Function
	
	'**************************************************
	'函数名：IsValidJsFileName
	'作  用：检查是否是有效的JS文件名
	'参  数：str ----要检查的字符
	'返回值：True  ----文件名合法
	'        False ----文件名不合法
	'**************************************************
	Function IsValidJsFileName(ByVal Str, ByVal ContentType)
		Dim I, c
		For I = 1 To Len(Str)
			c = LCase(Mid(Str, I, 1))
			If InStr("abcdefghijklmnopqrstuvwxyz_1234567890.", c) <= 0 Then
				IsValidJsFileName = False
				Exit Function
			End If
		Next
		If ContentType = 0 Then
			If LCase(Right(Str, 3)) <> ".js" Then
				IsValidJsFileName = False
			Else
				IsValidJsFileName = True
			End If
		Else
			If LCase(Right(Str, 5)) <> ".html" Then
				IsValidJsFileName = False
			Else
				IsValidJsFileName = True
			End If
		End If
	End Function
	
	'**************************************************
	'函数名：ReplaceBadChar
	'作  用：过滤非法的SQL字符
	'参  数：strChar-----要过滤的字符
	'返回值：过滤后的字符
	'**************************************************
	Function ReplaceBadChar(strChar)
		If strChar = "" Or IsNull(strChar) Then
			ReplaceBadChar = ""
			Exit Function
		End If
		Dim strBadChar, arrBadChar, tempChar, I
		strBadChar = "+,',%,^,&,?,(,),<,>,[,],{,},/,\,;,:," & Chr(34) & "," & Chr(0) & ",--"
		arrBadChar = Split(strBadChar, ",")
		tempChar = strChar
		For I = 0 To UBound(arrBadChar)
			tempChar = Replace(tempChar, arrBadChar(I), "")
		Next
		tempChar = Replace(tempChar, "@@", "@")
		ReplaceBadChar = tempChar
	End Function
	
	'**************************************************
	'函数名：ReplaceUrlBadChar 此函数可以和ReplaceBadChar函数合并，只要再增加一个类型判断即可 2008年9月29日
	'作  用：过滤Url中非法的SQL字符
	'参  数：strChar-----要过滤的字符
	'返回值：过滤后的字符
	'**************************************************
	Function ReplaceUrlBadChar(strChar)
		If strChar = "" Or IsNull(strChar) Then
			ReplaceUrlBadChar = ""
			Exit Function
		End If
		Dim strBadChar, arrBadChar, tempChar, I
		strBadChar = "+,',(,),<,>,[,],{,},\,;," & Chr(34) & "," & Chr(0) & ",--"
		arrBadChar = Split(strBadChar, ",")
		tempChar = strChar
		For I = 0 To UBound(arrBadChar)
			tempChar = Replace(tempChar, arrBadChar(I), "")
		Next
		tempChar = Replace(tempChar, "@@", "@")
		ReplaceUrlBadChar = tempChar
	End Function
	
	'**************************************************
	'函数名：CheckBadChar
	'作  用：检查是否包含非法的SQL字符
	'参  数：strChar-----要检查的字符
	'返回值：True  ----字符合法
	'        False ----字符不合法
	'**************************************************
	Function CheckBadChar(strChar)
		Dim strBadChar, arrBadChar, I
		strBadChar = "@@,+,',%,^,&,?,(,),<,>,[,],{,},/,\,;,:," & Chr(34) & ",--"
		arrBadChar = Split(strBadChar, ",")
		If strChar = "" Then
			CheckBadChar = False
		Else
			For I = 0 To UBound(arrBadChar)
				If InStr(strChar, arrBadChar(I)) > 0 Then
					CheckBadChar = False
					Exit Function
				End If
			Next
		End If
		CheckBadChar = True
	End Function
	
	'**************************************************
	'函数名：CheckUserBadChar  此函数可以和CheckBadChar合并 2008年9月29日
	'作  用：检查是否包含非法的字符
	'参  数：strChar-----要检查的字符
	'返回值：True  ----字符合法
	'        False ----字符不合法
	'**************************************************
	
	Function CheckUserBadChar(strChar)
		Dim strBadChar, arrBadChar, I
		strBadChar = "',%,^,&,?,(,),<,>,[,],{,},/,\,;,:," & Chr(34) & ",*,|,"",.,#"
		arrBadChar = Split(strBadChar, ",")
		If strChar = "" Then
			CheckUserBadChar = False
		Else
			For I = 0 To UBound(arrBadChar)
				If InStr(strChar, arrBadChar(I)) > 0 Then
					CheckUserBadChar = False
					Exit Function
				End If
			Next
		End If
		CheckUserBadChar = True
		
	End Function
	
	'**************************************************
	'函数名：CheckValidStr
	'作  用：检查数组中有无相同的字符
	'参  数：arrInvalidStr ----要查询的数组
	'        str1 ---- 要比较的字符
	'返回值：True  ----是否存在
	'**************************************************
	Function CheckValidStr(arrInvalidStr, str1)
		Dim arrStr, I
		If InStr(arrInvalidStr, ",") > 0 Then
			arrStr = Split(arrInvalidStr, ",")
			For I = 0 To UBound(arrStr)
				If LCase(Trim(arrStr(I))) = LCase(Trim(str1)) Then
					CheckValidStr = False
					Exit Function
				End If
			Next
		Else
			If LCase(Trim(arrInvalidStr)) = LCase(Trim(str1)) Then
				CheckValidStr = False
				Exit Function
			End If
		End If
		CheckValidStr = True
	End Function
	
	
	'**************************************************
	'函数名：IsValidID
	'作  用：检查传过来的ＩＤ是否是合法ＩＤ或者ＩＤ串
	'参  数：Check_ID ---- ID 字符串
	'返回值：True  ---- 合法ID
	'**************************************************
	Function IsValidID(Check_ID)
		Dim FixID, I
		If IsNull(Check_ID) Or Check_ID = "" Then
			IsValidID = False
			Exit Function
		End If
		FixID = Replace(Check_ID, "|", "")
		FixID = Replace(FixID, ",", "")
		FixID = Replace(FixID, "-", "")
		FixID = Trim(Replace(FixID, " ", ""))
		If FixID = "" Or IsNull(FixID) Then
			IsValidID = False
		Else
			For I = 1 To Len(FixID) Step 100
				If Not IsNumeric(Mid(FixID, I, 100)) Then
					IsValidID = False
					Exit Function
				End If
			Next
			IsValidID = True
		End If
	End Function
	
	'**************************************************
	'函数名：FC_ConvertBR
	'作  用：将文本区域内的<BR>替换换行
	'参  数：fString ---- 要处理的字符串
	'返回值：处理后的字符串
	'**************************************************
	Function FC_ConvertBR(ByVal fString)
		If IsNull(fString) Or Trim(fString) = "" Then
			FC_ConvertBR = ""
			Exit Function
		End If
		fString = Replace(fString, "</P><P>", Chr(10) & Chr(10))
		fString = Replace(fString, "<BR>", Chr(10))
		fString = Replace(fString, "<br>", Chr(10))
		FC_ConvertBR = fString
	End Function
	
	'**************************************************
	'函数名：FC_HTMLEncode
	'作  用：将html 标记替换成 能在IE显示的HTML
	'参  数：fString ---- 要处理的字符串
	'返回值：处理后的字符串
	'**************************************************
	Function FC_HTMLEncode(ByVal fString)
		If IsNull(fString) Or Trim(fString) = "" Then
			FC_HTMLEncode = ""
			Exit Function
		End If
		fString = Replace(fString, ">", "&gt;")
		fString = Replace(fString, "<", "&lt;")
	
		fString = Replace(fString, Chr(32), "&nbsp;")
		fString = Replace(fString, Chr(9), "&nbsp;")
		fString = Replace(fString, Chr(34), "&quot;")
		fString = Replace(fString, Chr(39), "&#39;")
		fString = Replace(fString, Chr(13), "")
		fString = Replace(fString, Chr(10) & Chr(10), "</P><P>")
		fString = Replace(fString, Chr(10), "<BR>")
	
		FC_HTMLEncode = fString
	End Function
	'**************************************************
	'函数名：FC_HtmlDecode
	'作  用：还原Html标记,配合FC_HTMLEncode 使用
	'参  数：fString ---- 要处理的字符串
	'返回值：处理后的字符串
	'**************************************************
	Function FC_HtmlDecode(ByVal fString)
		If IsNull(fString) Or Trim(fString) = "" Then
			FC_HtmlDecode = ""
			Exit Function
		End If
		fString = Replace(fString, "&gt;", ">")
		fString = Replace(fString, "&lt;", "<")
	
		fString = Replace(fString, "&nbsp;", " ")
		fString = Replace(fString, "&quot;", Chr(34))
		fString = Replace(fString, "&#39;", Chr(39))
		fString = Replace(fString, "</P><P> ", Chr(10) & Chr(10))
		fString = Replace(fString, "<BR> ", Chr(10))
	
		FC_HtmlDecode = fString
	End Function
	
	
	'**************************************************
	'函数名：Fc_Unicode
	'作  用：转换为 UTF8 编码
	'参  数：str ---- 要转换的字符
	'返回值：转换后的字符
	'**************************************************
	Function FC_Unicode(ByVal Str)
		Dim I, j, c, i1, i2, u, fs, f, p
		FC_Unicode = ""
		p = ""
		For I = 1 To Len(Str)
			c = Mid(Str, I, 1)
			j = AscW(c)
			If j < 0 Then
				j = j + 65536
			End If
			If j >= 0 And j <= 128 Then
				If p = "c" Then
					FC_Unicode = " " & FC_Unicode
					p = "e"
				End If
				FC_Unicode = FC_Unicode & c
			Else
				If p = "e" Then
					FC_Unicode = FC_Unicode & " "
					p = "c"
				End If
				FC_Unicode = FC_Unicode & ("&#" & j & ";")
			End If
		Next
	End Function
	
	'**************************************************
	'函数名：FC_ToAsc
	'作  用：转换为 Asc 编码
	'参  数：str ---- 要转换的字符
	'返回值：转换后的字符
	'**************************************************
	Function FC_ToAsc(ascStr)
		Dim I, j
		For I = 0 To Len(ascStr) - 1
			j = I + 1
			FC_ToAsc = FC_ToAsc & Asc(Mid(ascStr, j, 1))
		Next
	End Function
	
	
	Function IsValidPhone(Phone)
		Dim I, c
		IsValidPhone = True
		For I = 1 To Len(Phone)
			c = LCase(Mid(Phone, I, 1))
			If InStr("-()", c) <= 0 And Not IsNumeric(c) Then
				IsValidPhone = False
				Exit Function
			End If
		Next
	End Function
	
	
	'**************************************************
	'函数名：DelRightComma
	'作  用：删除字符串（如："1,3,5,8"）右侧多余的逗号以消除SQL查询时出错的问题，Comma：逗号。
	'参  数：str ---- 待处理的字符串
	'**************************************************
	Function DelRightComma(ByVal Str)
		Str = Trim(Str)
		If Right(Str, 1) = "," Then
			Str = Left(Str, Len(Str) - 1)
		End If
		DelRightComma = Str
	End Function
	
	'**************************************************
	'函数名：FilterArrNull
	'作  用：过滤数组空字符
	'**************************************************
	Function FilterArrNull(ByVal ArrString, ByVal CompartString)
		Dim arrContent, arrTemp, I
	
		If CompartString = "" Or ArrString = "" Then
			FilterArrNull = ArrString
			Exit Function
		End If
		If InStr(ArrString, CompartString) = 0 Then
			FilterArrNull = ArrString
			Exit Function
		Else
			arrContent = Split(ArrString, CompartString)
			For I = 0 To UBound(arrContent)
				If Trim(arrContent(I)) <> "" Then
					If arrTemp = "" Then
						arrTemp = Trim(arrContent(I))
					Else
						arrTemp = arrTemp & CompartString & Trim(arrContent(I))
					End If
				End If
			Next
		End If
		FilterArrNull = arrTemp
	End Function
	
	Function RemoveStr(str1, str2, strSplit)
		If IsNull(str1) Or str1 = "" Then
			RemoveStr = ""
			Exit Function
		End If
		If IsNull(str2) Or str2 = "" Then
			RemoveStr = str1
			Exit Function
		End If
		If InStr(str1, strSplit) > 0 Then
			Dim arrStr, tempStr, I
			arrStr = Split(str1, strSplit)
			For I = 0 To UBound(arrStr)
				If arrStr(I) <> str2 Then
					If tempStr = "" Then
						tempStr = arrStr(I)
					Else
						tempStr = tempStr & strSplit & arrStr(I)
					End If
				End If
			Next
			RemoveStr = tempStr
		Else
			If str1 = str2 Then
				RemoveStr = ""
			Else
				RemoveStr = str1
			End If
		End If
	End Function
	
	Function AppendStr(str1, str2, strSplit)
		If IsNull(str2) Or str2 = "" Then
			AppendStr = str1
			Exit Function
		End If
		If IsNull(str1) Or str1 = "" Then
			AppendStr = str2
			Exit Function
		End If
		Dim Foundstr, arrStr, I
		Foundstr = False
		If InStr(str1, strSplit) > 0 Then
			arrStr = Split(str1, strSplit)
			For I = 0 To UBound(arrStr)
				If arrStr(I) = str2 Then
					Foundstr = True
					Exit For
				End If
			Next
		Else
			If str1 = str2 Then
				Foundstr = True
			End If
		End If
		If Foundstr = False Then
			AppendStr = str1 & strSplit & str2
		Else
			AppendStr = str1
		End If
	End Function
	
	Function StyleDisplay(Compare1, Compare2)
		If Compare1 = Compare2 Then
			StyleDisplay = ""
		Else
			StyleDisplay = "none"
		End If
	End Function
	
	Function IsRadioChecked(Compare1, Compare2)
		If Compare1 = Compare2 Then
			IsRadioChecked = " checked"
		Else
			IsRadioChecked = ""
		End If
	End Function
	
	Function IsOptionSelected(Compare1, Compare2)
		If Compare1 = Compare2 Then
			IsOptionSelected = " selected"
		Else
			IsOptionSelected = ""
		End If
	End Function
	
	Function FixJs(Str)
		If Str <> "" Then
			Str = Replace(Str, "&#39;", "'")
			Str = Replace(Str, "\", "\\")
			Str = Replace(Str, Chr(34), "\""")
			Str = Replace(Str, Chr(39), "\'")
			Str = Replace(Str, Chr(13), "\n")
			Str = Replace(Str, Chr(10), "\r")
			Str = Replace(Str, "'", "&#39;")
			Str = Replace(Str, """", "&quot;")
		End If
		FixJs = Str
	End Function
	
	Function Html2Js(Str)
		If Str <> "" Then
			Str = Replace(Str, Chr(34), "\""")
			Str = Replace(Str, Chr(39), "\'")
			Str = Replace(Str, Chr(13), "\n")
			Str = Replace(Str, Chr(10), "\r")
		End If
		Html2Js = Str
	End Function
	'**************************************************
	'函数名：CreateKeyWord
	'作  用：由给定的字符串生成关键字
	'参  数：Constr---要生成关键字的原字符串
	'返回值：生成的关键字
	'**************************************************
	Function CreateKeyWord(ByVal ConStr, ByVal Num)
		If ConStr = "" Or IsNull(ConStr) = True Or ConStr = "$False$" Or IsNumeric(Num) = False Then
			CreateKeyWord = "$False$"
			Exit Function
		End If
		If CLng(Num) < 2 Then
			Num = 2
		End If
		ConStr = Replace(ConStr, Chr(32), "")
		ConStr = Replace(ConStr, Chr(9), "")
		ConStr = Replace(ConStr, "&nbsp;", "")
		ConStr = Replace(ConStr, " ", "")
		ConStr = Replace(ConStr, "(", "")
		ConStr = Replace(ConStr, ")", "")
		ConStr = Replace(ConStr, "<", "")
		ConStr = Replace(ConStr, ">", "")
		Dim i, ConstrTemp
		If Num >= Len(ConStr) Then
			CreateKeyWord = Left(ConStr, 254)
			Exit Function
		Else
			For i = 1 To Len(ConStr)
				If i + Num > Len(ConStr) Then
					Exit For
				Else
					ConstrTemp = ConstrTemp & "|" & Mid(ConStr, i, Num)
				End If
			Next
		End If
		If Len(ConstrTemp) < 254 Then
			ConstrTemp = ConstrTemp & "|"
		Else
			ConstrTemp = Left(ConstrTemp, 254) & "|"
		End If
		CreateKeyWord = ConstrTemp
	End Function
	
	'**************************************************
	'函数名：ZeroToEmpty
	'作  用：判断字符串是否等于"0"，如果是将字符串置为空，用于JS生成处理
	'参  数：str ---- 待处理的字符串
	'**************************************************
	Function ZeroToEmpty(Str)
		If Str = "0" Then
			ZeroToEmpty = ""
		Else
			ZeroToEmpty = Str
		End If
	End Function
	
	Function EncodeIP(sip)
		Dim strIP
		strIP = Split(sip, ".")
		If UBound(strIP) < 3 Then
			EncodeIP = 0
			Exit Function
		End If
		If IsNumeric(strIP(0)) = False Or IsNumeric(strIP(1)) = False Or IsNumeric(strIP(2)) = False Or IsNumeric(strIP(3)) = False Then
			EncodeIP = 0
		Else
			EncodeIP = CDbl(strIP(0)) * 256 * 256 * 256 + CLng(strIP(1)) * 256 * 256 + CLng(strIP(2)) * 256 + CLng(strIP(3)) - 1
		End If
	End Function
	
	Function DecodeIP(sip)
		Dim s1, s21, s2, s31, s3, s4
		sip = sip + 1
		s1 = Int(sip / 256 / 256 / 256)
		s21 = s1 * 256 * 256 * 256
		s2 = Int((sip - s21) / 256 / 256)
		s31 = s2 * 256 * 256 + s21
		s3 = Int((sip - s31) / 256)
		s4 = sip - s3 * 256 - s31
		DecodeIP = CStr(s1) + "." + CStr(s2) + "." + CStr(s3) + "." + CStr(s4)
	End Function
	
	'==================数据库操作部分=================
	'==========================
	'函数名BackUpSql
	'功能：恢复数据库
	'参数:sqlDatabaseName 目标数据库名称
	'参数:sqlBackUpFile 源数据库文件
	'web:www.melyysoft.com
	'Author:melyy
	'Date:2009-9-24
	'==========================
	Function BackUpSql(SqlHostIp, SqlUserName, SqlPassword, SqlDatabaseName, SqlBackUpFile)
		On Error Resume Next
		Dim SqlLoginTimeout, BakSer, BakSql, Files
		SqlLoginTimeout = 99999
		Set BakSer = Server.CreateObject("sqldmo.sqlserver")
		BakSer.logintimeout = SqlLoginTimeout
		BakSer.Connect SqlHostIp, SqlUserName, SqlPassword
		Set BakSql = Server.CreateObject("sqldmo.backup")
		BakSql.Database = SqlDatabaseName
		BakSql.devices = Files
		BakSql.Action = 0
		BakSql.Initialize = 1
		'BakSql.replace        = true
		BakSql.Files = SqlBackUpFile
		BakSql.sqlbackup BakSer
		If Err.Number > 0 Then
			BackUpSql = False
		Else
			BackUpSql = True
		End If
		BakSer.Close
		Set BakSer = Nothing
		Set BakSql = Nothing
	End Function
	'==========================
	'函数名RestoreSql
	'功能：备份数据库
	'参数:sqlDatabaseName 目标数据库名称
	'参数:SqlRestoreFile 源数据库文件
	'web:www.melyysoft.com
	'Author:melyy
	'Date:2009-9-24
	'==========================
	Function RestoreSql(SqlHostIp, SqlUserName, SqlPassword, SqlDatabaseName, SqlRestoreFile)
		On Error Resume Next
		Dim SqlLoginTimeout, ReSer, ReSql, Files
		SqlLoginTimeout = 9999
		Set ReSer = Server.CreateObject("sqldmo.sqlserver")
		ReSer.logintimeout = SqlLoginTimeout
		ReSer.Connect SqlHostIp, SqlUserName, SqlPassword
		Set ReSql = Server.CreateObject("sqldmo.restore")
		ReSql.Action = 0 ' full db restore
		ReSql.Database = SqlDatabaseName
		ReSql.devices = Files
		ReSql.Files = SqlRestoreFile
		ReSql.replacedatabase = True 'force restore over existing database
		If Err.Number > 0 Then
			RestoreSql = False
		Else
			RestoreSql = True
			ReSql.sqlrestore ReSer
		End If
		ReSer.Close
		Set ReSer = Nothing
		Set ReSql = Nothing
	End Function
	'==========================
	'函数名DelSqlLog
	'功能：截断数据库日志
	'参数:sqlDatabaseName 目标数据库名称
	'web:www.melyysoft.com
	'Author:melyy
	'Date:2009-9-29
	'==========================
	Function DelSqlLog(SqlHostIp, SqlUserName, SqlPassword, SqlDatabaseName)
		On Error Resume Next
		Dim ConnLog, ConnLogStr
		ConnLogStr = "Provider = Sqloledb; User ID = " & SqlUserName & "; Password = " & SqlPassword & "; Initial Catalog = " & SqlDatabaseName & "; Data Source = " & SqlHostIp & ";"
		Set ConnLog = Server.CreateObject("ADODB.Connection")
		ConnLog.Open ConnLogStr
		If Err Then
			DelSqlLog = False
		Else
			ConnLog.Execute ("BACKUP LOG " & SqlDatabaseName & " WITH   NO_LOG")
			ConnLog.Execute ("DBCC SHRINKDATABASE(" & SqlDatabaseName & ")")
			DelSqlLog = True
		End If
		ConnLog.Close: Set ConnLog = Nothing
	End Function
	
	Function ToAsc(strText)
		Dim I, j
		For I = 0 To Len(strText) - 1
			j = I + 1
			If j = 1 Then
				ToAsc = ""
			Else
				ToAsc = ToAsc & "$$$"
			End If
			ToAsc = ToAsc & Asc(Mid(strText, j, 1))
		Next
	End Function
	Function TextToDataIn(strText)
		dim i
		For i=0 to ubound(split(strText,","))
			If Trim(split(strText,",")(i))<>"" and isnull(Trim(split(strText,",")(i)))=False then
				If i=0 then
					TextToDataIn="'"&Trim(split(strText,",")(i))&"'"
				Else
					TextToDataIn=TextToDataIn &",'"&Trim(split(strText,",")(i))&"'"
				End If
			End If
		Next
	End Function
End Class
%>