<%
Class IPAddress
  ' ============================================
  ' 
  ' ============================================
  Dim Country, LocalStr, Buf, OffSet
  Private StartIP, EndIP, CountryFlag
  Public QQWryFile
  Public FirstStartIP, LastStartIP, RecordCount
  Private Stream, EndIPOff
  ' ============================================
  ' ģʼ
  ' ============================================
  Private Sub Class_Initialize
   On Error Resume Next
   Country 		= ""
   LocalStr 		= ""
   StartIP 		= 0
   EndIP 			= 0
   CountryFlag 	= 0
   FirstStartIP 	= 0
   LastStartIP 	= 0
   EndIPOff 		= 0
   QQWryFile = Server.MapPath("/inc/IPAddress.dat") 'QQ IP·Ҫת·
  End Sub
  ' ============================================
  ' IPַת
  ' ============================================
  Function IPToInt(IP)
   Dim IPArray, i
   IPArray = Split(IP, ".", -1)
   FOr i = 0 to 3
    If Not IsNumeric(IPArray(i)) Then IPArray(i) = 0
    If CInt(IPArray(i)) < 0 Then IPArray(i) = Abs(CInt(IPArray(i)))
    If CInt(IPArray(i)) > 255 Then IPArray(i) = 255
   Next
   IPToInt = (CInt(IPArray(0))*256*256*256) + (CInt(IPArray(1))*256*256) + (CInt(IPArray(2))*256) + CInt(IPArray(3))
  End Function
  ' ============================================
  ' תIPַ
  ' ============================================
  Function IntToIP(IntValue)
   p4 = IntValue - Fix(IntValue/256)*256
   IntValue = (IntValue-p4)/256
   p3 = IntValue - Fix(IntValue/256)*256
   IntValue = (IntValue-p3)/256
   p2 = IntValue - Fix(IntValue/256)*256
   IntValue = (IntValue - p2)/256
   p1 = IntValue
   IntToIP = Cstr(p1) & "." & Cstr(p2) & "." & Cstr(p3) & "." & Cstr(p4)
  End Function
  ' ============================================
  ' ȡʼIPλ
  ' ============================================
  Private Function GetStartIP(RecNo)
   OffSet = FirstStartIP + RecNo * 7
   Stream.Position = OffSet
   Buf = Stream.Read(7)

   EndIPOff = AscB(MidB(Buf, 5, 1)) + (AscB(MidB(Buf, 6, 1))*256) + (AscB(MidB(Buf, 7, 1))*256*256)
   StartIP  = AscB(MidB(Buf, 1, 1)) + (AscB(MidB(Buf, 2, 1))*256) + (AscB(MidB(Buf, 3, 1))*256*256) + (AscB(MidB(Buf, 4, 1))*256*256*256)
   GetStartIP = StartIP
  End Function
  ' ============================================
  ' ȡIPλ
  ' ============================================
  Private Function GetEndIP()
   Stream.Position = EndIPOff
   Buf = Stream.Read(5)
   EndIP = AscB(MidB(Buf, 1, 1)) + (AscB(MidB(Buf, 2, 1))*256) + (AscB(MidB(Buf, 3, 1))*256*256) + (AscB(MidB(Buf, 4, 1))*256*256*256)
   CountryFlag = AscB(MidB(Buf, 5, 1))
   GetEndIP = EndIP
  End Function
  ' ============================================
  ' ȡϢҺͺʡ
  ' ============================================
  Private Sub GetCountry(IP)
   If (CountryFlag = 1 Or CountryFlag = 2) Then
    Country = GetFlagStr(EndIPOff + 4)
    If CountryFlag = 1 Then
     LocalStr = GetFlagStr(Stream.Position)
     ' ȡݿ汾Ϣ
     If IP >= IPToInt("255.255.255.0") And IP <= IPToInt("255.255.255.255") Then
      LocalStr = GetFlagStr(EndIPOff + 21)
      Country = GetFlagStr(EndIPOff + 12)
     End If
    Else
     LocalStr = GetFlagStr(EndIPOff + 8)
    End If
   Else
    Country = GetFlagStr(EndIPOff + 4)
    LocalStr = GetFlagStr(Stream.Position)
   End If
   ' ݿеϢ
   Country = Trim(Country)
   LocalStr = Trim(LocalStr)
   If InStr(Country, "CZ88.NET") Then Country = "GZ110.CN"
   If InStr(LocalStr, "CZ88.NET") Then LocalStr = "GZ110.CN"
  End Sub
  ' ============================================
  ' ȡIPַʶ
  ' ============================================
  Private Function GetFlagStr(OffSet)
   Dim Flag
   Flag = 0
   Do While (True)
    Stream.Position = OffSet
    Flag = AscB(Stream.Read(1))
    If(Flag = 1 Or Flag = 2 ) Then
     Buf = Stream.Read(3)
     If (Flag = 2 ) Then
      CountryFlag = 2
      EndIPOff = OffSet - 4
     End If
     OffSet = AscB(MidB(Buf, 1, 1)) + (AscB(MidB(Buf, 2, 1))*256) + (AscB(MidB(Buf, 3, 1))*256*256)
    Else
     Exit Do
    End If
   Loop

   If (OffSet < 12 ) Then
    GetFlagStr = ""
   Else
    Stream.Position = OffSet
    GetFlagStr = GetStr()
   End If
  End Function
  ' ============================================
  ' ȡִϢ
  ' ============================================
  Private Function GetStr()
   Dim c
   GetStr = ""
   Do While (True)
    c = AscB(Stream.Read(1))
    If (c = 0) Then Exit Do

    '˫ֽڣͽиֽڽϵֽںϳһַ
    If c > 127 Then
     If Stream.EOS Then Exit Do
     GetStr = GetStr & Chr(AscW(ChrB(AscB(Stream.Read(1))) & ChrB(C)))
    Else
     GetStr = GetStr & Chr(c)
    End If
   Loop
  End Function
  ' ============================================
  ' ĺִIP
  ' ============================================
  Public Function QQWry(DotIP)
   Dim IP, nRet
   Dim RangB, RangE, RecNo

   IP = IPToInt (DotIP)

   Set Stream = CreateObject("ADodb.Stream")
   Stream.Mode = 3
   Stream.Type = 1
   Stream.Open
   Stream.LoadFromFile QQWryFile
   Stream.Position = 0
   Buf = Stream.Read(8)

   FirstStartIP = AscB(MidB(Buf, 1, 1)) + (AscB(MidB(Buf, 2, 1))*256) + (AscB(MidB(Buf, 3, 1))*256*256) + (AscB(MidB(Buf, 4, 1))*256*256*256)
   LastStartIP  = AscB(MidB(Buf, 5, 1)) + (AscB(MidB(Buf, 6, 1))*256) + (AscB(MidB(Buf, 7, 1))*256*256) + (AscB(MidB(Buf, 8, 1))*256*256*256)
   RecordCount = Int((LastStartIP - FirstStartIP)/7)
   ' ݿҲκIPַ
   If (RecordCount <= 1) Then
    Country = "δ֪"
    QQWry = 2
    Exit Function
   End If

   RangB = 0
   RangE = RecordCount

   Do While (RangB < (RangE - 1))
    RecNo = Int((RangB + RangE)/2)
    Call GetStartIP (RecNo)
    If (IP = StartIP) Then
     RangB = RecNo
     Exit Do
    End If
    If (IP > StartIP) Then
     RangB = RecNo
    Else
     RangE = RecNo
    End If
   Loop

   Call GetStartIP(RangB)
   Call GetEndIP()

   If (StartIP <= IP) And ( EndIP >= IP) Then
    ' ûҵ
    nRet = 0
   Else
    ' 
    nRet = 3
   End If
   Call GetCountry(IP)

   QQWry = nRet
  End Function
  ' ============================================
  ' IPַϷ
  ' ============================================
  Public Function IsIp(IP)
   IsIp = True
   If IP = "" Then IsIp = False : Exit Function
   Dim Re
   Set Re = New RegExp
   Re.Pattern = "^(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5])\.(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5])\.(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5])\.(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5])$"
   Re.IgnoreCase = True
   Re.Global = True
   IsIp = Re.Test(IP)
   Set Re = Nothing
  End Function
  ' ============================================
  ' ս

  ' ============================================
  Private Sub Class_Terminate
   On ErrOr Resume Next
   Stream.Close
   If Err Then Err.Clear
   Set Stream = Nothing
  End Sub
End Class

Public Function GetAddress(sip)
  If Len(sip) < 5 Then
     GetAddress = "δ֪"
     Exit Function
  End If
  On Error Resume Next
  Dim Wry,IPType
  Set Wry = New IPAddress
  If Not Wry.IsIp(sip) Then
     GetAddress = " δ֪"
     Exit Function
  End If
  IPType = Wry.QQWry(sip)
  GetAddress = Wry.Country & " " & Wry.LocalStr
End Function
%>