<%
'==================================================
' Updated 2009 /10 /24 16:38
'==================================================
Class ClsUpload
  Dim Form,File
  Dim AllowExt_
  Dim NoAllowExt_
  Dim IsDebug_
  Private oUpFileStream
  Private isErr_
  Private ErrMessage_
  Private isGetData_


  Public Property Get isErr
    isErr=isErr_
  End Property

  Public Property Get ErrMessage
    ErrMessage=ErrMessage_
  End Property

  Public Property Get AllowExt
    AllowExt=AllowExt_
  End Property

  Public Property Let AllowExt(Value)
    AllowExt_=LCase(Value)
  End Property

  Public Property Get NoAllowExt
    NoAllowExt=NoAllowExt_
  End Property

  Public Property Let NoAllowExt(Value)
    NoAllowExt_=LCase(Value)
  End Property

  Public Property Let IsDebug(Value)
    IsDebug_=Value
  End Property

  Private Sub Class_Initialize
    isErr_ = 0
    NoAllowExt=""
    NoAllowExt=LCase(NoAllowExt)
    AllowExt=""
    AllowExt=LCase(AllowExt)
    isGetData_=false
  End Sub


  Private Sub Class_Terminate
    'On Error Resume Next

    Form.RemoveAll
    Set Form = Nothing
    File.RemoveAll
    Set File = Nothing
    oUpFileStream.Close
    Set oUpFileStream = Nothing
    If Err.number<>0 Then OutErr("error when cleaning the class")
  End Sub


  Public Sub GetData (MaxSize)
   'On Error Resume Next
   If isGetData_=false Then
     Dim RequestBinDate,sSpace,bCrLf,sInfo,iInfoStart,iInfoEnd,tStream,iStart,oFileInfo
     Dim sFormValue,sFileName
     Dim iFindStart,iFindEnd
     Dim iFormStart,iFormEnd,sFormName

     If Request.TotalBytes < 1 Then
       isErr_ = 1
       ErrMessage_="no upload data"
       OutErr("no upload data!")
       Exit Sub
     End If
     If MaxSize > 0 Then
       If Request.TotalBytes > MaxSize Then
         isErr_ = 2
         ErrMessage_="too large"
         OutErr("too large")
         Exit Sub
       End If
     End If
     Set Form = Server.CreateObject ("Scripting.Dictionary")
     Form.CompareMode = 1
     Set File = Server.CreateObject ("Scripting.Dictionary")
     File.CompareMode = 1
     Set tStream = Server.CreateObject ("ADODB.Stream")
     Set oUpFileStream = Server.CreateObject ("ADODB.Stream")
     If Err.number<>0 Then OutErr("Error when creating adodb.stream")
     oUpFileStream.Type = 1
     oUpFileStream.Mode = 3
     oUpFileStream.Open
     oUpFileStream.Write Request.BinaryRead (Request.TotalBytes)
     oUpFileStream.Position = 0
     RequestBinDate = oUpFileStream.Read
     iFormEnd = oUpFileStream.Size
     bCrLf = ChrB (13) & ChrB (10)

     sSpace = MidB (RequestBinDate,1, InStrB (1,RequestBinDate,bCrLf)-1)
     iStart = LenB(sSpace)
     iFormStart = iStart+2

     Do
       iInfoEnd = InStrB (iFormStart,RequestBinDate,bCrLf & bCrLf)+3
       tStream.Type = 1
       tStream.Mode = 3
       tStream.Open
       oUpFileStream.Position = iFormStart
       oUpFileStream.CopyTo tStream,iInfoEnd-iFormStart
       tStream.Position = 0
       tStream.Type = 2
       tStream.CharSet = "gb2312"
       sInfo = tStream.ReadText

       iFormStart = InStrB (iInfoEnd,RequestBinDate,sSpace)-1
       iFindStart = InStr (22,sInfo,"name=""",1)+6
       iFindEnd = InStr (iFindStart,sInfo,"""",1)
       sFormName = Mid(sinfo,iFindStart,iFindEnd-iFindStart)

       If InStr (45,sInfo,"filename=""",1) > 0 Then
         Set oFileInfo = new FileInfo_Class

         iFindStart = InStr (iFindEnd,sInfo,"filename=""",1)+10
         iFindEnd = InStr (iFindStart,sInfo,""""&vbCrLf,1)
         sFileName = Trim(Mid(sinfo,iFindStart,iFindEnd-iFindStart))
         oFileInfo.FileName = GetFileName(sFileName)
         oFileInfo.FilePath = GetFilePath(sFileName)
         oFileInfo.FileExt = GetFileExt(sFileName)
         iFindStart = InStr (iFindEnd,sInfo,"Content-Type: ",1)+14
         iFindEnd = InStr (iFindStart,sInfo,vbCr)
         oFileInfo.FileMIME = Mid(sinfo,iFindStart,iFindEnd-iFindStart)
         oFileInfo.FileStart = iInfoEnd
         oFileInfo.FileSize = iFormStart -iInfoEnd -2
         oFileInfo.FormName = sFormName
         file.add sFormName,oFileInfo
       Else

         tStream.Close
         tStream.Type = 1
         tStream.Mode = 3
         tStream.Open
         oUpFileStream.Position = iInfoEnd
         oUpFileStream.CopyTo tStream,iFormStart-iInfoEnd-2
         tStream.Position = 0
         tStream.Type = 2
         tStream.CharSet = "gb2312"
         sFormValue = tStream.ReadText
         If Form.Exists (sFormName) Then
           Form (sFormName) = Form (sFormName) & ", " & sFormValue
         Else
           Form.Add sFormName,sFormValue
         End If
       End If
       tStream.Close
       iFormStart = iFormStart+iStart+2

     Loop Until (iFormStart+2) >= iFormEnd
     If Err.number<>0 Then OutErr("incorrect data")
     RequestBinDate = ""
     Set tStream = Nothing
     isGetData_=True
   End If
  End Sub


  Public Function SaveToFile(Item,Path)
    SaveToFile=SaveToFileEx(Item,Path,True)
  End Function


  Public Function AutoSave(Item,Path)
    AutoSave=SaveToFileEx(Item,Path,false)
  End Function


  Private Function SaveToFileEx(Item,Path,CanOverWrite)
'    On Error Resume Next
    Dim FileExt
    If file.Exists(Item) Then
      Dim oFileStream
      Dim tmpPath
      isErr_=0
      Set oFileStream = CreateObject("ADODB.Stream")
      oFileStream.Type = 1
      oFileStream.Mode = 3
      oFileStream.Open
      oUpFileStream.Position = File(Item).FileStart
      oUpFileStream.CopyTo oFileStream,File(Item).FileSize
      tmpPath=Left(Path, InstrRev(Path,".")-1)
      FileExt=GetFileExt(Path)
      If CanOverWrite Then
        If isAllowExt(FileExt) Then
          oFileStream.SaveToFile tmpPath & "." & FileExt,2
          If Err.number<>0 Then OutErr("Pls check the path" & tmpPath & "." & FileExt)
        Else
          isErr_=3
          ErrMessage_="Not allowed"
          OutErr("Not allowed")
        End If
      Else
        Path=GetFilePath(Path)
        Dim fori
        fori=1
        If isAllowExt(File(Item).FileExt) Then
          Do
            fori=fori+1
            Err.Clear()
            tmpPath=Path&GetNewFileName()&"."&File(Item).FileExt
            oFileStream.SaveToFile tmpPath
          Loop Until ((Err.number=0) or (fori>50))
          If Err.number<>0 Then OutErr("Pls check the path"&Path&GetNewFileName()&"."&File(Item).FileExt)
        Else
          isErr_=3
        End If
      End If
      oFileStream.Close
      Set oFileStream = Nothing
    Else
    End If
    If isErr_=3 Then SaveToFileEx="" Else SaveToFileEx=GetFileName(tmpPath)
  End Function


  Public Function FileData(Item)
    isErr_=0
    If file.Exists(Item) Then
      If isAllowExt(File(Item).FileExt) Then
        oUpFileStream.Position = File(Item).FileStart
        FileData = oUpFileStream.Read (File(Item).FileSize)
        Else
        isErr_=3
        ErrMessage_="Not allowed"
        OutErr ErrMessage_
        FileData=""
      End If
    Else
      ErrMessage_="Not Exist!"
      OutErr ErrMessage_
    End If
  End Function



  Public function GetFilePath(FullPath)
    If FullPath <> "" Then GetFilePath = Left(FullPath,InStrRev(FullPath, "\")) Else GetFilePath = ""
  End function


  Public Function GetFileName(FullPath)
    If FullPath <> "" Then GetFileName = mid(FullPath,InStrRev(FullPath, "\")+1) Else GetFileName = ""
  End function


  Public Function GetFileExt(FullPath)
    If FullPath <> "" Then GetFileExt = LCase(Mid(FullPath,InStrRev(FullPath, ".")+1)) Else GetFileExt = ""
  End function


  Public Function GetNewFileName()
    Dim ranNum
    Dim dtNow
    dtNow=Now()
    randomize
    ranNum=int(90000*rnd)+10000

    GetNewFileName=year(dtNow) & right("0" & month(dtNow),2) & right("0" & day(dtNow),2) & right("0" & hour(dtNow),2) & right("0" & minute(dtNow),2) & right("0" & second(dtNow),2) & ranNum
  End Function

  Public Function isAllowExt(Ext)
    If NoAllowExt="" Then
      isAllowExt=cbool(InStr(1,";"&AllowExt&";",LCase(";"&Ext&";")))
    Else
      isAllowExt=not CBool(InStr(1,";"&NoAllowExt&";",LCase(";"&Ext&";")))
    End If
  End Function
End Class

Public Sub OutErr(ErrMsg)
  If IsDebug_ Then
    Response.Write ErrMsg
    Response.End
  End If
End Sub



Class FileInfo_Class
  Dim FormName,FileName,FilePath,FileSize,FileMIME,FileStart,FileExt
End Class
%>
