// JavaScript Document

var MiniSite = new Object();

MiniSite.Browser = {
	ie: /msie/.test(window.navigator.userAgent.toLowerCase()),
	moz: /gecko/.test(window.navigator.userAgent.toLowerCase()),
	opera: /opera/.test(window.navigator.userAgent.toLowerCase())
};

MiniSite.$ = function(s)
{
	return (typeof s == 'object') ? s: document.getElementById(s);
};

MiniSite.JsLoader = {
	load: function(sUrl, fCallback)
	{
		var _script = document.createElement('script');
		_script.setAttribute('type', 'text/javascript');
		_script.setAttribute('src', sUrl);
		document.getElementsByTagName('head')[0].appendChild(_script);

		if (MiniSite.Browser.ie)
		{
			_script.onreadystatechange = function()
			{
				if (this.readyState=='loaded' || this.readyState=='complete')
				{
					fCallback();
				}
			};
		}
		else if (MiniSite.Browser.moz)
		{
			_script.onload = function()
			{
				fCallback();
			};
		}
		else
		{
			fCallback();
		}
	}
};

MiniSite.Cookie = {
	set: function(name, value, expires, path, domain)
	{
		if (typeof expires == "undefined")
		{
			expires = new Date(new Date().getTime() + 365*24*3600*100);
		}

		document.cookie = name + "=" + escape(value) +
			((expires) ? "; expires=" + expires.toGMTString() : "") +
			((path) ? "; path=" + path : "; path=/") +
			((domain) ? "; domain=" + domain : "");
	},

	get: function(name)
	{
		var arr = document.cookie.match(new RegExp("(^| )"+name+"=([^;]*)(;|$)"));

		if (arr != null)
		{
			return unescape(arr[2]);
		
		}

		return null;
	},

	clear: function(name, path, domain)
	{
		if (this.get(name))
		{
			document.cookie = name + "=" +
				((path) ? "; path=" + path : "; path=/") +
				((domain) ? "; domain=" + domain : "") +
				";expires=Fri, 02-Jan-1970 00:00:00 GMT";
		}
	}
};

MiniSite.Weather = {
	defaultCity: 142,
	city: {
		"": {
			"_": 125,
			"": 125
		},
		"Ϻ": {
			"_": 252,
			"Ϻ": 252
		},
		"": {
			"_": 127,
			"": 127,
			"": 132
		},
		"" : {
			"_": 212,
			"": 201,
			"": 212,
			"": 213
		},
		"": {
			"_": 1,
			"": 1
		},
		"": {
			"_": 2,
			"": 2
		},
		"̨ʡ": {
			"_": 280,
			"̨": 280
		},
		"ʡ": {
			"ͨ": 173,
			"": 174,
			"": 175,
			"ɽ": 176,
			"": 177,
			"": 178,
			"": 179,
			"": 180,
			"Ϫ": 181,
			"ٲ": 182,
			"˼é": 184,
			"ӹ": 185,
			"ɽ׳": 369,
			"˫ɴ": 370,
			"º徰": 371,
			"ŭ": 372,
			"": 373
		},
		"ɹ": {
			"ױ": 4,
			"˰": 7,
			"ֹ": 16,
			"׶": 63,
			"ͷ": 64,
			"ͺ": 69,
			"ֺ": 99,
			"ͨ": 101,
			"": 106,
			"ں": 382,
			"˹": 383,
			"첼": 384
		},
		"ʡ": {
			"Դ": 34,
			"ͨ": 36,
			"׳": 37,
			"ԭ": 96,
			"": 103,
			"": 104,
			"": 109,
			"ӱ߳": 110,
			"": 118,
			"ɽ": 119,
			"ƽ": 385
		},
		"Ĵʡ": {
			"β": 162,
			"ӲǼ": 163,
			"ɶ": 166,
			"": 167,
			"Ű": 168,
			"üɽ": 170,
			"ɽ": 171,
			"˱": 172,
			"": 199,
			"": 200,
			"": 204,
			"ϳ": 205,
			"": 216,
			"Թ": 359,
			"֦": 360,
			"": 361,
			"Ԫ": 362,
			"ڽ": 363,
			"㰲": 364,
			"üɽ": 365,
			"": 366,
			"ɽ": 367
		},
		"": {
			"ʯɽ": 54,
			"": 78,
			"": 83,
			"ԭ": 209
		},
		"ʡ": {
			"": 75,
			"ɽ": 76,
			"": 77,
			"ͭ": 92,
			"": 95,
			"": 100,
			"": 102,
			"": 105,
			"": 238,
			"": 239,
			"": 241,
			"": 242,
			"": 243,
			"Ϸ": 248,
			"ߺ": 249,
			"": 253,
			"ɽ": 254
		},
		"ɽʡ": {
			"": 134,
			"": 135,
			"̨": 136,
			"ĳ": 139,
			"": 140,
			"̩": 141,
			"Ͳ": 142,
			"Ϋ": 143,
			"ൺ": 144,
			"": 146,
			"": 147,
			"̩ɽ": 156,
			"ׯ": 159,
			"Ӫ": 160,
			"": 164,
			"": 165,
			"": 183,
			"": 206
		},
		"ɽʡ": {
			"": 9,
			"": 22,
			"˷": 70,
			"ͬ": 72,
			"": 80,
			"": 81,
			"̫ԭ": 84,
			"Ȫ": 85,
			"ٷ": 88,
			"˳": 93,
			"": 94,
			"̨ɽ": 381
		},
		"㶫ʡ": {
			"": 235,
			"ع": 283,
			"Զ": 284,
			"÷": 285,
			"": 291,
			"": 292,
			"Դ": 293,
			"ͷ": 294,
			"": 296,
			"β": 297,
			"տ": 300,
			"": 301,
			"ï": 302,
			"": 322,
			"÷": 323,
			"": 324,
			"Ҫ": 325,
			"麣": 330,
			"ɽ": 331,
			"": 332,
			"ݸ": 334,
			"ɽ": 335,
			"": 336,
			"": 337,
			"Ƹ": 338
		},
		"": {
			"": 232,
			"ӳ": 281,
			"": 282,
			"ɫ": 288,
			"": 289,
			"": 290,
			"": 295,
			"": 298,
			"": 299,
			"Ǹ": 339,
			"": 340,
			"": 341,
			"": 342,
			"": 343
		},
		"½": {
			"": 19,
			"տ¶": 20,
			"": 21,
			"": 23,
			"": 24,
			"ɹ": 27,
			"³ľ": 28,
			"³": 31,
			"": 32,
			"ʯ": 33,
			"ʲ": 35,
			"": 39,
			"": 41,
			"̨": 52
		},
		"ʡ": {
			"": 43,
			"": 44,
			"": 45,
			"": 46,
			"̨": 47,
			"": 53,
			"": 59,
			"̩": 61,
			"Ǩ": 62,
			"": 236,
			"Ƹ": 237,
			"": 240,
			"Ͼ": 244,
			"": 245,
			"γ": 246,
			"ͨ": 247,
			"": 250
		},
		"ʡ": {
			"®ɽ": 111,
			"ɽ": 137,
			"Ϫ": 138,
			"": 145,
			"Ƽ": 153,
			"": 154,
			"˴": 224,
			"": 234,
			"Ž": 258,
			"": 259,
			"ϲ": 264,
			"ӥ̶": 265,
			"": 267,
			"": 273
		},
		"ӱʡ": {
			"": 3,
			"ˮ": 8,
			"ʯׯ": 82,
			"̨": 86,
			"żҿ": 120,
			"е": 121,
			"ػʵ": 122,
			"ȷ": 126,
			"ɽ": 128,
			"": 130,
			"": 131
		},
		"ʡ": {
			"": 89,
			"Ͽ": 188,
			"֣": 189,
			"": 192,
			"ܿ": 193,
			"פ": 197,
			"": 198,
			"": 207,
			"": 228,
			"ƽɽ": 231,
			"": 251,
			"ױ": 260,
			"": 304,
			"": 305,
			"": 306,
			"": 307,
			"": 308,
			"Դ": 309
		},
		"㽭ʡ": {
			"": 65,
			"": 66,
			"ƽ": 67,
			"ʯ": 68,
			"": 71,
			"ͷ": 73,
			"ɽ": 74,
			"": 255,
			"": 256,
			"": 257,
			"": 261,
			"": 262,
			"": 263,
			"": 266,
			"ˮ": 268,
			"̨": 269,
			"": 272
		},
		"ʡ": {
			"": 303,
			"": 344,
			"Ͳ": 345,
			"": 346,
			"": 347,
			"Ĳ": 348,
			"": 349,
			"": 350,
			"": 351,
			"": 352,
			"ٸ": 353,
			"ɳ": 354,
			"ֶ": 355,
			"ˮ": 356,
			"ͤ": 357,
			"": 358
		},
		"ʡ": {
			"差": 196,
			"": 202,
			"Ƹ": 203,
			"ʩ": 208,
			"人": 211,
			"ʯ": 310,
			"": 314,
			"Т": 315,
			"": 316,
			"": 317,
			"": 318,
			"": 319,
			"Ǳ": 320,
			"ũ": 321
		},
		"ʡ": {
			"żҽ": 214,
			"": 215,
			"": 217,
			"ɳ": 218,
			"": 222,
			"": 223,
			"": 233,
			"ɣֲ": 311,
			"": 312,
			"": 313,
			"": 326,
			"̶": 327,
			"": 328,
			"¦": 329,
			"": 387
		},
		"ʡ": {
			"Ҵ": 49,
			"": 50,
			"": 51,
			"": 57,
			"": 58,
			"": 60,
			"ƽ": 90,
			"": 91,
			"": 225,
			"": 229,
			"ˮ": 377,
			"": 378,
			"Ȫ": 379,
			"¤": 380
		},
		"ʡ": {
			"": 107,
			"ֳ": 271,
			"ƽ": 274,
			"": 275,
			"": 276,
			"": 277,
			"": 278,
			"Ȫ": 279,
			"": 286,
			"": 287
		},
		"": {
			"": 148,
			"տ": 149,
			"": 150,
			"ɽ": 151,
			"": 152,
			"": 161,
			"֥": 169
		},
		"ʡ": {
			"Ͻ": 219,
			"": 220,
			"ͭ": 221,
			"˳": 226,
			"": 227,
			"ǭϲ": 230,
			"ˮ": 368
		},
		"ʡ": {
			"«": 25,
			"̽": 26,
			"": 29,
			"": 30,
			"": 108,
			"": 112,
			"": 113,
			"ɽ": 114,
			"": 115,
			"Ϫ": 116,
			"˳": 117,
			"Ӫ": 123,
			"": 124,
			"߷": 129,
			"": 133
		},
		"ʡ": {
			"": 79,
			"Ӱ": 87,
			"": 186,
			"μ": 187,
			"": 190,
			"": 191,
			"": 194,
			"ͭ": 374,
			"": 375,
			"": 376
		},
		"ຣ": {
			"": 48,
			"ϲ": 55,
			"": 56,
			"": 155,
			"ϲ": 157,
			"": 158,
			"ɹ": 195,
			"": 210
		},
		"ʡ": {
			"˰": 5,
			"ں": 6,
			"": 10,
			"绯": 11,
			"׸": 12,
			"ľ˹": 13,
			"": 14,
			"˫Ѽɽ": 15,
			"": 17,
			"": 18,
			"Į": 38,
			"": 40,
			"̨": 42,
			"ĵ": 97,
			"Һ": 98
		}
	},

	_print: function(province, city, conainter)
	{
		if (typeof this.city[province] != "undefined")
		{
			if (typeof this.city[province][city]  != "undefined")
			{
				var _city_ = this.city[province][city];
			}
			else if (typeof this.city[province]["_"]  != "undefined")
			{
				var _city_ = this.city[province]["_"];
			}
			else
			{
				var _city_ = this.defaultCity;
			}
		}
		else
		{
			var _city_ = this.defaultCity;
		}
		
		MiniSite.JsLoader.load("http://weather.news.qq.com/inc/minisite_"+_city_+".js", function()
		{
			try
			{
				MiniSite.$(conainter).innerHTML ="<a href=\"http://weather.news.qq.com/preend.htm?dc"+ _city_ +".htm\">"+__minisite__weather__ +"</a>" ;
			}
			catch (e)
			{
			}
		});
	},

	print: function(conainter)
	{
		var ok = function()
		{
			var province = null;
			var city = null;
			var ipAddress = MiniSite.Cookie.get("QQ_IPAddress");

			if (ipAddress != null)
			{
				try
				{
					var ipAddressArr = ipAddress.split(",");
					province = ipAddressArr[0];
					city =ipAddressArr[1];
				}
				catch (e)
				{
				}
			}

			MiniSite.Weather._print(province, city, conainter);
		};

		if (!MiniSite.Cookie.get("QQ_IPAddress"))
		{
			MiniSite.JsLoader.load("http://fw.qq.com:80/ipaddress", function()
			{
				if (typeof IPData != "undefined")
				{
					MiniSite.Cookie.set('QQ_IPAddress', IPData[2]+','+IPData[3]);
					ok();
				}
			});
		}
		else
		{
			ok();
		}
	}
};