(function($){
   $.fn.dialog = function(option){
       var defaultValue = {'width' : 100,'height' : 100,'top':0,'left':0,'bg': true, 'title' : '这事DIALOG','yes': null,'no': null,'yesname':'确认','noname':'取消'};
       var mPoint = {'x':0,'y':0};
       var ePoint = {'x':0,'y':0};
       var isDrag = false;

       $.extend(defaultValue,option);
       var obj = $(this);     
       var str = '';
       if(defaultValue.bg === true)  str +='<div id="dialog-bg-gr"></div>';
       str +='<div id="dialog-window">';
       defaultValue.title = obj.attr('title');
       str +='<div id="dialog-title"><span class="dialog-tl">'+defaultValue.title+'</span> <a id="dialog-close" href="javascript:void(0);">X</a> </div>';
       str +='<div id="dialog-main"></div>';
       str +='<div id="dialog-button">';
       if(defaultValue.yes!==null) str+='<input type="button" name="dialog-yes"  id="dialog-yes" value=" '+defaultValue.yesname+' ">';
       if(defaultValue.no!==null) str+='<input type="button" name="dialog-no" id="dialog-no" value=" '+defaultValue.noname+' ">';
       str+='</div></div>';

       if($('#dialog-window').length > 0){
           $('#dialog-window').remove();
       }
       if($('#dialog-bg-gr').length > 0){
           $('#dialog-bg-gr').remove();
       }
       $('body').append(str);
       $("#dialog-main").append(obj.html());
       $("#dialog-main").css({'width' :defaultValue.width,'height' : defaultValue.height});
       
       if(defaultValue.bg === true){
           $("#dialog-bg-gr").css({
                'width' : document.body.scrollWidth ,
                'height' :  document.body.scrollHeight<window.screen.height ? window.screen.height : document.body.scrollHeight
           }).show();
       }

       var w_width = defaultValue.width+20;
       var w_height = defaultValue.height+100;
       if(!defaultValue.yes && !defaultValue.no ) w_height = w_height - 50;
       var w_top = defaultValue.top > 0 ? defaultValue.top : ( window.screen.height    - w_height ) / 2;
       var w_left = defaultValue.left > 0 ? defaultValue.left : (document.body.scrollWidth - w_width) / 2;

       $("#dialog-window").css({'width':w_width+'px','height':w_height+'px','top':w_top+'px','left':w_left+'px'}).show(200);
       $('#dialog-close').click(function(){
           $(this).close();
       });
       if(defaultValue.yes!==null){
           $("#dialog-yes").click(defaultValue.yes);
       }
       if(defaultValue.no!==null){
           $("#dialog-no").click(defaultValue.no);
       }
       $("#dialog-title").mousedown(function(e){
           $(this).css('cursor','move');
           var win = $("#dialog-window").offset();
           ePoint = {'x':e.clientX,'y':e.clientY};
           mPoint = {'x':parseInt(win.left) ,'y':parseInt(win.top)};
           isDrag = true;
       });
       $('body').mouseup(function(e){
          isDrag = false;
       });
       $('body').mousemove(function(e){
          if(isDrag){
            var locLeft = mPoint.x + e.clientX - ePoint.x;
            var locTop  = mPoint.y + e.clientY - ePoint.y;
            var maxLeft = document.body.scrollWidth - w_width ;
            var maxTop  = document.body.scrollHeight- w_height + mPoint.y - ePoint.y;
            if(locLeft<0) locLeft = 0;
            if(locTop<0)  locTop  = 0;
            if(locLeft > maxLeft) locLeft = maxLeft;
            if(locTop > maxTop ) locTop = maxTop;
            $("#dialog-window").css({'left':locLeft,'top':locTop});
          }
       });
       return $;
   },
   $.fn.close = function(){
        if($('#dialog-window').length > 0){
            $('#dialog-window').hide().remove();
        }
        if($('#dialog-bg-gr').length > 0){
           $('#dialog-bg-gr').hide().remove();
        }
        return $;
   },
   $.fn.getFormData = function(){
       return $('#dialog-window form').serialize();
   },
   $.fn.submitForm = function(){
       return $('#dialog-window form').submit();
   };
})(jQuery);


function alertDiv(message,callBack){
   if($("#jq-alertDiv-message").length == 0 ){
       $('body').append('<div style="display:none;" id="jq-alertDiv-message" title="消息提示"></div>');
   }
   $("#jq-alertDiv-message").html(message);
   $("#jq-alertDiv-message").dialog({
       'width':300,
       'height':100,
       'bg'  : true,
       'yes' : callBack ? callBack : function(){
           $(this).close();
       }
   });
}

function confirmDiv(message,callBack){
   if($("#jq-alertDiv-message").length == 0 ){
       $('body').append('<div style="display:none;" id="jq-alertDiv-message" title="消息提示"></div>');
   }
   $("#jq-alertDiv-message").html(message);
   $("#jq-alertDiv-message").dialog({
       'width':400,
       'height':100,
       'bg'  : true,
       'yes' : callBack ? callBack : function(){ $(this).close();},
       'no'  : function(){ $(this).close();}
   });
}

(function(a) {
    a.fn.vTicker = function(b) {
        var c = {
            speed: 700,
            pause: 4000,
            showItems: 3,
            animation: "",
            mousePause: true,
            isPaused: false,
            direction: "up",
            height: 0
        };
        var b = a.extend(c, b);
        moveUp = function(g, d, e) {
            if (e.isPaused) {
                return;
            }
            var f = g.children("ul");
            var h = f.children("li:first").clone(true);
            if (e.height > 0) {
                d = f.children("li:first").height();
            }
            f.animate({
                top: "-=" + d + "px"
            },
            e.speed,
            function() {
                a(this).children("li:first").remove();
                a(this).css("top", "0px");
            });
            if (e.animation == "fade") {
                f.children("li:first").fadeOut(e.speed);
                if (e.height == 0) {
                    f.children("li:eq(" + e.showItems + ")").hide().fadeIn(e.speed);
                }
            }
            h.appendTo(f);
        };
        moveDown = function(g, d, e) {
            if (e.isPaused) {
                return;
            }
            var f = g.children("ul");
            var h = f.children("li:last").clone(true);
            if (e.height > 0) {
                d = f.children("li:first").height();
            }
            f.css("top", "-" + d + "px").prepend(h);
            f.animate({
                top: 0
            },
            e.speed,
            function() {
                a(this).children("li:last").remove();
            });
            if (e.animation == "fade") {
                if (e.height == 0) {
                    f.children("li:eq(" + e.showItems + ")").fadeOut(e.speed);
                }
                f.children("li:first").hide().fadeIn(e.speed);
            }
        };
        return this.each(function() {
            var f = a(this);
            var e = 0;
            f.css({
                overflow: "hidden",
                position: "relative"
            }).children("ul").css({
                position: "absolute",
                margin: 0,
                padding: 0
            }).children("li").css({
                margin: 0,
                padding: 0
            });
            if (b.height == 0) {
                f.children("ul").children("li").each(function() {
                    if (a(this).height() > e) {
                        e = a(this).height();
                    }
                });
                f.children("ul").children("li").each(function() {
                    a(this).height(e);
                });
                f.height(e * b.showItems);
            } else {
                f.height(b.height);
            }
            var d = setInterval(function() {
                if (b.direction == "up") {
                    moveUp(f, e, b);
                } else {
                    moveDown(f, e, b);
                }
            },
            b.pause);
            if (b.mousePause) {
                f.bind("mouseenter",
                function() {
                    b.isPaused = true;
                }).bind("mouseleave",
                function() {
                    b.isPaused = false;
                })
            }
        })
    }
})(jQuery);

(function ($, document, undefined) {

	var pluses = /\+/g;

	function raw(s) {
		return s;
	}

	function decoded(s) {
		return decodeURIComponent(s.replace(pluses, ' '));
	}

	var config = $.cookie = function (key, value, options) {

		// write
		if (value !== undefined) {
			options = $.extend({}, config.defaults, options);

			if (value === null) {
				options.expires = -1;
			}

			if (typeof options.expires === 'number') {
				var days = options.expires, t = options.expires = new Date();
				t.setDate(t.getDate() + days);
			}

			value = config.json ? JSON.stringify(value) : String(value);

			return (document.cookie = [
				encodeURIComponent(key), '=', config.raw ? value : encodeURIComponent(value),
				options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
				options.path    ? '; path=' + options.path : '',
				options.domain  ? '; domain=' + options.domain : '',
				options.secure  ? '; secure' : ''
			].join(''));
		}

		// read
		var decode = config.raw ? raw : decoded;
		var cookies = document.cookie.split('; ');
		for (var i = 0, l = cookies.length; i < l; i++) {
			var parts = cookies[i].split('=');
			if (decode(parts.shift()) === key) {
				var cookie = decode(parts.join('='));
				return config.json ? JSON.parse(cookie) : cookie;
			}
		}

		return null;
	};

	config.defaults = {};

	$.removeCookie = function (key, options) {
		if ($.cookie(key) !== null) {
			$.cookie(key, null, options);
			return true;
		}
		return false;
	};

})(jQuery, document);


function scrolls(id,dir){
    this.id = id; // id的对象的id
    this.dir = dir; //方向 "up","down","left","right"
    //this.dec; //方向决定 代表的scrollLeft,scrollTop
    this.h; //子层高度
    this.w; //子层宽度
    var pro;
}
scrolls.prototype = {
    addNodes : function (){ //在主层下添加复制元素
        //var p = id;
        var _this = this;
        var c = document.createElement("div");//子层
        var c1 = document.createElement("div");//双子层 1
        var c2 = document.createElement("div");//双子层 2
        var dir = _this.getDirection();
        if(this.dir == "err")
        {
            alert("方向参数错误!");
            return false;
        }
        //定死外框高度宽度
        _this.$(_this.id).style.height = _this.$(_this.id).offsetHeight + "px";
        _this.$(_this.id).style.width = _this.$(_this.id).offsetWidth + "px";
        c1.innerHTML = _this.$(_this.id).innerHTML;//复制层内的节点
        c2 = c1.cloneNode(true);//双子层2
        _this.$(_this.id).appendChild(c1);
        _this.$(_this.id).appendChild(c2);
        if(dir == "ud")//设置样式
        {
            _this.h = c1.offsetHeight > _this.$(_this.id).offsetHeight ? c1.offsetHeight : _this.$(_this.id).offsetHeight ;
            _this.w = _this.$(_this.id).offsetWidth;
            c1.style.cssText = "float:left;width:" + _this.w +"px;height:" + _this.h + "px;"
            c2.style.cssText = c1.style.cssText;
            c.style.cssText = "width:" + c1.offsetWidth + "px;height:"+ c1.offsetHeight*2 +"px;overflow:hidden;margin:0px;padding:0px;border-width:0px;"
        }
        else
        {
            _this.w = c1.offsetWidth > _this.$(_this.id).offsetWidth ? c1.offsetWidth : _this.$(_this.id).offsetWidth;
            _this.h = _this.$(_this.id).offsetHeight;
            c1.style.cssText = "float:left;width:" + _this.w +"px;height:" + _this.h + "px;"
            c2.style.cssText = c1.style.cssText;
            c.style.cssText = "width:" + (c1.offsetWidth*2) + "px;height:"+ c1.offsetWidth +"px;overflow:auto;margin:0px;padding:0px;border-width:0px;"
        }
        c.appendChild(c1);
        c.appendChild(c2);
        var pc = _this.$(_this.id).childNodes;
        for(var i = 0 ; i < pc.length ; i++)
        {
            pc[i].removeNode;
            _this.$(_this.id).removeChild(pc[i]);
        }
        _this.$(_this.id).innerHTML = "";
        _this.$(_this.id).appendChild(c);
        _this.maxSize = _this.getDirection() == "lr" ? _this.$(_this.id).getElementsByTagName("div")[0].offsetWidth/2 : _this.$(_this.id).getElementsByTagName("div")[0].offsetHeight/2;
        //alert(maxSize);
        _this.dec = _this.getDirection()=="lr" ? _this.$(_this.id).scrollLeft : _this.$(_this.id).scrollTop;
    //alert(_this.$(id).scrollWidth);
    //_this.$(id).scrollTop =20;
    },
    scrollPro:function(){
        var _this = this;
        //alert(_this.dir)
        switch(_this.dir){
            case "up" :
                _this.pro = setInterval(function(){
                _this.scrollUp()
                },50);
            break;
            case "down" :
                _this.pro = setInterval(function(){
                _this.scrollDown()
                },50);
            break;
            case "left" :
                _this.pro = setInterval(function(){
                _this.scrollLeft()
                },50);
            break;
            case "right" :
                _this.pro =setInterval(function(){
                _this.scrollRight()
                },50);
            break;
        }
        _this.$(_this.id).onmouseover = function(){
            clearTimeout(_this.pro)
            };
        _this.$(_this.id).onmouseout = function(){
            switch(_this.dir){
                case "up" :
                    _this.pro = setInterval(function(){
                    _this.scrollUp()
                    },50);
                break;
                case "down" :
                    _this.pro = setInterval(function(){
                    _this.scrollDown()
                    },50);
                break;
                case "left" :
                    _this.pro = setInterval(function(){
                    _this.scrollLeft()
                    },50);
                break;
                case "right" :
                    _this.pro =setInterval(function(){
                    _this.scrollRight()
                    },50);
                break;
            }
        }
    },
    scrollUp:function(){
        var _this = this;
        //alert(_this.$(_this.id).scrollTop);
        //alert(_this.maxSize);
        if(_this.$(this.id).scrollTop < _this.maxSize)
        {
            _this.$(this.id).scrollTop++;
        }
        else
        {
            _this.$(this.id).scrollTop = 0;
        }
    },
    scrollDown:function(){
        var _this = this;
        //alert(_this.$(_this.id).scrollTop);
        //alert(_this.maxSize);
        if(_this.$(this.id).scrollTop <= 0)
        {
            _this.$(this.id).scrollTop = _this.maxSize;
        }
        else
        {
            _this.$(this.id).scrollTop--;
        }
    },
    scrollRight:function(){
        var _this = this;
        //alert(_this.$(_this.id).scrollTop);
        //alert(_this.maxSize);
        if(_this.$(this.id).scrollLeft <= 0)
        {
            _this.$(this.id).scrollLeft = _this.maxSize;
        }
        else
        {
            _this.$(this.id).scrollLeft--;
        }
    },
    scrollLeft:function(){
        var _this = this;
        if(_this.$(this.id).scrollLeft < _this.maxSize)
        {
            _this.$(this.id).scrollLeft++;
        }
        else
        {
            _this.$(this.id).scrollLeft = 0;
        }
    },
    $:function (o){ //获取对象
        if(typeof(o) == "string")
        {
            if(document.getElementById(o))
            {
                return document.getElementById(o);
            }
            else
            {
                alert("err" + "\"o" + "\"");
                return false;
            }
        }
        else
        {
            return o;
        }
    },
    getDirection : function(){ //获取方向
        switch(this.dir){
            case "up" :
                return "ud" ;
                break;
            case "down" :
                return "ud" ;
                break;
            case "left" :
                return "lr" ;
                break;
            case "right" :
                return "lr" ;
                break;
            default :
                return "err";
        }
    }
}
