CREATE TABLE [dbo].[kw_checkday] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [checkday] [datetime] NULL
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_admin] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [username] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [userpsd] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [userflag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_dl] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [dalei] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [dldm] [int] NULL
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_hd] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [wtans] [ntext] COLLATE Chinese_PRC_CI_AS NOT NULL ,
        [userid] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [usertx] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [hdtime] [datetime] NULL ,
        [zt] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [hdques] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_user] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [userpass] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [userques] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [useranse] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [usermail] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [regtime] [datetime] NULL ,
        [lasttime] [datetime] NULL ,
        [jifen] [int] NULL ,
        [dengji] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [bcn] [int] NULL ,
        [pic] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [sex] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [realname] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [birthday] [datetime] NULL ,
        [country] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [blood] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [city] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [zhiye] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [xueli] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [images] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [tel] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [mail] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [QQ] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [MSN] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [address] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [userinfo] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
        [openp] [int] NULL ,
        [zhuan] [int] NULL ,
        [zhuan_dl] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
        [zhuan_xl] [nvarchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
        [mark] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [mark_logo] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
        [mark_url] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_wt] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [bt] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
        [nr] [ntext] COLLATE Chinese_PRC_CI_AS NOT NULL ,
        [dalei] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [xiaolei] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
        [userid] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NOT NULL ,
        [usertx] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [xsf] [int] NULL ,
        [zt] [int] NULL ,
        [twtime] [datetime] NULL ,
        [djs] [int] NULL ,
        [cn] [int] NULL ,
        [gq] [int] NULL ,
        [wt_filename] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [checkp] [int] NULL ,
        [strong] [int] NULL ,
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[kw_xl] (
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [xiaolei] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [dalei] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
        [xldm] [int] NULL
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[kw_dl] WITH NOCHECK ADD 
	CONSTRAINT [DF_kw_dl_dldm] DEFAULT (0) FOR [dldm]
GO

ALTER TABLE [dbo].[kw_user] WITH NOCHECK ADD 
	CONSTRAINT [DF_kw_user_jifen] DEFAULT (0) FOR [jifen] ,
        CONSTRAINT [DF_kw_user_bcn] DEFAULT (0) FOR [bcn] ,
        CONSTRAINT [DF_kw_user_pic] DEFAULT ('pic/1.gif') FOR [pic] ,
        CONSTRAINT [DF_kw_user_images] DEFAULT ('images/userface/image1.gif') FOR [images] ,
        CONSTRAINT [DF_kw_user_openp] DEFAULT (1) FOR [openp] ,
        CONSTRAINT [DF_kw_user_zhuan] DEFAULT (0) FOR [zhuan]
GO

ALTER TABLE [dbo].[kw_wt] WITH NOCHECK ADD 
	CONSTRAINT [DF_kw_wt_xsf] DEFAULT (0) FOR [xsf] ,
        CONSTRAINT [DF_kw_wt_zt] DEFAULT (0) FOR [zt] ,
        CONSTRAINT [DF_kw_wt_djs] DEFAULT (0) FOR [djs] ,
        CONSTRAINT [DF_kw_wt_cn] DEFAULT (0) FOR [cn] ,
        CONSTRAINT [DF_kw_wt_gq] DEFAULT (1) FOR [gq] ,
        CONSTRAINT [DF_kw_wt_checkp] DEFAULT (0) FOR [checkp] ,
        CONSTRAINT [DF_kw_wt_strong] DEFAULT (0) FOR [strong]
GO

ALTER TABLE [dbo].[kw_xl] WITH NOCHECK ADD 
	CONSTRAINT [DF_kw_xl_xldm] DEFAULT (0) FOR [xldm]
GO

ALTER TABLE [dbo].[kw_checkday] WITH NOCHECK ADD 
	CONSTRAINT [PK_checkday] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_admin] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_admin] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_dl] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_dl] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_hd] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_hd] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_user] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_user] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_wt] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_wt] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[kw_xl] WITH NOCHECK ADD 
	CONSTRAINT [PK_kw_xl] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

Insert Into kw_checkday (checkday)  Values ( getdate() )

Insert Into kw_admin (username,userpsd,userflag)  Values ( 'admin','469e80d32c0559f8','Ա' )