/**
* FD.widget.Scroll
*
* 
* ƣ
* 		1container һ<ul>
* 		2js/core/fdev.jsjs/core/yui/animation-min.jsjsļ
* ÷
* 		
*		<ul id="scroll1">
*			<li><a href="#">11111</a></li>
*			<li><a href="#">22222</a></li>
*			<li><a href="#">33333</a></li>
*		</ul>
*		
*		<script type="text/javascript">
*			FD.widget.Scroll.init('scroll1',{});
*		</script>
*
* @author 	yaosl<happyyaosl@gmail.com>
* @link    http://www.fdev-lib.cn/
*/
FD.widget.Scroll = new function() {
var defConfig = {
delay: 2,
speed: 20,
startDelay: 2,
direction: 'vertical',	/* 'horizontal(h)' or 'vertical(v)'. defaults to vertical. */
disableAutoPlay: false,
distance: 'auto',
scrollItemCount: 1  	/* ͬһйliĬ1 */
}
/**
* decorate ʼ
* @param {Object} container һul
* @param {Object} config
*/
this.init = function(container, config) {
container = $(container);
config = FD.common.applyIf(config||{}, defConfig);
var step = 2;
if (config.speed < 20) {
step = 5;
}
if (config.lineHeight) {
config.distance = config.lineHeight;
}
var scrollTimeId = null, startTimeId = null, startDelayTimeId = null;
/* Ƿ */
var isHorizontal = (config.direction.toLowerCase() == 'horizontal') || (config.direction.toLowerCase() == 'h');
/* ظߵĿֻԵ߿ɼķ/ */
var handle = {};
handle._distance = 0;
/* ռܷ񻹿Թ */
handle.scrollable = true;
/* Ԥƹľ */
handle.distance = config.distance;
/* ÿιľ */
handle._distance = 0;
/* ƶȥʱͣ */
handle.suspend = false;
/* ͣ */
handle.paused = false;
/* ڲʹ¼ */
var _onScrollEvent = new $Y.CustomEvent("_onScroll", handle, false, $Y.CustomEvent.FLAT);
_onScrollEvent.subscribe(function() {
var curLi = container.getElementsByTagName('li')[0];
if (!curLi) {
this.scrollable = false;
return;
}
this.distance = (config.distance == 'auto')?curLi[isHorizontal?'offsetWidth':'offsetHeight']:config.distance;
with(container) {
if (isHorizontal)
this.scrollable = (scrollWidth - scrollLeft - offsetWidth) >= this.distance;
else
this.scrollable = (scrollHeight - scrollTop - offsetHeight) >= this.distance;
}
});
/* ¼ */
var onScrollEvent = new $Y.CustomEvent("onScroll", handle, false, $Y.CustomEvent.FLAT);
if (config.onScroll) {
onScrollEvent.subscribe(config.onScroll);
} else {
onScrollEvent.subscribe(function() {
for (var i = 0; i < config.scrollItemCount; i++) {
container.appendChild(container.getElementsByTagName('li')[0]);
}
container[isHorizontal?'scrollLeft':'scrollTop'] = 0;
});
}
var scroll = function() {
if (handle.suspend) return;
handle._distance += step;
var _d;
if ((_d = handle._distance % handle.distance) < step) {
container[isHorizontal?'scrollLeft':'scrollTop'] += (step - _d);
clearInterval(scrollTimeId);
onScrollEvent.fire();
_onScrollEvent.fire();
startTimeId = null;
if (handle.scrollable && !handle.paused) handle.play();
}else{
container[isHorizontal?'scrollLeft':'scrollTop'] += step;
}
}
var start = function() {
if (handle.paused) return;
handle._distance = 0;
scrollTimeId = setInterval(scroll, config.speed);
}
$E.on(container, 'mouseover', function(){handle.suspend=true;});
$E.on(container, 'mouseout', function(){handle.suspend=false;});
FD.common.apply(handle, {
subscribeOnScroll: function(func, override) {
if (override === true && onScrollEvent.subscribers.length > 0)
onScrollEvent.unsubscribeAll();
onScrollEvent.subscribe(func);
},
pause: function() {
this.paused = true;
clearTimeout(startTimeId);
startTimeId = null;
},
play: function() {
this.paused = false;
if (startDelayTimeId) {clearTimeout(startDelayTimeId);}
if (!startTimeId) {
startTimeId = setTimeout(start, config.delay*1000);
}
}
});
handle.onScroll = handle.subscribeOnScroll;
/** ʼƶ벢жǷɹ */
_onScrollEvent.fire();
/** Զʼ */
if (!config.disableAutoPlay) {
startDelayTimeId = setTimeout(function(){handle.play();}, config.startDelay*1000);
}
return handle;
}
};
