﻿//---------------------------------------------------------
// 双鱼文本编辑器 PiscesTextEditor V1.2
// 作者：月伤 melody
// 作品链接：http://www.2fstory.net/blog/View.aspx?blogID=47
//---------------------------------------------------------

<!-- 常量 -->
var tabKey = 9;		// Tab键
var enterKey = 13;	// Enter键

<!-- 按钮定义 -->
var isAutoForeColor = true;
var isAutoBackColor = false;
var oldClass = 'TextEdit_ButtonNomal';		// 以前按钮的风格，用于记录按钮MouseOver之前的状态

<!-- 初始化 -->
var TextEdit_HtmlMode = "design";	// 编辑模式

var editor = TextEdit_Editor;		// 编辑器
var htmlbox = document.getElementById('TextEdit');				// html代码框
var previewbox = TextEdit_Preview;	// 预览框
var toolbar = document.getElementById('TextEdit_Toolbar');		// 工具条
var screenmode = document.getElementById('ScreenMode');		// 全屏模式图片
TextEdit_Initialize(editor, htmlbox, previewbox); 
TextEdit_ApplyEditorStyles(editor);
TextEdit_Preview.document.designMode = "Off";
TextEdit_Preview.document.open();
TextEdit_Preview.document.close();
TextEdit_ApplyEditorStyles(previewbox);

// 初始化
function TextEdit_Initialize(editor, htmlbox, previewbox) {
	editor.document.designMode = "On";
	editor.document.open();
	editor.document.write(htmlbox.value);
	editor.document.close();
	editor.document.body.contentEditable = "True";
    editor.document.oncontextmenu = function() { editor.event.returnValue = false; };
	editor.document.onkeydown = function() { TextEdit_Editor_onKeyDown( htmlbox); };
	htmlbox.onkeydown = function() { ChangeMode_onKeyDown( htmlbox, previewbox, window,"preview"); };
	htmlbox.onkeypress = function() { GetWordCount(htmlbox); };
	previewbox.onkeydown = function() { ChangeMode_onKeyDown( htmlbox, previewbox, previewbox,"design"); };
	editor.document.onselectionchange = function() { GetSelectedRangeState(); };
	
	ExecCmd("2D-Position",true);
}
// 设置iframe控件中的body样式
function TextEdit_ApplyEditorStyles(iframe) {
	iframe.document.createStyleSheet("");
	iframe.document.styleSheets[0].addRule("p","margin-top:0px;margin-bottom:0px;");
	iframe.document.styleSheets[0].addRule("div","border: 2px solid #00CCFF;");
	bs = iframe.document.body.style;
	bs.margin = "5";
	bs.scrollbar3dLightColor = "#D4D0C8";
	bs.scrollbarArrowColor = "#000000";
	bs.scrollbarBaseColor = "#D4D0C8";
	bs.scrollbarDarkShadowColor = "#D4D0C8";
	bs.scrollbarFaceColor = "#D4D0C8";
	bs.scrollbarHighlightColor = "#808080";
	bs.scrollbarShadowColor = "#808080";
	bs.scrollbarTrackColor = "#D4D0C8";
	bs.border = "0";
}
// 同时按下tab+ctrl切换视图模式
function ChangeMode_onKeyDown( htmlbox, previewbox, win, mode){
	if (win.event.keyCode == tabKey && win.event.ctrlKey) {
		win.event.returnValue = false;
		TextEdit_ChangeMode( htmlbox, previewbox, mode);
		win.focus();
	}
}
// 编辑窗口的按下事件
function TextEdit_Editor_onKeyDown( htmlbox) {
	var _QUOTE = 222;
	var _OPENCURLY = "&#8220;";
	var _CLOSECURLY = "&#8221;";
	// 切换模式 (Ctrl+TAB)
	if (editor.event.keyCode==tabKey && !editor.event.ctrlKey) {
		editor.event.returnValue = false;
		editor.document.selection.createRange().pasteHTML("&nbsp;&nbsp;&nbsp;&nbsp;");
	}
	CopyToHtmlBox(htmlbox);
	if (editor.event.keyCode == _QUOTE && editor.event.shiftKey) {
		var sel = editor.document.selection;
		if (sel.type == "Control") return;
		var r = sel.createRange();
		var before = CharBefore(r);
		var after = CharAfter(r);
		var r = sel.createRange();

		if (before == "start") {
			r.pasteHTML(_OPENCURLY);
			editor.event.cancelBubble = true;
			editor.event.returnValue = false;
			return false;
		} else if (before != " " && after == "end") {
			r.pasteHTML(_CLOSECURLY);
			editor.event.cancelBubble = true;
			editor.event.returnValue = false;
			return false;
		} else if (before == " " && after == "end") {
			r.pasteHTML(_OPENCURLY);
			editor.event.cancelBubble = true;
			editor.event.returnValue = false;
			return false;
		} else if (before != " " && after == " ") {
			r.pasteHTML(_CLOSECURLY);
			editor.event.cancelBubble = true;
			editor.event.returnValue = false;
			return false;
		} else {
			r.pasteHTML(_OPENCURLY);
			editor.event.cancelBubble = true;
			editor.event.returnValue = false;
			return false;
		}
	}
}
// 切换编辑模式
function TextEdit_ChangeMode( htmlbox, previewbox, mode) {
	document.getElementById("TextEdit_Editor").style.display = (mode == "design") ? "block" : "none";
	htmlbox.style.display = (mode == "html") ? "block" : "none";
	document.getElementById(previewbox.name).style.display = (mode == "preview") ? "block" : "none";
	toolbar.style.display = (mode == "design") ? "inline" : "none";
	if (TextEdit_HtmlMode != mode) {
		switch (mode) {
			case "design":	// 转到设计模式
				editor.focus();
				editor.document.body.innerHTML = htmlbox.value;
				SetActiveTab(document.getElementById("TextEdit_DesignModeTab"));
				break;
			case "html":	// 转到代码模式
				htmlbox.focus();
				SetActiveTab(document.getElementById("TextEdit_HtmlModeTab"));
				CopyToHtmlBox(htmlbox);
				break;
			case "preview":	// 转到预览模式
				previewbox.focus();
				previewbox.document.body.innerHTML = htmlbox.value;
				SetActiveTab(document.getElementById("TextEdit_PreviewModeTab"));
				break;
		}
		TextEdit_HtmlMode = mode;
	}
}
// 将Html代码复制到代码框中
function CopyToHtmlBox(htmlbox) {
	htmlbox.value = editor.document.body.innerHTML;
	htmlbox.value = htmlbox.value.replace(/<p>&nbsp;<\/p>/gi,"<BR>");
	htmlbox.value = htmlbox.value.replace(/<p>(.*?)<\/p>/gi,"$1<BR>");
	GetWordCount(htmlbox);
}
// 获得当前选中对象的状态
function GetSelectedRangeState() {
	var range = editor.document.selection.createRange();
	var selectionType = editor.document.selection.type.toLowerCase();
	var isSelected = selectionType == "control" || (selectionType == "text" && range.text.length > 0);
	document.getElementById("btnCut").style.filter = isSelected ? "" : "gray()";
	document.getElementById("btnCopy").style.filter = isSelected ? "" : "gray()";
	document.getElementById("btnPaste").style.filter = (clipboardData.getData('Text') != null || clipboardData.getData('Url') != null) ? "" : "gray()";
	document.getElementById("btnDelete").style.filter = isSelected ? "" : "gray()";
	UpdateButtonState( document.getElementById("btnAlignRight"), "JustifyRight");
	UpdateButtonState( document.getElementById("btnAlignCenter"), "JustifyCenter");
	UpdateButtonState( document.getElementById("btnAlignFull"), "JustifyFull");
	UpdateButtonState( document.getElementById("btnCreateLink"), "CreateLink");
	UpdateButtonState( document.getElementById("btnUnLink"), "UnLink");
	UpdateButtonState( document.getElementById("btnItalic"), "Italic");
	UpdateButtonState( document.getElementById("btnBold"), "Bold");
	UpdateButtonState( document.getElementById("btnUnderLine"), "UnderLine");
	UpdateButtonState( document.getElementById("btnStrikeThrough"), "StrikeThrough");
	UpdateButtonState( document.getElementById("btnInsertOrderedList"), "InsertOrderedList");
	UpdateButtonState( document.getElementById("btnInsertUnorderedList"), "InsertUnorderedList");
	UpdateButtonState( document.getElementById("btnSuperScript"), "SuperScript");
	UpdateButtonState( document.getElementById("btnSubScript"), "SubScript");
	document.getElementById("btnSelectAll").className = (selectionType == "text" && range.isEqual(editor.document.body.createTextRange())) ? "TextEdit_ButtonDown" : "TextEdit_ButtonNormal";
	
}
// 更新当前TD的ClassName
function UpdateButtonState( td, cmd) {
	var range = editor.document.selection.createRange();
	td.className = (range.queryCommandState(cmd)) ? "TextEdit_ButtonDown" : "TextEdit_ButtonNormal";
}
<!-- 工具栏 -->
// 保存
function Save(htmlbox) {
	//CopyToHtmlBox(htmlbox);
	ExecCmd("SaveAs",false,"C:\\code.htm");
}
// 全屏编辑
function FullScreen() {
	var btnScreenMode = document.getElementById("ScreenMode");
	if (EditDiv.style.position == "relative") {
		//window.scrollTo(0,0);
		document.body.scroll = "no";
		EditDiv.style.position = "absolute";
		EditDiv.style.zindex = "100";
		EditDiv.style.left = document.body.scrollLeft;		
		EditDiv.style.top = document.body.scrollTop;
		EditTable.style.width = document.body.clientWidth;
		EditTable.style.height = document.body.clientHeight;
		oldClass = "TextEdit_ButtonDown";
	}
	else {
		document.body.scroll = "yes";
		EditDiv.style.position = "relative";
		EditDiv.style.zindex = "0";
		EditDiv.style.left = "0";
		EditDiv.style.top = "0";
		EditTable.style.width = "100%";
		EditTable.style.height = "100%";
		oldClass = "TextEdit_ButtonNormal";
	}
}
// 全选
function SelectAll() {
	if (oldClass == "TextEdit_ButtonNormal") {
		oldClass = "TextEdit_ButtonDown";
		ExecCmd("selectall",null);
	}
	else {
		oldClass = "TextEdit_ButtonNormal";
		ExecCmd("Unselect", null);
	}
}
// 设置段落
function SetParagraph(controlName,value,text) {
	ExecCmd("formatBlock",value);
	document.getElementById(controlName).style.display='none';
	document.getElementById('currentParagraph').innerHTML = text;
}
// 设置字体
function SetFontName(controlName, name) {
	ExecCmd('fontname',name);
	document.getElementById(controlName).style.display='none';
	document.getElementById('currentfontname').innerHTML = name;
}
// 设置字号
function SetFontSize(controlName, size) {
	ExecCmd('fontsize',size);
	document.getElementById(controlName).style.display='none';
	document.getElementById('currentfontsize').innerHTML = size;
}
// 调用document.execCommand命令
function ExecCmd(param, value) {
	editor.focus();
	editor.document.execCommand(param,"",value); 
}
// 前景色
function ForeColor( color) {
	var range = editor.document.selection.createRange();
	range.pasteHTML("<span style=\"color:"+color+";\">"+range.text+"</span>");
}
// 设置前景色
function SetForeColor(color) {
	var colorsArray = new Array(
				"#000000","#993300","#333300","#003300","#003366","#000080","#333399","#333333",
				"#800000","#FF6600","#808000","#008000","#008080","#0000FF","#666699","#808080",
				"#FF0000","#FF9900","#99CC00","#339966","#33CCCC","#3366FF","#800080","#999999",
				"#FF00FF","#FFCC00","#FFFF00","#00FF00","#00FFFF","#00CCFF","#993366","#C0C0C0",
				"#FF99CC","#FFCC99","#FFFF99","#CCFFCC","#CCFFFF","#99CCFF","#CC99FF","#FFFFFF");
	var edgeColor = "#AAAAAA";
	var autoStyle = (isAutoForeColor) ? 'TextEdit_ButtonDown' : 'TextEdit_ButtonNormal';

	var str = "";
	str += "<table cellpadding='0' cellspacing='0' style='display:inline;border-top: 1px solid "+edgeColor+";"+
			"border-left: 1px solid "+edgeColor+";border-right: 1px solid "+edgeColor+";border-bottom:0px;'>"+
			"<tr><td width='29' height='20'></td></tr></table>"+
			"<table width='121' cellpadding='0' cellspacing='0' border='0' style='display:inline;' bgcolor='#0f0f0f'>"+
			"<tr><td height='1' bgcolor='"+edgeColor+"'></td></tr></table>"+
			"<table cellpadding='0' cellspacing='0' height='122' border='0' style='display:block;'>"+
			"<tr><td height='122' style='border-left: 1px solid "+edgeColor+";"+
			"border-right: 1px solid "+edgeColor+"; border-bottom: 1px solid "+edgeColor+"'>"+
			"<table cellpadding='0' cellspacing='3' style='background-color:#FFFFFF;'>"+
			"<tr><td width='100%' height='7'><img src='PiscesTextEditor/images/colorpickettitle.gif' border='0' /></td></tr><tr>"+
			"<td height='22' class='"+autoStyle+"' onmouseover='ButtonOver(this);'"+
			" onmouseout='ButtonOut(this);' onmousedown='SetColor(\"#000000\",\"ForeColor\",\"forecolor\",\"forecolorpicket\");'>"+
			"<table cellpadding='0' cellspacing='0' width='100%' style='font-size:9pt;'><tr><td width='18' align='right'>"+
			"<table cellpadding='0' border='1' cellspacing='0' bgcolor='#000000'"+
			" bordercolor='"+edgeColor+"' width='11' height='11'><tr><td></td></tr></table>"+
			"</td><td height='16' style='padding-left:42px;'>自动</td></tr></table></td></tr>"+
			"<tr><td align='center'>" +
			"<table cellspacing='0' cellpadding='0' border='1' bordercolor='#FFFFFF' noWrap>"
	for (var i=0;i<5;i++) {
		str += "<tr>";
		for (var j=0;j<8;j++) {
			str += "<td width='13' height='13' style='padding: 1px;' align='center'";
			if (color == colorsArray[8*i+j])
				str += " class='TextEdit_ButtonDown'";
			str += " onmouseover='ButtonOver(this);' onmouseout='ButtonOut(this);' "+
					" onmousedown='SetColor(\""+colorsArray[8*i+j]+"\",\"ForeColor\",\"forecolor\",\"forecolorpicket\");'>"+
					"<table cellpadding='0' cellspacing='0' border='1' width='12' height='12' bordercolor='#CCCCCC'"+
					" style='background-color:"+colorsArray[8*i+j]+"'><tr><td></td></tr></table></td>";
		}
		str += "</tr>";
	}
	str += "</table></td></tr>"+
//			"<tr><td height='22' align='center' class='TextEdit_ButtonNormal'"+
//			" onmouseover='ButtonOver(this);' onmouseout='ButtonOut(this);'>"+
//			"<table cellpadding='0' cellspacing='0' width='100%' border='0' style='font-size:9pt;'>"+
//			"<tr><td align='center'>其它颜色...</td></tr></table></td></tr>"+
			"</table></td></tr></table>";
	var control = document.getElementById('forecolorpicket');
	control.style.display = 'block';
	control.innerHTML = str;
}
function SetColor(color,colorshow,colortype,colorpicket) {
	isAutoForeColor = false;
	isAutoBackColor = false;
	editor.document.execCommand(colortype,false,color);
	document.getElementById(colorshow).style.backgroundColor=color;
	document.getElementById(colorpicket).innerHTML = '';
	editor.focus();
}
// 背景色
function BackColor(color) {
	var range = editor.document.selection.createRange();
	range.pasteHTML("<span style=\"background-color:"+color+";\">"+range.text+"</span>");
}
// 设置背景色
function SetBackColor(color) {
	var colorsArray = new Array(
			"#ffff00","#00ff00","#00ffff","#ff00ff","#0000ff",
			"#ff0000","#000080","#008080","#008000","#800080",
			"#800000","#808000","#808080","#c0c0c0","#000000");
	var edgeColor = "#AAAAAA";
	var autoStyle = (isAutoBackColor) ? 'TextEdit_ButtonDown' : 'TextEdit_ButtonNormal';
	
	var str = "";
	str += "<table cellpadding='0' cellspacing='0' style='display:inline;border-top: 1px solid "+edgeColor+";"+
			"border-left: 1px solid "+edgeColor+";border-right: 1px solid "+edgeColor+";border-bottom:0px;'>"+
			"<tr><td width='29' height='20'></td></tr></table>"+
			"<table width='64' cellpadding='0' cellspacing='0' border='0' style='display:inline;' bgcolor='#0f0f0f'>"+
			"<tr><td height='1' bgcolor='"+edgeColor+"'></td></tr></table>"+
			"<table cellpadding='0' cellspacing='0' height='62' border='0' style='display:block;'>"+
			"<tr><td height='62' style='border-left: 1px solid "+edgeColor+";"+
			"border-right: 1px solid "+edgeColor+"; border-bottom: 1px solid "+edgeColor+"'>"+
			"<table cellpadding='0' cellspacing='3' style='background-color:#FFFFFF;'>"+
			"<tr><td height='22' class='"+autoStyle+"' align='center' onmouseover='ButtonOver(this);'"+
			" onmouseout='ButtonOut(this);'"+
			" onmousedown='SetColor(\"#FFFFFF\",\"BackColor\",\"backcolor\",\"backcolorpicket\");isAutoBackColor=true;'>"+
			"无</td></tr>"+
			"<tr><td align='center'>";	str += "<table cellspacing='0' border='1' bordercolor='#FFFFFF' noWrap>"
	for (var i=0;i<3;i++) {
		str += "<tr>";
		for (var j=0;j<5;j++) {
			str += "<td width='13' height='13' style='padding: 1px;' align='center'";
			if (color == colorsArray[5*i+j])
				str += " class='TextEdit_ButtonDown'";
			str += " onmouseover='ButtonOver(this);' onmouseout='ButtonOut(this);' "+
					" onmousedown='SetColor(\""+colorsArray[5*i+j]+"\",\"BackColor\",\"backcolor\",\"backcolorpicket\");'>"+
					"<table cellpadding='0' cellspacing='0' border='1' width='12' height='12' bordercolor='#CCCCCC'"+
					" style='background-color:"+colorsArray[5*i+j]+"'>"+
					"<tr><td></td></tr></table></td>";
		}
		str += "</tr>";
	}
	str += "</table></td></tr></table></td></tr></table>";
	var control = document.getElementById('backcolorpicket');
	control.style.display = "block";
	control.innerHTML = str;
}
// 设置对齐方式
function SetAlign(cmd) {
	editor.focus();
	var isDown= (oldClass == "TextEdit_ButtonDown");
	document.getElementById("btnAlignRight").className = "TextEdit_ButtonNormal";
	document.getElementById("btnAlignCenter").className = "TextEdit_ButtonNormal";
	document.getElementById("btnAlignFull").className = "TextEdit_ButtonNormal";
	oldClass = isDown ? "TextEdit_ButtonNormal" : "TextEdit_ButtonDown";
	if (oldClass == 'TextEdit_ButtonNormal')	
		ExecCmd("JustifyNone",null);
	else
		ExecCmd(cmd,null);
}
// 插入符号
function InsertSymbol( name) {
	editor.focus();
	var page = "PiscesTextEditor/specialchar.htm";
	var str = ShowDialog(page,window,'360','250');
	//editor.document.body.innerHTML = str;
	//range.contentHTML = str;
	OutputHTML( str);
}
// 插入表情
function InsertEmot(){
	editor.focus();
	var page = "PiscesTextEditor/emot.htm";
	var str = ShowDialog(page,window,'286','172');
	OutputHTML( str);
}
// 查找替换
function Replace() {
	editor.focus();
	var page = "PiscesTextEditor/replace.htm";
	ShowDialog(page,window,'285','152');
}
// 转换为大写字母
function UpperCase() {
	editor.focus();
	var range = editor.document.selection.createRange();
	range.pasteHTML(range.htmlText.toUpperCase());
}
// 转换为小写字母
function LowerCase() {
	editor.focus();
	var range = editor.document.selection.createRange();
	range.pasteHTML(range.htmlText.toLowerCase());
}
// 设置绝对位置
var isAbsolutePosition = false;
function SetAbsolutePosition() {
	editor.focus();
	isAbsolutePosition = !isAbsolutePosition;
	ExecCmd("AbsolutePosition",isAbsolutePosition)
}
// 建立超链接
function CreateLink() {
	editor.focus();
	var url;
	var selectionType = editor.document.selection.type.toLowerCase();
	if (selectionType != 'control') {
		if (editor.document.selection.createRange().htmlText.match(/<a .*?>(.*?)<\/a>/gi) != null) {
			url = editor.document.selection.createRange().htmlText.replace(/<a href="(.*?)">.*?<\/a>/gi,"$1");
		}
		else {
			url = "";
		}
		var str = ShowDialog("PiscesTextEditor/link.htm", url, "286","150");
		if (str != null){
			if (selectionType != "None") {
				editor.document.execCommand("createlink",false,str);
			}
			else {
				editor.document.selection.createRange().pasteHTML("<a href=\""+str+"\">"+str+"</a>");
			}
		}
	}
	else {
		var tag = editor.document.selection.createRange().item(0).tagName.toLowerCase();
		if (tag == "img") {
			var str = ShowDialog("PiscesTextEditor/link.htm", "", "286","130");
			editor.document.execCommand("createlink",false,str);
		}
	}
}
// 取消超链接
function UnLink() {
	editor.document.execCommand("unlink",true,null); 
}
function SetOrderedList( cmd) {
	var isDown= (oldClass == "TextEdit_ButtonDown");
	document.getElementById("btnInsertOrderedList").className = "TextEdit_ButtonNormal";
	document.getElementById("btnInsertUnorderedList").className = "TextEdit_ButtonNormal";
	oldClass = isDown ? "TextEdit_ButtonNormal" : "TextEdit_ButtonDown";
	ExecCmd(cmd, null);
}
// 插入图片
function InsertImage() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/image.htm", "", "438","394");
	OutputHTML( str);
}
// 插入今天日期
function InsertToday() {
	editor.focus();
	var now = new Date();
	var range = editor.document.selection.createRange();
	range.pasteHTML(now.getYear()+"年"+(now.getMonth()+1)+"月"+now.getDate()+"日");
}
// 插入现在时间
function InsertTime() {
	editor.focus();
	var now = new Date();
	var hour = now.getHours().toString();
	hour = (hour.length==1)?("0"+hour):hour;
	var minute = now.getMinutes().toString();
	minute = (minute.length==1)?("0"+minute):minute;
	var second = now.getSeconds().toString();
	second = (second.length==1)?("0"+second):second;
	var range = editor.document.selection.createRange();
	range.pasteHTML(hour+":"+minute+":"+second);
}
// 拼写检查
function IeSpellCheck() {
	try {
		var tspell = new ActiveXObject("ieSpell.ieSpellExtension");
		tspell.CheckAllLinkedDocuments(window.document);
	}
	catch (err){
		if (window.confirm("拼写检查插件还没安装，你是否想现在就下载？")){
			window.open("http://iespell.huhbw.com/ieSpellSetup220647.exe");}
	};
}
// 插入表格
function InsertTable() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/table.htm", window, '400','320');
	OutputHTML( str);
}
// 插入层
function InsertLayer() {
	editor.focus();
	var str = "<div style='WIDTH: 104px; POSITION: absolute; HEIGHT: 104px'>在这里输入文字</div>";
	var range = editor.document.selection.createRange();
	range.pasteHTML(str);
}
// 插入栏目框
function InsertFieldset() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/fieldset.htm", "", "350","190");
	OutputHTML( str);
}
// 插入网页
function InsertIframe() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/iframe.htm", window,'350','215');  
	var range = editor.document.selection.createRange();
	if (str != null) range.pasteHTML(str);
}
// 插入Flash
function InsertFlash() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/flash.htm", window, "320","190"); 
	OutputHTML( str);
}
// 插入mediaplayer
function InsertMediaPlayer() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/media.htm", "", "320", "160");
	OutputHTML( str);
}
// 插入realplayer
function InsertRealPlayer() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/real.htm", "", "320", "160");  
	OutputHTML( str);
}
// 插入代码
function InsertCode() {
	editor.focus();
	var str = ShowDialog("PiscesTextEditor/InsertCode.htm",window,"510","450");
	OutputHTML( str);
}
// 帮助
function Help() {
	window.ShowDialog("PiscesTextEditor/help.htm",window,'400','230');
}

<!-- 工具栏风格 -->
function ButtonOver(theTD) {
	oldClass = theTD.className;
	theTD.className = "TextEdit_ButtonOver";
}
function ButtonOut(theTD) {
	theTD.className = oldClass;
}
function ButtonDown(theTD) {
	theTD.className = "TextEdit_ButtonDown";
}
function ButtonSelect(theTD) {
	oldClass = (oldClass == "TextEdit_ButtonDown") ? "TextEdit_ButtonNormal" : "TextEdit_ButtonDown";
	document.body.style.cursor = "default";
	theTD.className = "TextEdit_ButtonDown";
}

<!-- 显示模式菜单 -->
function SetActiveTab(theTD) {
	var parentTR = theTD.parentElement;
	for (var i=0;i<5;i++) {
		if (parentTR.cells[i].className == "TextEdit_TabOn")
			parentTR.cells[i].className = "TextEdit_TabOff";
	}
	theTD.className = "TextEdit_TabOn";
}
function TabOver() { document.body.style.cursor="hand"; }
function TabOut() { document.body.style.cursor="auto"; }
function CheckTag(item,tagName) {
	if (item.tagName.search(tagName)!=-1) {
		return item;
	}
	if (item.tagName=="BODY") {
		return false;
	}
	item=item.parentElement;
	return CheckTag(item,tagName);
}
function CharBefore(sel) {
	if (sel.move("character",-1) == -1) {
		sel.expand("character");
		return sel.text;
	} else {
		return "start";
	}
}
function CharAfter(sel) {
	var sel2 = sel;
	if (sel.expand("character")) {
		sel2.move("character",1);
		sel2.expand("character");
		return sel2.text;
	} else {
		return "end";
	}
}

<!--公共函数-->
// 统计文本框中的总字数
function GetWordCount(htmlbox) {
	totalchars.innerHTML = htmlbox.value.toString().length;
}
//
function GetClassSubName(className) {
	underscore = className.indexOf("_");
	if (underscore < 0) return className;
	return className.substring(underscore+1);
}
// 显示窗口，用于兼容IE和FireFox
function ShowDialog(url,name,width,height) {
	var browser = window.navigator.userAgent.toLowerCase();
	var returnValue = null;
	if (browser.indexOf("msie") != -1) {
		returnValue = window.showModalDialog(url,name,"dialogWidth:"+width+"px;dialogHeight:"+height+"px;"+			
					"status:no;scroll:no;help:no;resizable:no;");
	}
	else if (browser.indexOf("firefox") != -1) {
		window.open(url,"ShowDialog","width="+width+"px,height="+height+"px,"+
					"fullscreen=no,location=no,resizable=no,scrollbars=no,status=no,titlebar=no,toolbar=no,");
	}
	return returnValue;
}
// 输出窗口返回的代码
function OutputHTML( str) {
	var range = GetSelection(editor);
	if (str!=null) range.pasteHTML(str);
}
// 获得编辑器中选中的对象
function GetSelection(win) {
	var str = "";
	if (win.getSelection)
		str = win.getSelection().getRangeAt(0);
	else if (win.document.getSelection)
		str = win.document.getSelection();
	else if (win.document.selection)
		str = win.document.selection.createRange();
	return str;
}

// 计时器
var curTime = new Date(2000,1,1);
updateTimer();
function updateTimer() {
	curTime.setSeconds(curTime.getSeconds() + 1);
	document.getElementById("writetime").innerText = curTime.toLocaleTimeString();
	window.setTimeout("updateTimer();",1000);
}