<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:newasp="#newasp-functions" exclude-result-prefixes="msxsl newasp">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=0"><xsl:call-template name="showPageList_1"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="showPageList_2"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<!--#ASP̬ҳҳ-->
<xsl:template name="showPageList_1">
	<b><xsl:value-of select="/xml/@totalrec"/></b>/ÿҳ<b><xsl:value-of select="/xml/@pagesize"/></b>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			<kbd class="disable"><a href="{/xml/@link}page=1">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
			<a href="{/xml/@link}page=1" class="active">1</a> 
		</xsl:when>
		<xsl:otherwise>
			<kbd><a href="{/xml/@link}page={/xml/@pagenow - 1}">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
			<a href="{/xml/@link}page=1">1</a>
		</xsl:otherwise>
	</xsl:choose>
	
	<xsl:if test="/xml/@n &gt; 2 and /xml/@pagecount &gt; /xml/@max"><i>...</i></xsl:if>

	<xsl:for-each select="xml/datalist/row">
		<xsl:choose>
			<xsl:when test="/xml/@pagenow = @i">
				<a href="{/xml/@link}page={@i}" class="active"><xsl:value-of select="@i"/></a> 
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@s = 0">
						<!--a href="javascript:;"><xsl:value-of select="@i"/></a--> 
					</xsl:when>
					<xsl:otherwise>
						<a href="{/xml/@link}page={@i}"><xsl:value-of select="@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	
	<xsl:if test="/xml/@pagecount &gt; /xml/@i"><i>...</i></xsl:if>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount">
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{/xml/@link}page={/xml/@pagecount}" class="active"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			<dfn class="disable"><a href="{/xml/@link}page={/xml/@pagecount}">һҳ</a></dfn> 
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{/xml/@link}page={/xml/@pagecount}"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			<dfn><a href="{/xml/@link}page={/xml/@pagenow + 1}">һҳ</a></dfn>
		</xsl:otherwise>
	</xsl:choose>
	<input type="text" title="֣سת" size="3" onkeydown="if (13==event.keyCode) document.location.href='{/xml/@link}page='+this.value" value="{/xml/@pagenow}" />
</xsl:template>
<!--#̬HTMLҳ-->
<xsl:template name="showPageList_2">
	<script type="text/javascript">var strPageLinks='<xsl:value-of select="/xml/@link"/>';</script>
	<b><xsl:value-of select="/xml/@totalrec"/></b><b><xsl:value-of select="/xml/@pagesize"/></b>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow=1">
			<kbd class="disable"><a href="{newasp:ReplaceString(string(/xml/@link),1)}">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
			<a href="{newasp:ReplaceString(string(/xml/@link),1)}" class="active">1</a> 
		</xsl:when>
		<xsl:otherwise>
			<kbd><a href="{newasp:ReplaceString(string(/xml/@link),/xml/@pagenow - 1)}">һҳ</a></kbd>
			<xsl:text disable-output-escaping="yes"><![CDATA[<code>]]></xsl:text>
			<a href="{newasp:ReplaceString(string(/xml/@link),1)}">1</a>
		</xsl:otherwise>
	</xsl:choose>
	
	<xsl:if test="/xml/@n &gt; 2 and /xml/@pagecount &gt; /xml/@max"><i>...</i></xsl:if>

	<xsl:for-each select="xml/datalist/row">
		<xsl:choose>
			<xsl:when test="/xml/@pagenow = @i">
				<a href="{newasp:ReplaceString(string(/xml/@link),number(@i))}" class="active"><xsl:value-of select="@i"/></a> 
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@s = 0">
						<!--a href="javascript:;"><xsl:value-of select="@i"/></a--> 
					</xsl:when>
					<xsl:otherwise>
						<a href="{newasp:ReplaceString(string(/xml/@link),number(@i))}"><xsl:value-of select="@i"/></a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
	
	<xsl:if test="/xml/@pagecount &gt; /xml/@i"><i>...</i></xsl:if>
	<xsl:choose>
		<xsl:when test="/xml/@pagenow &gt;= /xml/@pagecount">
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagecount))}" class="active"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			<dfn class="disable"><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagecount))}">һҳ</a></dfn> 
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="/xml/@pagecount &gt; 9"><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagecount))}"><xsl:value-of select="/xml/@pagecount"/></a></xsl:if>
			<xsl:text disable-output-escaping="yes"><![CDATA[</code>]]></xsl:text>
			<dfn><a href="{newasp:ReplaceString(string(/xml/@link),number(/xml/@pagenow + 1))}">һҳ</a></dfn>
		</xsl:otherwise>
	</xsl:choose>
	<input type="text" title="֣سת" size="3" onkeydown="if (13==event.keyCode) document.location.href=strPageLinks.replace(/\[page\]/ig,this.value)" value="{/xml/@pagenow}" />
</xsl:template>

<msxsl:script language="VBScript" implements-prefix="newasp" xmlns:msxsl="urn:schemas-microsoft-com:xslt"><![CDATA[							
	Option Explicit
	
	Function ReplaceString(strValue,i)
		ReplaceString = Replace(strValue, "[page]", i)
	End Function

	Function ReplaceChar(nodelist,strValue,i)
		strValue=GetValue(nodelist,strValue)
		ReplaceChar = Replace(strValue, "[page]", i)
	End Function

	Function GetValue(nodelist,strRef)
		Dim objNode
		Set objNode = nodelist.item(0).selectSingleNode(strRef)
		GetValue = objNode.text
		Set objNode = Nothing
	End Function
]]>
</msxsl:script>

</xsl:stylesheet>