<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.cn Sunwin
	-->
<xsl:variable name="nowuserid">
	<xsl:value-of select="xml/@userid" disable-output-escaping="yes"/>
</xsl:variable>
<xsl:variable name="askedtitle">
	<xsl:value-of select="xml/topic/@title" disable-output-escaping="yes"/>
</xsl:variable>
<xsl:template match="/">
	<iframe name="_hideframe" style="display:none;"></iframe>
	<xsl:if test="/xml/postlist/row/@postsmode='0'">
		<xsl:call-template name="post_question"/>
	</xsl:if>
	<xsl:if test="/xml/@nowpostnum &gt; 0">
		<xsl:call-template name="post_answer"/>
	</xsl:if>
	<xsl:if test="/xml/@allowanswers='1'">
		<xsl:call-template name="post_answerform"/>
	</xsl:if>
</xsl:template>
<xsl:template name="post_question">
	<xsl:for-each select="xml/postlist/row[@postsmode=0]">
	<div id="mainTopicZone">
		<h2><span class="headline"><img src="{$installdir}images/icons/icon_0{/xml/@icons}.gif" border="0"/>&amp;nbsp;
		<xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/>
		</span>
		<xsl:if test="/xml/@isnowuser=0">
			<span class="headside"><img src="{$installdir}images/icons/icon_13.gif" border="0"/> <a target="_hideframe" href="{$installdir}userfavorite.asp?action=add&amp;topicid={@topicid}" title="ղصĸģԱ´β鿴">ղ</a></span>
		</xsl:if>
		</h2>
		<h1 class="title"><xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/>
		<span class="hits">&amp;nbsp;&amp;nbsp;
			 <xsl:value-of select="/xml/topic/@hits" disable-output-escaping="yes"/></span></h1>
		<div id="questioninfo">
			<div class="content"><xsl:value-of select="@content" disable-output-escaping="yes"/></div>
			<div class="askPostInfo"><span class="post1"><a class="btn1" href="#post">ظ</a></span>
			<span class="post2">
			<xsl:choose>
			<xsl:when test="/xml/topic/@anonymous=1"></xsl:when>
			<xsl:otherwise>
				<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=3" target="_blank"><xsl:value-of select="/xml/topic/@postusername" disable-output-escaping="yes"/></a> 
			</xsl:otherwise>
			</xsl:choose>
			 &amp;nbsp;&amp;nbsp;ʱ <xsl:value-of select="/xml/topic/@dateandtime" disable-output-escaping="yes"/>
			</span></div>
		</div>
	</div>
	<div style="clear:both"></div>
	</xsl:for-each>
</xsl:template>
<xsl:template name="post_answer">
	<div id="mainAnswerZone">
		<h2>ظ<xsl:value-of select="/xml/topic/@title" disable-output-escaping="yes"/></h2>
		<xsl:for-each select="xml/postlist/row[@postsmode=1 and @satis=0]">
			<div class="content">
			<xsl:value-of select="@content" disable-output-escaping="yes"/></div>
			<div class="AnswerBot">
			<xsl:choose>
				<xsl:when test="/xml/topic/@topicmode='3' and /xml/@isnowuser='1' and /xml/@allowdeletes='1'"><span onclick="checkDelAnswer('{$installdir}handle.asp?action=delanswer&amp;topicid={@topicid}&amp;postsid={@postsid}');"><a href="javascript:;">ɾ</a></span></xsl:when>
				<xsl:otherwise><span> <xsl:value-of select="@i" /> ¥</span></xsl:otherwise>
			</xsl:choose>
			<a href="{$installdir}usertopic.asp?userid={@userid}&amp;topicmode=3" target="_blank"><xsl:value-of select="@username" disable-output-escaping="yes"/></a>&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;ʱ <xsl:value-of select="@posttime" disable-output-escaping="yes"/></div>
		</xsl:for-each>
	</div>
	<div style="clear:both"></div>
</xsl:template>
<xsl:template name="post_answerform">
	<div id="postAnswerZone">
		<form method="post" name="answerform" id="answerform" action="postshare.asp" target="_hideframe">
		<div id="postAnswer">
			<input type="hidden" name="action" value="reply"/>
			<input type="hidden" name="direct" value="1"/>
			<input type="hidden" name="topicid" value="{/xml/topic/@topicid}"/>
			<input type="hidden" name="classid" value="{/xml/topic/@classid}"/>
			<a name="post"></a>
			<xsl:choose>
				<xsl:when test="$nowuserid=0">
					<textarea name="content" id="TextContent" disabled="disabled" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;">װûûе¼ȵ¼</textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" disabled="disabled" value="OK!ظ" class="btn2" style="margin-right:10px;"/>
					<script language="JavaScript">document.writeln('<a href="'+sitePath+'login.asp?ReturnURL=' +window.location.href + '">¼</a>');</script> 
				</xsl:when>
				<xsl:otherwise>
					<textarea name="content" id="TextContent" wrap="PHYSICAL" style="width:100%;height:100px;padding:4px;"></textarea><br/><br class="x"/>
					<input type="submit" name="answerSubmit" id="answerSubmit" value="OK!ظ" class="btn2" style="margin-right:10px;"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		</form>
	</div>
	<div style="clear:both"></div>
</xsl:template>
</xsl:stylesheet>