<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.cn Sunwin
	-->
<xsl:template match="/">
<h2 class="listHead">
	<xsl:choose>
		<xsl:when test="xml/@topicmode='0'"><span class="headline1"><b></b></span> </xsl:when>
		<xsl:otherwise><span class="headline2"><a href="{$installdir}showlist.asp?classid={xml/@classid}&amp;topicmode=0&amp;page=1"></a></span> </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="xml/@topicmode='1'"><span class="headline1"><b>ѽ</b></span> </xsl:when>
		<xsl:otherwise><span class="headline2"><a href="{$installdir}showlist.asp?classid={xml/@classid}&amp;topicmode=1&amp;page=1">ѽ</a></span> </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="xml/@topicmode='2'"><span class="headline1"><b>ͶƱе</b></span> </xsl:when>
		<xsl:otherwise><span class="headline2"><a href="{$installdir}showlist.asp?classid={xml/@classid}&amp;topicmode=2&amp;page=1">ͶƱе</a></span> </xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="xml/@topicmode='3'"><span class="headline1"><b>û</b></span> <span class="headline2"><a href="{$installdir}postshare.asp?classid={xml/@classid}&amp;topicmode=3">µ</a></span></xsl:when>
		<xsl:otherwise><span class="headline2"><a href="{$installdir}showlist.asp?classid={xml/@classid}&amp;topicmode=3&amp;page=1">û</a></span> </xsl:otherwise>
	</xsl:choose>
	<span class="headline3"><input type="checkbox" onchange="javascript:toggleLinkAttributes();" id="toggleLinks" /><label for="toggleLinks" title="Open in new window?"><strong>´</strong></label></span>
</h2>
<div id="asklistZone">
<ul>
	<li class="headline"><span class="title">( <xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/> )</span> <span class="cent">ش</span> <span class="state">״̬</span> <span class="time">ʱ</span></li>
	<xsl:if test="xml/topic/row">
		<xsl:for-each select="xml/topic/row">
			<li><xsl:if test="@reward &gt; 0"><span class="reward"><img src="{$installdir}images/icons/icon_10.gif" border="0"/> <xsl:value-of select="@reward" disable-output-escaping="yes"/></span></xsl:if>
			<span class="title">
			<xsl:choose>
				<xsl:when test="@topicmode=3">
					<a rel="external" href="{$installdir}share.asp?topicid={@topicid}">
					<xsl:choose>
						<xsl:when test="string-length(@title) &gt; 35 "><xsl:value-of select="concat(substring(@title,0,25),'....',substring(@title,(string-length(@title)- 10 ),string-length(@title)))" disable-output-escaping="yes"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
					</xsl:choose>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
					<xsl:choose>
						<xsl:when test="string-length(@title) &gt; 35 "><xsl:value-of select="concat(substring(@title,0,25),'....',substring(@title,(string-length(@title)- 10 ),string-length(@title)))" disable-output-escaping="yes"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
					</xsl:choose>
					</a>
				</xsl:otherwise>
			</xsl:choose>
			</span> 
			<span class="cent"><xsl:value-of select="@postnum" disable-output-escaping="yes"/></span> 
			<span class="state"><img src="{$installdir}images/icons/icon_0{@topicmode}.gif" border="0"/></span> 
			<span class="time"><xsl:value-of select="@dateandtime" disable-output-escaping="yes"/></span></li>
		</xsl:for-each>
	</xsl:if>
</ul>
	<div class="mainPage">
		<i class="postCount"><xsl:value-of select="xml/@classname" disable-output-escaping="yes"/><b><xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/></b>ҳΣ<b><xsl:value-of select="xml/@page" disable-output-escaping="yes"/></b>/<xsl:value-of select="xml/@pagecount" disable-output-escaping="yes"/>ҳ</i>
		<var class="morePage">
			{$AskedPageList}
		</var>
	</div>
</div>
<xsl:if test="/xml/@child='0'">
	<xsl:choose>
		<xsl:when test="xml/@topicmode='3'"><xsl:call-template name="post_shareform"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="post_askedform"/></xsl:otherwise>
	</xsl:choose>
</xsl:if>
</xsl:template>
<xsl:template name="post_askedform">
<xsl:if test="/xml/@fastpostasked='1' and /xml/@userid &gt; 0">
	<div id="fastPostForm">
		<h2><span class="headline"></span></h2>
		<iframe name="_hideframe" style="display:none;"></iframe>
		<form method="post" name="answerform" id="answerform" action="postask.asp?action=save" target="_hideframe">
		<input type="hidden" name="classid" value="{xml/@classid}"/>
		<table border="0" cellpadding="0" cellspacing="6">
		<tr>
			<td width="15%" align="right"><b>⣺</b></td>
			<td width="85%"><input type="text" size="90" name="topic" id="topic" maxlength="150" /> <font color="red">*</font></td>
		</tr>
		<tr>
			<td align="right"><b></b></td>
			<td><textarea  name="askcontent" id="askcontent" cols="90" rows="6" wrap="PHYSICAL"></textarea></td>
		</tr>
		<tr>
			<td align="right"><b>ͣ</b></td>
			<td><select name="points" id="points">
				<option value="0"></option>
				<option value="5">5</option>
				<option value="10">10</option>
				<option value="15">15</option>
				<option value="20">20</option>
				<option value="30">30</option>
				<option value="50">50</option>
				<option value="80">80</option>
				<option value="100">100</option>
			</select> ǰĻ <font color="red"><xsl:value-of select="xml/@userpoints" disable-output-escaping="yes"/></font>
			<span>ͿʵĻش</span></td>
		</tr>
		<tr>
		<td align="right"></td>
		<td><input class="button" type="submit" name="asksubmit" id="asksubmit" value="ύ"/></td>
		</tr>
		</table>
		</form>
	</div>
</xsl:if>
</xsl:template>
<xsl:template name="post_shareform">
<xsl:if test="/xml/@fastpostshare='1' and /xml/@userid &gt; 0">
	<div id="fastPostForm">
		<h2><span class="headline">ٷ</span></h2>
		<iframe name="_hideframe" style="display:none;"></iframe>
		<form method="post" name="shareform" id="shareform" action="postshare.asp?action=save" target="_hideframe">
		<input type="hidden" name="classid" value="{xml/@classid}"/>
		<table border="0" cellpadding="0" cellspacing="6">
		<tr>
			<td width="15%" align="right"><b>⣺</b></td>
			<td width="85%"><input type="text" size="90" name="topic" id="topic" maxlength="150" /> <font color="red">*</font></td>
		</tr>
		<tr>
			<td align="right"><b>ݣ</b></td>
			<td><textarea  name="content" id="textcontent" cols="90" rows="6" wrap="PHYSICAL"></textarea></td>
		</tr>
		<tr>
		<td align="right"></td>
		<td><input class="button" type="submit" name="sharesubmit" id="sharesubmit" value="ٷ"/></td>
		</tr>
		</table>
		</form>
	</div>
</xsl:if>
</xsl:template>
</xsl:stylesheet>