function getCookie(name){
    var arr,reg=new RegExp("(^| )"+name+"=([^;]*)(;|$)");
    if(arr=document.cookie.match(reg)) return unescape(arr[2]);
    else return null;
}

function setCookie(name,value){
    var expire = arguments[2] ? arguments[2] : 365*24*60*60*1000;
    var exp = new Date(); 
    exp.setTime(exp.getTime() + expire);
    document.cookie = name + "="+ escape (value) + ";path=/;expires=" + exp.toGMTString();
}

function visit(evn){
    evn= evn ? evn : window.event;
    var s= (evn.target) ? evn.target : evn.srcElement;
    if(s.tagName == "A" && s.parentNode.tagName == "LI" && s.href.indexOf("http://") == 0 && s.href.indexOf("http://"+location.host) != 0) setVisitCookie(s);
}

function setVisitCookie(atag){
    cookieValue = atag.innerHTML + "|" + atag.href;
    if(!isVisited(cookieValue))
    {
        visitedArr = get360VisitedWeb();
        expire = 1000*3600*24*30;
        if(visitedArr)
        {
            visited = '';
            var maxlen = 20;
            var len = visitedArr.length >= maxlen ? maxlen-1 : visitedArr.length;
            for(var i=0; i< len; i++)
            {
                if(visitedArr[i] != '') visited = visited=='' ? visitedArr[i] : visited+";"+visitedArr[i];
            }
            setCookie(getVisitedCookieName(), cookieValue+";"+visited, expire);
        }
        else
        {
            setCookie(getVisitedCookieName(), cookieValue, expire);
        }
    }
    return ;
}

Array.prototype.in_array=function (e){
    for(var i=0; i<this.length;i++)
    {
        if(this[i] && e == this[i])
        return true;
    }
    return false;
}

function getVisited(){
    return getCookie(getVisitedCookieName());
}

function get360VisitedWeb(){
    visited = getVisited();
    if(!visited) return null;
    visitedArr = visited.split(";");
    if(visitedArr) return visitedArr;
    return null;
}

function isVisited(cookieValue){
    visitedArr = get360VisitedWeb();
    if(visitedArr) return visitedArr.in_array(cookieValue);
    return false;
}
function getVisitedCookieName(){return "360WebUserVisited";}
document.onclick = visit;