﻿<%
'* -------------------------------
'* 文件名：Cls_FileSys.asp
'* 作  用：文件系统操作（FSO、XML）
'* -------------------------------
Class Cls_FileSystem
	Private FileOs, Fle
	Private FsTrue
    '//* 初始化类 *//
	Private Sub Class_Initialize
		On Error Resume Next
		Set FileOs = Server.CreateObject(FsoString)
		FsTrue = True
		If -2147221005 = Err Then
			Err.Clear
			FsTrue = False
		End If
	End Sub
    '//* 注消类 *//
	Private Sub Class_Terminate
		Set FileOs = Nothing
	End Sub
	'//* 判断对象 *//
	'--- 返回BOOL值
	Public Function Obj_Install(ByVal ObjString)
		On Error Resume Next
		Obj_Install = True
		Dim TmpObj
		Err=0
		Set TmpObj = Server.CreateObject(ObjString)
		If -2147221005 = Err Then
			Err.Clear
			Obj_Install = False
		End If
		Set TmpObj = Nothing
	End Function
	'//* 目录列表 *//
	Public Function Get_FolderList(ByVal oPath)
		Dim FolderTemp,oFolder
		Dim Tmp
		'oFilePath = Server.Mappath(oPath)
		Set FolderTemp = FileOs.GetFolder(Server.Mappath(oPath))
		For Each oFolder in FolderTemp.SubFolders
		  If Tmp = "" Then
		    Tmp = oFolder.name
		  Else
		    Tmp = Tmp & "|" & oFolder.name
		  End If
		Next
		Set FolderTemp = Nothing
    Get_FolderList = LCase(Tmp)
  End Function
	'//* 文件列表 *//
	Public Function Get_FileList(ByVal oPath)
		Dim FileTemp,oFile
		Dim Tmp
		'oFilePath = Server.Mappath(oPath)
		Set FileTemp = FileOs.GetFolder(Server.Mappath(oPath))
		For Each oFile in FileTemp.Files
		  If Tmp = "" Then
		    Tmp = oFile.name
		  Else
		    Tmp = Tmp & "|" & oFile.name
		  End If
		Next
		Set FileTemp = Nothing
    Get_FileList = Tmp
  End Function
	'--- 复制文件
	'--- File_Name:文件路径
	Public Sub Copy_File(ByVal F1,ByVal F2)
	  If Not FsTrue Then Exit Sub
	  Dim oPath1,oPath2
		oPath1 = Server.Mappath(F1)
		oPath2 = Server.Mappath(F2)
		FileOs.CopyFile oPath1,oPath2,True
	End Sub
	'//* FSO 操作部分 *//
	'--- 读取文件
	'--- File_Name:文件路径
	Public Function Get_File(ByVal File_Name)
	  If Not FsTrue Then Exit Function
		Dim FileTemp,FilePath
		FilePath = Server.Mappath(File_Name)
		Set FileTemp = FileOs.OpenTextFile(FilePath,1,True)
		Get_File = FileTemp.ReadAll
		FileTemp.Close
		Set FileTemp = Nothing
	End Function
	'--- 写入文件
	'--- File_Name:文件路径
	'--- FileType:文件内容
	Public Sub Create_File(ByVal File_Name,ByVal FileType)
	  If Not FsTrue Then Exit Sub
		Dim FileTemp,FilePath
		FilePath=Server.Mappath(File_Name)
		Set FileTemp=FileOs.CreateTextFile(FilePath,True)
		FileTemp.WriteLine( FileType )
		FileTemp.Close
		Set FileTemp=Nothing
	End Sub
	'--- 写入文件2
	'--- 依次检测目录再写入
	Public Sub CreateHtmlFile(ByVal FileFolder1,ByVal FileFolder2,ByVal FileName,ByVal FileType)
	  If Not FsTrue Then Exit Sub
	       Dim j,MyFolder,Filepath1,Filepath2,FileTemp
		   MyFolder = Server.Mappath(FileFolder1)&"/"
		   If FileFolder2<>"" and FileFolder2<>"/" then
		      Filepath1 = Split(FileFolder2,"/")
		      Filepath2 = ""
		         For j=0 to ubound(Filepath1)-1
		           if Filepath2="" then
				      Filepath2=Filepath1(j)
				   else
			          Filepath2=Filepath2&"/"&Filepath1(j)
				   end if
		           If Not(FileOs.FolderExists(MyFolder&FilePath2)) Then FileOs.CreateFolder(MyFolder&FilePath2)
			    Next
		   End If
                 WriteTOFile FileFolder1&"/"&FilePath2&"/"&FileName, FileType		   
		'Set FileTemp=FileOs.CreateTextFile(MyFolder&FilePath2&"/"&FileName,True)
		'FileTemp.WriteLine( FileType )
		'FileTemp.Close
		'Set FileTemp=Nothing
	End Sub	
	'--- 创建目录
	'--- Folder_Name:目录路径
	Public Sub Make_Dir(ByVal Folder_Name)
	  If Not FsTrue Then Exit Sub
		Dim FolderOs,MyFolder
		If Folder_Name<>"" Then
			MyFolder=Server.Mappath(Folder_Name)
	 		If Not FileOs.FolderExists(MyFolder) Then
	 			Set FolderOs=FileOs.CreateFolder(MyFolder)
	 			Set FolderOs=Nothing
	 		End If
		End If
	End Sub
	'--- 删除文件
	'--- File_Name:文件路径
	Public Sub Del_File(ByVal File_Name)
	  If Not FsTrue Then Exit Sub
		if File_Name="" then Exit Sub
    Dim MyFile
    MyFile=Server.Mappath(File_Name)
    If FileOs.FileExists(MyFile) Then
       FileOs.DeleteFile(MyFile)
    End if
  End Sub
  	'--- 删除目录
	'--- Folder_Name:目录路径
	Public Sub Del_Folder(ByVal Folder_Name)
	If Not FsTrue Then Exit Sub
		if Folder_Name="" then Exit Sub
    Dim MyFolder
    MyFolder=Server.Mappath(Folder_Name)
    If FileOs.FolderExists(MyFolder) Then
       FileOs.DeleteFolder(MyFolder)
    End if
  End Sub
    '--- 移动目录
	'--- FolderSource:原目录路径
	'--- FolderTo:移动到的目录路径
	Public Sub Move_Folder(ByVal FolderSource,ByVal FolderTo)
	If Not FsTrue Then Exit Sub
		if FolderSource="" or FolderTo = "" then Exit Sub
    Dim MyFolder,MyFolder2
    MyFolder=Server.Mappath(FolderSource)
	MyFolder2=Server.Mappath(FolderTo)
    If FileOs.FolderExists(MyFolder) Then
	   If Not(FileOs.FolderExists(MyFolder2)) Then 
             FileOs.MoveFolder MyFolder,MyFolder2
	   end if
    End if
  End Sub
	'--- 判断目录、文件是否存在
	'--- FName:目录、文件路径
	'--- FType:
	'	 0: 目录
	'	 1: 文件
	'--- 返回布尔值
	Public Function Chk_Exist(ByVal FName,ByVal FType)
		Chk_Exist=False
	  If Not FsTrue Then Exit Function
		Dim FolderOs,MyExist
		If Cls.Is_Null(FName)="" Then Exit Function
		MyExist=Server.Mappath(FName)
		If FType=0 Then
 			If FileOs.FolderExists(MyExist) Then Chk_Exist=True
 		Else
 			If FileOs.FileExists(MyExist) Then Chk_Exist=True
 		End If
	End Function
	'--- 去除多余空格与换行
	Public Function Chk_Trim(ByVal FVar)
		Dim temp1,tmp,tmpvar
		temp1=FVar
		tmp=False
		Do While Not tmp
			tmpvar=Left(temp1,1)
			If tmpvar=Chr(10) Or tmpvar=Chr(13) Then
				temp1=Right(temp1,Len(temp1)-1)
			Else
				tmp=True
			End If
		Loop
		tmp=False
		Do While Not tmp
			tmpvar=Right(temp1,1)
			If tmpvar=Chr(10) Or tmpvar=Chr(13) Then
				temp1=Left(temp1,Len(temp1)-1)
			Else
				tmp=True
			End If
		Loop
		Chk_Trim=temp1
	End Function

	'**************************************************
	'函数名：WriteTOFile
	'作  用：写内容到指定的html文件
	'参  数：Filename  ----目标文件件 如 mb\index.htm
	'        Content   ------要写入目标文件的内容
	'返回值：成功返回true ,失败返回false
	'**************************************************
	Public Function WriteTOFile(FileName, Content)
               Dim stm,str
               Set stm=server.CreateObject("adodb.stream") 
               stm.Type=2
               stm.mode=3 
               stm.charset="utf-8"
               stm.open 
               stm.WriteText Content 
               stm.SaveToFile server.MapPath(FileName),2  
               stm.flush 
               stm.Close 
               set stm=nothing 
	  
	   If Err.Number <> 0 Then
		 WriteTOFile = False
	  Else
		 WriteTOFile = True
	  End If
	End Function

	'**************************************************
	'函数名：CreateListFolder
	'作  用：不限分级创建目录 形如 1\2\3\ 则在网站根目录下创建分级目录
	'参  数：Folder要创建的目录
	'返回值：成功返回true 否则返回Flase
	'**************************************************
	Public Function CreateListFolder(Folder)
                If Not FsTrue Then Exit Function
		Dim WaitCreateFolder, SplitFolder, CF, k
		On Error Resume Next
		If Folder = "" Then
		 CreateListFolder = False:Exit Function
		End If
	   Folder = Replace(Folder, "\", "/")
	   If Right(Folder, 1) <> "/" Then
		Folder = Folder & "/"
	   End If
	   If Left(Folder, 1) <> "/" Then
		Folder = "/" & Folder
		End If
		 If Not FileOs.FolderExists(Server.MapPath(Folder)) Then
		   SplitFolder = Split(Folder, "/")
		 For k = 0 To UBound(SplitFolder) - 1
		  If k = 0 Then
		   CF = SplitFolder(k) & "/"
		  Else
		  CF = CF & SplitFolder(k) & "/"
		  End If
		  If (Not FileOs.FolderExists(Server.MapPath(CF))) Then
			 FileOs.CreateFolder (Server.MapPath(CF))
			 CreateListFolder = True
		  End If
		 Next
	   End If
	   Set FileOs = Nothing
	   If Err.Number <> 0 Then
	   Err.Clear
	   CreateListFolder = False
	   Else
	   CreateListFolder = True
	   End If
	 End Function

	'**************************************************
	'函数名：ReadFromFile
	'作  用：写内容到指定的html文件
	'参  数：Filename  ----目标文件件 如 mb\index.htm
	'返回值：成功返回文件内容 ,失败返回""
	'**************************************************
	Public Function ReadFromFile(FileName)
		 On Error Resume Next
		 Dim FsoObj, FileStreamObj, FileObj
		 Set FsoObj = Server.CreateObject(FsoString)
		 If Chk_Exist(FileName,1) = False Then
			  Call Alert("错误提示:\n\n[" & Server.MapPath(FileName) & "]文件不存在", ""):Exit Function
		  End If
		  Set FileObj = FsoObj.GetFile(Server.MapPath(FileName))
		  Set FileStreamObj = FileObj.OpenAsTextStream(1)
		  If Not FileStreamObj.AtEndOfStream Then
				ReadFromFile = FileStreamObj.ReadAll
		 Else
				 ReadFromFile = ""
		 End If
	End Function

Public function ReadFromUTF(Temp,CharSet)    'Temp要读取的模板文件路径; Charset是编码
    dim str,stm
    set stm=server.CreateObject("adodb.stream")
    stm.Type=2 
    stm.mode=3 
    stm.charset=CharSet
    stm.open
    stm.loadfromfile server.MapPath(Temp)
    str=stm.readtext
    stm.Close
    set stm=nothing
    ReadFromUTF=str
end function

Public function WriteToUTF(FileUrl,Str)  'FileUrl 是文件保存的文件名,Str是要写入的内容,CharSet是采用什么编码写入
 Dim stm, CharSet
 CharSet = "utf-8"
 set stm=server.CreateObject("adodb.stream") 
 stm.Type=2
 stm.mode=3 
 stm.charset=CharSet
 stm.open 
 stm.WriteText str 
 stm.SaveToFile server.MapPath(FileUrl),2  
 stm.flush 
 stm.Close 
 set stm=nothing 
end function


	Public sub create_book(file_name,ll,filetype,file)
        dim filetemp,filepath
        if (fileos.FolderExists(server.mappath(file_name))) then'判断文件夹是否存在
        else
        fileos.CreateFolder(server.mappath(file_name))
        end if

        file_name=file_name&"/"&ll
        if (fileos.FolderExists(server.mappath(file_name))) then'判断文件夹是否存在
        else
           fileos.CreateFolder(server.mappath(file_name))
        end if
       ' filepath=server.mappath(file_name)&"\"&file
        'set filetemp=fileos.createtextfile(filepath,true)
        'filetemp.writeline( filetype )
        'filetemp.close
        set filetemp=nothing
                 WriteTOFile file_name&"/"&file, filetype
        end sub
End Class
%>
