﻿<%
Dim HTML
Set HTML = New Public_Cls
Class Public_Cls
	'================================================
	'函数名：LoadArticleList
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowPic   ----是否显示图文标题
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        HtmlStr    ----列表代码
	'================================================
	Public Function LoadArticleList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim ArticleTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		strLen = Cls.ChkNumeric(strLen)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadArticleList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
			Case 3: foundstr = "And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 6: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
			Case 7: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.IncludeInfo,A.Ispic,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Article] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTopic = Cls.GetIncInfo(Rs("IncludeInfo"))
				sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'if rs("ispic")=true then sTitle = sTitle & "<font class=red>[图]</font>"
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				ArticleTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("topic") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(13)
				strContent = Replace(strContent, "{$ArticleTopic}", ArticleTopic)
				strContent = Replace(strContent, "{$ArticleID}", Rs("ID"))
				strContent = Replace(strContent, "{$ArticleTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("topic"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$AticleHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadArticleList = strContent
	End Function
	'================================================
	'函数名：ReadArticleList
	'作  用：读取文章列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadArticleList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadArticleList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadArticleList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadArticleList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadArticleList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10), ArrayList(11)))
			Next
		End If
		ReadArticleList = strTemp
	End Function
	
	
	Public Function LoadIaskList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim IaskTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName,Rekoe_UserName,Rekoe_Reward 
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		strLen = Cls.ChkNumeric(strLen)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadIaskList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
			Case 3: foundstr = "And A.Reward >30 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 6: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
			Case 7: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.IncludeInfo,A.Reward,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.Replys,A.Solves,A.Expired,A.HtmlFileDate,A.UserName,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Iask] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sDot=""&sDot&""&Cls.GetIaskDot(rs("replys"),rs("Solves"),rs("Expired"))&""
				Rekoe_UserName=rs("UserName")
				sTopic = Cls.GetIncInfo(Rs("IncludeInfo"))
				sTitle = Cls.Cuted(Rs("Name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				Rekoe_Reward="<font class=tims>"&rs("Reward")&"</font><img src='/Skin/Skin_1/Small/ico_integral.gIf'>"
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				IaskTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("Name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				if stype=1 or stype=2 then
				strContent = strContent & Cls.ReadSkin(13)
				else
				strContent = strContent & Cls.ReadSkin(36)
				end if
				strContent = Replace(strContent, "{$ArticleTopic}", IaskTopic)
				strContent = Replace(strContent, "{$IaskID}", Rs("ID"))
				strContent = Replace(strContent, "{$IaskTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("Name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$Rekoe_Reward}", Rekoe_Reward)
				strContent = Replace(strContent, "{$Rekoe_username}", Rs("UserName"))
				strContent = Replace(strContent, "{$AticleHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadIaskList = strContent
	End Function
	'================================================
	'函数名：ReadIaskList
	'作  用：读取文章列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadIaskList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadIaskList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadIaskList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadIaskList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadIaskList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10), ArrayList(11)))
			Next
		End If
		ReadIaskList = strTemp
	End Function

		'================================================
	'函数名：LoadPrisList
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowPic   ----是否显示图文标题
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        HtmlStr    ----列表代码
	'================================================
	Public Function LoadPrisList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim ArticleTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		strLen = Cls.ChkNumeric(strLen)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadNewsList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
			Case 3: foundstr = "And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 6: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
			Case 7: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.name,A.Ispic,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Pris] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'if rs("ispic")=true then sTitle = sTitle & "<font class=red>[图]</font>"
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				ArticleTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(13)
				strContent = Replace(strContent, "{$ArticleTopic}", ArticleTopic)
				strContent = Replace(strContent, "{$NewsID}", Rs("ID"))
				strContent = Replace(strContent, "{$NewsTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$AticleHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadPrisList = strContent
	End Function
	'================================================
	'函数名：ReadNewsList
	'作  用：读取文章列表
	'参  数：str ----原字符串
	'================================================
		Public Function ReadPrisList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadPrisList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadPrisList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadPrisList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadPrisList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10), ArrayList(11)))
			Next
		End If
		ReadPrisList = strTemp
	End Function
		'================================================
	'函数名：LoadNewsList
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowPic   ----是否显示图文标题
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        HtmlStr    ----列表代码
	'================================================
	Public Function LoadNewsList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim ArticleTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		strLen = Cls.ChkNumeric(strLen)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadNewsList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
			Case 3: foundstr = "And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 6: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
			Case 7: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.IncludeInfo,A.Ispic,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_News] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTopic = Cls.GetIncInfo(Rs("IncludeInfo"))
				sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'if rs("ispic")=true then sTitle = sTitle & "<font class=red>[图]</font>"
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				ArticleTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("topic") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(13)
				strContent = Replace(strContent, "{$ArticleTopic}", ArticleTopic)
				strContent = Replace(strContent, "{$NewsID}", Rs("ID"))
				strContent = Replace(strContent, "{$NewsTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("topic"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$AticleHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadNewsList = strContent
	End Function
	'================================================
	'函数名：ReadNewsList
	'作  用：读取文章列表
	'参  数：str ----原字符串
	'================================================
		Public Function ReadNewsList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadNewsList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadNewsList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadNewsList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadNewsList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10), ArrayList(11)))
			Next
		End If
		ReadNewsList = strTemp
	End Function
	'================================================
	'函数名：LoadSoftList
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadSoftList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim SoftTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadSoftList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Down] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				SoftTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(14)
				strContent = Replace(strContent, "{$SoftTopic}", SoftTopic)
				strContent = Replace(strContent, "{$SoftID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$SoftTime}", WriteTime)
				strContent = Replace(strContent, "{$SoftHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadSoftList = strContent
	End Function	
	'================================================
	'函数名：ReadSoftList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadSoftList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadSoftList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadSoftList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadSoftList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadSoftList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadSoftList = strTemp
	End Function
	'================================================
	'函数名：LoadShopList
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadShopList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim ShopTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadShopList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Shop] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				ShopTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(15)
				strContent = Replace(strContent, "{$ShopTopic}", ShopTopic)
				strContent = Replace(strContent, "{$ShopID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$ShopHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadShopList = strContent
	End Function	
		'================================================
	'函数名：LoadFleaList
	'作  用：装载信息列表
	'================================================
	Public Function LoadFleaList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim FleaTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		strLen = Cls.ChkNumeric(strLen)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadFleaList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
			Select Case CInt(stype)
			Case 0: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 1: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		    Case Else
			        foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
		    End Select
		Else
			ChildStr = "0"
			Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
		    Case Else
			        foundstr = "Order By A.ID Desc"
		    End Select
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.Types,A.pic,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Flea] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				If rs("types")=1 then
				sTopic = "<font color=blue>[求]</font>"
				Else
				sTopic = "<font color=orange>[供]</font>"
				End If
				sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'if rs("ispic")=true then sTitle = sTitle & "<font class=red>[图]</font>"
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				FleaTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("topic") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(40)
				strContent = Replace(strContent, "{$FleaTopic}", FleaTopic)
				strContent = Replace(strContent, "{$FleaID}", Rs("ID"))
				strContent = Replace(strContent, "{$FleaTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("topic"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$Type}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$AticleHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadFleaList = strContent
	End Function

	'================================================
	'函数名：ReadFleaList
	'作  用：读取信息列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFleaList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFleaList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFleaList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFleaList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFleaList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10), ArrayList(11)))
			Next
		End If
		ReadFleaList = strTemp
	End Function
	'================================================
	'函数名：ReadShopList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadShopList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadShopList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadShopList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadShopList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadShopList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadShopList = strTemp
	End Function
'================================================
	'函数名：LoadPhotoList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadPhotoList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Photo] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadPhotoList = strContent
	End Function	

'================================================
	'函数名：LoadFlashcList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadFlashcList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Photo] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				'前标
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)

				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadFlashcList = strContent
	End Function

        '================================================
	'函数名：LoadFlash_List
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadFlash_List(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Flash] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadFlash_List = strContent
	End Function


        '================================================
	'函数名：LoadMtvList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadMtvList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Mtv] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadMtvList = strContent
	End Function


	'================================================
	'函数名：ReadMtvList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMtvList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMtvList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMtvList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMtvList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMtvList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMtvList = strTemp
	End Function
        '================================================
	'函数名：LoadFlashList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadFlashList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Flash] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadFlashList = strContent
	End Function
	'================================================
	'函数名：ReadFlashList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFlashList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFlash_List(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_List(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_List(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFlashList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadFlashList = strTemp
	End Function

	'================================================
	'函数名：ReadPhotoList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadPhotoList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadPhotoList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadPhotoList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadPhotoList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadPhotoList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadPhotoList = strTemp
	End Function

	'================================================
	'函数名：ReadFlash_List
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFlash_List(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFlash_List(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_List(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_List(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFlash_List(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadFlash_List = strTemp
	End Function
'================================================
	'函数名：LoadMovieList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadMovieList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.counter,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Movie] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16) '16
				strContent = Replace(strContent, "{$PhotoTopic}", PhotoTopic)
				strContent = Replace(strContent, "{$PhotoID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$PhotoHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadMovieList = strContent
	End Function	
	'================================================
	'函数名：ReadMovieList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMovieList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMovieList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMovieList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMovieList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMovieList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMovieList = strTemp
	End Function
	'================================================
	'函数名：LoadBloger
	'作  用：装载博客列表
	'================================================
	Public Function LoadBloger(ByVal ClassID, ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ClassID = Cls.ChkNumeric(ClassID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		'Cls.LoadChannel(10)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=10 And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadBloger = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
			Select Case CInt(stype)
			Case 0: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 1: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.Hits Desc ,A.ID Desc"
		    Case Else
			        foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
		    End Select
		Else
			ChildStr = "0"
			Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.Hits Desc, A.ID Desc"
		    Case Else
			        foundstr = "Order By A.ID Desc"
		    End Select
		End If
		SQL = " A.ID,A.ClassID,A.BlogName,A.UserName,A.Hits,A.Tim,A.isgood,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName FROM [ITZD_Blog] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(false,false,rs("isgood"))
				sTitle = Cls.Cuted(Rs("blogname"), CInt(strLen))
				'sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				HtmlFileUrl = Cls.Web_Dir& "Blog/?" & Rs("UserName")
				ClassName = "<a href='" & Cls.Web_Dir& "Blog/list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='博客名称：" & Rs("blogname") & "&#13;&#10;创建时间：" & Rs("tim") & "&#13;&#10;访问次数：" & Rs("hits") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(38)
				strContent = Replace(strContent, "{$BlogName}", PhotoTopic)
				strContent = Replace(strContent, "{$BlogID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("blogname"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$Type}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$Time}", WriteTime)
				strContent = Replace(strContent, "{$Hits}", Rs("hits"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadBloger = strContent
	End Function	
	'================================================
	'函数名：ReadBloger
	'作  用：读取博客列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadBloger(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadBloger(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadBloger(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadBloger(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadBloger(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8)))
			Next
		End If
		ReadBloger = strTemp
	End Function

	'================================================
	'函数名：LoadBlogData
	'作  用：装载博客列表
	'================================================
	Public Function LoadBlogData(ByVal dtype, ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showtype, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim PhotoTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		'ClassID = Cls.ChkNumeric(ClassID)
		dtype = Cls.ChkNumeric(dtype)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		'Cls.LoadChannel(10)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(dtype) = 1  Then foundstr = " And Type=1 "
		If CInt(dtype) = 2  Then foundstr = " And Type=2 "
		Select Case CInt(stype)
			Case 0: foundstr = foundstr & "Order By Id Desc"
			'Case 1: foundstr = foundstr & "And Isgood = 1 Order By ID Desc"
			Case 1: foundstr = foundstr & "Order By count Desc ,ID Desc"
			Case 2: foundstr = foundstr & " And retim<>null Order By retim Desc ,ID Desc"
			Case 3: foundstr = foundstr & " And retim<>null Order By reply Desc ,ID Desc"
		Case Else
			foundstr = foundstr & "Order By ID Desc"
		End Select
		SQL = " ID,Topic,Type,UserName,Count,Tim"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & "  FROM [ITZD_BlogData] WHERE hidden=1 " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "还没有添加内容"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				'If Rs("isgood") <> 0 Then
				'	BestCode = 2
				'	BestString = "<font color='red'>推荐</font>"
				'Else
				'	BestCode = 1
				'	BestString = ""
				'End If
				'前标
				sDot=Cls.GetDot(false,false,false)
				sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				'sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				If CInt(showtype) <> 0 Then
				   If rs("type")=1 then
				      ClassName = "<font color=blue>日志</font>"
				   Else
				      ClassName = "<font color=orange>相片</font>"
				   End If
				Else
				   ClassName = ""
				End If
				HtmlFileUrl = Cls.Web_Dir& "Blog/View/?" & Rs("ID")
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				PhotoTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='标题：" & Rs("Topic") & "&#13;&#10;时间：" & Rs("tim") & "&#13;&#10;访问次数：" & Rs("count") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(39)
				strContent = Replace(strContent, "{$Topic}", PhotoTopic)
				strContent = Replace(strContent, "{$ID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("Topic"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$Type}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$Time}", WriteTime)
				strContent = Replace(strContent, "{$Hits}", Rs("count"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadBlogData = strContent
	End Function	
	'================================================
	'函数名：ReadBlogData
	'作  用：读取博客列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadBlogData(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadBlogData(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogData(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogData(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadBlogData(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8)))
			Next
		End If
		ReadBlogData = strTemp
	End Function

	'================================================
	'函数名：LoadBlogTags
	'作  用：装载博客列表
	'================================================
	Public Function LoadBlogTags(ByVal stype, ByVal TopNum, ByVal newindow,ByVal TagSmall,ByVal TagLarge)
		Dim Rs, SQL, i, strContent,  LinkTarget,  LinkURL
	    dim intK,intJ,intH,cc_tag_small,cc_tag_large,strTag
        '最小标签象素
        cc_tag_small = Cls.ChkNumeric(TagSmall)
        '最大标签象素
        cc_tag_large = Cls.ChkNumeric(TagLarge)
		stype = Cls.ChkNumeric(stype)
		'On Error Resume Next
		If Trim(TopNum)<>"0" Then 
		   TopNum=" Top "&TopNum&" "
		Else
		   TopNum=""
		End If
		if stype=2 then
   		   stype=" Where type = 2 "
		   LinkURL="list2.asp"
	    else
   		   stype=" Where type = 1 "
		   LinkURL="list1.asp"
		end if
		If CInt(newindow) <> 0 Then
		   LinkTarget = " target=""_blank"""
		Else
		   LinkTarget = ""
		End If
   strTag=""
   sql="select "&TopNum&" Tags,sum(Num)as Num2,Max(Num)as Max2 from ITZD_BlogTags "&stype&" group by Tags having sum(Num)>0"
   set rs = cls.exec(sql,1)
   if not rs.Eof then
   intJ=RS("max2")
   intH = intJ\(cc_tag_large-cc_tag_small)
     while not rs.Eof
     Select Case intH
				Case 0,1
					intK = CInt(RS("Num2") + cc_tag_small)
				Case Else
					intK = CInt(RS("Num2")*cc_tag_large/intH)
			End Select
			If intK < cc_tag_small Then
				intK = cc_tag_small
			End If
			If intK > cc_tag_large Then
				intK = cc_tag_large
			End If
      	strTag=strTag& "<span style=""font-size:"&intK&"px;margin:10px;;line-height:160%;""><a href="""&LinkURL&"?Action=search&sea_type=tags&keyword=" & Server.URLEncode(RS("tags")) & """ title=""标签名称:"&rs("tags")&"&#13;&#10;点击搜索相关内容"" "&LinkTarget&">" & Server.HTMLEncode(RS("tags")) & "</a></span>"&vbCrLf      
      rs.MoveNext
     wend
   end if
   rs.close
   LoadBlogTags = strTag   

	End Function	
	'================================================
	'函数名：ReadBlogTags
	'作  用：读取博客列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadBlogTags(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		'On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadBlogTags(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogTags(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogTags(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadBlogTags(ArrayList(0), ArrayList(1),ArrayList(2),ArrayList(3),ArrayList(4)))
			Next
		End If
		ReadBlogTags = strTemp
	End Function

	'================================================
	'函数名：LoadMusicList
	'作  用：装载相片列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4=分类最新文章
	'        TopNum   ----显示文章列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
	Public Function LoadMusicList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim MusicTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoList = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.hits Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.hits Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.hits,A.Tim,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_MusicDisk] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "该分类还没有添加任何内容!"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'sTopic = Cls.GetIncInfo(Rs("IncludeInfo")) '前标
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				MusicTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("name") & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;下载次数：" & Rs("hits") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(16)
				strContent = Replace(strContent, "{$PhotoTopic}", MusicTopic)
				strContent = Replace(strContent, "{$MusicID}", Rs("ID"))
				strContent = Replace(strContent, "{$Title}", Rs("name"))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$addTime}", WriteTime)
				strContent = Replace(strContent, "{$MusicHits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadMusicList = strContent
	End Function	
	'================================================
	'函数名：ReadMusicList
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMusicList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMusicList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMusicList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMusicList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMusicList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMusicList = strTemp
	End Function
	'================================================
	'函数名：LoadArticlePic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadArticlePic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadArticlePic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "And A.Ispic = 1 Order By A.Id Desc"
			Case 1: foundstr = "And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.Ispic,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Article] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(18)
					   	strContent = Replace(strContent, "{$ArticlePicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$ArticleTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$ArticleTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadArticlePic = strContent				
	End Function
	'================================================
	'函数名：ReadArticlePic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadArticlePic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadArticlePic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadArticlePic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadArticlePic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadArticlePic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadArticlePic = strTemp
	End Function
	'================================================
	'函数名：LoadIaskPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadIaskPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadIaskPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "And A.Ispic = 1 Order By A.Id Desc"
			Case 1: foundstr = "And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Ispic,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Iask] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(18)
					   	strContent = Replace(strContent, "{$IaskPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$IaskTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$IaskTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadIaskPic = strContent				
	End Function
	'================================================
	'函数名：ReadIaskPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadIaskPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadIaskPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadIaskPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadIaskPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadIaskPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadIaskPic = strTemp
	End Function
	'================================================
	'函数名：LoadSoftPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	'================================================
	'函数名：LoadPrisPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadPrisPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadNewsPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "And A.Ispic = 1 Order By A.Id Desc"
			Case 1: foundstr = "And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.name,A.Ispic,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Pris] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(18)
					   	strContent = Replace(strContent, "{$ArticlePicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$ArticleTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$ArticleTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadPrisPic = strContent				
	End Function
	'================================================
	'函数名：ReadNewsPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadPrisPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadPrisPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadPrisPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadPrisPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadPrisPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadPrisPic = strTemp
	End Function
	'================================================
	'函数名：LoadNewsPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadNewsPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadNewsPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "And A.Ispic = 1 Order By A.Id Desc"
			Case 1: foundstr = "And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Ispic = 1 Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "And A.Ispic = 1 Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.Ispic,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_News] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(18)
					   	strContent = Replace(strContent, "{$ArticlePicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$ArticleTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$ArticleTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadNewsPic = strContent				
	End Function
	'================================================
	'函数名：ReadNewsPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadNewsPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadNewsPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadNewsPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadNewsPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadNewsPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadNewsPic = strTemp
	End Function

	Public Function LoadSoftPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadSoftPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Down] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(19)
					   	strContent = Replace(strContent, "{$SoftPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$SoftTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$SoftTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadSoftPic = strContent				
	End Function
	'================================================
	'函数名：ReadSoftPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadSoftPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadSoftPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadSoftPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadSoftPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadSoftPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadSoftPic = strTemp
	End Function
	'================================================
	'函数名：LoadShopPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadShopPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadShopPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.tim,A.Price_Original,A.price,A.discount,A.emoney,A.is_emoney,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Shop] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(20)
					   	strContent = Replace(strContent, "{$ShopPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$ShopID}",rs("id"))
							strContent = Replace(strContent, "{$ChannelRootDir}",Cls.ChannelPath)
							strContent = Replace(strContent, "{$ShopUrl}",HtmlFileUrl)
							strContent = Replace(strContent, "{$PastPrice}",rs("Price_Original"))
							strContent = Replace(strContent, "{$DisCount}",Cls.FM_Discount(rs("DisCount")))
							strContent = Replace(strContent, "{$NowPrice}",Rs("price"))
							strContent = Replace(strContent, "{$AddTime}", Cls.ShowDateTime(Rs("tim"), 7))
							strContent = Replace(strContent, "{$Emoney}",Cls.Shop_Emoney_Pay(rs("is_emoney"),rs("emoney"),rs("id"),1))
							strContent = Replace(strContent, "{$ShopName}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$hidden}", " style='display:none;' ")
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadShopPic = strContent				
	End Function
	'================================================
	'函数名：ReadShopPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadShopPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadShopPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadShopPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadShopPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadShopPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadShopPic = strTemp
	End Function

	'================================================
	'函数名：ReadMtvPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMtvPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMtvPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMtvPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMtvPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMtvPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMtvPic = strTemp
	End Function

	'================================================
	'函数名：LoadMtvPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadMtvPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Mtv] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(21)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadMtvPic = strContent				
	End Function

	'================================================
	'函数名：ReadFlash_Pic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFlash_Pic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFlash_Pic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_Pic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlash_Pic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFlash_Pic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadFlash_Pic = strTemp
	End Function

	'================================================
	'函数名：LoadFlash_Pic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadFlash_Pic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Flash] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(21)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadFlash_Pic = strContent				
	End Function

	'================================================
	'函数名：LoadPhotoPic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadPhotoPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Photo] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(21)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadPhotoPic = strContent				
	End Function

	'================================================
	'函数名：ReadPhotoPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadPhotoPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadPhotoPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadPhotoPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadPhotoPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadPhotoPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadPhotoPic = strTemp
	End Function
	'================================================
	'函数名：LoadMoviePic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadMoviePic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Movie] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(21)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadMoviePic = strContent				
	End Function
	'================================================
	'函数名：ReadMoviePic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMoviePic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMoviePic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMoviePic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMoviePic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMoviePic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMoviePic = strTemp
	End Function
		'================================================
	'函数名：LoadFleaPic
	'作  用：装载Flea列表
	'================================================
	Public Function LoadFleaPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
	Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, sTopic, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadFleaPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
			Select Case CInt(stype)
			Case 0: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 1: foundstr = "And A.ClassID in (" & ChildStr & ") A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		    Case Else
			        foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
		    End Select
		Else
			ChildStr = "0"
			Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
		    Case Else
			        foundstr = "Order By A.ID Desc"
		    End Select
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Topic,A.Pic,A.types,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_Flea] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				      If rs("types")=1 then
				         sTopic = "<font color=blue>[求]</font>"
				      Else
				         sTopic = "<font color=orange>[供]</font>"
				      End If
					   'If CInt(showtypes) = 0 Then sTopic = ""
				       sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(41)
					   	strContent = Replace(strContent, "{$FleaPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$FleaTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$FleaTopic}", vbNullString)
						End If
						strContent = Replace(strContent, "{$Type}", sTopic)
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadFleaPic = strContent				
	End Function
	'================================================
	'函数名：ReadFleaPic
	'作  用：读取Flea图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFleaPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFleaPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFleaPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFleaPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFleaPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadFleaPic = strTemp
	End Function

		'================================================
	'函数名：LoadMoviePic
	'作  用：装载文章列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用文章类型,0=所有最新文章，1=推荐文章，2=热门文章，3=图文文章，4,5,6,7=分类文章 
	'        TopNum   ----显示文章列表数
	'        ColNum  ----每行显示数目
	'        strlen   ----显示标题长度
    '        width
	'        height
	'        newindow   ----新窗口打开
	'        showtopic
	'================================================
	Public Function LoadMusicPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 3 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadPhotoPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.ClassID,A.TColor,A.Name,A.Pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.ClassName,C.HtmlFileDir FROM [ITZD_MusicDisk] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("name"), CInt(strLen))
				       sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       If CInt(Cls.ChannelUseHtml) <> 0 Then
				        	HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					        HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				       Else
				           	HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				       End If
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(21)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("name") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadMusicPic = strContent				
	End Function
	'================================================
	'函数名：ReadMoviePic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadMusicPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadMusicPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadMusicPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadMusicPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMusicPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
			Next
		End If
		ReadMusicPic = strTemp
	End Function
	
	'================================================
	'函数名：LoadBlogPhoto
	'作  用：装载Blog Pic
	'================================================
	Public Function LoadBlogPhoto(ByVal stype, ByVal TopNum, ByVal ColNum, ByVal strLen, ByVal newindow, ByVal Width, ByVal Height, ByVal showtopic )
		Dim Rs, SQL, i, strContent, foundstr
		Dim sTitle, ChildStr, ImageUrl, HtmlFileName
		Dim HtmlFileUrl, WriteTime, LinkTarget
		stype = Cls.ChkNumeric(stype)
		'On Error Resume Next
		'Cls.LoadChannel(ChannelID)
		Select Case CInt(stype)
			Case 0: foundstr =  "Order By Id Desc"
			Case 1: foundstr =  "Order By count Desc ,ID Desc"
			Case 2: foundstr =  " And retim<>null Order By retim Desc ,ID Desc"
			Case 3: foundstr =  " And retim<>null Order By reply Desc ,ID Desc"
		Case Else
			foundstr = "Order By ID Desc"
		End Select
		SQL = " ID,Topic,Pic,Type,UserName,Count,Tim"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & "  FROM [ITZD_BlogData] WHERE Type=2 And hidden=1 " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
            strContent = strContent & "<tr>" & vbCrLf
			For i = 1 To CInt(ColNum)
					strContent = strContent & "<td align=""center"" class=""imagelist"">"
				If Not Rs.EOF Then
				       sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				       'sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
					   If rs("Pic")="" then
					   ImageUrl = Cls.Web_Dir&Cls.web_upload&"/no_pic.gif"
					   else
					   ImageUrl = rs("Pic")
					   end if
				       ImageUrl = "<img src='"&ImageUrl&"' width=" & width & " height=" & height & " border=0>"
				       HtmlFileUrl = Cls.Web_Dir& "Blog/View/?" & Rs("ID")
				       If CInt(newindow) <> 0 Then
				         	LinkTarget = " target=""_blank"""
				       Else
				        	LinkTarget = ""
			       	   End If
						strContent = strContent & Cls.ReadSkin(42)
					   	strContent = Replace(strContent, "{$PhotoPicture}", Cls.GetPic("<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & ImageUrl & "</a>"))
						If CInt(showtopic) = 1 Then
							strContent = Replace(strContent, "{$PhotoTopic}", "<a href='" & HtmlFileUrl & "' title='" & Rs("topic") & "'" & LinkTarget & ">" & sTitle & "</a>")
						Else
							strContent = Replace(strContent, "{$PhotoTopic}", vbNullString)
						End If
					Rs.MoveNext
				End If
				strContent = strContent & "</td>" & vbCrLf
			Next
			strContent = strContent & "</tr>" & vbCrLf
			Loop
			strContent = strContent & "</table>" & vbCrLf
		End If
		Rs.Close: Set Rs = Nothing
		LoadBlogPhoto = strContent				
	End Function
	'================================================
	'函数名：ReadPhotoPic
	'作  用：读取文章图片列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadBlogPhoto(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		'On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadBlogPhoto(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogPhoto(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadBlogPhoto(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadBlogPhoto(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7)))
			Next
		End If
		ReadBlogPhoto = strTemp
	End Function

	'================================================
	'函数名：LoadBBSListt
	'作  用：装载帖子列表
	'参  数：ClassID   ----分类ID
	'        ChannelID   ----频道ID
	'        SpecialID  ----专题ID
	'        sType   ----调用帖子类型,0=所有最新帖子，1=推荐帖子，2=热门帖子，3=分类最新帖子
	'        TopNum   ----显示帖子列表数
	'        strlen   ----显示标题长度
	'        ShowClass   ----是否显示分类
	'        ShowDate   ----是否显示日期
	'        DateMode   ----显示日期模式
	'        newindow   ----新窗口打开
	'        styles    ----样式
	'================================================
   Public Function LoadBBSList(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, _
		ByVal stype, ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showdate, _
		ByVal DateMode, ByVal newindow, ByVal styles)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim BbsTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc ,A.ID Desc"
			Case 3: foundstr = "And A.Forum_ID = "&ClassID&" Order By A.ID Desc"
			Case 4: foundstr = "And A.Forum_ID = "&ClassID&" And A.Isgood = 1 Order By A.ID Desc"
			Case 5: foundstr = "And A.Forum_ID = "&ClassID&" Order By A.counter Desc ,A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 3 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		SQL = " A.ID,A.Forum_ID,A.TColor,A.Tbb,A.Topic,A.username,A.counter,A.re_counter,A.Tim,A.islock,istop,A.isgood,isvote,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.Forum_Name FROM [ITZD_BbsTopic] A INNER JOIn [ITZD_BbsForum] C ON A.Forum_ID=C.Forum_ID WHERE A.Forum_ID<>999999999 " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "该论坛下还没有任何帖子！"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetBBSDot(rs("istop"),rs("islock"),rs("isgood"),rs("isvote"))
				sTitle = Cls.Cuted(Rs("topic"), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),rs("tbb"))
				ClassName = Rs("Forum_Name")
				HtmlFileUrl = Cls.ChannelPath & "view.asp?fid="& rs("Forum_ID") &"&id=" & Rs("ID")
				ClassName = "<a href='" & Cls.ChannelPath & "list.asp?fid=" & Rs("Forum_ID") & "'>" & ClassName & "</a>"
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				BbsTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs("topic") & "&#13;&#10;发表时间：" & Rs("tim") & "&#13;&#10;人气指数：" & Rs("counter") & " / " & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(17)
				strContent = Replace(strContent, "{$BbsTopic}", BbsTopic)
				strContent = Replace(strContent, "{$TopicID}", Rs("ID"))
				strContent = Replace(strContent, "{$BbsTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs("topic"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$Hits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadBbsList = strContent
     End Function
' --------首页各模块读取，包括：----------
'|                ReadBbsList 帖子        |
'|                ReadData　数据统计      |
'|                ReadCast　公告          |
'|                ReadVote　调查          |
'|                ReadLink　链接          |
' -----------------------------------------
     Public Function ReadBbsList(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadBBSList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadBBSList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadBBSList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
                  If Cls.Web_IsCreatIndex=True then
				      strTemp = Replace(strTemp, arrTempContents(i), "<script language=javascript src='"&Cls.Web_Dir&"Include/ForumView.asp?FvStr="&arrTempContent(i)&"'></script>")
                  Else
				      ArrayList = Split(arrTempContent(i), ",")
				      strTemp = Replace(strTemp, arrTempContents(i), LoadBBSList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8), ArrayList(9), ArrayList(10)))
                   End If
			Next
		End If
		ReadBbsList = strTemp
     End Function
	'================================================
	'函数名：LoadGuestList
	'作  用：装载留言列表
	'参  数：maxnum ----最多留言数
	'        maxlen ----字符长度
	'        newindow ----是否新窗口打开 1=是，0=否
	'        showdate ----是否显示时间 1=是，0=否
	'        DateMode ----时间模式
	'        styles ----风格名称
	'================================================
		Public Function LoadGuestList(ByVal maxnum, ByVal maxlen, ByVal newindow, _
		ByVal showdate, ByVal DateMode, ByVal styles)
		Dim Rs, SQL, strContent, reinfo
		Dim i, ListStyle, GuestTopic, LinkTarget
		Dim WriteTime, lastime, GuestTitle,strChannelDir,Rekoe_Img
		On Error Resume Next
		Set Rs = Cls.Exec("SELECT TOP " & CInt(maxnum) & " id,Topic,nname,tim,re_tim,isReply FROM [ITZD_GuestBook] WHERE hidden=1 ORDER BY id DESC",1)
		If Rs.BOF And Rs.EOF Then
			LoadGuestList = "没有任何留言!"
			Set Rs = Nothing
			Exit Function
		Else
			i = 0
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			strChannelDir = cls.web_dir&"common/GuestBook.asp"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("Tim"), CInt(DateMode))
					if rs("isreply")=true then
					lastime = Cls.ShowDateTime(Rs("re_tim"), CInt(DateMode))
					 reinfo ="&#13;&#10;回复时间："&Rs("re_tim")
					 Rekoe_Img="/Images/ssr52a_1.gif"
					else
					lastime = ""
					reinfo ="&#13;&#10;管理员尚未回复此留言！"
					Rekoe_Img="/Images/ssr37_1.gif"
					end if
				Else
					WriteTime = ""
					lastime = ""
				End If
				GuestTitle = rs("topic")
				GuestTopic = "" &Cls.Cuted( GuestTitle, CInt(maxlen)) & ""
				'GuestTopic = "<a href=""" & strChannelDir &  """ title=""主题：" & GuestTitle & "&#13;&#10;时间：" & Rs("tim") &"&#13;&#10;作者：" & Rs("nname") &reinfo& """" & LinkTarget & ">" & GuestTopic & "</a>"
				GuestTopic="<a href='"& strChannelDir &  "?id="&Rs("id")&"'><IMG='"&Rekoe_Img&"'>" & GuestTopic & "</a>"
				strContent = strContent &  Cls.ReadSkin(23)
				strContent = Replace(strContent, "{$GuestID}", Rs("id"))
				strContent = Replace(strContent, "{$UserName}", Rs("nname"))
				strContent = Replace(strContent, "{$GuestTopic}", GuestTopic)
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$Number}", i)
				strContent = Replace(strContent, "{$WriteTime}", WriteTime)
				strContent = Replace(strContent, "{$restime}", lastime)
				Rs.MoveNext
				i = i + 1
			Loop
			strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadGuestList = strContent
	End Function
	'================================================
	'函数名：ReadGuestList
	'作  用：读取留言列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadGuestList(ByVal str)
		Dim strTemp, i, sTempContent
		Dim nTempContent, ArrayList
		Dim arrTempContent, arrTempContents
		strTemp = str
		If InStr(strTemp, "{$ReadGuestList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadGuestList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadGuestList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadGuestList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5)))
			Next
		End If
		ReadGuestList = strTemp
	End Function
    '参数 showpic 只对文章类频道有效
		Public Function LoadRelateList(ByVal TopNum, ByVal strLen, _
		ByVal showclass, ByVal showpic, ByVal showdate, _
		ByVal DateMode, ByVal newindow,  ByVal styles,ByVal ChannelID,ByVal ViewID,ByVal ViewKey)
		Dim Rs, SQL, i, strContent, foundstr, obj_search, GetInfo
		Dim sDot,sTitle, sTopic, ChildStr, ListStyle, BestCode, BestString
		Dim ArticleTopic, ClassName, HtmlFileUrl, WriteTime, LinkTarget, HtmlFileName
        Dim TopicType
		ChannelID = Cls.ChkNumeric(ChannelID)
		ViewID = Cls.ChkNumeric(ViewID)
		strLen = Cls.ChkNumeric(strLen)
		ViewKey = Trim(ViewKey)
		styles="ShowList"
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		strContent =  ""
		TopicType="Name"
		GetInfo=""
		If Cls.ChannelModType=1 or Cls.ChannelModType=8 or Cls.ChannelModType=11 Then 
		TopicType="Topic"
		GetInfo="A.IncludeInfo,"
		End If
		If Not Cls.KeyWordTrue Or Cls.Is_Null(ViewKey)="" Then
		LoadRelateList="<font class=gray>没有相关"&Cls.ChannelModule&"</font>"
		Exit Function
		End If
        set obj_search=New Cls_Search        
		SQL = " A.ID,A.ClassID,A."&TopicType&","&GetInfo&"A.tcolor,A.tim,A.counter,A.isgood,A.isfocus,A.istop,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & "C.ClassName, C.HtmlFileDir FROM ["&Cls.ChannelDBtable&"] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE  A.hidden=1 And A.ChannelIDs=" & ChannelID & " and id<>"&ViewID&" and "&obj_search.sql_key(ViewKey,"A.keyes",1,"or") & " order by id desc"
        set obj_search=nothing
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = "<font class=gray>没有相关"&Cls.ChannelModule&"</font>"
		Else
			strContent = "<table width=""100%"" border=0 cellpadding=2 cellspacing=0>"
			Do While Not Rs.EOF
				If (i Mod 2) = 0 Then
					ListStyle = Trim(styles) & 1
				Else
					ListStyle = Trim(styles) & 2
				End If
				If Rs("isgood") <> 0 Then
					BestCode = 2
					BestString = "<font color='red'>推荐</font>"
				Else
					BestCode = 1
					BestString = ""
				End If
				'前标
				sDot=Cls.GetDot(rs("istop"),rs("isfocus"),rs("isgood"))
				If Cls.ChannelModType=1 Then 
				sTopic = Cls.GetIncInfo(Rs("IncludeInfo"))
				End If
				sTitle = Cls.Cuted(Rs(TopicType), CInt(strLen))
				sTitle = Cls.GetTcolor(sTitle,rs("tcolor"),False)
				'if rs("ispic")=true then sTitle = sTitle & "<font class=red>[图]</font>"
				ClassName = Rs("ClassName")
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
					ClassName = "<a href='" & Cls.ChannelPath & Rs("HtmlFileDir") & "Index_1" & Cls.ChannelHtmlExt & "'>" & ClassName & "</a>"
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
					ClassName = "<a href='" & Cls.ChannelPath & "list.asp?c_id=" & Rs("ClassID") & "'>" & ClassName & "</a>"
				End If
				If CInt(showclass) = 0 Then ClassName = ""
				If CInt(showpic) = 0 Then sTopic = ""
				If CInt(showdate) <> 0 Then
					WriteTime = Cls.ShowDateTime(Rs("tim"), CInt(DateMode))
				Else
					WriteTime = ""
				End If
				If CInt(newindow) <> 0 Then
					LinkTarget = " target=""_blank"""
				Else
					LinkTarget = ""
				End If
				ArticleTopic = "<a href='" & HtmlFileUrl & "'" & LinkTarget & " title='" & Cls.ChannelModule & "标题：" & Rs(TopicType) & "&#13;&#10;发布时间：" & Rs("tim") & "&#13;&#10;阅览次数：" & Rs("counter") & "' class=showlist>" & sTitle & "</a>"
				strContent = strContent & Cls.ReadSkin(24)
				strContent = Replace(strContent, "{$Topic}", ArticleTopic)
				strContent = Replace(strContent, "{$ID}", Rs("ID"))
				strContent = Replace(strContent, "{$sTitle}", sTitle)
				strContent = Replace(strContent, "{$Title}", Rs(TopicType))
				strContent = Replace(strContent, "{$Date}", Rs("tim"))
				strContent = Replace(strContent, "{$Dot}", sDot)
				strContent = Replace(strContent, "{$BriefTopic}", sTopic)
				strContent = Replace(strContent, "{$HtmlFileUrl}", HtmlFileUrl)
				strContent = Replace(strContent, "{$ClassName}", ClassName)
				strContent = Replace(strContent, "[]", "")
				strContent = Replace(strContent, "{$Target}", LinkTarget)
				strContent = Replace(strContent, "{$AddTime}", WriteTime)
				strContent = Replace(strContent, "{$Hits}", Rs("counter"))
				strContent = Replace(strContent, "{$ListStyle}", ListStyle)
				strContent = Replace(strContent, "{$BestCode}", BestCode)
				strContent = Replace(strContent, "{$BestString}", BestString)
			Rs.MoveNext
			i = i + 1
			Loop
		    strContent = strContent & "</table>"
		End If
		Rs.Close: Set Rs = Nothing
		LoadRelateList = strContent
	End Function
  	'================================================
	'函数名：ReadRelateList
	'================================================
	Public Function ReadRelateList(ByVal str,ByVal rcid,ByVal rvid,ByVal rvkey,ByVal ishtml)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadRelate(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadRelate(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadRelate(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
                  If ishtml=True then
				      strTemp = Replace(strTemp, arrTempContents(i), "<script language=javascript src='"&Cls.Web_Dir&"Include/Relate.asp?cid="&rcid&"&vid="&rvid&"&key="&rvkey&"&FvStr="&arrTempContent(i)&"'></script>")
                  Else
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadRelateList(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), rcid, rvid, rvkey))
                  End If
		    Next
		End If
		ReadRelateList = strTemp
	End Function
	
   '//* 公告 *//
   Public Function LoadMainCast(ByVal strChannelIDs,ByVal strNum,ByVal strCutNum)
           Dim Tmp1,n_topic,tmpnsort,iListStr
               strChannelIDs = Cls.ChkNumeric(strChannelIDs)
               SQL="Select top "&strNum&" id,topic,tim from ITZD_Cast where ChannelIDs="&strChannelIDs&" order by id desc"
               Set Rs=Cls.Exec(SQL,1)
               Do While Not Rs.Eof
                 n_topic=rs("topic")
                 n_topic=Cls.code_js(n_topic,1)
                 Tmp1=Tmp1&vbcrlf&"<tr>" &_
                     vbcrlf&"<td height=20>"&Cls.img("h_shop")&"&nbsp;<a href='"&Cls.Web_Dir&"Common/Update.asp?Action="&strChannelIDs&"&id="&rs("id")&"' target_blank title='公告标题："&Cls.Code_Html(n_topic,1,0)&vbcrlf&"发布时间："&rs("tim")&vbcrlf&"点击浏览详细……'>"&Cls.Code_Html(n_topic,1,strCutNum)&"</a></td>" &_
                     vbcrlf&"</tr>"
                 Rs.MoveNext
	           Loop
	           Rs.Close
           	LoadMainCast = "<div id=table><table border=0 cellspacing=0 cellpadding=2 width='100%'>"&Tmp1&VbCrlf&"</table></div>"
    End Function
    Public Function ReadCast(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadCast(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadCast(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadCast(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMainCast(ArrayList(0), ArrayList(1), ArrayList(2)))
			Next
		End If
		ReadCast = strTemp
     End Function
     Public Function LoadMainVote(strNum)
        LoadMainVote="<script language=javascript src='"&Cls.Web_Dir&"style/data_vote_"&strNum&".js'></script>"
     End Function
     Public Function ReadVote(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadVote(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadVote(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadVote(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadMainVote(ArrayList(0)))
			Next
		End If
		ReadVote = strTemp
     End Function
    Public Function ReadData(ByVal str)
    	Dim strTemp, Tmp1, iCount, Tii
    	strTemp = str
    	If InStr(strTemp, "{$ReadData}") > 0 Then
    	iCount = Cls.Channel_Menu
    	For Tii = 0 To UBound(iCount,2)
    		If Int(iCount(8,Tii)) <> 2 Or Int(iCount(11,Tii)) <> 5 Then
    			If Int(iCount(11,Tii)) = 4 then
    				Tmp1 = Tmp1 & "<tr><td height="&m_hei&">"&img_skin("h_")&"论坛主题：<font class=red>"&iCount(29,Tii)&"</font> "&iCount(15,Tii)&"</td></tr>"
    				Tmp1 = Tmp1 & "<tr><td height="&m_hei&">"&img_skin("h_")&"论坛贴子：<font class=red>"&iCount(30,Tii)&"</font> "&iCount(15,Tii)&"</td></tr>"
					tmp1 = tmp1 & "<tr><td height="&m_hei&">"&img_skin("h_")&"今日发贴：<font class=red>"&cls.web_infono(7,0)&"</font> "&icount(15,tii)&"</td></tr>"
    			Else
    				Tmp1 = Tmp1 & "<tr><td height="&m_hei&">"&img_skin("h_")&iCount(13,Tii)&"总数：<font class=red title='点击数："&iCount(30,Tii)&"'>"&iCount(29,Tii)&"</font> "&iCount(15,Tii)&"</td></tr>"
    			End If
	    	End If
    	Next
    	Erase iCount
    	Tmp1 = VbCrlf& Tmp1
    	Tmp1 = Tmp1&VbCrlf&"<tr><td height="&m_hei&">"&img_skin("h_")&"网站注册：<font class=red>"&Cls.Web_InfoNo(0,0)&"</font> 人</td></tr>" & _
	    	   VbCrlf&"<tr><td height="&m_hei&">"&img_skin("h_")&"最新注册："&format_user_name(Cls.Web_InfoNo(1,0),0,"")&"</td></tr>" & _
	    	   VbCrlf&"<tr><td height="&m_hei&" title='网站建立时间："&Cls.Web_InfoNo(5,0)&"'>"&img_skin("h_")&"浏览次数：<font class=red>"&Cls.Web_InfoNo(2,0)&"</font> 次</td></tr>" & _
	    	   VbCrlf&"<tr><td height="&m_hei&">"&img_skin("h_")&"最高在线：<font class=red title='最高在线发生于："&Cls.Web_InfoNo(4,0)&"'>"&Cls.Web_InfoNo(3,0)&"</font> 人</td></tr>"
	        Tmp1 = "<table border=0 cellspacing=0 cellpadding=2 width='100%'>"&Tmp1&VbCrlf&"</table>"
	    strTemp = Replace(strTemp, "{$ReadData}", tmp1)
      End If
      	ReadData =  strTemp 
    End Function
    Public Function ReadLink(ByVal str)
	    Dim strTemp
	    strTemp = str
      If InStr(strTemp, "{$ReadLink}") > 0 Then
        strTemp =  Replace(strTemp, "{$ReadLink}", "<script language=""javascript"" src='"&Cls.Web_Dir&"Style/data_link_index_fir.js'></script>"&vbcrlf&"<script language=""javascript"" src='"&Cls.Web_Dir&"Style/data_link_txt.js'></script>")
      End If
      ReadLink = strTemp
    End Function
	Public Function ReadChannelMenu(ByVal str)
	    Dim strTemp
	    strTemp = str
      If InStr(strTemp, "{$ShowMenu}") > 0 Then
        strTemp =  Replace(strTemp, "{$ShowMenu}", "<script Language=""JavaScript"" src="""&Cls.Web_Dir&"style/stm31.js""></script>"&vbcrlf&"<Script Language=""JavaScript"" src="""&Cls.Web_Dir&Cls.ChannelDir&"/Images/Menu.Js""></Script>")
      End If
      ReadChannelMenu = strTemp
    End Function
    Public Function ReadUserLogin(ByVal str)
	    Dim strTemp
	    strTemp = str
      If InStr(strTemp, "{$ReadUserLogin}") > 0 Then
        'strTemp =  Replace(strTemp, "{$ReadUserLogin}", User_Login())
		 strTemp =  Replace(strTemp, "{$ReadUserLogin}", "<script language=""JavaScript"" src="""&Cls.Web_Dir&"Include/Login.asp?old_url=back&Tit="&tit&"""></script>")
      End If
      ReadUserLogin = strTemp
    End Function


     Public Function ReadWebHead(ByVal str)
	    ReadWebHead = LoadWebHead(str)
     End Function
     Public Function ReadWebEnd(ByVal str)
		ReadWebEnd = LoadWebEnd(str)
     End Function 
     Public Sub LoadReplaced()
	    If Tit_Dir="" Or IsNull(Tit_Dir) Then Tit_Dir = Tit
		HtmlContent=Replace(HtmlContent,"{$tit_dir}",Tit_Dir)
		HtmlContent=Replace(HtmlContent,"{$ChannelID}",ChannelIDs)
    	HtmlContent=Replace(HtmlContent,"{$ChannelTit}",Cls.ChannelTit)
	    HtmlContent=Replace(HtmlContent,"{$ChannelDir}",Cls.ChannelDir)
	    HtmlContent=Replace(HtmlContent,"{$ChannelName}",Cls.ChannelName)
	    HtmlContent=Replace(HtmlContent,"{$ChannelUnit}",Cls.ChannelUnit)
     End Sub 
 
 Public Function LoadFlashPic(ByVal ChannelID, ByVal ClassID, ByVal SpecialID, ByVal Stype, ByVal TopNum, ByVal strLen, ByVal W, ByVal H, ByVal TextHeight)
		Dim Rs, SQL, i, strContent, foundstr
		Dim sDot, sTitle, sTopic, ChildStr ,TopicType
		Dim Topic1, ClassName, HtmlFileUrl, Pics1,pic, Links1, HtmlFileName
		ChannelID = Cls.ChkNumeric(ChannelID)
		ClassID = Cls.ChkNumeric(ClassID)
		SpecialID = Cls.ChkNumeric(SpecialID)
		stype = Cls.ChkNumeric(stype)
		On Error Resume Next
		Cls.LoadChannel(ChannelID)
		If CInt(stype) >= 4 And CLng(ClassID) <> 0 Then
			SQL = "SELECT ClassChildStr FROM [ITZD_Class] WHERE ChannelIDs=" & ChannelID & " And C_ID=" & ClassID
			Set Rs = Cls.Exec(SQL,1)
			If Rs.BOF And Rs.EOF Then
				Set Rs = Nothing
				LoadFlashPic = ""
				Exit Function
			Else
				ChildStr = Rs("ClassChildStr")
			End If
			Set Rs = Nothing
		Else
			ChildStr = "0"
		End If
		Select Case CInt(stype)
			Case 0: foundstr = "Order By A.Id Desc"
			Case 1: foundstr = "And A.Isgood = 1 Order By A.ID Desc"
			Case 2: foundstr = "Order By A.counter Desc, A.ID Desc"
			Case 3: foundstr = "And A.Pic<>'' Order By A.ID Desc"
			Case 4: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.ID Desc"
			Case 5: foundstr = "And A.ClassID in (" & ChildStr & ") And A.Isgood = 1 Order By A.ID Desc"
			Case 6: foundstr = "And A.ClassID in (" & ChildStr & ") Order By A.counter Desc ,A.ID Desc"
			Case 7: foundstr = "And A.ClassID in (" & ChildStr & ") And A.A.pic <>'' Order By A.ID Desc"
		Case Else
			foundstr = "Order By A.ID Desc"
		End Select
		If CInt(stype) >= 4 And CLng(ClassID) = 0 Then
			foundstr = "Order By A.ID Desc"
		End If
		If CLng(SpecialID) <> 0 Then
			foundstr = "And A.SpecialID =" & CLng(SpecialID) & " " & foundstr
		End If
		TopicType="Name"
		If Cls.ChannelModType=1 or Cls.ChannelModType=8 or Cls.ChannelModType=12 Then TopicType="Topic"
		SQL = " A.ID,A.ClassID,A."&TopicType&",A.pic,A.HtmlFileDate,"
		SQL = "SELECT Top " & CInt(TopNum) & SQL & " C.HtmlFileDir FROM ["&Cls.ChannelDBtable&"] A INNER JOIn [ITZD_Class] C ON A.ClassID=C.C_ID WHERE  A.hidden=1 And A.ChannelIDs=" & ChannelID & " " & foundstr & ""
		Set Rs = Cls.Exec(SQL,1)
		i = 0
		If Rs.BOF And Rs.EOF Then
			strContent = Cls.GetPic("<img src='"&Cls.Web_Dir&Cls.Web_Upload&"/no_pic.gif' border=0>")
		Else
			Do While Not Rs.EOF
				sTitle = Cls.Cuted(Rs(TopicType), CInt(strLen))
				If CInt(Cls.ChannelUseHtml) <> 0 Then
					HtmlFileName = Cls.ReadFileName(Rs("HtmlFileDate"), Rs("ID"), Cls.ChannelHtmlExt, Cls.ChannelPrefix, Cls.ChannelHtmForm, "")
					HtmlFileUrl = Cls.ChannelPath & Rs("HtmlFileDir") & Cls.ShowDatePath(Rs("HtmlFileDate"), Cls.ChannelHtmPath) & HtmlFileName
				Else
					HtmlFileUrl = Cls.ChannelPath & "view.asp?id=" & Rs("ID")
				End If
				'If CInt(showclass) = 0 Then ClassName = ""
               Pic=rs("pic")
               pic=Cls.code_html(pic,1,0)
               pics1= pics1&"|"&pic
               links1= links1&"|"&HtmlFileUrl
               Topic1 = Topic1&"|"&sTitle
        rs.movenext
        loop
        rs.close
        if left(pics1,1)="|" then pics1=right(pics1,len(pics1)-1)
        if left(links1,1)="|" then links1=right(links1,len(links1)-1)
        if left(Topic1,1)="|" then Topic1=right(Topic1,len(Topic1)-1)
 StrContent = vbcrlf&"<script type=""text/javascript"" src="""&Cls.Web_Dir&"Style/writeflashhtml.js""></script>"&_
 vbcrlf&"<script type=""text/javascript"">writeFlashHTML(""_version=8,0,0,0"" ,""_swf="&Cls.Web_Dir&"images/small/bcastr.swf"", ""_width="&w&""", ""_height="&h&""", ""_quality=high"", ""_flashvars=bcastr_flie="&pics1&"&bcastr_link="&links1&"&bcastr_title="&Topic1&"&autoPlayTime=3&titlebgalpha=45&titlebgcolor=0x0466B1&titleplace=tc&titlesize=23&titlefont=Verdana&target=_self"", ""_menu=false"");</script>"
          End If
          LoadFlashPic = StrContent 
     End Function
	'================================================
	'函数名：ReadFlashPic
	'作  用：读取软件列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadFlashPic(ByVal str)
		Dim strTemp, i
		Dim sTempContent, nTempContent
		Dim arrTempContent, arrTempContents, ArrayList
		On Error Resume Next
		strTemp = str
		If InStr(strTemp, "{$ReadFlashPic(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlashPic(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadFlashPic(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadFlashPic(ArrayList(0), ArrayList(1), ArrayList(2), ArrayList(3), ArrayList(4), ArrayList(5), ArrayList(6), ArrayList(7), ArrayList(8)))
			Next
		End If
		ReadFlashPic = strTemp
	End Function
    
    '================================================
	'函数名：LoadRssList
	'作  用：读取RSS
	'参  数：str ----原字符串
	' 0 最新 1 热门   2 推荐 3 焦点 4 高分  5图片 6 固顶
	'================================================
     		Public Function LoadRssList(ByVal styles)
		Dim Rekoe_rss,strContent
		If styles=0 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp'><a href='RssFeed.asp' target=_blank><img src='/Images/small/rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
		If styles=1 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=hot'><a href='RssFeed.asp?action=hot' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
		If styles=2 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=good'><a href='RssFeed.asp?action=good' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
		If styles=3 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=focus'><a href='RssFeed.asp?action=good' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
		If styles=4 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=Reward'><a href='RssFeed.asp?action=Reward' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
        If styles=5 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=pic'><a href='RssFeed.asp?action=pic' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
        If styles=6 then Rekoe_rss="<link type='application/rss+xml' rel='alternate' href='RssFeed.asp?action=top'><a href='RssFeed.asp?action=top' target=_blank><img src='/images/small/"&Cls.ChannelDir&"_rss_xml.gif' border=0 title='RSS 2.0 支持'></a>"
		strContent = strContent &  Cls.ReadSkin(37)
		strContent = Replace(strContent, "{$Rekoe_Xml}", Rekoe_rss)
		LoadRssList= strContent
	    End Function
	'================================================
	'函数名：ReadRssList
	'作  用：读取留言列表
	'参  数：str ----原字符串
	'================================================
	Public Function ReadRssList(ByVal str)
		Dim strTemp, i, sTempContent
		Dim nTempContent, ArrayList
		Dim arrTempContent, arrTempContents
		strTemp = str
		If InStr(strTemp, "{$ReadRssList(") > 0 Then
			sTempContent = Cls.CutMatchContent(strTemp, "{$ReadRssList(", ")}", 1)
			nTempContent = Cls.CutMatchContent(strTemp, "{$ReadRssList(", ")}", 0)
			arrTempContents = Split(sTempContent, "|||")
			arrTempContent = Split(nTempContent, "|||")
			For i = 0 To UBound(arrTempContents)
				ArrayList = Split(arrTempContent(i), ",")
				strTemp = Replace(strTemp, arrTempContents(i), LoadRssList(ArrayList(0)))
			Next
		End If
		ReadRssList = strTemp
	End Function

	Public Function ReadSearch(ByVal str)
                Dim strTemp,tmp
		strTemp = str
                tmp = vbcrlf & "<script language='javascript' src='/Style/Search.js'></script>" & _
                      vbcrlf & "<TABLE  cellSpacing=0 cellPadding=0 border=0>" & _
                      vbcrlf & "<tr><td align=left>" & _
                      vbcrlf & "<input type='text' size=39 id=txtSearch name=txtSearch onkeydown=""TabSearch();"" value=''class=bg_search></td>" & _
                      vbcrlf & "<td>&nbsp;<select name=xz>" & _
                      vbcrlf & "<option value=article>文章</option>" & _
                      vbcrlf & "<option value=news>新闻</option>" & _
                      vbcrlf & "<option value=down>软件</option>" & _
                      vbcrlf & "<option value=photo>贴图</option>" & _
                      vbcrlf & "<option value=shop>商城</option>" & _

                      vbcrlf & "<option value=iask>爱问</option>" & _

					  vbcrlf & "<option value=blog>博客</option>" & _
                      vbcrlf & "<option value=flea>跳蚤</option>" & _
                      vbcrlf & "<option value=flash>动画</option>" & _
                      vbcrlf & "<option value=pirs>企业</option>" & _
                      vbcrlf & "<option value=Mtv>Mtv</option>" & _
                      vbcrlf & "</select></td>" & _
                      vbcrlf & "<td height=25 colspan=2><input name=Submit type=submit onclick=""go();"" class=btn value='搜 索'></td> " & _
                      vbcrlf & "</tr>" & _
                      vbcrlf & "</table>"
		If InStr(strTemp, "{$ReadSearch}") > 0 Then
                   strTemp = Replace(strTemp, "{$ReadSearch}", tmp)
                End if
                ReadSearch = strTemp
	End Function


    '================================================
	'函数名：ShowIndex
	'作  用：显示网站首页
	'参  数：返回/输出
	'================================================
	Public Function ShowIndex(ByVal isHtml)
	    tit="网站首页"
		Call Cls.LoadTemplate(ChannelIDs)
	        HtmlContent = Cls.ReadTemplate(0)
		HtmlContent = ReadWebHead(HtmlContent)
		HtmlContent = ReadWebEnd(HtmlContent)
		HtmlContent = ReadUserLogin(HtmlContent)
    	HtmlContent = ReadArticleList(HtmlContent)
    	HtmlContent = ReadNewsList(HtmlContent)
        HtmlContent = ReadIaskList(HtmlContent)
		HtmlContent = ReadSoftList(HtmlContent)
		HtmlContent = ReadShopList(HtmlContent)
		HtmlContent = ReadPhotoList(HtmlContent)
        HtmlContent = ReadBlogData(HtmlContent)
		HtmlContent = ReadBlogPhoto(HtmlContent)
		HtmlContent = ReadPrisList(HtmlContent)
		HtmlContent = ReadFleaList(HtmlContent)
		HtmlContent = ReadFlash_List(HtmlContent)
		HtmlContent = ReadFlash_Pic(HtmlContent)
		HtmlContent = ReadMtvList(HtmlContent)
		HtmlContent = ReadRssList(HtmlContent)
		HtmlContent = ReadArticlePic(HtmlContent)
		HtmlContent = ReadNewsPic(HtmlContent)
		HtmlContent = ReadIaskPic(HtmlContent)
		HtmlContent = ReadSoftPic(HtmlContent)
		HtmlContent = ReadPhotoPic(HtmlContent)
		HtmlContent = ReadShopPic(HtmlContent)

		HtmlContent = ReadMtvPic(HtmlContent)
		HtmlContent = ReadBbsList(HtmlContent)
		HtmlContent = ReadGuestList(HtmlContent)
		HtmlContent = ReadFlashPic(HtmlContent)
		HtmlContent = ReadData(HtmlContent)
		HtmlContent = ReadCast(HtmlContent)
		HtmlContent = ReadVote(HtmlContent)
		HtmlContent = ReadLink(HtmlContent)
		HtmlContent = ReadChannelMenu(HtmlContent)
		HtmlContent = ReadSearch(HtmlContent)

		HtmlContent = Cls.ReHtml(HtmlContent,0)
	    If isHtml Then
			ShowIndex = HtmlContent
	    Else
			Response.Write HtmlContent
	    End If
	End Function
End Class
%>
