<?php

/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id: youhui.ctl.php 2034 2013-12-07 03:08:33Z langzhong $
 */
if (!defined('__CORE_DIR')) {
    exit("Access Denied");
}

class Ctl_Company_Youhui extends Ctl {

    public function index($page = 1) {
        $filter = $pager = array();
        $pager['page'] = max(intval($page), 1);
        $pager['limit'] = $limit = 50;
        if ($SO = $this->GP('SO')) {
            $pager['SO'] = $SO;
            if ($SO['youhui_id']) {
                $filter['youhui_id'] = $SO['youhui_id'];
            }
            if ($SO['area_id']) {
                $filter['area_id'] = $SO['area_id'];
            }
            if (!isset($filter['area_id'])) {
                if ($SO['city_id']) {
                    $filter['city_id'] = $SO['city_id'];
                }
            }
            if ($SO['company_id']) {
                $filter['company_id'] = $SO['company_id'];
            }
            if ($SO['title']) {
                $filter['title'] = "LIKE:%" . $SO['title'] . "%";
            }
            if (is_array($SO['bg_date'])) {
                if ($SO['bg_date'][0] && $SO['bg_date'][1]) {
                    $a = strtotime($SO['bg_date'][0]);
                    $b = strtotime($SO['bg_date'][1]) + 86400;
                    $filter['bg_date'] = $a . "~" . $b;
                }
            }
            if (is_array($SO['end_date'])) {
                if ($SO['end_date'][0] && $SO['end_date'][1]) {
                    $a = strtotime($SO['end_date'][0]);
                    $b = strtotime($SO['end_date'][1]) + 86400;
                    $filter['end_date'] = $a . "~" . $b;
                }
            }
            if ($SO['audit']) {
                $filter['audit'] = $SO['audit'];
            }
        }
        $companyIds = array();
        if ($items = K::M('company/youhui')->items($filter, null, $page, $limit, $count)) {
            foreach ($items as $k => $v) {

                if (!empty($v['company_id']))
                    $companyIds[$v['company_id']] = $v['company_id'];
                $items[$k]['create_ip'] = $v['create_ip'] . '(' . K::M("misc/location")->location($v['create_ip']) . ')';
            }
            $pager['count'] = $count;
            $pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink(null, array('{page}')), array('SO' => $SO));
        }
        $this->pagedata['company_list'] = K::M('company/company')->items_by_ids($companyIds);
        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager;
        $this->pagedata['cityList'] = K::M("data/city")->fetch_all();
        $this->pagedata['areaList'] = K::M("data/area")->fetch_all();
        $this->tmpl = 'admin:company/youhui/items.html';
    }

    public function so() {
        $this->tmpl = 'admin:company/youhui/so.html';
    }
    
    public function audit($youhui_id = null)
    {
        if ($youhui_id = (int) $youhui_id) {
            if (K::M('company/youhui')->update($youhui_id,array('audit'=>1))) {
                $this->err->add('审核成功');
            }
        } else if ($ids = $this->GP('youhui_id')) {
            if (K::M('company/youhui')->batch($ids,array('audit'=>1))) {
                $this->err->add('审核成功');
            }
        } else {
            $this->err->add('未指定要审核的ID', 401);
        }
    }

    public function create() {
        if ($this->checksubmit()) {
            if (!$data = $this->GP('data')) {
                $this->err->add('非法的数据提交', 201);
            } else {
                if ($_FILES['data']) {
                    foreach ($_FILES['data'] as $k => $v) {
                        foreach ($v as $kk => $vv) {
                            $attachs[$kk][$k] = $vv;
                        }
                    }
                    $cfg = K::$system->config->get('attach');
                    $oImg = K::M('image/gd');
                    $upload = K::M('magic/upload');
                    foreach ($attachs as $k => $attach) {
                        if ($attach['error'] == UPLOAD_ERR_OK) {
                            if ($a = $upload->upload($attach, 'company')) {
                                $data[$k] = $a['photo'];
                                $size['photo'] = $cfg['youhui']['photo'] ? $cfg['youhui']['photo'] : 200;
                                $oImg->thumbs($a['file'], array($size['photo'] => $a['file']));
                            }
                        }
                    }
                }
                $data['dateline'] = __TIME;
                $data['create_ip'] = __IP;


                if ($youhui_id = K::M('company/youhui')->create($data)) {
                    $this->err->add('添加内容成功');
                    $this->err->set_data('forward', '?company/youhui-index.html');
                }
            }
        } else {
            $this->tmpl = 'admin:company/youhui/create.html';
        }
    }

    public function edit($youhui_id = null) {
        if (!($youhui_id = (int) $youhui_id) && !($youhui_id = $this->GP('youhui_id'))) {
            $this->err->add('未指定要修改的内容ID', 211);
        } else if (!$detail = K::M('company/youhui')->detail($youhui_id)) {
            $this->err->add('您要修改的内容不存在或已经删除', 212);
        } else if ($this->checksubmit('data')) {
            if (!$data = $this->GP('data')) {
                $this->err->add('非法的数据提交', 201);
            } else {
                if ($_FILES['data']) {
                    foreach ($_FILES['data'] as $k => $v) {
                        foreach ($v as $kk => $vv) {
                            $attachs[$kk][$k] = $vv;
                        }
                    }
                    $upload = K::M('magic/upload');
                    foreach ($attachs as $k => $attach) {
                        if ($attach['error'] == UPLOAD_ERR_OK) {
                            if ($a = $upload->upload($attach, 'company')) {
                                $data[$k] = $a['photo'];
                            }
                        }
                    }
                }

                if (K::M('company/youhui')->update($youhui_id, $data)) {
                    $this->err->add('修改内容成功');
                }
            }
        } else {
            if ($company_id = $detail['company_id']) {
                $this->pagedata['company'] = K::M('company/company')->detail($company_id);
            }
            $this->pagedata['detail'] = $detail;
            $this->tmpl = 'admin:company/youhui/edit.html';
        }
    }

    public function delete($youhui_id = null) {
        if ($youhui_id = (int) $youhui_id) {
            if (K::M('company/youhui')->delete($youhui_id)) {
                $this->err->add('删除成功');
            }
        } else if ($ids = $this->GP('youhui_id')) {
            if (K::M('company/youhui')->delete($ids)) {
                $this->err->add('批量删除成功');
            }
        } else {
            $this->err->add('未指定要删除的内容ID', 401);
        }
    }

}
